package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import com.okta.sdk.resource.model.Sso;
import com.okta.sdk.resource.model.SubmissionResponseConfigInner;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * SubmissionResponse
 */
@JsonPropertyOrder({ SubmissionResponse.JSON_PROPERTY_CONFIG, SubmissionResponse.JSON_PROPERTY_DESCRIPTION,
        SubmissionResponse.JSON_PROPERTY_ID, SubmissionResponse.JSON_PROPERTY_LAST_PUBLISHED,
        SubmissionResponse.JSON_PROPERTY_LAST_UPDATED, SubmissionResponse.JSON_PROPERTY_LAST_UPDATED_BY,
        SubmissionResponse.JSON_PROPERTY_LOGO, SubmissionResponse.JSON_PROPERTY_NAME,
        SubmissionResponse.JSON_PROPERTY_SSO, SubmissionResponse.JSON_PROPERTY_STATUS })
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-01-23T09:50:29.349096-06:00[America/Chicago]", comments = "Generator version: 7.8.0")
public class SubmissionResponse implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_CONFIG = "config";
    private List<SubmissionResponseConfigInner> config = null;

    public static final String JSON_PROPERTY_DESCRIPTION = "description";
    private String description;

    public static final String JSON_PROPERTY_ID = "id";
    private String id;

    public static final String JSON_PROPERTY_LAST_PUBLISHED = "lastPublished";
    private String lastPublished;

    public static final String JSON_PROPERTY_LAST_UPDATED = "lastUpdated";
    private String lastUpdated;

    public static final String JSON_PROPERTY_LAST_UPDATED_BY = "lastUpdatedBy";
    private String lastUpdatedBy;

    public static final String JSON_PROPERTY_LOGO = "logo";
    private URI logo;

    public static final String JSON_PROPERTY_NAME = "name";
    private String name;

    public static final String JSON_PROPERTY_SSO = "sso";
    private Sso sso;

    public static final String JSON_PROPERTY_STATUS = "status";
    private String status;

    public SubmissionResponse() {
    }

    /*
     * @JsonCreator public SubmissionResponse(
     *
     * @JsonProperty(JSON_PROPERTY_ID) String id,
     *
     * @JsonProperty(JSON_PROPERTY_LAST_PUBLISHED) String lastPublished,
     *
     * @JsonProperty(JSON_PROPERTY_LAST_UPDATED) String lastUpdated,
     *
     * @JsonProperty(JSON_PROPERTY_LAST_UPDATED_BY) String lastUpdatedBy,
     *
     * @JsonProperty(JSON_PROPERTY_STATUS) String status ) { this(); this.id = id; this.lastPublished = lastPublished;
     * this.lastUpdated = lastUpdated; this.lastUpdatedBy = lastUpdatedBy; this.status = status; }
     */

    public SubmissionResponse config(List<SubmissionResponseConfigInner> config) {

        this.config = config;
        return this;
    }

    public SubmissionResponse addconfigItem(SubmissionResponseConfigInner configItem) {
        if (this.config == null) {
            this.config = new ArrayList<>();
        }
        this.config.add(configItem);
        return this;
    }

    /**
     * List of org-level variables for the customer per-tenant configuration. For example, a &#x60;subdomain&#x60;
     * variable can be used in the ACS URL: &#x60;https://${org.subdomain}.example.com/saml/login&#x60;
     *
     * @return config
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "List of org-level variables for the customer per-tenant configuration. For example, a `subdomain` variable can be used in the ACS URL: `https://${org.subdomain}.example.com/saml/login`")
    @JsonProperty(JSON_PROPERTY_CONFIG)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public List<SubmissionResponseConfigInner> getConfig() {
        return config;
    }

    @JsonProperty(JSON_PROPERTY_CONFIG)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setConfig(List<SubmissionResponseConfigInner> config) {
        this.config = config;
    }

    public SubmissionResponse description(String description) {

        this.description = description;
        return this;
    }

    /**
     * A general description of your application and the benefits provided to your customers
     *
     * @return description
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(example = "Your one source for in-season strawberry deals. Okta's Strawberry Central integration allow users to securely access those sweet deals.", value = "A general description of your application and the benefits provided to your customers")
    @JsonProperty(JSON_PROPERTY_DESCRIPTION)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getDescription() {
        return description;
    }

    @JsonProperty(JSON_PROPERTY_DESCRIPTION)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setDescription(String description) {
        this.description = description;
    }

    /**
     * OIN Integration ID
     *
     * @return id
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(example = "acme_submissionapp_1", value = "OIN Integration ID")
    @JsonProperty(JSON_PROPERTY_ID)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getId() {
        return id;
    }

    /**
     * Timestamp when the OIN Integration was last published
     *
     * @return lastPublished
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(example = "2023-08-24T14:15:22.000Z", value = "Timestamp when the OIN Integration was last published")
    @JsonProperty(JSON_PROPERTY_LAST_PUBLISHED)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getLastPublished() {
        return lastPublished;
    }

    /**
     * Timestamp when the OIN Integration instance was last updated
     *
     * @return lastUpdated
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(example = "2023-08-24T14:15:22.000Z", value = "Timestamp when the OIN Integration instance was last updated")
    @JsonProperty(JSON_PROPERTY_LAST_UPDATED)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getLastUpdated() {
        return lastUpdated;
    }

    /**
     * ID of the user who made the last update
     *
     * @return lastUpdatedBy
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(example = "00ub0oNGTSWTBKOLGLNR", value = "ID of the user who made the last update")
    @JsonProperty(JSON_PROPERTY_LAST_UPDATED_BY)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getLastUpdatedBy() {
        return lastUpdatedBy;
    }

    public SubmissionResponse logo(URI logo) {

        this.logo = logo;
        return this;
    }

    /**
     * URL to an uploaded application logo. This logo appears next to your app integration name in the OIN catalog. You
     * must first [Upload an OIN Integration
     * logo](/openapi/okta-management/management/tag/YourOinIntegrations/#tag/YourOinIntegrations/operation/uploadSubmissionLogo)
     * to obtain the logo URL before you can specify this value.
     *
     * @return logo
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(example = "https://acme.okta.com/bc/image/fileStoreRecord?id=fs03xxd3KmkDBwJU80g4", value = "URL to an uploaded application logo. This logo appears next to your app integration name in the OIN catalog. You must first [Upload an OIN Integration logo](/openapi/okta-management/management/tag/YourOinIntegrations/#tag/YourOinIntegrations/operation/uploadSubmissionLogo) to obtain the logo URL before you can specify this value.")
    @JsonProperty(JSON_PROPERTY_LOGO)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public URI getLogo() {
        return logo;
    }

    @JsonProperty(JSON_PROPERTY_LOGO)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setLogo(URI logo) {
        this.logo = logo;
    }

    public SubmissionResponse name(String name) {

        this.name = name;
        return this;
    }

    /**
     * The app integration name. This is the main title used for your integration in the OIN catalog.
     *
     * @return name
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(example = "Strawberry Central", value = "The app integration name. This is the main title used for your integration in the OIN catalog.")
    @JsonProperty(JSON_PROPERTY_NAME)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getName() {
        return name;
    }

    @JsonProperty(JSON_PROPERTY_NAME)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setName(String name) {
        this.name = name;
    }

    public SubmissionResponse sso(Sso sso) {

        this.sso = sso;
        return this;
    }

    /**
     * Get sso
     *
     * @return sso
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_SSO)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public Sso getSso() {
        return sso;
    }

    @JsonProperty(JSON_PROPERTY_SSO)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setSso(Sso sso) {
        this.sso = sso;
    }

    /**
     * Status of the OIN Integration submission
     *
     * @return status
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(example = "New", value = "Status of the OIN Integration submission")
    @JsonProperty(JSON_PROPERTY_STATUS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getStatus() {
        return status;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        SubmissionResponse submissionResponse = (SubmissionResponse) o;
        return Objects.equals(this.config, submissionResponse.config)
                && Objects.equals(this.description, submissionResponse.description)
                && Objects.equals(this.id, submissionResponse.id)
                && Objects.equals(this.lastPublished, submissionResponse.lastPublished)
                && Objects.equals(this.lastUpdated, submissionResponse.lastUpdated)
                && Objects.equals(this.lastUpdatedBy, submissionResponse.lastUpdatedBy)
                && Objects.equals(this.logo, submissionResponse.logo)
                && Objects.equals(this.name, submissionResponse.name)
                && Objects.equals(this.sso, submissionResponse.sso)
                && Objects.equals(this.status, submissionResponse.status);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(config, description, id, lastPublished, lastUpdated, lastUpdatedBy, logo, name, sso,
                status);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SubmissionResponse {\n");
        sb.append("    config: ").append(toIndentedString(config)).append("\n");
        sb.append("    description: ").append(toIndentedString(description)).append("\n");
        sb.append("    id: ").append(toIndentedString(id)).append("\n");
        sb.append("    lastPublished: ").append(toIndentedString(lastPublished)).append("\n");
        sb.append("    lastUpdated: ").append(toIndentedString(lastUpdated)).append("\n");
        sb.append("    lastUpdatedBy: ").append(toIndentedString(lastUpdatedBy)).append("\n");
        sb.append("    logo: ").append(toIndentedString(logo)).append("\n");
        sb.append("    name: ").append(toIndentedString(name)).append("\n");
        sb.append("    sso: ").append(toIndentedString(sso)).append("\n");
        sb.append("    status: ").append(toIndentedString(status)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
