package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import com.okta.sdk.resource.model.TokenPayLoadDataContextAllOfPolicyRule;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * The authorization server policy used to mint the token
 */
@ApiModel(description = "The authorization server policy used to mint the token")
@JsonPropertyOrder({ TokenPayLoadDataContextAllOfPolicy.JSON_PROPERTY_ID,
        TokenPayLoadDataContextAllOfPolicy.JSON_PROPERTY_RULE })
@JsonTypeName("TokenPayLoad_data_context_allOf_policy")
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-01-23T09:50:29.349096-06:00[America/Chicago]", comments = "Generator version: 7.8.0")
public class TokenPayLoadDataContextAllOfPolicy implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_ID = "id";
    private String id;

    public static final String JSON_PROPERTY_RULE = "rule";
    private TokenPayLoadDataContextAllOfPolicyRule rule;

    public TokenPayLoadDataContextAllOfPolicy() {
    }

    public TokenPayLoadDataContextAllOfPolicy id(String id) {

        this.id = id;
        return this;
    }

    /**
     * The unique identifier for the policy
     *
     * @return id
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(example = "00p4ktaq2ryOYtsHC0g7", value = "The unique identifier for the policy")
    @JsonProperty(JSON_PROPERTY_ID)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getId() {
        return id;
    }

    @JsonProperty(JSON_PROPERTY_ID)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setId(String id) {
        this.id = id;
    }

    public TokenPayLoadDataContextAllOfPolicy rule(TokenPayLoadDataContextAllOfPolicyRule rule) {

        this.rule = rule;
        return this;
    }

    /**
     * Get rule
     *
     * @return rule
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_RULE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public TokenPayLoadDataContextAllOfPolicyRule getRule() {
        return rule;
    }

    @JsonProperty(JSON_PROPERTY_RULE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setRule(TokenPayLoadDataContextAllOfPolicyRule rule) {
        this.rule = rule;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        TokenPayLoadDataContextAllOfPolicy tokenPayLoadDataContextAllOfPolicy = (TokenPayLoadDataContextAllOfPolicy) o;
        return Objects.equals(this.id, tokenPayLoadDataContextAllOfPolicy.id)
                && Objects.equals(this.rule, tokenPayLoadDataContextAllOfPolicy.rule);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(id, rule);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TokenPayLoadDataContextAllOfPolicy {\n");
        sb.append("    id: ").append(toIndentedString(id)).append("\n");
        sb.append("    rule: ").append(toIndentedString(rule)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
