package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import com.okta.sdk.resource.model.TokenPayLoadDataContextAllOfProtocolClient;
import com.okta.sdk.resource.model.TokenPayLoadDataContextAllOfProtocolIssuer;
import com.okta.sdk.resource.model.TokenPayLoadDataContextAllOfProtocolOriginalGrant;
import com.okta.sdk.resource.model.TokenProtocolRequest;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * Details of the authentication protocol
 */
@ApiModel(description = "Details of the authentication protocol")
@JsonPropertyOrder({ TokenPayLoadDataContextAllOfProtocol.JSON_PROPERTY_TYPE,
        TokenPayLoadDataContextAllOfProtocol.JSON_PROPERTY_REQUEST,
        TokenPayLoadDataContextAllOfProtocol.JSON_PROPERTY_ORIGINAL_GRANT,
        TokenPayLoadDataContextAllOfProtocol.JSON_PROPERTY_ISSUER,
        TokenPayLoadDataContextAllOfProtocol.JSON_PROPERTY_CLIENT })
@JsonTypeName("TokenPayLoad_data_context_allOf_protocol")
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-01-23T09:50:29.349096-06:00[America/Chicago]", comments = "Generator version: 7.8.0")
public class TokenPayLoadDataContextAllOfProtocol implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_TYPE = "type";
    private String type;

    public static final String JSON_PROPERTY_REQUEST = "request";
    private TokenProtocolRequest request;

    public static final String JSON_PROPERTY_ORIGINAL_GRANT = "OriginalGrant";
    private TokenPayLoadDataContextAllOfProtocolOriginalGrant originalGrant;

    public static final String JSON_PROPERTY_ISSUER = "issuer";
    private TokenPayLoadDataContextAllOfProtocolIssuer issuer;

    public static final String JSON_PROPERTY_CLIENT = "client";
    private TokenPayLoadDataContextAllOfProtocolClient client;

    public TokenPayLoadDataContextAllOfProtocol() {
    }

    public TokenPayLoadDataContextAllOfProtocol type(String type) {

        this.type = type;
        return this;
    }

    /**
     * The type of authentication protocol used
     *
     * @return type
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(example = "OAUTH2.0", value = "The type of authentication protocol used")
    @JsonProperty(JSON_PROPERTY_TYPE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getType() {
        return type;
    }

    @JsonProperty(JSON_PROPERTY_TYPE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setType(String type) {
        this.type = type;
    }

    public TokenPayLoadDataContextAllOfProtocol request(TokenProtocolRequest request) {

        this.request = request;
        return this;
    }

    /**
     * Get request
     *
     * @return request
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_REQUEST)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public TokenProtocolRequest getRequest() {
        return request;
    }

    @JsonProperty(JSON_PROPERTY_REQUEST)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setRequest(TokenProtocolRequest request) {
        this.request = request;
    }

    public TokenPayLoadDataContextAllOfProtocol originalGrant(
            TokenPayLoadDataContextAllOfProtocolOriginalGrant originalGrant) {

        this.originalGrant = originalGrant;
        return this;
    }

    /**
     * Get originalGrant
     *
     * @return originalGrant
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_ORIGINAL_GRANT)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public TokenPayLoadDataContextAllOfProtocolOriginalGrant getOriginalGrant() {
        return originalGrant;
    }

    @JsonProperty(JSON_PROPERTY_ORIGINAL_GRANT)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setOriginalGrant(TokenPayLoadDataContextAllOfProtocolOriginalGrant originalGrant) {
        this.originalGrant = originalGrant;
    }

    public TokenPayLoadDataContextAllOfProtocol issuer(TokenPayLoadDataContextAllOfProtocolIssuer issuer) {

        this.issuer = issuer;
        return this;
    }

    /**
     * Get issuer
     *
     * @return issuer
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_ISSUER)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public TokenPayLoadDataContextAllOfProtocolIssuer getIssuer() {
        return issuer;
    }

    @JsonProperty(JSON_PROPERTY_ISSUER)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setIssuer(TokenPayLoadDataContextAllOfProtocolIssuer issuer) {
        this.issuer = issuer;
    }

    public TokenPayLoadDataContextAllOfProtocol client(TokenPayLoadDataContextAllOfProtocolClient client) {

        this.client = client;
        return this;
    }

    /**
     * Get client
     *
     * @return client
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_CLIENT)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public TokenPayLoadDataContextAllOfProtocolClient getClient() {
        return client;
    }

    @JsonProperty(JSON_PROPERTY_CLIENT)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setClient(TokenPayLoadDataContextAllOfProtocolClient client) {
        this.client = client;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        TokenPayLoadDataContextAllOfProtocol tokenPayLoadDataContextAllOfProtocol = (TokenPayLoadDataContextAllOfProtocol) o;
        return Objects.equals(this.type, tokenPayLoadDataContextAllOfProtocol.type)
                && Objects.equals(this.request, tokenPayLoadDataContextAllOfProtocol.request)
                && Objects.equals(this.originalGrant, tokenPayLoadDataContextAllOfProtocol.originalGrant)
                && Objects.equals(this.issuer, tokenPayLoadDataContextAllOfProtocol.issuer)
                && Objects.equals(this.client, tokenPayLoadDataContextAllOfProtocol.client);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(type, request, originalGrant, issuer, client);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TokenPayLoadDataContextAllOfProtocol {\n");
        sb.append("    type: ").append(toIndentedString(type)).append("\n");
        sb.append("    request: ").append(toIndentedString(request)).append("\n");
        sb.append("    originalGrant: ").append(toIndentedString(originalGrant)).append("\n");
        sb.append("    issuer: ").append(toIndentedString(issuer)).append("\n");
        sb.append("    client: ").append(toIndentedString(client)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
