package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import com.okta.sdk.resource.model.GrantType;
import java.net.URI;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * Details of the token request
 */
@ApiModel(description = "Details of the token request")
@JsonPropertyOrder({ TokenProtocolRequest.JSON_PROPERTY_CLIENT_ID, TokenProtocolRequest.JSON_PROPERTY_GRANT_TYPE,
        TokenProtocolRequest.JSON_PROPERTY_REDIRECT_URI, TokenProtocolRequest.JSON_PROPERTY_RESPONSE_MODE,
        TokenProtocolRequest.JSON_PROPERTY_RESPONSE_TYPE, TokenProtocolRequest.JSON_PROPERTY_SCOPE,
        TokenProtocolRequest.JSON_PROPERTY_STATE })
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-01-23T09:50:29.349096-06:00[America/Chicago]", comments = "Generator version: 7.8.0")
public class TokenProtocolRequest implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_CLIENT_ID = "client_id";
    private String clientId;

    public static final String JSON_PROPERTY_GRANT_TYPE = "grant_type";
    private GrantType grantType;

    public static final String JSON_PROPERTY_REDIRECT_URI = "redirect_uri";
    private URI redirectUri;

    /**
     * The authorization response mode
     */
    public enum ResponseModeEnum {
        FORM_POST("form_post"),

        FRAGMENT("fragment"),

        OKTA_POST_MESSAGE("okta_post_message"),

        QUERY("query"),

        UNKNOWN_DEFAULT_OPEN_API("unknown_default_open_api");

        private String value;

        ResponseModeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return value;
        }

        @Override
        public String toString() {
            return String.valueOf(value);
        }

        @JsonCreator
        public static ResponseModeEnum fromValue(String value) {
            for (ResponseModeEnum b : ResponseModeEnum.values()) {
                if (b.value.equals(value)) {
                    return b;
                }
            }
            return UNKNOWN_DEFAULT_OPEN_API;
        }
    }

    public static final String JSON_PROPERTY_RESPONSE_MODE = "response_mode";
    private ResponseModeEnum responseMode;

    /**
     * The authorization response type
     */
    public enum ResponseTypeEnum {
        CODE("code"),

        ID_TOKEN("id_token"),

        TOKEN("token"),

        NONE("none"),

        UNKNOWN_DEFAULT_OPEN_API("unknown_default_open_api");

        private String value;

        ResponseTypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return value;
        }

        @Override
        public String toString() {
            return String.valueOf(value);
        }

        @JsonCreator
        public static ResponseTypeEnum fromValue(String value) {
            for (ResponseTypeEnum b : ResponseTypeEnum.values()) {
                if (b.value.equals(value)) {
                    return b;
                }
            }
            return UNKNOWN_DEFAULT_OPEN_API;
        }
    }

    public static final String JSON_PROPERTY_RESPONSE_TYPE = "response_type";
    private ResponseTypeEnum responseType;

    public static final String JSON_PROPERTY_SCOPE = "scope";
    private String scope;

    public static final String JSON_PROPERTY_STATE = "state";
    private String state;

    public TokenProtocolRequest() {
    }

    public TokenProtocolRequest clientId(String clientId) {

        this.clientId = clientId;
        return this;
    }

    /**
     * The ID of the client associated with the token
     *
     * @return clientId
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "The ID of the client associated with the token")
    @JsonProperty(JSON_PROPERTY_CLIENT_ID)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getClientId() {
        return clientId;
    }

    @JsonProperty(JSON_PROPERTY_CLIENT_ID)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public TokenProtocolRequest grantType(GrantType grantType) {

        this.grantType = grantType;
        return this;
    }

    /**
     * Get grantType
     *
     * @return grantType
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_GRANT_TYPE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public GrantType getGrantType() {
        return grantType;
    }

    @JsonProperty(JSON_PROPERTY_GRANT_TYPE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setGrantType(GrantType grantType) {
        this.grantType = grantType;
    }

    public TokenProtocolRequest redirectUri(URI redirectUri) {

        this.redirectUri = redirectUri;
        return this;
    }

    /**
     * Specifies the callback location where the authorization was sent
     *
     * @return redirectUri
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Specifies the callback location where the authorization was sent")
    @JsonProperty(JSON_PROPERTY_REDIRECT_URI)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public URI getRedirectUri() {
        return redirectUri;
    }

    @JsonProperty(JSON_PROPERTY_REDIRECT_URI)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setRedirectUri(URI redirectUri) {
        this.redirectUri = redirectUri;
    }

    public TokenProtocolRequest responseMode(ResponseModeEnum responseMode) {

        this.responseMode = responseMode;
        return this;
    }

    /**
     * The authorization response mode
     *
     * @return responseMode
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "The authorization response mode")
    @JsonProperty(JSON_PROPERTY_RESPONSE_MODE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public ResponseModeEnum getResponseMode() {
        return responseMode;
    }

    @JsonProperty(JSON_PROPERTY_RESPONSE_MODE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setResponseMode(ResponseModeEnum responseMode) {
        this.responseMode = responseMode;
    }

    public TokenProtocolRequest responseType(ResponseTypeEnum responseType) {

        this.responseType = responseType;
        return this;
    }

    /**
     * The authorization response type
     *
     * @return responseType
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "The authorization response type")
    @JsonProperty(JSON_PROPERTY_RESPONSE_TYPE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public ResponseTypeEnum getResponseType() {
        return responseType;
    }

    @JsonProperty(JSON_PROPERTY_RESPONSE_TYPE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setResponseType(ResponseTypeEnum responseType) {
        this.responseType = responseType;
    }

    public TokenProtocolRequest scope(String scope) {

        this.scope = scope;
        return this;
    }

    /**
     * The scopes requested
     *
     * @return scope
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "The scopes requested")
    @JsonProperty(JSON_PROPERTY_SCOPE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getScope() {
        return scope;
    }

    @JsonProperty(JSON_PROPERTY_SCOPE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setScope(String scope) {
        this.scope = scope;
    }

    public TokenProtocolRequest state(String state) {

        this.state = state;
        return this;
    }

    /**
     * Get state
     *
     * @return state
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_STATE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getState() {
        return state;
    }

    @JsonProperty(JSON_PROPERTY_STATE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setState(String state) {
        this.state = state;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        TokenProtocolRequest tokenProtocolRequest = (TokenProtocolRequest) o;
        return Objects.equals(this.clientId, tokenProtocolRequest.clientId)
                && Objects.equals(this.grantType, tokenProtocolRequest.grantType)
                && Objects.equals(this.redirectUri, tokenProtocolRequest.redirectUri)
                && Objects.equals(this.responseMode, tokenProtocolRequest.responseMode)
                && Objects.equals(this.responseType, tokenProtocolRequest.responseType)
                && Objects.equals(this.scope, tokenProtocolRequest.scope)
                && Objects.equals(this.state, tokenProtocolRequest.state);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(clientId, grantType, redirectUri, responseMode, responseType, scope, state);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TokenProtocolRequest {\n");
        sb.append("    clientId: ").append(toIndentedString(clientId)).append("\n");
        sb.append("    grantType: ").append(toIndentedString(grantType)).append("\n");
        sb.append("    redirectUri: ").append(toIndentedString(redirectUri)).append("\n");
        sb.append("    responseMode: ").append(toIndentedString(responseMode)).append("\n");
        sb.append("    responseType: ").append(toIndentedString(responseType)).append("\n");
        sb.append("    scope: ").append(toIndentedString(scope)).append("\n");
        sb.append("    state: ").append(toIndentedString(state)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
