package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * The type of token for token exchange.
 */
public enum TokenType {

    IETF_PARAMS_OAUTH_TOKEN_TYPE_ACCESS_TOKEN("urn:ietf:params:oauth:token-type:access_token"),

    IETF_PARAMS_OAUTH_TOKEN_TYPE_ID_TOKEN("urn:ietf:params:oauth:token-type:id_token"),

    IETF_PARAMS_OAUTH_TOKEN_TYPE_JWT("urn:ietf:params:oauth:token-type:jwt"),

    IETF_PARAMS_OAUTH_TOKEN_TYPE_REFRESH_TOKEN("urn:ietf:params:oauth:token-type:refresh_token"),

    IETF_PARAMS_OAUTH_TOKEN_TYPE_SAML1("urn:ietf:params:oauth:token-type:saml1"),

    IETF_PARAMS_OAUTH_TOKEN_TYPE_SAML2("urn:ietf:params:oauth:token-type:saml2"),

    OKTA_OAUTH_TOKEN_TYPE_WEB_SSO_TOKEN("urn:okta:oauth:token-type:web_sso_token"),

    X_OATH_PARAMS_OAUTH_TOKEN_TYPE_DEVICE_SECRET("urn:x-oath:params:oauth:token-type:device-secret"),

    UNKNOWN_DEFAULT_OPEN_API("unknown_default_open_api");

    private String value;

    TokenType(String value) {
        this.value = value;
    }

    @JsonValue
    public String getValue() {
        return value;
    }

    @Override
    public String toString() {
        return String.valueOf(value);
    }

    @JsonCreator
    public static TokenType fromValue(String value) {
        for (TokenType b : TokenType.values()) {
            if (b.value.equals(value)) {
                return b;
            }
        }
        return UNKNOWN_DEFAULT_OPEN_API;
    }

    /**
     * Convert the instance into URL query string.
     *
     * @param prefix
     *            prefix of the query string
     *
     * @return URL query string
     */
    public String toUrlQueryString(String prefix) {
        if (prefix == null) {
            prefix = "";
        }

        return String.format("%s=%s", prefix, this.toString().toString());
    }
}
