package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import com.okta.sdk.resource.model.UIElement;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * Properties of the UI schema
 */
@ApiModel(description = "Properties of the UI schema")
@JsonPropertyOrder({ UISchemaObject.JSON_PROPERTY_BUTTON_LABEL, UISchemaObject.JSON_PROPERTY_ELEMENTS,
        UISchemaObject.JSON_PROPERTY_LABEL, UISchemaObject.JSON_PROPERTY_TYPE })
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-01-23T09:50:29.349096-06:00[America/Chicago]", comments = "Generator version: 7.8.0")
public class UISchemaObject implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_BUTTON_LABEL = "buttonLabel";
    private String buttonLabel = "Submit";

    public static final String JSON_PROPERTY_ELEMENTS = "elements";
    private UIElement elements;

    public static final String JSON_PROPERTY_LABEL = "label";
    private String label = "Sign in";

    public static final String JSON_PROPERTY_TYPE = "type";
    private String type;

    public UISchemaObject() {
    }

    public UISchemaObject buttonLabel(String buttonLabel) {

        this.buttonLabel = buttonLabel;
        return this;
    }

    /**
     * Specifies the button label for the &#x60;Submit&#x60; button at the bottom of the enrollment form
     *
     * @return buttonLabel
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Specifies the button label for the `Submit` button at the bottom of the enrollment form")
    @JsonProperty(JSON_PROPERTY_BUTTON_LABEL)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getButtonLabel() {
        return buttonLabel;
    }

    @JsonProperty(JSON_PROPERTY_BUTTON_LABEL)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setButtonLabel(String buttonLabel) {
        this.buttonLabel = buttonLabel;
    }

    public UISchemaObject elements(UIElement elements) {

        this.elements = elements;
        return this;
    }

    /**
     * Get elements
     *
     * @return elements
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_ELEMENTS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public UIElement getElements() {
        return elements;
    }

    @JsonProperty(JSON_PROPERTY_ELEMENTS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setElements(UIElement elements) {
        this.elements = elements;
    }

    public UISchemaObject label(String label) {

        this.label = label;
        return this;
    }

    /**
     * Specifies the label at the top of the enrollment form under the logo
     *
     * @return label
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Specifies the label at the top of the enrollment form under the logo")
    @JsonProperty(JSON_PROPERTY_LABEL)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getLabel() {
        return label;
    }

    @JsonProperty(JSON_PROPERTY_LABEL)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setLabel(String label) {
        this.label = label;
    }

    public UISchemaObject type(String type) {

        this.type = type;
        return this;
    }

    /**
     * Specifies the type of layout
     *
     * @return type
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Specifies the type of layout")
    @JsonProperty(JSON_PROPERTY_TYPE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getType() {
        return type;
    }

    @JsonProperty(JSON_PROPERTY_TYPE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setType(String type) {
        this.type = type;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        UISchemaObject uiSchemaObject = (UISchemaObject) o;
        return Objects.equals(this.buttonLabel, uiSchemaObject.buttonLabel)
                && Objects.equals(this.elements, uiSchemaObject.elements)
                && Objects.equals(this.label, uiSchemaObject.label) && Objects.equals(this.type, uiSchemaObject.type);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(buttonLabel, elements, label, type);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class UISchemaObject {\n");
        sb.append("    buttonLabel: ").append(toIndentedString(buttonLabel)).append("\n");
        sb.append("    elements: ").append(toIndentedString(elements)).append("\n");
        sb.append("    label: ").append(toIndentedString(label)).append("\n");
        sb.append("    type: ").append(toIndentedString(type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
