package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import com.okta.sdk.resource.model.ProvisioningConnectionOauthRequest;
import com.okta.sdk.resource.model.ProvisioningConnectionOauthRequestProfile;
import com.okta.sdk.resource.model.ProvisioningConnectionTokenRequest;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * UpdateDefaultProvisioningConnectionForApplicationRequest
 */
@JsonPropertyOrder({ UpdateDefaultProvisioningConnectionForApplicationRequest.JSON_PROPERTY_BASE_URL,
        UpdateDefaultProvisioningConnectionForApplicationRequest.JSON_PROPERTY_PROFILE })
@JsonTypeName("updateDefaultProvisioningConnectionForApplication_request")
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-01-23T09:50:29.349096-06:00[America/Chicago]", comments = "Generator version: 7.8.0")
public class UpdateDefaultProvisioningConnectionForApplicationRequest implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_BASE_URL = "baseUrl";
    private String baseUrl;

    public static final String JSON_PROPERTY_PROFILE = "profile";
    private ProvisioningConnectionOauthRequestProfile profile;

    public UpdateDefaultProvisioningConnectionForApplicationRequest() {
    }

    public UpdateDefaultProvisioningConnectionForApplicationRequest baseUrl(String baseUrl) {

        this.baseUrl = baseUrl;
        return this;
    }

    /**
     * Only used for the Zscaler 2.0 (&#x60;zscalerbyz&#x60;) app. The base URL for the Zscaler 2.0 target app, which
     * also contains the Zscaler ID.
     *
     * @return baseUrl
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Only used for the Zscaler 2.0 (`zscalerbyz`) app. The base URL for the Zscaler 2.0 target app, which also contains the Zscaler ID.")
    @JsonProperty(JSON_PROPERTY_BASE_URL)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getBaseUrl() {
        return baseUrl;
    }

    @JsonProperty(JSON_PROPERTY_BASE_URL)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setBaseUrl(String baseUrl) {
        this.baseUrl = baseUrl;
    }

    public UpdateDefaultProvisioningConnectionForApplicationRequest profile(
            ProvisioningConnectionOauthRequestProfile profile) {

        this.profile = profile;
        return this;
    }

    /**
     * Get profile
     *
     * @return profile
     **/
    @javax.annotation.Nonnull
    @ApiModelProperty(required = true, value = "")
    @JsonProperty(JSON_PROPERTY_PROFILE)
    @JsonInclude(value = JsonInclude.Include.ALWAYS)

    public ProvisioningConnectionOauthRequestProfile getProfile() {
        return profile;
    }

    @JsonProperty(JSON_PROPERTY_PROFILE)
    @JsonInclude(value = JsonInclude.Include.ALWAYS)
    public void setProfile(ProvisioningConnectionOauthRequestProfile profile) {
        this.profile = profile;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        UpdateDefaultProvisioningConnectionForApplicationRequest updateDefaultProvisioningConnectionForApplicationRequest = (UpdateDefaultProvisioningConnectionForApplicationRequest) o;
        return Objects.equals(this.baseUrl, updateDefaultProvisioningConnectionForApplicationRequest.baseUrl)
                && Objects.equals(this.profile, updateDefaultProvisioningConnectionForApplicationRequest.profile);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(baseUrl, profile);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class UpdateDefaultProvisioningConnectionForApplicationRequest {\n");
        sb.append("    baseUrl: ").append(toIndentedString(baseUrl)).append("\n");
        sb.append("    profile: ").append(toIndentedString(profile)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
