package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import com.okta.sdk.resource.model.UserCredentials;
import com.okta.sdk.resource.model.UserLinks;
import com.okta.sdk.resource.model.UserProfile;
import com.okta.sdk.resource.model.UserStatus;
import com.okta.sdk.resource.model.UserType;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.Map;
import org.openapitools.jackson.nullable.JsonNullable;
import com.fasterxml.jackson.annotation.JsonIgnore;
import org.openapitools.jackson.nullable.JsonNullable;
import java.util.NoSuchElementException;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * User
 */
@JsonPropertyOrder({ User.JSON_PROPERTY_ACTIVATED, User.JSON_PROPERTY_CREATED, User.JSON_PROPERTY_CREDENTIALS,
        User.JSON_PROPERTY_ID, User.JSON_PROPERTY_LAST_LOGIN, User.JSON_PROPERTY_LAST_UPDATED,
        User.JSON_PROPERTY_PASSWORD_CHANGED, User.JSON_PROPERTY_PROFILE, User.JSON_PROPERTY_REALM_ID,
        User.JSON_PROPERTY_STATUS, User.JSON_PROPERTY_STATUS_CHANGED, User.JSON_PROPERTY_TRANSITIONING_TO_STATUS,
        User.JSON_PROPERTY_TYPE, User.JSON_PROPERTY_EMBEDDED, User.JSON_PROPERTY_LINKS })
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-01-23T09:50:29.349096-06:00[America/Chicago]", comments = "Generator version: 7.8.0")
public class User implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_ACTIVATED = "activated";
    private JsonNullable<OffsetDateTime> activated = JsonNullable.<OffsetDateTime> undefined();

    public static final String JSON_PROPERTY_CREATED = "created";
    private OffsetDateTime created;

    public static final String JSON_PROPERTY_CREDENTIALS = "credentials";
    private UserCredentials credentials;

    public static final String JSON_PROPERTY_ID = "id";
    private String id;

    public static final String JSON_PROPERTY_LAST_LOGIN = "lastLogin";
    private JsonNullable<OffsetDateTime> lastLogin = JsonNullable.<OffsetDateTime> undefined();

    public static final String JSON_PROPERTY_LAST_UPDATED = "lastUpdated";
    private OffsetDateTime lastUpdated;

    public static final String JSON_PROPERTY_PASSWORD_CHANGED = "passwordChanged";
    private JsonNullable<OffsetDateTime> passwordChanged = JsonNullable.<OffsetDateTime> undefined();

    public static final String JSON_PROPERTY_PROFILE = "profile";
    private UserProfile profile;

    public static final String JSON_PROPERTY_REALM_ID = "realmId";
    private String realmId;

    public static final String JSON_PROPERTY_STATUS = "status";
    private UserStatus status;

    public static final String JSON_PROPERTY_STATUS_CHANGED = "statusChanged";
    private JsonNullable<OffsetDateTime> statusChanged = JsonNullable.<OffsetDateTime> undefined();

    public static final String JSON_PROPERTY_TRANSITIONING_TO_STATUS = "transitioningToStatus";
    private UserStatus transitioningToStatus;

    public static final String JSON_PROPERTY_TYPE = "type";
    private UserType type;

    public static final String JSON_PROPERTY_EMBEDDED = "_embedded";
    private Map<String, Object> embedded = null;

    public static final String JSON_PROPERTY_LINKS = "_links";
    private UserLinks links;

    public User() {
    }

    /*
     * @JsonCreator public User(
     *
     * @JsonProperty(JSON_PROPERTY_ACTIVATED) OffsetDateTime activated,
     *
     * @JsonProperty(JSON_PROPERTY_CREATED) OffsetDateTime created,
     *
     * @JsonProperty(JSON_PROPERTY_ID) String id,
     *
     * @JsonProperty(JSON_PROPERTY_LAST_LOGIN) OffsetDateTime lastLogin,
     *
     * @JsonProperty(JSON_PROPERTY_LAST_UPDATED) OffsetDateTime lastUpdated,
     *
     * @JsonProperty(JSON_PROPERTY_PASSWORD_CHANGED) OffsetDateTime passwordChanged,
     *
     * @JsonProperty(JSON_PROPERTY_REALM_ID) String realmId,
     *
     * @JsonProperty(JSON_PROPERTY_STATUS_CHANGED) OffsetDateTime statusChanged,
     *
     * @JsonProperty(JSON_PROPERTY_EMBEDDED) Map<String, Object> embedded ) { this(); this.activated = activated;
     * this.created = created; this.id = id; this.lastLogin = lastLogin; this.lastUpdated = lastUpdated;
     * this.passwordChanged = passwordChanged; this.realmId = realmId; this.statusChanged = statusChanged; this.embedded
     * = embedded; }
     */

    /**
     * The timestamp when the User status transitioned to &#x60;ACTIVE&#x60;
     *
     * @return activated
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "The timestamp when the User status transitioned to `ACTIVE`")
    @JsonIgnore

    public OffsetDateTime getActivated() {

        if (activated == null) {
            activated = JsonNullable.<OffsetDateTime> undefined();
        }
        return activated.orElse(null);
    }

    @JsonProperty(JSON_PROPERTY_ACTIVATED)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public JsonNullable<OffsetDateTime> getActivated_JsonNullable() {
        return activated;
    }

    @JsonProperty(JSON_PROPERTY_ACTIVATED)
    private void setActivated_JsonNullable(JsonNullable<OffsetDateTime> activated) {
        this.activated = activated;
    }

    /**
     * The timestamp when the User was created
     *
     * @return created
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "The timestamp when the User was created")
    @JsonProperty(JSON_PROPERTY_CREATED)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public OffsetDateTime getCreated() {
        return created;
    }

    public User credentials(UserCredentials credentials) {

        this.credentials = credentials;
        return this;
    }

    /**
     * Get credentials
     *
     * @return credentials
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_CREDENTIALS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public UserCredentials getCredentials() {
        return credentials;
    }

    @JsonProperty(JSON_PROPERTY_CREDENTIALS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setCredentials(UserCredentials credentials) {
        this.credentials = credentials;
    }

    /**
     * The unique key for the user
     *
     * @return id
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "The unique key for the user")
    @JsonProperty(JSON_PROPERTY_ID)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getId() {
        return id;
    }

    /**
     * The timestamp of the last login
     *
     * @return lastLogin
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "The timestamp of the last login")
    @JsonIgnore

    public OffsetDateTime getLastLogin() {

        if (lastLogin == null) {
            lastLogin = JsonNullable.<OffsetDateTime> undefined();
        }
        return lastLogin.orElse(null);
    }

    @JsonProperty(JSON_PROPERTY_LAST_LOGIN)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public JsonNullable<OffsetDateTime> getLastLogin_JsonNullable() {
        return lastLogin;
    }

    @JsonProperty(JSON_PROPERTY_LAST_LOGIN)
    private void setLastLogin_JsonNullable(JsonNullable<OffsetDateTime> lastLogin) {
        this.lastLogin = lastLogin;
    }

    /**
     * The timestamp when the User was last updated
     *
     * @return lastUpdated
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "The timestamp when the User was last updated")
    @JsonProperty(JSON_PROPERTY_LAST_UPDATED)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public OffsetDateTime getLastUpdated() {
        return lastUpdated;
    }

    /**
     * The timestamp when the User&#39;s password was last updated
     *
     * @return passwordChanged
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "The timestamp when the User's password was last updated")
    @JsonIgnore

    public OffsetDateTime getPasswordChanged() {

        if (passwordChanged == null) {
            passwordChanged = JsonNullable.<OffsetDateTime> undefined();
        }
        return passwordChanged.orElse(null);
    }

    @JsonProperty(JSON_PROPERTY_PASSWORD_CHANGED)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public JsonNullable<OffsetDateTime> getPasswordChanged_JsonNullable() {
        return passwordChanged;
    }

    @JsonProperty(JSON_PROPERTY_PASSWORD_CHANGED)
    private void setPasswordChanged_JsonNullable(JsonNullable<OffsetDateTime> passwordChanged) {
        this.passwordChanged = passwordChanged;
    }

    public User profile(UserProfile profile) {

        this.profile = profile;
        return this;
    }

    /**
     * Get profile
     *
     * @return profile
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_PROFILE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public UserProfile getProfile() {
        return profile;
    }

    @JsonProperty(JSON_PROPERTY_PROFILE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setProfile(UserProfile profile) {
        this.profile = profile;
    }

    /**
     * &lt;div class&#x3D;\&quot;x-lifecycle-container\&quot;&gt;&lt;x-lifecycle
     * class&#x3D;\&quot;ea\&quot;&gt;&lt;/x-lifecycle&gt;&lt;/div&gt;The ID of the Realm in which the User is residing
     *
     * @return realmId
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(example = "guo1bfiNtSnZYILxO0g4", value = "<div class=\"x-lifecycle-container\"><x-lifecycle class=\"ea\"></x-lifecycle></div>The ID of the Realm in which the User is residing")
    @JsonProperty(JSON_PROPERTY_REALM_ID)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getRealmId() {
        return realmId;
    }

    public User status(UserStatus status) {

        this.status = status;
        return this;
    }

    /**
     * Get status
     *
     * @return status
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_STATUS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public UserStatus getStatus() {
        return status;
    }

    @JsonProperty(JSON_PROPERTY_STATUS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setStatus(UserStatus status) {
        this.status = status;
    }

    /**
     * The timestamp when the status of the User last changed
     *
     * @return statusChanged
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "The timestamp when the status of the User last changed")
    @JsonIgnore

    public OffsetDateTime getStatusChanged() {

        if (statusChanged == null) {
            statusChanged = JsonNullable.<OffsetDateTime> undefined();
        }
        return statusChanged.orElse(null);
    }

    @JsonProperty(JSON_PROPERTY_STATUS_CHANGED)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public JsonNullable<OffsetDateTime> getStatusChanged_JsonNullable() {
        return statusChanged;
    }

    @JsonProperty(JSON_PROPERTY_STATUS_CHANGED)
    private void setStatusChanged_JsonNullable(JsonNullable<OffsetDateTime> statusChanged) {
        this.statusChanged = statusChanged;
    }

    public User transitioningToStatus(UserStatus transitioningToStatus) {

        this.transitioningToStatus = transitioningToStatus;
        return this;
    }

    /**
     * Get transitioningToStatus
     *
     * @return transitioningToStatus
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_TRANSITIONING_TO_STATUS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public UserStatus getTransitioningToStatus() {
        return transitioningToStatus;
    }

    @JsonProperty(JSON_PROPERTY_TRANSITIONING_TO_STATUS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setTransitioningToStatus(UserStatus transitioningToStatus) {
        this.transitioningToStatus = transitioningToStatus;
    }

    public User type(UserType type) {

        this.type = type;
        return this;
    }

    /**
     * Get type
     *
     * @return type
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_TYPE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public UserType getType() {
        return type;
    }

    @JsonProperty(JSON_PROPERTY_TYPE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setType(UserType type) {
        this.type = type;
    }

    /**
     * Embedded resources related to the User using the [JSON Hypertext Application
     * Language](https://datatracker.ietf.org/doc/html/draft-kelly-json-hal-06) specification
     *
     * @return embedded
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Embedded resources related to the User using the [JSON Hypertext Application Language](https://datatracker.ietf.org/doc/html/draft-kelly-json-hal-06) specification")
    @JsonProperty(JSON_PROPERTY_EMBEDDED)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public Map<String, Object> getEmbedded() {
        return embedded;
    }

    public User links(UserLinks links) {

        this.links = links;
        return this;
    }

    /**
     * Get links
     *
     * @return links
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_LINKS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public UserLinks getLinks() {
        return links;
    }

    @JsonProperty(JSON_PROPERTY_LINKS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setLinks(UserLinks links) {
        this.links = links;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        User user = (User) o;
        return equalsNullable(this.activated, user.activated) && Objects.equals(this.created, user.created)
                && Objects.equals(this.credentials, user.credentials) && Objects.equals(this.id, user.id)
                && equalsNullable(this.lastLogin, user.lastLogin) && Objects.equals(this.lastUpdated, user.lastUpdated)
                && equalsNullable(this.passwordChanged, user.passwordChanged)
                && Objects.equals(this.profile, user.profile) && Objects.equals(this.realmId, user.realmId)
                && Objects.equals(this.status, user.status) && equalsNullable(this.statusChanged, user.statusChanged)
                && Objects.equals(this.transitioningToStatus, user.transitioningToStatus)
                && Objects.equals(this.type, user.type) && Objects.equals(this.embedded, user.embedded)
                && Objects.equals(this.links, user.links);
        // ;
    }

    private static <T> boolean equalsNullable(JsonNullable<T> a, JsonNullable<T> b) {
        return a == b
                || (a != null && b != null && a.isPresent() && b.isPresent() && Objects.deepEquals(a.get(), b.get()));
    }

    @Override
    public int hashCode() {
        return Objects.hash(hashCodeNullable(activated), created, credentials, id, hashCodeNullable(lastLogin),
                lastUpdated, hashCodeNullable(passwordChanged), profile, realmId, status,
                hashCodeNullable(statusChanged), transitioningToStatus, type, embedded, links);
    }

    private static <T> int hashCodeNullable(JsonNullable<T> a) {
        if (a == null) {
            return 1;
        }
        return a.isPresent() ? Arrays.deepHashCode(new Object[] { a.get() }) : 31;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class User {\n");
        sb.append("    activated: ").append(toIndentedString(activated)).append("\n");
        sb.append("    created: ").append(toIndentedString(created)).append("\n");
        sb.append("    credentials: ").append(toIndentedString(credentials)).append("\n");
        sb.append("    id: ").append(toIndentedString(id)).append("\n");
        sb.append("    lastLogin: ").append(toIndentedString(lastLogin)).append("\n");
        sb.append("    lastUpdated: ").append(toIndentedString(lastUpdated)).append("\n");
        sb.append("    passwordChanged: ").append(toIndentedString(passwordChanged)).append("\n");
        sb.append("    profile: ").append(toIndentedString(profile)).append("\n");
        sb.append("    realmId: ").append(toIndentedString(realmId)).append("\n");
        sb.append("    status: ").append(toIndentedString(status)).append("\n");
        sb.append("    statusChanged: ").append(toIndentedString(statusChanged)).append("\n");
        sb.append("    transitioningToStatus: ").append(toIndentedString(transitioningToStatus)).append("\n");
        sb.append("    type: ").append(toIndentedString(type)).append("\n");
        sb.append("    embedded: ").append(toIndentedString(embedded)).append("\n");
        sb.append("    links: ").append(toIndentedString(links)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
