package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * Type of Factor
 */
public enum UserFactorType {

    CALL("call"),

    EMAIL("email"),

    PUSH("push"),

    QUESTION("question"),

    SIGNED_NONCE("signed_nonce"),

    SMS("sms"),

    TOKEN("token"),

    TOKEN_HARDWARE("token:hardware"),

    TOKEN_HOTP("token:hotp"),

    TOKEN_SOFTWARE_TOTP("token:software:totp"),

    U2F("u2f"),

    WEB("web"),

    WEBAUTHN("webauthn"),

    UNKNOWN_DEFAULT_OPEN_API("unknown_default_open_api");

    private String value;

    UserFactorType(String value) {
        this.value = value;
    }

    @JsonValue
    public String getValue() {
        return value;
    }

    @Override
    public String toString() {
        return String.valueOf(value);
    }

    @JsonCreator
    public static UserFactorType fromValue(String value) {
        for (UserFactorType b : UserFactorType.values()) {
            if (b.value.equals(value)) {
                return b;
            }
        }
        return UNKNOWN_DEFAULT_OPEN_API;
    }

    /**
     * Convert the instance into URL query string.
     *
     * @param prefix
     *            prefix of the query string
     *
     * @return URL query string
     */
    public String toUrlQueryString(String prefix) {
        if (prefix == null) {
            prefix = "";
        }

        return String.format("%s=%s", prefix, this.toString().toString());
    }
}
