package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * UserFactorWebAuthnProfile
 */
@JsonPropertyOrder({ UserFactorWebAuthnProfile.JSON_PROPERTY_AUTHENTICATOR_NAME,
        UserFactorWebAuthnProfile.JSON_PROPERTY_CREDENTIAL_ID })
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-01-23T09:50:29.349096-06:00[America/Chicago]", comments = "Generator version: 7.8.0")
public class UserFactorWebAuthnProfile implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_AUTHENTICATOR_NAME = "authenticatorName";
    private String authenticatorName;

    public static final String JSON_PROPERTY_CREDENTIAL_ID = "credentialId";
    private String credentialId;

    public UserFactorWebAuthnProfile() {
    }

    public UserFactorWebAuthnProfile authenticatorName(String authenticatorName) {

        this.authenticatorName = authenticatorName;
        return this;
    }

    /**
     * Human-readable name of the authenticator
     *
     * @return authenticatorName
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(example = "MacBook Touch ID", value = "Human-readable name of the authenticator")
    @JsonProperty(JSON_PROPERTY_AUTHENTICATOR_NAME)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getAuthenticatorName() {
        return authenticatorName;
    }

    @JsonProperty(JSON_PROPERTY_AUTHENTICATOR_NAME)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setAuthenticatorName(String authenticatorName) {
        this.authenticatorName = authenticatorName;
    }

    public UserFactorWebAuthnProfile credentialId(String credentialId) {

        this.credentialId = credentialId;
        return this;
    }

    /**
     * ID for the Factor credential
     *
     * @return credentialId
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(example = "AHoOEhwvYiMv6SSwLp7KYRNttXtg_kYgQoQiEIWPFH_T3Ztp5Vj3bQ5H0LypIFR8ka8kfiCJ3I5qVpxrsd6JTMWKcE3xNh_U2QVF0Kwlan8Fiw", value = "ID for the Factor credential")
    @JsonProperty(JSON_PROPERTY_CREDENTIAL_ID)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getCredentialId() {
        return credentialId;
    }

    @JsonProperty(JSON_PROPERTY_CREDENTIAL_ID)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setCredentialId(String credentialId) {
        this.credentialId = credentialId;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        UserFactorWebAuthnProfile userFactorWebAuthnProfile = (UserFactorWebAuthnProfile) o;
        return Objects.equals(this.authenticatorName, userFactorWebAuthnProfile.authenticatorName)
                && Objects.equals(this.credentialId, userFactorWebAuthnProfile.credentialId);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(authenticatorName, credentialId);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class UserFactorWebAuthnProfile {\n");
        sb.append("    authenticatorName: ").append(toIndentedString(authenticatorName)).append("\n");
        sb.append("    credentialId: ").append(toIndentedString(credentialId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
