package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import com.okta.sdk.resource.model.UserIdentifierMatchType;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * Used in the User Identifier Condition object. Specifies the details of the patterns to match against.
 */
@ApiModel(description = "Used in the User Identifier Condition object. Specifies the details of the patterns to match against.")
@JsonPropertyOrder({ UserIdentifierConditionEvaluatorPattern.JSON_PROPERTY_MATCH_TYPE,
        UserIdentifierConditionEvaluatorPattern.JSON_PROPERTY_VALUE })
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-01-23T09:50:29.349096-06:00[America/Chicago]", comments = "Generator version: 7.8.0")
public class UserIdentifierConditionEvaluatorPattern implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_MATCH_TYPE = "matchType";
    private UserIdentifierMatchType matchType;

    public static final String JSON_PROPERTY_VALUE = "value";
    private String value;

    public UserIdentifierConditionEvaluatorPattern() {
    }

    public UserIdentifierConditionEvaluatorPattern matchType(UserIdentifierMatchType matchType) {

        this.matchType = matchType;
        return this;
    }

    /**
     * Get matchType
     *
     * @return matchType
     **/
    @javax.annotation.Nonnull
    @ApiModelProperty(required = true, value = "")
    @JsonProperty(JSON_PROPERTY_MATCH_TYPE)
    @JsonInclude(value = JsonInclude.Include.ALWAYS)

    public UserIdentifierMatchType getMatchType() {
        return matchType;
    }

    @JsonProperty(JSON_PROPERTY_MATCH_TYPE)
    @JsonInclude(value = JsonInclude.Include.ALWAYS)
    public void setMatchType(UserIdentifierMatchType matchType) {
        this.matchType = matchType;
    }

    public UserIdentifierConditionEvaluatorPattern value(String value) {

        this.value = value;
        return this;
    }

    /**
     * The regular expression or simple match string
     *
     * @return value
     **/
    @javax.annotation.Nonnull
    @ApiModelProperty(required = true, value = "The regular expression or simple match string")
    @JsonProperty(JSON_PROPERTY_VALUE)
    @JsonInclude(value = JsonInclude.Include.ALWAYS)

    public String getValue() {
        return value;
    }

    @JsonProperty(JSON_PROPERTY_VALUE)
    @JsonInclude(value = JsonInclude.Include.ALWAYS)
    public void setValue(String value) {
        this.value = value;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        UserIdentifierConditionEvaluatorPattern userIdentifierConditionEvaluatorPattern = (UserIdentifierConditionEvaluatorPattern) o;
        return Objects.equals(this.matchType, userIdentifierConditionEvaluatorPattern.matchType)
                && Objects.equals(this.value, userIdentifierConditionEvaluatorPattern.value);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(matchType, value);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class UserIdentifierConditionEvaluatorPattern {\n");
        sb.append("    matchType: ").append(toIndentedString(matchType)).append("\n");
        sb.append("    value: ").append(toIndentedString(value)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
