package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import com.okta.sdk.resource.model.UserSchemaAttributeEnum;
import com.okta.sdk.resource.model.UserSchemaAttributeFormat;
import com.okta.sdk.resource.model.UserSchemaAttributeItems;
import com.okta.sdk.resource.model.UserSchemaAttributeMaster;
import com.okta.sdk.resource.model.UserSchemaAttributeMutabilityString;
import com.okta.sdk.resource.model.UserSchemaAttributePermission;
import com.okta.sdk.resource.model.UserSchemaAttributeScope;
import com.okta.sdk.resource.model.UserSchemaAttributeType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.openapitools.jackson.nullable.JsonNullable;
import com.fasterxml.jackson.annotation.JsonIgnore;
import org.openapitools.jackson.nullable.JsonNullable;
import java.util.NoSuchElementException;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * UserSchemaAttribute
 */
@JsonPropertyOrder({ UserSchemaAttribute.JSON_PROPERTY_DESCRIPTION, UserSchemaAttribute.JSON_PROPERTY_ENUM,
        UserSchemaAttribute.JSON_PROPERTY_ITEMS, UserSchemaAttribute.JSON_PROPERTY_EXTERNAL_NAME,
        UserSchemaAttribute.JSON_PROPERTY_EXTERNAL_NAMESPACE, UserSchemaAttribute.JSON_PROPERTY_FORMAT,
        UserSchemaAttribute.JSON_PROPERTY_MASTER, UserSchemaAttribute.JSON_PROPERTY_MAX_LENGTH,
        UserSchemaAttribute.JSON_PROPERTY_MIN_LENGTH, UserSchemaAttribute.JSON_PROPERTY_MUTABILITY,
        UserSchemaAttribute.JSON_PROPERTY_ONE_OF, UserSchemaAttribute.JSON_PROPERTY_PATTERN,
        UserSchemaAttribute.JSON_PROPERTY_PERMISSIONS, UserSchemaAttribute.JSON_PROPERTY_REQUIRED,
        UserSchemaAttribute.JSON_PROPERTY_SCOPE, UserSchemaAttribute.JSON_PROPERTY_TITLE,
        UserSchemaAttribute.JSON_PROPERTY_TYPE, UserSchemaAttribute.JSON_PROPERTY_UNIQUE })
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-01-23T09:50:29.349096-06:00[America/Chicago]", comments = "Generator version: 7.8.0")
public class UserSchemaAttribute implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_DESCRIPTION = "description";
    private String description;

    public static final String JSON_PROPERTY_ENUM = "enum";
    private JsonNullable<List<String>> _enum = JsonNullable.<List<String>> undefined();

    public static final String JSON_PROPERTY_ITEMS = "items";
    private UserSchemaAttributeItems items;

    public static final String JSON_PROPERTY_EXTERNAL_NAME = "externalName";
    private String externalName;

    public static final String JSON_PROPERTY_EXTERNAL_NAMESPACE = "externalNamespace";
    private String externalNamespace;

    public static final String JSON_PROPERTY_FORMAT = "format";
    private UserSchemaAttributeFormat format;

    public static final String JSON_PROPERTY_MASTER = "master";
    private JsonNullable<UserSchemaAttributeMaster> master = JsonNullable.<UserSchemaAttributeMaster> undefined();

    public static final String JSON_PROPERTY_MAX_LENGTH = "maxLength";
    private JsonNullable<Integer> maxLength = JsonNullable.<Integer> undefined();

    public static final String JSON_PROPERTY_MIN_LENGTH = "minLength";
    private JsonNullable<Integer> minLength = JsonNullable.<Integer> undefined();

    public static final String JSON_PROPERTY_MUTABILITY = "mutability";
    private UserSchemaAttributeMutabilityString mutability;

    public static final String JSON_PROPERTY_ONE_OF = "oneOf";
    private JsonNullable<List<UserSchemaAttributeEnum>> oneOf = JsonNullable
            .<List<UserSchemaAttributeEnum>> undefined();

    public static final String JSON_PROPERTY_PATTERN = "pattern";
    private String pattern;

    public static final String JSON_PROPERTY_PERMISSIONS = "permissions";
    private JsonNullable<List<UserSchemaAttributePermission>> permissions = JsonNullable
            .<List<UserSchemaAttributePermission>> undefined();

    public static final String JSON_PROPERTY_REQUIRED = "required";
    private JsonNullable<Boolean> required = JsonNullable.<Boolean> undefined();

    public static final String JSON_PROPERTY_SCOPE = "scope";
    private UserSchemaAttributeScope scope;

    public static final String JSON_PROPERTY_TITLE = "title";
    private String title;

    public static final String JSON_PROPERTY_TYPE = "type";
    private UserSchemaAttributeType type;

    public static final String JSON_PROPERTY_UNIQUE = "unique";
    private String unique;

    public UserSchemaAttribute() {
    }

    public UserSchemaAttribute description(String description) {

        this.description = description;
        return this;
    }

    /**
     * Description of the property
     *
     * @return description
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Description of the property")
    @JsonProperty(JSON_PROPERTY_DESCRIPTION)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getDescription() {
        return description;
    }

    @JsonProperty(JSON_PROPERTY_DESCRIPTION)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setDescription(String description) {
        this.description = description;
    }

    public UserSchemaAttribute _enum(List<String> _enum) {
        this._enum = JsonNullable.<List<String>> of(_enum);

        return this;
    }

    public UserSchemaAttribute addenumItem(String _enumItem) {
        if (this._enum == null || !this._enum.isPresent()) {
            this._enum = JsonNullable.<List<String>> of(new ArrayList<>());
        }
        try {
            this._enum.get().add(_enumItem);
        } catch (java.util.NoSuchElementException e) {
            // this can never happen, as we make sure above that the value is present
        }
        return this;
    }

    /**
     * Enumerated value of the property. The value of the property is limited to one of the values specified in the enum
     * definition. The list of values for the enum must consist of unique elements.
     *
     * @return _enum
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Enumerated value of the property.  The value of the property is limited to one of the values specified in the enum definition. The list of values for the enum must consist of unique elements.")
    @JsonIgnore

    public List<String> getEnum() {
        return _enum.orElse(null);
    }

    @JsonProperty(JSON_PROPERTY_ENUM)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public JsonNullable<List<String>> getEnum_JsonNullable() {
        return _enum;
    }

    @JsonProperty(JSON_PROPERTY_ENUM)
    public void setEnum_JsonNullable(JsonNullable<List<String>> _enum) {
        this._enum = _enum;
    }

    public void setEnum(List<String> _enum) {
        this._enum = JsonNullable.<List<String>> of(_enum);
    }

    public UserSchemaAttribute items(UserSchemaAttributeItems items) {

        this.items = items;
        return this;
    }

    /**
     * Get items
     *
     * @return items
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_ITEMS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public UserSchemaAttributeItems getItems() {
        return items;
    }

    @JsonProperty(JSON_PROPERTY_ITEMS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setItems(UserSchemaAttributeItems items) {
        this.items = items;
    }

    public UserSchemaAttribute externalName(String externalName) {

        this.externalName = externalName;
        return this;
    }

    /**
     * Name of the property as it exists in an external application **NOTE**: When you add a custom property, only
     * Identity Provider app user schemas require &#x60;externalName&#x60; to be included in the request body. If an
     * existing custom Identity Provider app user schema property has an empty &#x60;externalName&#x60;, requests
     * aren&#39;t allowed to update other properties until the &#x60;externalName&#x60; is defined.
     *
     * @return externalName
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Name of the property as it exists in an external application  **NOTE**: When you add a custom property, only Identity Provider app user schemas require `externalName` to be included in the request body. If an existing custom Identity Provider app user schema property has an empty `externalName`, requests aren't allowed to update other properties until the `externalName` is defined.")
    @JsonProperty(JSON_PROPERTY_EXTERNAL_NAME)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getExternalName() {
        return externalName;
    }

    @JsonProperty(JSON_PROPERTY_EXTERNAL_NAME)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setExternalName(String externalName) {
        this.externalName = externalName;
    }

    public UserSchemaAttribute externalNamespace(String externalNamespace) {

        this.externalNamespace = externalNamespace;
        return this;
    }

    /**
     * Namespace from the external application
     *
     * @return externalNamespace
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Namespace from the external application")
    @JsonProperty(JSON_PROPERTY_EXTERNAL_NAMESPACE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getExternalNamespace() {
        return externalNamespace;
    }

    @JsonProperty(JSON_PROPERTY_EXTERNAL_NAMESPACE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setExternalNamespace(String externalNamespace) {
        this.externalNamespace = externalNamespace;
    }

    public UserSchemaAttribute format(UserSchemaAttributeFormat format) {

        this.format = format;
        return this;
    }

    /**
     * Identifies the type of data represented by the string
     *
     * @return format
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Identifies the type of data represented by the string")
    @JsonProperty(JSON_PROPERTY_FORMAT)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public UserSchemaAttributeFormat getFormat() {
        return format;
    }

    @JsonProperty(JSON_PROPERTY_FORMAT)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setFormat(UserSchemaAttributeFormat format) {
        this.format = format;
    }

    public UserSchemaAttribute master(UserSchemaAttributeMaster master) {
        this.master = JsonNullable.<UserSchemaAttributeMaster> of(master);

        return this;
    }

    /**
     * Identifies where the property is mastered
     *
     * @return master
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Identifies where the property is mastered")
    @JsonIgnore

    public UserSchemaAttributeMaster getMaster() {
        return master.orElse(null);
    }

    @JsonProperty(JSON_PROPERTY_MASTER)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public JsonNullable<UserSchemaAttributeMaster> getMaster_JsonNullable() {
        return master;
    }

    @JsonProperty(JSON_PROPERTY_MASTER)
    public void setMaster_JsonNullable(JsonNullable<UserSchemaAttributeMaster> master) {
        this.master = master;
    }

    public void setMaster(UserSchemaAttributeMaster master) {
        this.master = JsonNullable.<UserSchemaAttributeMaster> of(master);
    }

    public UserSchemaAttribute maxLength(Integer maxLength) {
        this.maxLength = JsonNullable.<Integer> of(maxLength);

        return this;
    }

    /**
     * Maximum character length of a string property
     *
     * @return maxLength
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Maximum character length of a string property")
    @JsonIgnore

    public Integer getMaxLength() {
        return maxLength.orElse(null);
    }

    @JsonProperty(JSON_PROPERTY_MAX_LENGTH)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public JsonNullable<Integer> getMaxLength_JsonNullable() {
        return maxLength;
    }

    @JsonProperty(JSON_PROPERTY_MAX_LENGTH)
    public void setMaxLength_JsonNullable(JsonNullable<Integer> maxLength) {
        this.maxLength = maxLength;
    }

    public void setMaxLength(Integer maxLength) {
        this.maxLength = JsonNullable.<Integer> of(maxLength);
    }

    public UserSchemaAttribute minLength(Integer minLength) {
        this.minLength = JsonNullable.<Integer> of(minLength);

        return this;
    }

    /**
     * Minimum character length of a string property
     *
     * @return minLength
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Minimum character length of a string property")
    @JsonIgnore

    public Integer getMinLength() {
        return minLength.orElse(null);
    }

    @JsonProperty(JSON_PROPERTY_MIN_LENGTH)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public JsonNullable<Integer> getMinLength_JsonNullable() {
        return minLength;
    }

    @JsonProperty(JSON_PROPERTY_MIN_LENGTH)
    public void setMinLength_JsonNullable(JsonNullable<Integer> minLength) {
        this.minLength = minLength;
    }

    public void setMinLength(Integer minLength) {
        this.minLength = JsonNullable.<Integer> of(minLength);
    }

    public UserSchemaAttribute mutability(UserSchemaAttributeMutabilityString mutability) {

        this.mutability = mutability;
        return this;
    }

    /**
     * Defines the mutability of the property
     *
     * @return mutability
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Defines the mutability of the property")
    @JsonProperty(JSON_PROPERTY_MUTABILITY)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public UserSchemaAttributeMutabilityString getMutability() {
        return mutability;
    }

    @JsonProperty(JSON_PROPERTY_MUTABILITY)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setMutability(UserSchemaAttributeMutabilityString mutability) {
        this.mutability = mutability;
    }

    public UserSchemaAttribute oneOf(List<UserSchemaAttributeEnum> oneOf) {
        this.oneOf = JsonNullable.<List<UserSchemaAttributeEnum>> of(oneOf);

        return this;
    }

    public UserSchemaAttribute addoneOfItem(UserSchemaAttributeEnum oneOfItem) {
        if (this.oneOf == null || !this.oneOf.isPresent()) {
            this.oneOf = JsonNullable.<List<UserSchemaAttributeEnum>> of(new ArrayList<>());
        }
        try {
            this.oneOf.get().add(oneOfItem);
        } catch (java.util.NoSuchElementException e) {
            // this can never happen, as we make sure above that the value is present
        }
        return this;
    }

    /**
     * Non-empty array of valid JSON schemas. Okta only supports &#x60;oneOf&#x60; for specifying display names for an
     * &#x60;enum&#x60;. Each schema has the following format: &#x60;&#x60;&#x60; { \&quot;const\&quot;:
     * \&quot;enumValue\&quot;, \&quot;title\&quot;: \&quot;display name\&quot; } &#x60;&#x60;&#x60;json When
     * &#x60;enum&#x60; is used in conjunction with &#x60;oneOf&#x60;, you must keep the set of enumerated values and
     * their order. &#x60;&#x60;&#x60; {\&quot;enum\&quot;:
     * [\&quot;S\&quot;,\&quot;M\&quot;,\&quot;L\&quot;,\&quot;XL\&quot;], \&quot;oneOf\&quot;: [ {\&quot;const\&quot;:
     * \&quot;S\&quot;, \&quot;title\&quot;: \&quot;Small\&quot;}, {\&quot;const\&quot;: \&quot;M\&quot;,
     * \&quot;title\&quot;: \&quot;Medium\&quot;}, {\&quot;const\&quot;: \&quot;L\&quot;, \&quot;title\&quot;:
     * \&quot;Large\&quot;}, {\&quot;const\&quot;: \&quot;XL\&quot;, \&quot;title\&quot;: \&quot;Extra Large\&quot;} ] }
     * &#x60;&#x60;&#x60;json The &#x60;oneOf&#x60; key is only supported in conjunction with &#x60;enum&#x60; and
     * provides a mechanism to return a display name for the &#x60;enum&#x60; value.
     *
     * @return oneOf
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Non-empty array of valid JSON schemas.  Okta only supports `oneOf` for specifying display names for an `enum`. Each schema has the following format:    ```     {       \"const\": \"enumValue\",       \"title\": \"display name\"     }   ```json  When `enum` is used in conjunction with `oneOf`, you must keep the set of enumerated values and their order.    ```     {\"enum\": [\"S\",\"M\",\"L\",\"XL\"],       \"oneOf\": [         {\"const\": \"S\", \"title\": \"Small\"},         {\"const\": \"M\", \"title\": \"Medium\"},         {\"const\": \"L\", \"title\": \"Large\"},         {\"const\": \"XL\", \"title\": \"Extra Large\"}       ]     }   ```json  The `oneOf` key is only supported in conjunction with `enum` and provides a mechanism to return a display name for the `enum` value.")
    @JsonIgnore

    public List<UserSchemaAttributeEnum> getOneOf() {
        return oneOf.orElse(null);
    }

    @JsonProperty(JSON_PROPERTY_ONE_OF)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public JsonNullable<List<UserSchemaAttributeEnum>> getOneOf_JsonNullable() {
        return oneOf;
    }

    @JsonProperty(JSON_PROPERTY_ONE_OF)
    public void setOneOf_JsonNullable(JsonNullable<List<UserSchemaAttributeEnum>> oneOf) {
        this.oneOf = oneOf;
    }

    public void setOneOf(List<UserSchemaAttributeEnum> oneOf) {
        this.oneOf = JsonNullable.<List<UserSchemaAttributeEnum>> of(oneOf);
    }

    public UserSchemaAttribute pattern(String pattern) {

        this.pattern = pattern;
        return this;
    }

    /**
     * For &#x60;string&#x60; property types, specifies the regular expression used to validate the property
     *
     * @return pattern
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "For `string` property types, specifies the regular expression used to validate the property")
    @JsonProperty(JSON_PROPERTY_PATTERN)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getPattern() {
        return pattern;
    }

    @JsonProperty(JSON_PROPERTY_PATTERN)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setPattern(String pattern) {
        this.pattern = pattern;
    }

    public UserSchemaAttribute permissions(List<UserSchemaAttributePermission> permissions) {
        this.permissions = JsonNullable.<List<UserSchemaAttributePermission>> of(permissions);

        return this;
    }

    public UserSchemaAttribute addpermissionsItem(UserSchemaAttributePermission permissionsItem) {
        if (this.permissions == null || !this.permissions.isPresent()) {
            this.permissions = JsonNullable.<List<UserSchemaAttributePermission>> of(new ArrayList<>());
        }
        try {
            this.permissions.get().add(permissionsItem);
        } catch (java.util.NoSuchElementException e) {
            // this can never happen, as we make sure above that the value is present
        }
        return this;
    }

    /**
     * Access control permissions for the property
     *
     * @return permissions
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Access control permissions for the property")
    @JsonIgnore

    public List<UserSchemaAttributePermission> getPermissions() {
        return permissions.orElse(null);
    }

    @JsonProperty(JSON_PROPERTY_PERMISSIONS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public JsonNullable<List<UserSchemaAttributePermission>> getPermissions_JsonNullable() {
        return permissions;
    }

    @JsonProperty(JSON_PROPERTY_PERMISSIONS)
    public void setPermissions_JsonNullable(JsonNullable<List<UserSchemaAttributePermission>> permissions) {
        this.permissions = permissions;
    }

    public void setPermissions(List<UserSchemaAttributePermission> permissions) {
        this.permissions = JsonNullable.<List<UserSchemaAttributePermission>> of(permissions);
    }

    public UserSchemaAttribute required(Boolean required) {
        this.required = JsonNullable.<Boolean> of(required);

        return this;
    }

    /**
     * Determines whether the property is required
     *
     * @return required
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Determines whether the property is required")
    @JsonIgnore

    public Boolean getRequired() {
        return required.orElse(null);
    }

    @JsonProperty(JSON_PROPERTY_REQUIRED)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public JsonNullable<Boolean> getRequired_JsonNullable() {
        return required;
    }

    @JsonProperty(JSON_PROPERTY_REQUIRED)
    public void setRequired_JsonNullable(JsonNullable<Boolean> required) {
        this.required = required;
    }

    public void setRequired(Boolean required) {
        this.required = JsonNullable.<Boolean> of(required);
    }

    public UserSchemaAttribute scope(UserSchemaAttributeScope scope) {

        this.scope = scope;
        return this;
    }

    /**
     * Get scope
     *
     * @return scope
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_SCOPE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public UserSchemaAttributeScope getScope() {
        return scope;
    }

    @JsonProperty(JSON_PROPERTY_SCOPE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setScope(UserSchemaAttributeScope scope) {
        this.scope = scope;
    }

    public UserSchemaAttribute title(String title) {

        this.title = title;
        return this;
    }

    /**
     * User-defined display name for the property
     *
     * @return title
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "User-defined display name for the property")
    @JsonProperty(JSON_PROPERTY_TITLE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getTitle() {
        return title;
    }

    @JsonProperty(JSON_PROPERTY_TITLE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setTitle(String title) {
        this.title = title;
    }

    public UserSchemaAttribute type(UserSchemaAttributeType type) {

        this.type = type;
        return this;
    }

    /**
     * Type of property
     *
     * @return type
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Type of property")
    @JsonProperty(JSON_PROPERTY_TYPE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public UserSchemaAttributeType getType() {
        return type;
    }

    @JsonProperty(JSON_PROPERTY_TYPE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setType(UserSchemaAttributeType type) {
        this.type = type;
    }

    public UserSchemaAttribute unique(String unique) {

        this.unique = unique;
        return this;
    }

    /**
     * Get unique
     *
     * @return unique
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_UNIQUE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getUnique() {
        return unique;
    }

    @JsonProperty(JSON_PROPERTY_UNIQUE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setUnique(String unique) {
        this.unique = unique;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        UserSchemaAttribute userSchemaAttribute = (UserSchemaAttribute) o;
        return Objects.equals(this.description, userSchemaAttribute.description)
                && equalsNullable(this._enum, userSchemaAttribute._enum)
                && Objects.equals(this.items, userSchemaAttribute.items)
                && Objects.equals(this.externalName, userSchemaAttribute.externalName)
                && Objects.equals(this.externalNamespace, userSchemaAttribute.externalNamespace)
                && Objects.equals(this.format, userSchemaAttribute.format)
                && equalsNullable(this.master, userSchemaAttribute.master)
                && equalsNullable(this.maxLength, userSchemaAttribute.maxLength)
                && equalsNullable(this.minLength, userSchemaAttribute.minLength)
                && Objects.equals(this.mutability, userSchemaAttribute.mutability)
                && equalsNullable(this.oneOf, userSchemaAttribute.oneOf)
                && Objects.equals(this.pattern, userSchemaAttribute.pattern)
                && equalsNullable(this.permissions, userSchemaAttribute.permissions)
                && equalsNullable(this.required, userSchemaAttribute.required)
                && Objects.equals(this.scope, userSchemaAttribute.scope)
                && Objects.equals(this.title, userSchemaAttribute.title)
                && Objects.equals(this.type, userSchemaAttribute.type)
                && Objects.equals(this.unique, userSchemaAttribute.unique);
        // ;
    }

    private static <T> boolean equalsNullable(JsonNullable<T> a, JsonNullable<T> b) {
        return a == b
                || (a != null && b != null && a.isPresent() && b.isPresent() && Objects.deepEquals(a.get(), b.get()));
    }

    @Override
    public int hashCode() {
        return Objects.hash(description, hashCodeNullable(_enum), items, externalName, externalNamespace, format,
                hashCodeNullable(master), hashCodeNullable(maxLength), hashCodeNullable(minLength), mutability,
                hashCodeNullable(oneOf), pattern, hashCodeNullable(permissions), hashCodeNullable(required), scope,
                title, type, unique);
    }

    private static <T> int hashCodeNullable(JsonNullable<T> a) {
        if (a == null) {
            return 1;
        }
        return a.isPresent() ? Arrays.deepHashCode(new Object[] { a.get() }) : 31;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class UserSchemaAttribute {\n");
        sb.append("    description: ").append(toIndentedString(description)).append("\n");
        sb.append("    _enum: ").append(toIndentedString(_enum)).append("\n");
        sb.append("    items: ").append(toIndentedString(items)).append("\n");
        sb.append("    externalName: ").append(toIndentedString(externalName)).append("\n");
        sb.append("    externalNamespace: ").append(toIndentedString(externalNamespace)).append("\n");
        sb.append("    format: ").append(toIndentedString(format)).append("\n");
        sb.append("    master: ").append(toIndentedString(master)).append("\n");
        sb.append("    maxLength: ").append(toIndentedString(maxLength)).append("\n");
        sb.append("    minLength: ").append(toIndentedString(minLength)).append("\n");
        sb.append("    mutability: ").append(toIndentedString(mutability)).append("\n");
        sb.append("    oneOf: ").append(toIndentedString(oneOf)).append("\n");
        sb.append("    pattern: ").append(toIndentedString(pattern)).append("\n");
        sb.append("    permissions: ").append(toIndentedString(permissions)).append("\n");
        sb.append("    required: ").append(toIndentedString(required)).append("\n");
        sb.append("    scope: ").append(toIndentedString(scope)).append("\n");
        sb.append("    title: ").append(toIndentedString(title)).append("\n");
        sb.append("    type: ").append(toIndentedString(type)).append("\n");
        sb.append("    unique: ").append(toIndentedString(unique)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
