package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * Credential request object for the initialized credential, along with the enrollment and key identifiers to associate
 * with the credential
 */
@ApiModel(description = "Credential request object for the initialized credential, along with the enrollment and key identifiers to associate with the credential")
@JsonPropertyOrder({ WebAuthnCredRequest.JSON_PROPERTY_AUTHENTICATOR_ENROLLMENT_ID,
        WebAuthnCredRequest.JSON_PROPERTY_CRED_REQUEST_JWE, WebAuthnCredRequest.JSON_PROPERTY_KEY_ID })
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-01-23T09:50:29.349096-06:00[America/Chicago]", comments = "Generator version: 7.8.0")
public class WebAuthnCredRequest implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_AUTHENTICATOR_ENROLLMENT_ID = "authenticatorEnrollmentId";
    private String authenticatorEnrollmentId;

    public static final String JSON_PROPERTY_CRED_REQUEST_JWE = "credRequestJwe";
    private String credRequestJwe;

    public static final String JSON_PROPERTY_KEY_ID = "keyId";
    private String keyId;

    public WebAuthnCredRequest() {
    }

    public WebAuthnCredRequest authenticatorEnrollmentId(String authenticatorEnrollmentId) {

        this.authenticatorEnrollmentId = authenticatorEnrollmentId;
        return this;
    }

    /**
     * ID for a WebAuthn Preregistration Factor in Okta
     *
     * @return authenticatorEnrollmentId
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "ID for a WebAuthn Preregistration Factor in Okta")
    @JsonProperty(JSON_PROPERTY_AUTHENTICATOR_ENROLLMENT_ID)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getAuthenticatorEnrollmentId() {
        return authenticatorEnrollmentId;
    }

    @JsonProperty(JSON_PROPERTY_AUTHENTICATOR_ENROLLMENT_ID)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setAuthenticatorEnrollmentId(String authenticatorEnrollmentId) {
        this.authenticatorEnrollmentId = authenticatorEnrollmentId;
    }

    public WebAuthnCredRequest credRequestJwe(String credRequestJwe) {

        this.credRequestJwe = credRequestJwe;
        return this;
    }

    /**
     * Encrypted JWE of credential request for the fulfillment provider
     *
     * @return credRequestJwe
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Encrypted JWE of credential request for the fulfillment provider")
    @JsonProperty(JSON_PROPERTY_CRED_REQUEST_JWE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getCredRequestJwe() {
        return credRequestJwe;
    }

    @JsonProperty(JSON_PROPERTY_CRED_REQUEST_JWE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setCredRequestJwe(String credRequestJwe) {
        this.credRequestJwe = credRequestJwe;
    }

    public WebAuthnCredRequest keyId(String keyId) {

        this.keyId = keyId;
        return this;
    }

    /**
     * ID for the Okta response key-pair used to encrypt and decrypt credential requests and responses
     *
     * @return keyId
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "ID for the Okta response key-pair used to encrypt and decrypt credential requests and responses")
    @JsonProperty(JSON_PROPERTY_KEY_ID)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getKeyId() {
        return keyId;
    }

    @JsonProperty(JSON_PROPERTY_KEY_ID)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setKeyId(String keyId) {
        this.keyId = keyId;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        WebAuthnCredRequest webAuthnCredRequest = (WebAuthnCredRequest) o;
        return Objects.equals(this.authenticatorEnrollmentId, webAuthnCredRequest.authenticatorEnrollmentId)
                && Objects.equals(this.credRequestJwe, webAuthnCredRequest.credRequestJwe)
                && Objects.equals(this.keyId, webAuthnCredRequest.keyId);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(authenticatorEnrollmentId, credRequestJwe, keyId);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class WebAuthnCredRequest {\n");
        sb.append("    authenticatorEnrollmentId: ").append(toIndentedString(authenticatorEnrollmentId)).append("\n");
        sb.append("    credRequestJwe: ").append(toIndentedString(credRequestJwe)).append("\n");
        sb.append("    keyId: ").append(toIndentedString(keyId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
