package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import com.okta.sdk.resource.model.PipelineType;
import com.okta.sdk.resource.model.WellKnownOrgMetadataLinks;
import com.okta.sdk.resource.model.WellKnownOrgMetadataSettings;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * WellKnownOrgMetadata
 */
@JsonPropertyOrder({ WellKnownOrgMetadata.JSON_PROPERTY_ID, WellKnownOrgMetadata.JSON_PROPERTY_PIPELINE,
        WellKnownOrgMetadata.JSON_PROPERTY_SETTINGS, WellKnownOrgMetadata.JSON_PROPERTY_LINKS })
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-01-23T09:50:29.349096-06:00[America/Chicago]", comments = "Generator version: 7.8.0")
public class WellKnownOrgMetadata implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_ID = "id";
    private String id;

    public static final String JSON_PROPERTY_PIPELINE = "pipeline";
    private PipelineType pipeline;

    public static final String JSON_PROPERTY_SETTINGS = "settings";
    private WellKnownOrgMetadataSettings settings;

    public static final String JSON_PROPERTY_LINKS = "_links";
    private WellKnownOrgMetadataLinks links;

    public WellKnownOrgMetadata() {
    }

    public WellKnownOrgMetadata id(String id) {

        this.id = id;
        return this;
    }

    /**
     * The unique identifier of the Org
     *
     * @return id
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "The unique identifier of the Org")
    @JsonProperty(JSON_PROPERTY_ID)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getId() {
        return id;
    }

    @JsonProperty(JSON_PROPERTY_ID)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setId(String id) {
        this.id = id;
    }

    public WellKnownOrgMetadata pipeline(PipelineType pipeline) {

        this.pipeline = pipeline;
        return this;
    }

    /**
     * Get pipeline
     *
     * @return pipeline
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_PIPELINE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public PipelineType getPipeline() {
        return pipeline;
    }

    @JsonProperty(JSON_PROPERTY_PIPELINE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setPipeline(PipelineType pipeline) {
        this.pipeline = pipeline;
    }

    public WellKnownOrgMetadata settings(WellKnownOrgMetadataSettings settings) {

        this.settings = settings;
        return this;
    }

    /**
     * Get settings
     *
     * @return settings
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_SETTINGS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public WellKnownOrgMetadataSettings getSettings() {
        return settings;
    }

    @JsonProperty(JSON_PROPERTY_SETTINGS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setSettings(WellKnownOrgMetadataSettings settings) {
        this.settings = settings;
    }

    public WellKnownOrgMetadata links(WellKnownOrgMetadataLinks links) {

        this.links = links;
        return this;
    }

    /**
     * Get links
     *
     * @return links
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_LINKS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public WellKnownOrgMetadataLinks getLinks() {
        return links;
    }

    @JsonProperty(JSON_PROPERTY_LINKS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setLinks(WellKnownOrgMetadataLinks links) {
        this.links = links;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        WellKnownOrgMetadata wellKnownOrgMetadata = (WellKnownOrgMetadata) o;
        return Objects.equals(this.id, wellKnownOrgMetadata.id)
                && Objects.equals(this.pipeline, wellKnownOrgMetadata.pipeline)
                && Objects.equals(this.settings, wellKnownOrgMetadata.settings)
                && Objects.equals(this.links, wellKnownOrgMetadata.links);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(id, pipeline, settings, links);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class WellKnownOrgMetadata {\n");
        sb.append("    id: ").append(toIndentedString(id)).append("\n");
        sb.append("    pipeline: ").append(toIndentedString(pipeline)).append("\n");
        sb.append("    settings: ").append(toIndentedString(settings)).append("\n");
        sb.append("    links: ").append(toIndentedString(links)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
