

# Application


## Properties

| Name | Type | Description | Notes |
|------------ | ------------- | ------------- | -------------|
|**accessibility** | [**ApplicationAccessibility**](ApplicationAccessibility.md) |  |  [optional] |
|**created** | **OffsetDateTime** | Timestamp when the Application object was created |  [optional] [readonly] |
|**features** | [**List&lt;FeaturesEnum&gt;**](#List&lt;FeaturesEnum&gt;) | Enabled app features &gt; **Note:** Some apps can support optional provisioning features. See [Application Features](/openapi/okta-management/management/tag/ApplicationFeatures/)  |  [optional] |
|**id** | **String** | Unique ID for the app instance |  [optional] [readonly] |
|**label** | **String** | User-defined display name for app |  |
|**lastUpdated** | **OffsetDateTime** | Timestamp when the Application object was last updated |  [optional] [readonly] |
|**licensing** | [**ApplicationLicensing**](ApplicationLicensing.md) |  |  [optional] |
|**orn** | **String** | The Okta resource name (ORN) for the current app instance |  [optional] [readonly] |
|**profile** | **Map&lt;String, Object&gt;** | Contains any valid JSON schema for specifying properties that can be referenced from a request (only available to OAuth 2.0 client apps). For example, add an app manager contact email address or define an allowlist of groups that you can then reference using the Okta Expression Language &#x60;getFilteredGroups&#x60; function.  &gt; **Notes:** &gt; * &#x60;profile&#x60; isn&#39;t encrypted, so don&#39;t store sensitive data in it. &gt; * &#x60;profile&#x60; doesn&#39;t limit the level of nesting in the JSON schema you created, but there is a practical size limit. Okta recommends a JSON schema size of 1 MB or less for best performance. |  [optional] |
|**signOnMode** | **ApplicationSignOnMode** |  |  |
|**status** | **ApplicationLifecycleStatus** |  |  [optional] |
|**visibility** | [**ApplicationVisibility**](ApplicationVisibility.md) |  |  [optional] |
|**embedded** | [**ApplicationEmbedded**](ApplicationEmbedded.md) |  |  [optional] |
|**links** | [**ApplicationLinks**](ApplicationLinks.md) |  |  [optional] |



## Enum: List&lt;FeaturesEnum&gt;

| Name | Value |
|---- | -----|
| GROUP_PUSH | &quot;GROUP_PUSH&quot; |
| IMPORT_NEW_USERS | &quot;IMPORT_NEW_USERS&quot; |
| IMPORT_PROFILE_UPDATES | &quot;IMPORT_PROFILE_UPDATES&quot; |
| IMPORT_USER_SCHEMA | &quot;IMPORT_USER_SCHEMA&quot; |
| PROFILE_MASTERING | &quot;PROFILE_MASTERING&quot; |
| PUSH_NEW_USERS | &quot;PUSH_NEW_USERS&quot; |
| PUSH_PASSWORD_UPDATES | &quot;PUSH_PASSWORD_UPDATES&quot; |
| PUSH_PROFILE_UPDATES | &quot;PUSH_PROFILE_UPDATES&quot; |
| PUSH_USER_DEACTIVATION | &quot;PUSH_USER_DEACTIVATION&quot; |
| REACTIVATE_USERS | &quot;REACTIVATE_USERS&quot; |
| OUTBOUND_DEL_AUTH | &quot;OUTBOUND_DEL_AUTH&quot; |
| DESKTOP_SSO | &quot;DESKTOP_SSO&quot; |
| FEDERATED_PROFILE | &quot;FEDERATED_PROFILE&quot; |
| SUPPRESS_ACTIVATION_EMAIL | &quot;SUPPRESS_ACTIVATION_EMAIL&quot; |
| PUSH_PENDING_USERS | &quot;PUSH_PENDING_USERS&quot; |
| MFA | &quot;MFA&quot; |
| UPDATE_EXISTING_USERNAME | &quot;UPDATE_EXISTING_USERNAME&quot; |
| EXCLUDE_USERNAME_UPDATE_ON_PROFILE_PUSH | &quot;EXCLUDE_USERNAME_UPDATE_ON_PROFILE_PUSH&quot; |
| EXCHANGE_ACTIVE_SYNC | &quot;EXCHANGE_ACTIVE_SYNC&quot; |
| IMPORT_SYNC | &quot;IMPORT_SYNC&quot; |
| IMPORT_SYNC_CONTACTS | &quot;IMPORT_SYNC_CONTACTS&quot; |
| DEVICE_COMPLIANCE | &quot;DEVICE_COMPLIANCE&quot; |
| VPN_CONFIG | &quot;VPN_CONFIG&quot; |
| IMPORT_SCHEMA_ENUM_VALUES | &quot;IMPORT_SCHEMA_ENUM_VALUES&quot; |
| SCIM_PROVISIONING | &quot;SCIM_PROVISIONING&quot; |
| DEVICE_FILTER_IN_SIGN_ON_RULES | &quot;DEVICE_FILTER_IN_SIGN_ON_RULES&quot; |
| PROFILE_TEMPLATE_UPGRADE | &quot;PROFILE_TEMPLATE_UPGRADE&quot; |
| DEFAULT_PUSH_STATUS_TO_PUSH | &quot;DEFAULT_PUSH_STATUS_TO_PUSH&quot; |
| REAL_TIME_SYNC | &quot;REAL_TIME_SYNC&quot; |
| SSO | &quot;SSO&quot; |
| AUTHN_CONTEXT | &quot;AUTHN_CONTEXT&quot; |
| JIT_PROVISIONING | &quot;JIT_PROVISIONING&quot; |
| GROUP_SYNC | &quot;GROUP_SYNC&quot; |
| OPP_SCIM_INCREMENTAL_IMPORTS | &quot;OPP_SCIM_INCREMENTAL_IMPORTS&quot; |
| IN_MEMORY_APP_USER | &quot;IN_MEMORY_APP_USER&quot; |
| LOG_STREAMING | &quot;LOG_STREAMING&quot; |
| OAUTH_INTEGRATION | &quot;OAUTH_INTEGRATION&quot; |
| IDP | &quot;IDP&quot; |
| PUSH_NEW_USERS_WITHOUT_PASSWORD | &quot;PUSH_NEW_USERS_WITHOUT_PASSWORD&quot; |
| SKYHOOK_SERVICE | &quot;SKYHOOK_SERVICE&quot; |
| ENTITLEMENT_MANAGEMENT | &quot;ENTITLEMENT_MANAGEMENT&quot; |
| PUSH_NEW_USERS_WITH_HASHED_PASSWORD | &quot;PUSH_NEW_USERS_WITH_HASHED_PASSWORD&quot; |
| UNKNOWN_DEFAULT_OPEN_API | &quot;unknown_default_open_api&quot; |


## Implemented Interfaces

* Serializable


