# ApplicationConnectionsApi

All URIs are relative to *https://subdomain.okta.com*

| Method | HTTP request | Description |
|------------- | ------------- | -------------|
| [**activateDefaultProvisioningConnectionForApplication**](ApplicationConnectionsApi.md#activateDefaultProvisioningConnectionForApplication) | **POST** /api/v1/apps/{appId}/connections/default/lifecycle/activate | Activate the default Provisioning Connection |
| [**deactivateDefaultProvisioningConnectionForApplication**](ApplicationConnectionsApi.md#deactivateDefaultProvisioningConnectionForApplication) | **POST** /api/v1/apps/{appId}/connections/default/lifecycle/deactivate | Deactivate the default Provisioning Connection |
| [**getDefaultProvisioningConnectionForApplication**](ApplicationConnectionsApi.md#getDefaultProvisioningConnectionForApplication) | **GET** /api/v1/apps/{appId}/connections/default | Retrieve the default Provisioning Connection |
| [**updateDefaultProvisioningConnectionForApplication**](ApplicationConnectionsApi.md#updateDefaultProvisioningConnectionForApplication) | **POST** /api/v1/apps/{appId}/connections/default | Update the default Provisioning Connection |
| [**verifyProvisioningConnectionForApplication**](ApplicationConnectionsApi.md#verifyProvisioningConnectionForApplication) | **POST** /api/v1/apps/{appName}/{appId}/oauth2/callback | Verify the Provisioning Connection |



## activateDefaultProvisioningConnectionForApplication

> activateDefaultProvisioningConnectionForApplication(appId)

Activate the default Provisioning Connection

Activates the default Provisioning Connection for an app

### Example

```java
// Import classes:
import com.okta.sdk.resource.client.ApiClient;
import com.okta.sdk.resource.client.ApiException;
import com.okta.sdk.resource.client.Configuration;
import com.okta.sdk.resource.client.auth.*;
import com.okta.sdk.resource.client.models.*;
import com.okta.sdk.resource.api.ApplicationConnectionsApi;

public class Example {
    public static void main(String[] args) {
        ApiClient defaultClient = Configuration.getDefaultApiClient();
        defaultClient.setBasePath("https://subdomain.okta.com");
        
        // Configure API key authorization: apiToken
        ApiKeyAuth apiToken = (ApiKeyAuth) defaultClient.getAuthentication("apiToken");
        apiToken.setApiKey("YOUR API KEY");
        // Uncomment the following line to set a prefix for the API key, e.g. "Token" (defaults to null)
        //apiToken.setApiKeyPrefix("Token");

        // Configure OAuth2 access token for authorization: oauth2
        OAuth oauth2 = (OAuth) defaultClient.getAuthentication("oauth2");
        oauth2.setAccessToken("YOUR ACCESS TOKEN");

        ApplicationConnectionsApi apiInstance = new ApplicationConnectionsApi(defaultClient);
        String appId = "0oafxqCAJWWGELFTYASJ"; // String | Application ID
        try {
            apiInstance.activateDefaultProvisioningConnectionForApplication(appId);
        } catch (ApiException e) {
            System.err.println("Exception when calling ApplicationConnectionsApi#activateDefaultProvisioningConnectionForApplication");
            System.err.println("Status code: " + e.getCode());
            System.err.println("Reason: " + e.getResponseBody());
            System.err.println("Response headers: " + e.getResponseHeaders());
            e.printStackTrace();
        }
    }
}
```

### Parameters


| Name | Type | Description  | Notes |
|------------- | ------------- | ------------- | -------------|
| **appId** | **String**| Application ID | |

### Return type

null (empty response body)

### Authorization

[apiToken](../README.md#apiToken), [oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json


### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **204** | No Content |  -  |
| **403** | Forbidden |  -  |
| **404** | Not Found |  -  |
| **429** | Too Many Requests |  -  |


## deactivateDefaultProvisioningConnectionForApplication

> deactivateDefaultProvisioningConnectionForApplication(appId)

Deactivate the default Provisioning Connection

Deactivates the default Provisioning Connection for an app

### Example

```java
// Import classes:
import com.okta.sdk.resource.client.ApiClient;
import com.okta.sdk.resource.client.ApiException;
import com.okta.sdk.resource.client.Configuration;
import com.okta.sdk.resource.client.auth.*;
import com.okta.sdk.resource.client.models.*;
import com.okta.sdk.resource.api.ApplicationConnectionsApi;

public class Example {
    public static void main(String[] args) {
        ApiClient defaultClient = Configuration.getDefaultApiClient();
        defaultClient.setBasePath("https://subdomain.okta.com");
        
        // Configure API key authorization: apiToken
        ApiKeyAuth apiToken = (ApiKeyAuth) defaultClient.getAuthentication("apiToken");
        apiToken.setApiKey("YOUR API KEY");
        // Uncomment the following line to set a prefix for the API key, e.g. "Token" (defaults to null)
        //apiToken.setApiKeyPrefix("Token");

        // Configure OAuth2 access token for authorization: oauth2
        OAuth oauth2 = (OAuth) defaultClient.getAuthentication("oauth2");
        oauth2.setAccessToken("YOUR ACCESS TOKEN");

        ApplicationConnectionsApi apiInstance = new ApplicationConnectionsApi(defaultClient);
        String appId = "0oafxqCAJWWGELFTYASJ"; // String | Application ID
        try {
            apiInstance.deactivateDefaultProvisioningConnectionForApplication(appId);
        } catch (ApiException e) {
            System.err.println("Exception when calling ApplicationConnectionsApi#deactivateDefaultProvisioningConnectionForApplication");
            System.err.println("Status code: " + e.getCode());
            System.err.println("Reason: " + e.getResponseBody());
            System.err.println("Response headers: " + e.getResponseHeaders());
            e.printStackTrace();
        }
    }
}
```

### Parameters


| Name | Type | Description  | Notes |
|------------- | ------------- | ------------- | -------------|
| **appId** | **String**| Application ID | |

### Return type

null (empty response body)

### Authorization

[apiToken](../README.md#apiToken), [oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json


### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **204** | No Content |  -  |
| **403** | Forbidden |  -  |
| **404** | Not Found |  -  |
| **429** | Too Many Requests |  -  |


## getDefaultProvisioningConnectionForApplication

> ProvisioningConnectionResponse getDefaultProvisioningConnectionForApplication(appId)

Retrieve the default Provisioning Connection

Retrieves the default Provisioning Connection for an app

### Example

```java
// Import classes:
import com.okta.sdk.resource.client.ApiClient;
import com.okta.sdk.resource.client.ApiException;
import com.okta.sdk.resource.client.Configuration;
import com.okta.sdk.resource.client.auth.*;
import com.okta.sdk.resource.client.models.*;
import com.okta.sdk.resource.api.ApplicationConnectionsApi;

public class Example {
    public static void main(String[] args) {
        ApiClient defaultClient = Configuration.getDefaultApiClient();
        defaultClient.setBasePath("https://subdomain.okta.com");
        
        // Configure API key authorization: apiToken
        ApiKeyAuth apiToken = (ApiKeyAuth) defaultClient.getAuthentication("apiToken");
        apiToken.setApiKey("YOUR API KEY");
        // Uncomment the following line to set a prefix for the API key, e.g. "Token" (defaults to null)
        //apiToken.setApiKeyPrefix("Token");

        // Configure OAuth2 access token for authorization: oauth2
        OAuth oauth2 = (OAuth) defaultClient.getAuthentication("oauth2");
        oauth2.setAccessToken("YOUR ACCESS TOKEN");

        ApplicationConnectionsApi apiInstance = new ApplicationConnectionsApi(defaultClient);
        String appId = "0oafxqCAJWWGELFTYASJ"; // String | Application ID
        try {
            ProvisioningConnectionResponse result = apiInstance.getDefaultProvisioningConnectionForApplication(appId);
            System.out.println(result);
        } catch (ApiException e) {
            System.err.println("Exception when calling ApplicationConnectionsApi#getDefaultProvisioningConnectionForApplication");
            System.err.println("Status code: " + e.getCode());
            System.err.println("Reason: " + e.getResponseBody());
            System.err.println("Response headers: " + e.getResponseHeaders());
            e.printStackTrace();
        }
    }
}
```

### Parameters


| Name | Type | Description  | Notes |
|------------- | ------------- | ------------- | -------------|
| **appId** | **String**| Application ID | |

### Return type

[**ProvisioningConnectionResponse**](ProvisioningConnectionResponse.md)

### Authorization

[apiToken](../README.md#apiToken), [oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json


### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **200** | Success |  -  |
| **403** | Forbidden |  -  |
| **404** | Not Found |  -  |
| **429** | Too Many Requests |  -  |


## updateDefaultProvisioningConnectionForApplication

> ProvisioningConnectionResponse updateDefaultProvisioningConnectionForApplication(appId, updateDefaultProvisioningConnectionForApplicationRequest, activate)

Update the default Provisioning Connection

Updates the default Provisioning Connection for an app

### Example

```java
// Import classes:
import com.okta.sdk.resource.client.ApiClient;
import com.okta.sdk.resource.client.ApiException;
import com.okta.sdk.resource.client.Configuration;
import com.okta.sdk.resource.client.auth.*;
import com.okta.sdk.resource.client.models.*;
import com.okta.sdk.resource.api.ApplicationConnectionsApi;

public class Example {
    public static void main(String[] args) {
        ApiClient defaultClient = Configuration.getDefaultApiClient();
        defaultClient.setBasePath("https://subdomain.okta.com");
        
        // Configure API key authorization: apiToken
        ApiKeyAuth apiToken = (ApiKeyAuth) defaultClient.getAuthentication("apiToken");
        apiToken.setApiKey("YOUR API KEY");
        // Uncomment the following line to set a prefix for the API key, e.g. "Token" (defaults to null)
        //apiToken.setApiKeyPrefix("Token");

        // Configure OAuth2 access token for authorization: oauth2
        OAuth oauth2 = (OAuth) defaultClient.getAuthentication("oauth2");
        oauth2.setAccessToken("YOUR ACCESS TOKEN");

        ApplicationConnectionsApi apiInstance = new ApplicationConnectionsApi(defaultClient);
        String appId = "0oafxqCAJWWGELFTYASJ"; // String | Application ID
        UpdateDefaultProvisioningConnectionForApplicationRequest updateDefaultProvisioningConnectionForApplicationRequest = new UpdateDefaultProvisioningConnectionForApplicationRequest(); // UpdateDefaultProvisioningConnectionForApplicationRequest | 
        Boolean activate = true; // Boolean | Activates the Provisioning Connection
        try {
            ProvisioningConnectionResponse result = apiInstance.updateDefaultProvisioningConnectionForApplication(appId, updateDefaultProvisioningConnectionForApplicationRequest, activate);
            System.out.println(result);
        } catch (ApiException e) {
            System.err.println("Exception when calling ApplicationConnectionsApi#updateDefaultProvisioningConnectionForApplication");
            System.err.println("Status code: " + e.getCode());
            System.err.println("Reason: " + e.getResponseBody());
            System.err.println("Response headers: " + e.getResponseHeaders());
            e.printStackTrace();
        }
    }
}
```

### Parameters


| Name | Type | Description  | Notes |
|------------- | ------------- | ------------- | -------------|
| **appId** | **String**| Application ID | |
| **updateDefaultProvisioningConnectionForApplicationRequest** | [**UpdateDefaultProvisioningConnectionForApplicationRequest**](UpdateDefaultProvisioningConnectionForApplicationRequest.md)|  | |
| **activate** | **Boolean**| Activates the Provisioning Connection | [optional] |

### Return type

[**ProvisioningConnectionResponse**](ProvisioningConnectionResponse.md)

### Authorization

[apiToken](../README.md#apiToken), [oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: application/json
- **Accept**: application/json


### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **200** | OK |  -  |
| **201** | Created |  -  |
| **400** | Bad Request |  -  |
| **403** | Forbidden |  -  |
| **404** | Not Found |  -  |
| **429** | Too Many Requests |  -  |


## verifyProvisioningConnectionForApplication

> verifyProvisioningConnectionForApplication(appName, appId, code, state)

Verify the Provisioning Connection

Verifies the OAuth 2.0-based connection as part of the OAuth 2.0 consent flow. The validation of the consent flow is the last step of the provisioning setup for an OAuth 2.0-based connection. Currently, this operation only supports &#x60;office365&#x60;,&#x60;google&#x60;, &#x60;zoomus&#x60;, and &#x60;slack&#x60; apps. 

### Example

```java
// Import classes:
import com.okta.sdk.resource.client.ApiClient;
import com.okta.sdk.resource.client.ApiException;
import com.okta.sdk.resource.client.Configuration;
import com.okta.sdk.resource.client.auth.*;
import com.okta.sdk.resource.client.models.*;
import com.okta.sdk.resource.api.ApplicationConnectionsApi;

public class Example {
    public static void main(String[] args) {
        ApiClient defaultClient = Configuration.getDefaultApiClient();
        defaultClient.setBasePath("https://subdomain.okta.com");
        
        // Configure API key authorization: apiToken
        ApiKeyAuth apiToken = (ApiKeyAuth) defaultClient.getAuthentication("apiToken");
        apiToken.setApiKey("YOUR API KEY");
        // Uncomment the following line to set a prefix for the API key, e.g. "Token" (defaults to null)
        //apiToken.setApiKeyPrefix("Token");

        // Configure OAuth2 access token for authorization: oauth2
        OAuth oauth2 = (OAuth) defaultClient.getAuthentication("oauth2");
        oauth2.setAccessToken("YOUR ACCESS TOKEN");

        ApplicationConnectionsApi apiInstance = new ApplicationConnectionsApi(defaultClient);
        OAuthProvisioningEnabledApp appName = OAuthProvisioningEnabledApp.fromValue("google"); // OAuthProvisioningEnabledApp | 
        String appId = "0oafxqCAJWWGELFTYASJ"; // String | Application ID
        String code = "code_example"; // String | 
        String state = "state_example"; // String | 
        try {
            apiInstance.verifyProvisioningConnectionForApplication(appName, appId, code, state);
        } catch (ApiException e) {
            System.err.println("Exception when calling ApplicationConnectionsApi#verifyProvisioningConnectionForApplication");
            System.err.println("Status code: " + e.getCode());
            System.err.println("Reason: " + e.getResponseBody());
            System.err.println("Response headers: " + e.getResponseHeaders());
            e.printStackTrace();
        }
    }
}
```

### Parameters


| Name | Type | Description  | Notes |
|------------- | ------------- | ------------- | -------------|
| **appName** | [**OAuthProvisioningEnabledApp**](.md)|  | [enum: google, office365, slack, zoomus] |
| **appId** | **String**| Application ID | |
| **code** | **String**|  | [optional] |
| **state** | **String**|  | [optional] |

### Return type

null (empty response body)

### Authorization

[apiToken](../README.md#apiToken), [oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json


### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **204** | No content |  -  |
| **403** | Forbidden |  -  |
| **404** | Not Found |  -  |
| **429** | Too Many Requests |  -  |

