# ApplicationFeaturesApi

All URIs are relative to *https://subdomain.okta.com*

| Method | HTTP request | Description |
|------------- | ------------- | -------------|
| [**getFeatureForApplication**](ApplicationFeaturesApi.md#getFeatureForApplication) | **GET** /api/v1/apps/{appId}/features/{featureName} | Retrieve a Feature |
| [**listFeaturesForApplication**](ApplicationFeaturesApi.md#listFeaturesForApplication) | **GET** /api/v1/apps/{appId}/features | List all Features |
| [**updateFeatureForApplication**](ApplicationFeaturesApi.md#updateFeatureForApplication) | **PUT** /api/v1/apps/{appId}/features/{featureName} | Update a Feature |



## getFeatureForApplication

> ApplicationFeature getFeatureForApplication(appId, featureName)

Retrieve a Feature

Retrieves a Feature object for an app

### Example

```java
// Import classes:
import com.okta.sdk.resource.client.ApiClient;
import com.okta.sdk.resource.client.ApiException;
import com.okta.sdk.resource.client.Configuration;
import com.okta.sdk.resource.client.auth.*;
import com.okta.sdk.resource.client.models.*;
import com.okta.sdk.resource.api.ApplicationFeaturesApi;

public class Example {
    public static void main(String[] args) {
        ApiClient defaultClient = Configuration.getDefaultApiClient();
        defaultClient.setBasePath("https://subdomain.okta.com");
        
        // Configure API key authorization: apiToken
        ApiKeyAuth apiToken = (ApiKeyAuth) defaultClient.getAuthentication("apiToken");
        apiToken.setApiKey("YOUR API KEY");
        // Uncomment the following line to set a prefix for the API key, e.g. "Token" (defaults to null)
        //apiToken.setApiKeyPrefix("Token");

        // Configure OAuth2 access token for authorization: oauth2
        OAuth oauth2 = (OAuth) defaultClient.getAuthentication("oauth2");
        oauth2.setAccessToken("YOUR ACCESS TOKEN");

        ApplicationFeaturesApi apiInstance = new ApplicationFeaturesApi(defaultClient);
        String appId = "0oafxqCAJWWGELFTYASJ"; // String | Application ID
        ApplicationFeatureType featureName = ApplicationFeatureType.fromValue("USER_PROVISIONING"); // ApplicationFeatureType | Name of the Feature
        try {
            ApplicationFeature result = apiInstance.getFeatureForApplication(appId, featureName);
            System.out.println(result);
        } catch (ApiException e) {
            System.err.println("Exception when calling ApplicationFeaturesApi#getFeatureForApplication");
            System.err.println("Status code: " + e.getCode());
            System.err.println("Reason: " + e.getResponseBody());
            System.err.println("Response headers: " + e.getResponseHeaders());
            e.printStackTrace();
        }
    }
}
```

### Parameters


| Name | Type | Description  | Notes |
|------------- | ------------- | ------------- | -------------|
| **appId** | **String**| Application ID | |
| **featureName** | [**ApplicationFeatureType**](.md)| Name of the Feature | [enum: USER_PROVISIONING, USER_PROVISIONING, INBOUND_PROVISIONING] |

### Return type

[**ApplicationFeature**](ApplicationFeature.md)

### Authorization

[apiToken](../README.md#apiToken), [oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json


### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **200** | Success |  -  |
| **403** | Forbidden |  -  |
| **404** | Not Found |  -  |
| **429** | Too Many Requests |  -  |


## listFeaturesForApplication

> List&lt;ApplicationFeature&gt; listFeaturesForApplication(appId)

List all Features

Lists all features for an app &gt; **Note:** This request returns an error if provisioning isn&#39;t enabled for the app. &gt; To set up provisioning, see [Update the default Provisioning Connection](/openapi/okta-management/management/tag/ApplicationConnections/#tag/ApplicationConnections/operation/updateDefaultProvisioningConnectionForApplication). 

### Example

```java
// Import classes:
import com.okta.sdk.resource.client.ApiClient;
import com.okta.sdk.resource.client.ApiException;
import com.okta.sdk.resource.client.Configuration;
import com.okta.sdk.resource.client.auth.*;
import com.okta.sdk.resource.client.models.*;
import com.okta.sdk.resource.api.ApplicationFeaturesApi;

public class Example {
    public static void main(String[] args) {
        ApiClient defaultClient = Configuration.getDefaultApiClient();
        defaultClient.setBasePath("https://subdomain.okta.com");
        
        // Configure API key authorization: apiToken
        ApiKeyAuth apiToken = (ApiKeyAuth) defaultClient.getAuthentication("apiToken");
        apiToken.setApiKey("YOUR API KEY");
        // Uncomment the following line to set a prefix for the API key, e.g. "Token" (defaults to null)
        //apiToken.setApiKeyPrefix("Token");

        // Configure OAuth2 access token for authorization: oauth2
        OAuth oauth2 = (OAuth) defaultClient.getAuthentication("oauth2");
        oauth2.setAccessToken("YOUR ACCESS TOKEN");

        ApplicationFeaturesApi apiInstance = new ApplicationFeaturesApi(defaultClient);
        String appId = "0oafxqCAJWWGELFTYASJ"; // String | Application ID
        try {
            List<ApplicationFeature> result = apiInstance.listFeaturesForApplication(appId);
            System.out.println(result);
        } catch (ApiException e) {
            System.err.println("Exception when calling ApplicationFeaturesApi#listFeaturesForApplication");
            System.err.println("Status code: " + e.getCode());
            System.err.println("Reason: " + e.getResponseBody());
            System.err.println("Response headers: " + e.getResponseHeaders());
            e.printStackTrace();
        }
    }
}
```

### Parameters


| Name | Type | Description  | Notes |
|------------- | ------------- | ------------- | -------------|
| **appId** | **String**| Application ID | |

### Return type

[**List&lt;ApplicationFeature&gt;**](ApplicationFeature.md)

### Authorization

[apiToken](../README.md#apiToken), [oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json


### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **200** | Success |  -  |
| **400** | Bad Request |  -  |
| **403** | Forbidden |  -  |
| **404** | Not Found |  -  |
| **429** | Too Many Requests |  -  |


## updateFeatureForApplication

> ApplicationFeature updateFeatureForApplication(appId, featureName, updateFeatureForApplicationRequest)

Update a Feature

Updates a Feature object for an app &gt; **Note:** This endpoint supports partial updates. 

### Example

```java
// Import classes:
import com.okta.sdk.resource.client.ApiClient;
import com.okta.sdk.resource.client.ApiException;
import com.okta.sdk.resource.client.Configuration;
import com.okta.sdk.resource.client.auth.*;
import com.okta.sdk.resource.client.models.*;
import com.okta.sdk.resource.api.ApplicationFeaturesApi;

public class Example {
    public static void main(String[] args) {
        ApiClient defaultClient = Configuration.getDefaultApiClient();
        defaultClient.setBasePath("https://subdomain.okta.com");
        
        // Configure API key authorization: apiToken
        ApiKeyAuth apiToken = (ApiKeyAuth) defaultClient.getAuthentication("apiToken");
        apiToken.setApiKey("YOUR API KEY");
        // Uncomment the following line to set a prefix for the API key, e.g. "Token" (defaults to null)
        //apiToken.setApiKeyPrefix("Token");

        // Configure OAuth2 access token for authorization: oauth2
        OAuth oauth2 = (OAuth) defaultClient.getAuthentication("oauth2");
        oauth2.setAccessToken("YOUR ACCESS TOKEN");

        ApplicationFeaturesApi apiInstance = new ApplicationFeaturesApi(defaultClient);
        String appId = "0oafxqCAJWWGELFTYASJ"; // String | Application ID
        ApplicationFeatureType featureName = ApplicationFeatureType.fromValue("USER_PROVISIONING"); // ApplicationFeatureType | Name of the Feature
        UpdateFeatureForApplicationRequest updateFeatureForApplicationRequest = new UpdateFeatureForApplicationRequest(); // UpdateFeatureForApplicationRequest | 
        try {
            ApplicationFeature result = apiInstance.updateFeatureForApplication(appId, featureName, updateFeatureForApplicationRequest);
            System.out.println(result);
        } catch (ApiException e) {
            System.err.println("Exception when calling ApplicationFeaturesApi#updateFeatureForApplication");
            System.err.println("Status code: " + e.getCode());
            System.err.println("Reason: " + e.getResponseBody());
            System.err.println("Response headers: " + e.getResponseHeaders());
            e.printStackTrace();
        }
    }
}
```

### Parameters


| Name | Type | Description  | Notes |
|------------- | ------------- | ------------- | -------------|
| **appId** | **String**| Application ID | |
| **featureName** | [**ApplicationFeatureType**](.md)| Name of the Feature | [enum: USER_PROVISIONING, USER_PROVISIONING, INBOUND_PROVISIONING] |
| **updateFeatureForApplicationRequest** | [**UpdateFeatureForApplicationRequest**](UpdateFeatureForApplicationRequest.md)|  | |

### Return type

[**ApplicationFeature**](ApplicationFeature.md)

### Authorization

[apiToken](../README.md#apiToken), [oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: application/json
- **Accept**: application/json


### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **200** | Success |  -  |
| **400** | Bad Request |  -  |
| **403** | Forbidden |  -  |
| **404** | Not Found |  -  |
| **429** | Too Many Requests |  -  |

