# ApplicationPoliciesApi

All URIs are relative to *https://subdomain.okta.com*

| Method | HTTP request | Description |
|------------- | ------------- | -------------|
| [**assignApplicationPolicy**](ApplicationPoliciesApi.md#assignApplicationPolicy) | **PUT** /api/v1/apps/{appId}/policies/{policyId} | Assign an Authentication Policy |



## assignApplicationPolicy

> assignApplicationPolicy(appId, policyId)

Assign an Authentication Policy

Assigns an app to an [authentication policy](/openapi/okta-management/management/tag/Policy/), identified by &#x60;policyId&#x60;. If the app was previously assigned to another policy, this operation replaces that assignment with the updated policy identified by &#x60;policyId&#x60;.  &gt; **Note:** When you [merge duplicate authentication policies](https://help.okta.com/okta_help.htm?type&#x3D;oie&amp;id&#x3D;ext-merge-auth-policies), the policy and mapping CRUD operations may be unavailable during the consolidation. When the consolidation is complete, you receive an email with merged results.

### Example

```java
// Import classes:
import com.okta.sdk.resource.client.ApiClient;
import com.okta.sdk.resource.client.ApiException;
import com.okta.sdk.resource.client.Configuration;
import com.okta.sdk.resource.client.auth.*;
import com.okta.sdk.resource.client.models.*;
import com.okta.sdk.resource.api.ApplicationPoliciesApi;

public class Example {
    public static void main(String[] args) {
        ApiClient defaultClient = Configuration.getDefaultApiClient();
        defaultClient.setBasePath("https://subdomain.okta.com");
        
        // Configure API key authorization: apiToken
        ApiKeyAuth apiToken = (ApiKeyAuth) defaultClient.getAuthentication("apiToken");
        apiToken.setApiKey("YOUR API KEY");
        // Uncomment the following line to set a prefix for the API key, e.g. "Token" (defaults to null)
        //apiToken.setApiKeyPrefix("Token");

        // Configure OAuth2 access token for authorization: oauth2
        OAuth oauth2 = (OAuth) defaultClient.getAuthentication("oauth2");
        oauth2.setAccessToken("YOUR ACCESS TOKEN");

        ApplicationPoliciesApi apiInstance = new ApplicationPoliciesApi(defaultClient);
        String appId = "0oafxqCAJWWGELFTYASJ"; // String | Application ID
        String policyId = "00plrilJ7jZ66Gn0X0g3"; // String | `id` of the Policy
        try {
            apiInstance.assignApplicationPolicy(appId, policyId);
        } catch (ApiException e) {
            System.err.println("Exception when calling ApplicationPoliciesApi#assignApplicationPolicy");
            System.err.println("Status code: " + e.getCode());
            System.err.println("Reason: " + e.getResponseBody());
            System.err.println("Response headers: " + e.getResponseHeaders());
            e.printStackTrace();
        }
    }
}
```

### Parameters


| Name | Type | Description  | Notes |
|------------- | ------------- | ------------- | -------------|
| **appId** | **String**| Application ID | |
| **policyId** | **String**| &#x60;id&#x60; of the Policy | |

### Return type

null (empty response body)

### Authorization

[apiToken](../README.md#apiToken), [oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json


### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **204** | No Content |  -  |
| **403** | Forbidden |  -  |
| **404** | Not Found |  -  |
| **429** | Too Many Requests |  -  |

