# AuthorizationServerClaimsApi

All URIs are relative to *https://subdomain.okta.com*

| Method | HTTP request | Description |
|------------- | ------------- | -------------|
| [**createOAuth2Claim**](AuthorizationServerClaimsApi.md#createOAuth2Claim) | **POST** /api/v1/authorizationServers/{authServerId}/claims | Create a custom token Claim |
| [**deleteOAuth2Claim**](AuthorizationServerClaimsApi.md#deleteOAuth2Claim) | **DELETE** /api/v1/authorizationServers/{authServerId}/claims/{claimId} | Delete a custom token Claim |
| [**getOAuth2Claim**](AuthorizationServerClaimsApi.md#getOAuth2Claim) | **GET** /api/v1/authorizationServers/{authServerId}/claims/{claimId} | Retrieve a custom token Claim |
| [**listOAuth2Claims**](AuthorizationServerClaimsApi.md#listOAuth2Claims) | **GET** /api/v1/authorizationServers/{authServerId}/claims | List all custom token Claims |
| [**replaceOAuth2Claim**](AuthorizationServerClaimsApi.md#replaceOAuth2Claim) | **PUT** /api/v1/authorizationServers/{authServerId}/claims/{claimId} | Replace a custom token Claim |



## createOAuth2Claim

> OAuth2Claim createOAuth2Claim(authServerId, oAuth2Claim)

Create a custom token Claim

Creates a custom token Claim for a custom authorization server

### Example

```java
// Import classes:
import com.okta.sdk.resource.client.ApiClient;
import com.okta.sdk.resource.client.ApiException;
import com.okta.sdk.resource.client.Configuration;
import com.okta.sdk.resource.client.auth.*;
import com.okta.sdk.resource.client.models.*;
import com.okta.sdk.resource.api.AuthorizationServerClaimsApi;

public class Example {
    public static void main(String[] args) {
        ApiClient defaultClient = Configuration.getDefaultApiClient();
        defaultClient.setBasePath("https://subdomain.okta.com");
        
        // Configure API key authorization: apiToken
        ApiKeyAuth apiToken = (ApiKeyAuth) defaultClient.getAuthentication("apiToken");
        apiToken.setApiKey("YOUR API KEY");
        // Uncomment the following line to set a prefix for the API key, e.g. "Token" (defaults to null)
        //apiToken.setApiKeyPrefix("Token");

        // Configure OAuth2 access token for authorization: oauth2
        OAuth oauth2 = (OAuth) defaultClient.getAuthentication("oauth2");
        oauth2.setAccessToken("YOUR ACCESS TOKEN");

        AuthorizationServerClaimsApi apiInstance = new AuthorizationServerClaimsApi(defaultClient);
        String authServerId = "GeGRTEr7f3yu2n7grw22"; // String | `id` of the Authorization Server
        OAuth2Claim oAuth2Claim = new OAuth2Claim(); // OAuth2Claim | 
        try {
            OAuth2Claim result = apiInstance.createOAuth2Claim(authServerId, oAuth2Claim);
            System.out.println(result);
        } catch (ApiException e) {
            System.err.println("Exception when calling AuthorizationServerClaimsApi#createOAuth2Claim");
            System.err.println("Status code: " + e.getCode());
            System.err.println("Reason: " + e.getResponseBody());
            System.err.println("Response headers: " + e.getResponseHeaders());
            e.printStackTrace();
        }
    }
}
```

### Parameters


| Name | Type | Description  | Notes |
|------------- | ------------- | ------------- | -------------|
| **authServerId** | **String**| &#x60;id&#x60; of the Authorization Server | |
| **oAuth2Claim** | [**OAuth2Claim**](OAuth2Claim.md)|  | |

### Return type

[**OAuth2Claim**](OAuth2Claim.md)

### Authorization

[apiToken](../README.md#apiToken), [oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: application/json
- **Accept**: application/json


### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **201** | Success |  -  |
| **400** | Bad Request |  -  |
| **403** | Forbidden |  -  |
| **404** | Not Found |  -  |
| **429** | Too Many Requests |  -  |


## deleteOAuth2Claim

> deleteOAuth2Claim(authServerId, claimId)

Delete a custom token Claim

Deletes a custom token Claim specified by the &#x60;claimId&#x60;

### Example

```java
// Import classes:
import com.okta.sdk.resource.client.ApiClient;
import com.okta.sdk.resource.client.ApiException;
import com.okta.sdk.resource.client.Configuration;
import com.okta.sdk.resource.client.auth.*;
import com.okta.sdk.resource.client.models.*;
import com.okta.sdk.resource.api.AuthorizationServerClaimsApi;

public class Example {
    public static void main(String[] args) {
        ApiClient defaultClient = Configuration.getDefaultApiClient();
        defaultClient.setBasePath("https://subdomain.okta.com");
        
        // Configure API key authorization: apiToken
        ApiKeyAuth apiToken = (ApiKeyAuth) defaultClient.getAuthentication("apiToken");
        apiToken.setApiKey("YOUR API KEY");
        // Uncomment the following line to set a prefix for the API key, e.g. "Token" (defaults to null)
        //apiToken.setApiKeyPrefix("Token");

        // Configure OAuth2 access token for authorization: oauth2
        OAuth oauth2 = (OAuth) defaultClient.getAuthentication("oauth2");
        oauth2.setAccessToken("YOUR ACCESS TOKEN");

        AuthorizationServerClaimsApi apiInstance = new AuthorizationServerClaimsApi(defaultClient);
        String authServerId = "GeGRTEr7f3yu2n7grw22"; // String | `id` of the Authorization Server
        String claimId = "hNJ3Uk76xLagWkGx5W3N"; // String | `id` of Claim
        try {
            apiInstance.deleteOAuth2Claim(authServerId, claimId);
        } catch (ApiException e) {
            System.err.println("Exception when calling AuthorizationServerClaimsApi#deleteOAuth2Claim");
            System.err.println("Status code: " + e.getCode());
            System.err.println("Reason: " + e.getResponseBody());
            System.err.println("Response headers: " + e.getResponseHeaders());
            e.printStackTrace();
        }
    }
}
```

### Parameters


| Name | Type | Description  | Notes |
|------------- | ------------- | ------------- | -------------|
| **authServerId** | **String**| &#x60;id&#x60; of the Authorization Server | |
| **claimId** | **String**| &#x60;id&#x60; of Claim | |

### Return type

null (empty response body)

### Authorization

[apiToken](../README.md#apiToken), [oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json


### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **204** | No Content |  -  |
| **403** | Forbidden |  -  |
| **404** | Not Found |  -  |
| **429** | Too Many Requests |  -  |


## getOAuth2Claim

> OAuth2Claim getOAuth2Claim(authServerId, claimId)

Retrieve a custom token Claim

Retrieves a custom token Claim by the specified &#x60;claimId&#x60;

### Example

```java
// Import classes:
import com.okta.sdk.resource.client.ApiClient;
import com.okta.sdk.resource.client.ApiException;
import com.okta.sdk.resource.client.Configuration;
import com.okta.sdk.resource.client.auth.*;
import com.okta.sdk.resource.client.models.*;
import com.okta.sdk.resource.api.AuthorizationServerClaimsApi;

public class Example {
    public static void main(String[] args) {
        ApiClient defaultClient = Configuration.getDefaultApiClient();
        defaultClient.setBasePath("https://subdomain.okta.com");
        
        // Configure API key authorization: apiToken
        ApiKeyAuth apiToken = (ApiKeyAuth) defaultClient.getAuthentication("apiToken");
        apiToken.setApiKey("YOUR API KEY");
        // Uncomment the following line to set a prefix for the API key, e.g. "Token" (defaults to null)
        //apiToken.setApiKeyPrefix("Token");

        // Configure OAuth2 access token for authorization: oauth2
        OAuth oauth2 = (OAuth) defaultClient.getAuthentication("oauth2");
        oauth2.setAccessToken("YOUR ACCESS TOKEN");

        AuthorizationServerClaimsApi apiInstance = new AuthorizationServerClaimsApi(defaultClient);
        String authServerId = "GeGRTEr7f3yu2n7grw22"; // String | `id` of the Authorization Server
        String claimId = "hNJ3Uk76xLagWkGx5W3N"; // String | `id` of Claim
        try {
            OAuth2Claim result = apiInstance.getOAuth2Claim(authServerId, claimId);
            System.out.println(result);
        } catch (ApiException e) {
            System.err.println("Exception when calling AuthorizationServerClaimsApi#getOAuth2Claim");
            System.err.println("Status code: " + e.getCode());
            System.err.println("Reason: " + e.getResponseBody());
            System.err.println("Response headers: " + e.getResponseHeaders());
            e.printStackTrace();
        }
    }
}
```

### Parameters


| Name | Type | Description  | Notes |
|------------- | ------------- | ------------- | -------------|
| **authServerId** | **String**| &#x60;id&#x60; of the Authorization Server | |
| **claimId** | **String**| &#x60;id&#x60; of Claim | |

### Return type

[**OAuth2Claim**](OAuth2Claim.md)

### Authorization

[apiToken](../README.md#apiToken), [oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json


### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **200** | Success |  -  |
| **403** | Forbidden |  -  |
| **404** | Not Found |  -  |
| **429** | Too Many Requests |  -  |


## listOAuth2Claims

> List&lt;OAuth2Claim&gt; listOAuth2Claims(authServerId)

List all custom token Claims

Lists all custom token Claims defined for a specified custom authorization server

### Example

```java
// Import classes:
import com.okta.sdk.resource.client.ApiClient;
import com.okta.sdk.resource.client.ApiException;
import com.okta.sdk.resource.client.Configuration;
import com.okta.sdk.resource.client.auth.*;
import com.okta.sdk.resource.client.models.*;
import com.okta.sdk.resource.api.AuthorizationServerClaimsApi;

public class Example {
    public static void main(String[] args) {
        ApiClient defaultClient = Configuration.getDefaultApiClient();
        defaultClient.setBasePath("https://subdomain.okta.com");
        
        // Configure API key authorization: apiToken
        ApiKeyAuth apiToken = (ApiKeyAuth) defaultClient.getAuthentication("apiToken");
        apiToken.setApiKey("YOUR API KEY");
        // Uncomment the following line to set a prefix for the API key, e.g. "Token" (defaults to null)
        //apiToken.setApiKeyPrefix("Token");

        // Configure OAuth2 access token for authorization: oauth2
        OAuth oauth2 = (OAuth) defaultClient.getAuthentication("oauth2");
        oauth2.setAccessToken("YOUR ACCESS TOKEN");

        AuthorizationServerClaimsApi apiInstance = new AuthorizationServerClaimsApi(defaultClient);
        String authServerId = "GeGRTEr7f3yu2n7grw22"; // String | `id` of the Authorization Server
        try {
            List<OAuth2Claim> result = apiInstance.listOAuth2Claims(authServerId);
            System.out.println(result);
        } catch (ApiException e) {
            System.err.println("Exception when calling AuthorizationServerClaimsApi#listOAuth2Claims");
            System.err.println("Status code: " + e.getCode());
            System.err.println("Reason: " + e.getResponseBody());
            System.err.println("Response headers: " + e.getResponseHeaders());
            e.printStackTrace();
        }
    }
}
```

### Parameters


| Name | Type | Description  | Notes |
|------------- | ------------- | ------------- | -------------|
| **authServerId** | **String**| &#x60;id&#x60; of the Authorization Server | |

### Return type

[**List&lt;OAuth2Claim&gt;**](OAuth2Claim.md)

### Authorization

[apiToken](../README.md#apiToken), [oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json


### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **200** | Success |  -  |
| **403** | Forbidden |  -  |
| **404** | Not Found |  -  |
| **429** | Too Many Requests |  -  |


## replaceOAuth2Claim

> OAuth2Claim replaceOAuth2Claim(authServerId, claimId, oAuth2Claim)

Replace a custom token Claim

Replaces a custom token Claim specified by the &#x60;claimId&#x60;

### Example

```java
// Import classes:
import com.okta.sdk.resource.client.ApiClient;
import com.okta.sdk.resource.client.ApiException;
import com.okta.sdk.resource.client.Configuration;
import com.okta.sdk.resource.client.auth.*;
import com.okta.sdk.resource.client.models.*;
import com.okta.sdk.resource.api.AuthorizationServerClaimsApi;

public class Example {
    public static void main(String[] args) {
        ApiClient defaultClient = Configuration.getDefaultApiClient();
        defaultClient.setBasePath("https://subdomain.okta.com");
        
        // Configure API key authorization: apiToken
        ApiKeyAuth apiToken = (ApiKeyAuth) defaultClient.getAuthentication("apiToken");
        apiToken.setApiKey("YOUR API KEY");
        // Uncomment the following line to set a prefix for the API key, e.g. "Token" (defaults to null)
        //apiToken.setApiKeyPrefix("Token");

        // Configure OAuth2 access token for authorization: oauth2
        OAuth oauth2 = (OAuth) defaultClient.getAuthentication("oauth2");
        oauth2.setAccessToken("YOUR ACCESS TOKEN");

        AuthorizationServerClaimsApi apiInstance = new AuthorizationServerClaimsApi(defaultClient);
        String authServerId = "GeGRTEr7f3yu2n7grw22"; // String | `id` of the Authorization Server
        String claimId = "hNJ3Uk76xLagWkGx5W3N"; // String | `id` of Claim
        OAuth2Claim oAuth2Claim = new OAuth2Claim(); // OAuth2Claim | 
        try {
            OAuth2Claim result = apiInstance.replaceOAuth2Claim(authServerId, claimId, oAuth2Claim);
            System.out.println(result);
        } catch (ApiException e) {
            System.err.println("Exception when calling AuthorizationServerClaimsApi#replaceOAuth2Claim");
            System.err.println("Status code: " + e.getCode());
            System.err.println("Reason: " + e.getResponseBody());
            System.err.println("Response headers: " + e.getResponseHeaders());
            e.printStackTrace();
        }
    }
}
```

### Parameters


| Name | Type | Description  | Notes |
|------------- | ------------- | ------------- | -------------|
| **authServerId** | **String**| &#x60;id&#x60; of the Authorization Server | |
| **claimId** | **String**| &#x60;id&#x60; of Claim | |
| **oAuth2Claim** | [**OAuth2Claim**](OAuth2Claim.md)|  | |

### Return type

[**OAuth2Claim**](OAuth2Claim.md)

### Authorization

[apiToken](../README.md#apiToken), [oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: application/json
- **Accept**: application/json


### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **200** | Success |  -  |
| **400** | Bad Request |  -  |
| **403** | Forbidden |  -  |
| **404** | Not Found |  -  |
| **429** | Too Many Requests |  -  |

