# AuthorizationServerRulesApi

All URIs are relative to *https://subdomain.okta.com*

| Method | HTTP request | Description |
|------------- | ------------- | -------------|
| [**activateAuthorizationServerPolicyRule**](AuthorizationServerRulesApi.md#activateAuthorizationServerPolicyRule) | **POST** /api/v1/authorizationServers/{authServerId}/policies/{policyId}/rules/{ruleId}/lifecycle/activate | Activate a Policy Rule |
| [**createAuthorizationServerPolicyRule**](AuthorizationServerRulesApi.md#createAuthorizationServerPolicyRule) | **POST** /api/v1/authorizationServers/{authServerId}/policies/{policyId}/rules | Create a Policy Rule |
| [**deactivateAuthorizationServerPolicyRule**](AuthorizationServerRulesApi.md#deactivateAuthorizationServerPolicyRule) | **POST** /api/v1/authorizationServers/{authServerId}/policies/{policyId}/rules/{ruleId}/lifecycle/deactivate | Deactivate a Policy Rule |
| [**deleteAuthorizationServerPolicyRule**](AuthorizationServerRulesApi.md#deleteAuthorizationServerPolicyRule) | **DELETE** /api/v1/authorizationServers/{authServerId}/policies/{policyId}/rules/{ruleId} | Delete a Policy Rule |
| [**getAuthorizationServerPolicyRule**](AuthorizationServerRulesApi.md#getAuthorizationServerPolicyRule) | **GET** /api/v1/authorizationServers/{authServerId}/policies/{policyId}/rules/{ruleId} | Retrieve a Policy Rule |
| [**listAuthorizationServerPolicyRules**](AuthorizationServerRulesApi.md#listAuthorizationServerPolicyRules) | **GET** /api/v1/authorizationServers/{authServerId}/policies/{policyId}/rules | List all Policy Rules |
| [**replaceAuthorizationServerPolicyRule**](AuthorizationServerRulesApi.md#replaceAuthorizationServerPolicyRule) | **PUT** /api/v1/authorizationServers/{authServerId}/policies/{policyId}/rules/{ruleId} | Replace a Policy Rule |



## activateAuthorizationServerPolicyRule

> activateAuthorizationServerPolicyRule(authServerId, policyId, ruleId)

Activate a Policy Rule

Activates an authorization server policy rule

### Example

```java
// Import classes:
import com.okta.sdk.resource.client.ApiClient;
import com.okta.sdk.resource.client.ApiException;
import com.okta.sdk.resource.client.Configuration;
import com.okta.sdk.resource.client.auth.*;
import com.okta.sdk.resource.client.models.*;
import com.okta.sdk.resource.api.AuthorizationServerRulesApi;

public class Example {
    public static void main(String[] args) {
        ApiClient defaultClient = Configuration.getDefaultApiClient();
        defaultClient.setBasePath("https://subdomain.okta.com");
        
        // Configure API key authorization: apiToken
        ApiKeyAuth apiToken = (ApiKeyAuth) defaultClient.getAuthentication("apiToken");
        apiToken.setApiKey("YOUR API KEY");
        // Uncomment the following line to set a prefix for the API key, e.g. "Token" (defaults to null)
        //apiToken.setApiKeyPrefix("Token");

        // Configure OAuth2 access token for authorization: oauth2
        OAuth oauth2 = (OAuth) defaultClient.getAuthentication("oauth2");
        oauth2.setAccessToken("YOUR ACCESS TOKEN");

        AuthorizationServerRulesApi apiInstance = new AuthorizationServerRulesApi(defaultClient);
        String authServerId = "GeGRTEr7f3yu2n7grw22"; // String | `id` of the Authorization Server
        String policyId = "00plrilJ7jZ66Gn0X0g3"; // String | `id` of the Policy
        String ruleId = "ruld3hJ7jZh4fn0st0g3"; // String | `id` of the Policy Rule
        try {
            apiInstance.activateAuthorizationServerPolicyRule(authServerId, policyId, ruleId);
        } catch (ApiException e) {
            System.err.println("Exception when calling AuthorizationServerRulesApi#activateAuthorizationServerPolicyRule");
            System.err.println("Status code: " + e.getCode());
            System.err.println("Reason: " + e.getResponseBody());
            System.err.println("Response headers: " + e.getResponseHeaders());
            e.printStackTrace();
        }
    }
}
```

### Parameters


| Name | Type | Description  | Notes |
|------------- | ------------- | ------------- | -------------|
| **authServerId** | **String**| &#x60;id&#x60; of the Authorization Server | |
| **policyId** | **String**| &#x60;id&#x60; of the Policy | |
| **ruleId** | **String**| &#x60;id&#x60; of the Policy Rule | |

### Return type

null (empty response body)

### Authorization

[apiToken](../README.md#apiToken), [oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json


### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **204** | No Content |  -  |
| **403** | Forbidden |  -  |
| **404** | Not Found |  -  |
| **429** | Too Many Requests |  -  |


## createAuthorizationServerPolicyRule

> AuthorizationServerPolicyRule createAuthorizationServerPolicyRule(authServerId, policyId, policyRule)

Create a Policy Rule

Creates a policy rule for the specified Custom Authorization Server and Policy

### Example

```java
// Import classes:
import com.okta.sdk.resource.client.ApiClient;
import com.okta.sdk.resource.client.ApiException;
import com.okta.sdk.resource.client.Configuration;
import com.okta.sdk.resource.client.auth.*;
import com.okta.sdk.resource.client.models.*;
import com.okta.sdk.resource.api.AuthorizationServerRulesApi;

public class Example {
    public static void main(String[] args) {
        ApiClient defaultClient = Configuration.getDefaultApiClient();
        defaultClient.setBasePath("https://subdomain.okta.com");
        
        // Configure API key authorization: apiToken
        ApiKeyAuth apiToken = (ApiKeyAuth) defaultClient.getAuthentication("apiToken");
        apiToken.setApiKey("YOUR API KEY");
        // Uncomment the following line to set a prefix for the API key, e.g. "Token" (defaults to null)
        //apiToken.setApiKeyPrefix("Token");

        // Configure OAuth2 access token for authorization: oauth2
        OAuth oauth2 = (OAuth) defaultClient.getAuthentication("oauth2");
        oauth2.setAccessToken("YOUR ACCESS TOKEN");

        AuthorizationServerRulesApi apiInstance = new AuthorizationServerRulesApi(defaultClient);
        String authServerId = "GeGRTEr7f3yu2n7grw22"; // String | `id` of the Authorization Server
        String policyId = "00plrilJ7jZ66Gn0X0g3"; // String | `id` of the Policy
        AuthorizationServerPolicyRuleRequest policyRule = new AuthorizationServerPolicyRuleRequest(); // AuthorizationServerPolicyRuleRequest | 
        try {
            AuthorizationServerPolicyRule result = apiInstance.createAuthorizationServerPolicyRule(authServerId, policyId, policyRule);
            System.out.println(result);
        } catch (ApiException e) {
            System.err.println("Exception when calling AuthorizationServerRulesApi#createAuthorizationServerPolicyRule");
            System.err.println("Status code: " + e.getCode());
            System.err.println("Reason: " + e.getResponseBody());
            System.err.println("Response headers: " + e.getResponseHeaders());
            e.printStackTrace();
        }
    }
}
```

### Parameters


| Name | Type | Description  | Notes |
|------------- | ------------- | ------------- | -------------|
| **authServerId** | **String**| &#x60;id&#x60; of the Authorization Server | |
| **policyId** | **String**| &#x60;id&#x60; of the Policy | |
| **policyRule** | [**AuthorizationServerPolicyRuleRequest**](AuthorizationServerPolicyRuleRequest.md)|  | |

### Return type

[**AuthorizationServerPolicyRule**](AuthorizationServerPolicyRule.md)

### Authorization

[apiToken](../README.md#apiToken), [oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: application/json
- **Accept**: application/json


### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **201** | Created |  -  |
| **400** | Bad Request |  -  |
| **403** | Forbidden |  -  |
| **404** | Not Found |  -  |
| **429** | Too Many Requests |  -  |


## deactivateAuthorizationServerPolicyRule

> deactivateAuthorizationServerPolicyRule(authServerId, policyId, ruleId)

Deactivate a Policy Rule

Deactivates an authorization server policy rule

### Example

```java
// Import classes:
import com.okta.sdk.resource.client.ApiClient;
import com.okta.sdk.resource.client.ApiException;
import com.okta.sdk.resource.client.Configuration;
import com.okta.sdk.resource.client.auth.*;
import com.okta.sdk.resource.client.models.*;
import com.okta.sdk.resource.api.AuthorizationServerRulesApi;

public class Example {
    public static void main(String[] args) {
        ApiClient defaultClient = Configuration.getDefaultApiClient();
        defaultClient.setBasePath("https://subdomain.okta.com");
        
        // Configure API key authorization: apiToken
        ApiKeyAuth apiToken = (ApiKeyAuth) defaultClient.getAuthentication("apiToken");
        apiToken.setApiKey("YOUR API KEY");
        // Uncomment the following line to set a prefix for the API key, e.g. "Token" (defaults to null)
        //apiToken.setApiKeyPrefix("Token");

        // Configure OAuth2 access token for authorization: oauth2
        OAuth oauth2 = (OAuth) defaultClient.getAuthentication("oauth2");
        oauth2.setAccessToken("YOUR ACCESS TOKEN");

        AuthorizationServerRulesApi apiInstance = new AuthorizationServerRulesApi(defaultClient);
        String authServerId = "GeGRTEr7f3yu2n7grw22"; // String | `id` of the Authorization Server
        String policyId = "00plrilJ7jZ66Gn0X0g3"; // String | `id` of the Policy
        String ruleId = "ruld3hJ7jZh4fn0st0g3"; // String | `id` of the Policy Rule
        try {
            apiInstance.deactivateAuthorizationServerPolicyRule(authServerId, policyId, ruleId);
        } catch (ApiException e) {
            System.err.println("Exception when calling AuthorizationServerRulesApi#deactivateAuthorizationServerPolicyRule");
            System.err.println("Status code: " + e.getCode());
            System.err.println("Reason: " + e.getResponseBody());
            System.err.println("Response headers: " + e.getResponseHeaders());
            e.printStackTrace();
        }
    }
}
```

### Parameters


| Name | Type | Description  | Notes |
|------------- | ------------- | ------------- | -------------|
| **authServerId** | **String**| &#x60;id&#x60; of the Authorization Server | |
| **policyId** | **String**| &#x60;id&#x60; of the Policy | |
| **ruleId** | **String**| &#x60;id&#x60; of the Policy Rule | |

### Return type

null (empty response body)

### Authorization

[apiToken](../README.md#apiToken), [oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json


### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **204** | No Content |  -  |
| **403** | Forbidden |  -  |
| **404** | Not Found |  -  |
| **429** | Too Many Requests |  -  |


## deleteAuthorizationServerPolicyRule

> deleteAuthorizationServerPolicyRule(authServerId, policyId, ruleId)

Delete a Policy Rule

Deletes a Policy Rule defined in the specified Custom Authorization Server and Policy

### Example

```java
// Import classes:
import com.okta.sdk.resource.client.ApiClient;
import com.okta.sdk.resource.client.ApiException;
import com.okta.sdk.resource.client.Configuration;
import com.okta.sdk.resource.client.auth.*;
import com.okta.sdk.resource.client.models.*;
import com.okta.sdk.resource.api.AuthorizationServerRulesApi;

public class Example {
    public static void main(String[] args) {
        ApiClient defaultClient = Configuration.getDefaultApiClient();
        defaultClient.setBasePath("https://subdomain.okta.com");
        
        // Configure API key authorization: apiToken
        ApiKeyAuth apiToken = (ApiKeyAuth) defaultClient.getAuthentication("apiToken");
        apiToken.setApiKey("YOUR API KEY");
        // Uncomment the following line to set a prefix for the API key, e.g. "Token" (defaults to null)
        //apiToken.setApiKeyPrefix("Token");

        // Configure OAuth2 access token for authorization: oauth2
        OAuth oauth2 = (OAuth) defaultClient.getAuthentication("oauth2");
        oauth2.setAccessToken("YOUR ACCESS TOKEN");

        AuthorizationServerRulesApi apiInstance = new AuthorizationServerRulesApi(defaultClient);
        String authServerId = "GeGRTEr7f3yu2n7grw22"; // String | `id` of the Authorization Server
        String policyId = "00plrilJ7jZ66Gn0X0g3"; // String | `id` of the Policy
        String ruleId = "ruld3hJ7jZh4fn0st0g3"; // String | `id` of the Policy Rule
        try {
            apiInstance.deleteAuthorizationServerPolicyRule(authServerId, policyId, ruleId);
        } catch (ApiException e) {
            System.err.println("Exception when calling AuthorizationServerRulesApi#deleteAuthorizationServerPolicyRule");
            System.err.println("Status code: " + e.getCode());
            System.err.println("Reason: " + e.getResponseBody());
            System.err.println("Response headers: " + e.getResponseHeaders());
            e.printStackTrace();
        }
    }
}
```

### Parameters


| Name | Type | Description  | Notes |
|------------- | ------------- | ------------- | -------------|
| **authServerId** | **String**| &#x60;id&#x60; of the Authorization Server | |
| **policyId** | **String**| &#x60;id&#x60; of the Policy | |
| **ruleId** | **String**| &#x60;id&#x60; of the Policy Rule | |

### Return type

null (empty response body)

### Authorization

[apiToken](../README.md#apiToken), [oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json


### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **204** | No Content |  -  |
| **403** | Forbidden |  -  |
| **404** | Not Found |  -  |
| **429** | Too Many Requests |  -  |


## getAuthorizationServerPolicyRule

> AuthorizationServerPolicyRule getAuthorizationServerPolicyRule(authServerId, policyId, ruleId)

Retrieve a Policy Rule

Retrieves a policy rule by &#x60;ruleId&#x60;

### Example

```java
// Import classes:
import com.okta.sdk.resource.client.ApiClient;
import com.okta.sdk.resource.client.ApiException;
import com.okta.sdk.resource.client.Configuration;
import com.okta.sdk.resource.client.auth.*;
import com.okta.sdk.resource.client.models.*;
import com.okta.sdk.resource.api.AuthorizationServerRulesApi;

public class Example {
    public static void main(String[] args) {
        ApiClient defaultClient = Configuration.getDefaultApiClient();
        defaultClient.setBasePath("https://subdomain.okta.com");
        
        // Configure API key authorization: apiToken
        ApiKeyAuth apiToken = (ApiKeyAuth) defaultClient.getAuthentication("apiToken");
        apiToken.setApiKey("YOUR API KEY");
        // Uncomment the following line to set a prefix for the API key, e.g. "Token" (defaults to null)
        //apiToken.setApiKeyPrefix("Token");

        // Configure OAuth2 access token for authorization: oauth2
        OAuth oauth2 = (OAuth) defaultClient.getAuthentication("oauth2");
        oauth2.setAccessToken("YOUR ACCESS TOKEN");

        AuthorizationServerRulesApi apiInstance = new AuthorizationServerRulesApi(defaultClient);
        String authServerId = "GeGRTEr7f3yu2n7grw22"; // String | `id` of the Authorization Server
        String policyId = "00plrilJ7jZ66Gn0X0g3"; // String | `id` of the Policy
        String ruleId = "ruld3hJ7jZh4fn0st0g3"; // String | `id` of the Policy Rule
        try {
            AuthorizationServerPolicyRule result = apiInstance.getAuthorizationServerPolicyRule(authServerId, policyId, ruleId);
            System.out.println(result);
        } catch (ApiException e) {
            System.err.println("Exception when calling AuthorizationServerRulesApi#getAuthorizationServerPolicyRule");
            System.err.println("Status code: " + e.getCode());
            System.err.println("Reason: " + e.getResponseBody());
            System.err.println("Response headers: " + e.getResponseHeaders());
            e.printStackTrace();
        }
    }
}
```

### Parameters


| Name | Type | Description  | Notes |
|------------- | ------------- | ------------- | -------------|
| **authServerId** | **String**| &#x60;id&#x60; of the Authorization Server | |
| **policyId** | **String**| &#x60;id&#x60; of the Policy | |
| **ruleId** | **String**| &#x60;id&#x60; of the Policy Rule | |

### Return type

[**AuthorizationServerPolicyRule**](AuthorizationServerPolicyRule.md)

### Authorization

[apiToken](../README.md#apiToken), [oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json


### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **200** | Success |  -  |
| **403** | Forbidden |  -  |
| **404** | Not Found |  -  |
| **429** | Too Many Requests |  -  |


## listAuthorizationServerPolicyRules

> List&lt;AuthorizationServerPolicyRule&gt; listAuthorizationServerPolicyRules(authServerId, policyId)

List all Policy Rules

Lists all policy rules for the specified Custom Authorization Server and Policy

### Example

```java
// Import classes:
import com.okta.sdk.resource.client.ApiClient;
import com.okta.sdk.resource.client.ApiException;
import com.okta.sdk.resource.client.Configuration;
import com.okta.sdk.resource.client.auth.*;
import com.okta.sdk.resource.client.models.*;
import com.okta.sdk.resource.api.AuthorizationServerRulesApi;

public class Example {
    public static void main(String[] args) {
        ApiClient defaultClient = Configuration.getDefaultApiClient();
        defaultClient.setBasePath("https://subdomain.okta.com");
        
        // Configure API key authorization: apiToken
        ApiKeyAuth apiToken = (ApiKeyAuth) defaultClient.getAuthentication("apiToken");
        apiToken.setApiKey("YOUR API KEY");
        // Uncomment the following line to set a prefix for the API key, e.g. "Token" (defaults to null)
        //apiToken.setApiKeyPrefix("Token");

        // Configure OAuth2 access token for authorization: oauth2
        OAuth oauth2 = (OAuth) defaultClient.getAuthentication("oauth2");
        oauth2.setAccessToken("YOUR ACCESS TOKEN");

        AuthorizationServerRulesApi apiInstance = new AuthorizationServerRulesApi(defaultClient);
        String authServerId = "GeGRTEr7f3yu2n7grw22"; // String | `id` of the Authorization Server
        String policyId = "00plrilJ7jZ66Gn0X0g3"; // String | `id` of the Policy
        try {
            List<AuthorizationServerPolicyRule> result = apiInstance.listAuthorizationServerPolicyRules(authServerId, policyId);
            System.out.println(result);
        } catch (ApiException e) {
            System.err.println("Exception when calling AuthorizationServerRulesApi#listAuthorizationServerPolicyRules");
            System.err.println("Status code: " + e.getCode());
            System.err.println("Reason: " + e.getResponseBody());
            System.err.println("Response headers: " + e.getResponseHeaders());
            e.printStackTrace();
        }
    }
}
```

### Parameters


| Name | Type | Description  | Notes |
|------------- | ------------- | ------------- | -------------|
| **authServerId** | **String**| &#x60;id&#x60; of the Authorization Server | |
| **policyId** | **String**| &#x60;id&#x60; of the Policy | |

### Return type

[**List&lt;AuthorizationServerPolicyRule&gt;**](AuthorizationServerPolicyRule.md)

### Authorization

[apiToken](../README.md#apiToken), [oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json


### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **200** | Success |  -  |
| **403** | Forbidden |  -  |
| **404** | Not Found |  -  |
| **429** | Too Many Requests |  -  |


## replaceAuthorizationServerPolicyRule

> AuthorizationServerPolicyRule replaceAuthorizationServerPolicyRule(authServerId, policyId, ruleId, policyRule)

Replace a Policy Rule

Replaces the configuration of the Policy Rule defined in the specified Custom Authorization Server and Policy

### Example

```java
// Import classes:
import com.okta.sdk.resource.client.ApiClient;
import com.okta.sdk.resource.client.ApiException;
import com.okta.sdk.resource.client.Configuration;
import com.okta.sdk.resource.client.auth.*;
import com.okta.sdk.resource.client.models.*;
import com.okta.sdk.resource.api.AuthorizationServerRulesApi;

public class Example {
    public static void main(String[] args) {
        ApiClient defaultClient = Configuration.getDefaultApiClient();
        defaultClient.setBasePath("https://subdomain.okta.com");
        
        // Configure API key authorization: apiToken
        ApiKeyAuth apiToken = (ApiKeyAuth) defaultClient.getAuthentication("apiToken");
        apiToken.setApiKey("YOUR API KEY");
        // Uncomment the following line to set a prefix for the API key, e.g. "Token" (defaults to null)
        //apiToken.setApiKeyPrefix("Token");

        // Configure OAuth2 access token for authorization: oauth2
        OAuth oauth2 = (OAuth) defaultClient.getAuthentication("oauth2");
        oauth2.setAccessToken("YOUR ACCESS TOKEN");

        AuthorizationServerRulesApi apiInstance = new AuthorizationServerRulesApi(defaultClient);
        String authServerId = "GeGRTEr7f3yu2n7grw22"; // String | `id` of the Authorization Server
        String policyId = "00plrilJ7jZ66Gn0X0g3"; // String | `id` of the Policy
        String ruleId = "ruld3hJ7jZh4fn0st0g3"; // String | `id` of the Policy Rule
        AuthorizationServerPolicyRuleRequest policyRule = new AuthorizationServerPolicyRuleRequest(); // AuthorizationServerPolicyRuleRequest | 
        try {
            AuthorizationServerPolicyRule result = apiInstance.replaceAuthorizationServerPolicyRule(authServerId, policyId, ruleId, policyRule);
            System.out.println(result);
        } catch (ApiException e) {
            System.err.println("Exception when calling AuthorizationServerRulesApi#replaceAuthorizationServerPolicyRule");
            System.err.println("Status code: " + e.getCode());
            System.err.println("Reason: " + e.getResponseBody());
            System.err.println("Response headers: " + e.getResponseHeaders());
            e.printStackTrace();
        }
    }
}
```

### Parameters


| Name | Type | Description  | Notes |
|------------- | ------------- | ------------- | -------------|
| **authServerId** | **String**| &#x60;id&#x60; of the Authorization Server | |
| **policyId** | **String**| &#x60;id&#x60; of the Policy | |
| **ruleId** | **String**| &#x60;id&#x60; of the Policy Rule | |
| **policyRule** | [**AuthorizationServerPolicyRuleRequest**](AuthorizationServerPolicyRuleRequest.md)|  | |

### Return type

[**AuthorizationServerPolicyRule**](AuthorizationServerPolicyRule.md)

### Authorization

[apiToken](../README.md#apiToken), [oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: application/json
- **Accept**: application/json


### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **200** | Success |  -  |
| **400** | Bad Request |  -  |
| **403** | Forbidden |  -  |
| **404** | Not Found |  -  |
| **429** | Too Many Requests |  -  |

