# AuthorizationServerScopesApi

All URIs are relative to *https://subdomain.okta.com*

| Method | HTTP request | Description |
|------------- | ------------- | -------------|
| [**createOAuth2Scope**](AuthorizationServerScopesApi.md#createOAuth2Scope) | **POST** /api/v1/authorizationServers/{authServerId}/scopes | Create a Custom Token Scope |
| [**deleteOAuth2Scope**](AuthorizationServerScopesApi.md#deleteOAuth2Scope) | **DELETE** /api/v1/authorizationServers/{authServerId}/scopes/{scopeId} | Delete a Custom Token Scope |
| [**getOAuth2Scope**](AuthorizationServerScopesApi.md#getOAuth2Scope) | **GET** /api/v1/authorizationServers/{authServerId}/scopes/{scopeId} | Retrieve a Custom Token Scope |
| [**listOAuth2Scopes**](AuthorizationServerScopesApi.md#listOAuth2Scopes) | **GET** /api/v1/authorizationServers/{authServerId}/scopes | List all Custom Token Scopes |
| [**replaceOAuth2Scope**](AuthorizationServerScopesApi.md#replaceOAuth2Scope) | **PUT** /api/v1/authorizationServers/{authServerId}/scopes/{scopeId} | Replace a Custom Token Scope |



## createOAuth2Scope

> OAuth2Scope createOAuth2Scope(authServerId, oAuth2Scope)

Create a Custom Token Scope

Creates a custom token scope

### Example

```java
// Import classes:
import com.okta.sdk.resource.client.ApiClient;
import com.okta.sdk.resource.client.ApiException;
import com.okta.sdk.resource.client.Configuration;
import com.okta.sdk.resource.client.auth.*;
import com.okta.sdk.resource.client.models.*;
import com.okta.sdk.resource.api.AuthorizationServerScopesApi;

public class Example {
    public static void main(String[] args) {
        ApiClient defaultClient = Configuration.getDefaultApiClient();
        defaultClient.setBasePath("https://subdomain.okta.com");
        
        // Configure API key authorization: apiToken
        ApiKeyAuth apiToken = (ApiKeyAuth) defaultClient.getAuthentication("apiToken");
        apiToken.setApiKey("YOUR API KEY");
        // Uncomment the following line to set a prefix for the API key, e.g. "Token" (defaults to null)
        //apiToken.setApiKeyPrefix("Token");

        // Configure OAuth2 access token for authorization: oauth2
        OAuth oauth2 = (OAuth) defaultClient.getAuthentication("oauth2");
        oauth2.setAccessToken("YOUR ACCESS TOKEN");

        AuthorizationServerScopesApi apiInstance = new AuthorizationServerScopesApi(defaultClient);
        String authServerId = "GeGRTEr7f3yu2n7grw22"; // String | `id` of the Authorization Server
        OAuth2Scope oAuth2Scope = new OAuth2Scope(); // OAuth2Scope | 
        try {
            OAuth2Scope result = apiInstance.createOAuth2Scope(authServerId, oAuth2Scope);
            System.out.println(result);
        } catch (ApiException e) {
            System.err.println("Exception when calling AuthorizationServerScopesApi#createOAuth2Scope");
            System.err.println("Status code: " + e.getCode());
            System.err.println("Reason: " + e.getResponseBody());
            System.err.println("Response headers: " + e.getResponseHeaders());
            e.printStackTrace();
        }
    }
}
```

### Parameters


| Name | Type | Description  | Notes |
|------------- | ------------- | ------------- | -------------|
| **authServerId** | **String**| &#x60;id&#x60; of the Authorization Server | |
| **oAuth2Scope** | [**OAuth2Scope**](OAuth2Scope.md)|  | |

### Return type

[**OAuth2Scope**](OAuth2Scope.md)

### Authorization

[apiToken](../README.md#apiToken), [oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: application/json
- **Accept**: application/json


### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **201** | Success |  -  |
| **400** | Bad Request |  -  |
| **403** | Forbidden |  -  |
| **404** | Not Found |  -  |
| **429** | Too Many Requests |  -  |


## deleteOAuth2Scope

> deleteOAuth2Scope(authServerId, scopeId)

Delete a Custom Token Scope

Deletes a custom token scope

### Example

```java
// Import classes:
import com.okta.sdk.resource.client.ApiClient;
import com.okta.sdk.resource.client.ApiException;
import com.okta.sdk.resource.client.Configuration;
import com.okta.sdk.resource.client.auth.*;
import com.okta.sdk.resource.client.models.*;
import com.okta.sdk.resource.api.AuthorizationServerScopesApi;

public class Example {
    public static void main(String[] args) {
        ApiClient defaultClient = Configuration.getDefaultApiClient();
        defaultClient.setBasePath("https://subdomain.okta.com");
        
        // Configure API key authorization: apiToken
        ApiKeyAuth apiToken = (ApiKeyAuth) defaultClient.getAuthentication("apiToken");
        apiToken.setApiKey("YOUR API KEY");
        // Uncomment the following line to set a prefix for the API key, e.g. "Token" (defaults to null)
        //apiToken.setApiKeyPrefix("Token");

        // Configure OAuth2 access token for authorization: oauth2
        OAuth oauth2 = (OAuth) defaultClient.getAuthentication("oauth2");
        oauth2.setAccessToken("YOUR ACCESS TOKEN");

        AuthorizationServerScopesApi apiInstance = new AuthorizationServerScopesApi(defaultClient);
        String authServerId = "GeGRTEr7f3yu2n7grw22"; // String | `id` of the Authorization Server
        String scopeId = "0TMRpCWXRKFjP7HiPFNM"; // String | `id` of Scope
        try {
            apiInstance.deleteOAuth2Scope(authServerId, scopeId);
        } catch (ApiException e) {
            System.err.println("Exception when calling AuthorizationServerScopesApi#deleteOAuth2Scope");
            System.err.println("Status code: " + e.getCode());
            System.err.println("Reason: " + e.getResponseBody());
            System.err.println("Response headers: " + e.getResponseHeaders());
            e.printStackTrace();
        }
    }
}
```

### Parameters


| Name | Type | Description  | Notes |
|------------- | ------------- | ------------- | -------------|
| **authServerId** | **String**| &#x60;id&#x60; of the Authorization Server | |
| **scopeId** | **String**| &#x60;id&#x60; of Scope | |

### Return type

null (empty response body)

### Authorization

[apiToken](../README.md#apiToken), [oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json


### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **204** | No Content |  -  |
| **403** | Forbidden |  -  |
| **404** | Not Found |  -  |
| **429** | Too Many Requests |  -  |


## getOAuth2Scope

> OAuth2Scope getOAuth2Scope(authServerId, scopeId)

Retrieve a Custom Token Scope

Retrieves a custom token scope

### Example

```java
// Import classes:
import com.okta.sdk.resource.client.ApiClient;
import com.okta.sdk.resource.client.ApiException;
import com.okta.sdk.resource.client.Configuration;
import com.okta.sdk.resource.client.auth.*;
import com.okta.sdk.resource.client.models.*;
import com.okta.sdk.resource.api.AuthorizationServerScopesApi;

public class Example {
    public static void main(String[] args) {
        ApiClient defaultClient = Configuration.getDefaultApiClient();
        defaultClient.setBasePath("https://subdomain.okta.com");
        
        // Configure API key authorization: apiToken
        ApiKeyAuth apiToken = (ApiKeyAuth) defaultClient.getAuthentication("apiToken");
        apiToken.setApiKey("YOUR API KEY");
        // Uncomment the following line to set a prefix for the API key, e.g. "Token" (defaults to null)
        //apiToken.setApiKeyPrefix("Token");

        // Configure OAuth2 access token for authorization: oauth2
        OAuth oauth2 = (OAuth) defaultClient.getAuthentication("oauth2");
        oauth2.setAccessToken("YOUR ACCESS TOKEN");

        AuthorizationServerScopesApi apiInstance = new AuthorizationServerScopesApi(defaultClient);
        String authServerId = "GeGRTEr7f3yu2n7grw22"; // String | `id` of the Authorization Server
        String scopeId = "0TMRpCWXRKFjP7HiPFNM"; // String | `id` of Scope
        try {
            OAuth2Scope result = apiInstance.getOAuth2Scope(authServerId, scopeId);
            System.out.println(result);
        } catch (ApiException e) {
            System.err.println("Exception when calling AuthorizationServerScopesApi#getOAuth2Scope");
            System.err.println("Status code: " + e.getCode());
            System.err.println("Reason: " + e.getResponseBody());
            System.err.println("Response headers: " + e.getResponseHeaders());
            e.printStackTrace();
        }
    }
}
```

### Parameters


| Name | Type | Description  | Notes |
|------------- | ------------- | ------------- | -------------|
| **authServerId** | **String**| &#x60;id&#x60; of the Authorization Server | |
| **scopeId** | **String**| &#x60;id&#x60; of Scope | |

### Return type

[**OAuth2Scope**](OAuth2Scope.md)

### Authorization

[apiToken](../README.md#apiToken), [oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json


### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **200** | Success |  -  |
| **403** | Forbidden |  -  |
| **404** | Not Found |  -  |
| **429** | Too Many Requests |  -  |


## listOAuth2Scopes

> List&lt;OAuth2Scope&gt; listOAuth2Scopes(authServerId, q, filter, after, limit)

List all Custom Token Scopes

Lists all custom token scopes

### Example

```java
// Import classes:
import com.okta.sdk.resource.client.ApiClient;
import com.okta.sdk.resource.client.ApiException;
import com.okta.sdk.resource.client.Configuration;
import com.okta.sdk.resource.client.auth.*;
import com.okta.sdk.resource.client.models.*;
import com.okta.sdk.resource.api.AuthorizationServerScopesApi;

public class Example {
    public static void main(String[] args) {
        ApiClient defaultClient = Configuration.getDefaultApiClient();
        defaultClient.setBasePath("https://subdomain.okta.com");
        
        // Configure API key authorization: apiToken
        ApiKeyAuth apiToken = (ApiKeyAuth) defaultClient.getAuthentication("apiToken");
        apiToken.setApiKey("YOUR API KEY");
        // Uncomment the following line to set a prefix for the API key, e.g. "Token" (defaults to null)
        //apiToken.setApiKeyPrefix("Token");

        // Configure OAuth2 access token for authorization: oauth2
        OAuth oauth2 = (OAuth) defaultClient.getAuthentication("oauth2");
        oauth2.setAccessToken("YOUR ACCESS TOKEN");

        AuthorizationServerScopesApi apiInstance = new AuthorizationServerScopesApi(defaultClient);
        String authServerId = "GeGRTEr7f3yu2n7grw22"; // String | `id` of the Authorization Server
        String q = "q_example"; // String | Searches the `name` of Custom Token Scopes for matching values
        String filter = "filter_example"; // String | Filter expression for Custom Token Scopes
        String after = "after_example"; // String | Specifies the pagination cursor for the next page of scopes. Treat the after cursor as an opaque value and obtain it through the next link relationship. See [Pagination](https://developer.okta.com/docs/api/#pagination).
        Integer limit = 56; // Integer | Specifies the number of objects to return per page. If there are multiple pages of results, the Link header contains a `next` link that you need to use as an opaque value (follow it, don't parse it). See [Pagination](https://developer.okta.com/docs/api/#pagination).
        try {
            List<OAuth2Scope> result = apiInstance.listOAuth2Scopes(authServerId, q, filter, after, limit);
            System.out.println(result);
        } catch (ApiException e) {
            System.err.println("Exception when calling AuthorizationServerScopesApi#listOAuth2Scopes");
            System.err.println("Status code: " + e.getCode());
            System.err.println("Reason: " + e.getResponseBody());
            System.err.println("Response headers: " + e.getResponseHeaders());
            e.printStackTrace();
        }
    }
}
```

### Parameters


| Name | Type | Description  | Notes |
|------------- | ------------- | ------------- | -------------|
| **authServerId** | **String**| &#x60;id&#x60; of the Authorization Server | |
| **q** | **String**| Searches the &#x60;name&#x60; of Custom Token Scopes for matching values | [optional] |
| **filter** | **String**| Filter expression for Custom Token Scopes | [optional] |
| **after** | **String**| Specifies the pagination cursor for the next page of scopes. Treat the after cursor as an opaque value and obtain it through the next link relationship. See [Pagination](https://developer.okta.com/docs/api/#pagination). | [optional] |
| **limit** | **Integer**| Specifies the number of objects to return per page. If there are multiple pages of results, the Link header contains a &#x60;next&#x60; link that you need to use as an opaque value (follow it, don&#39;t parse it). See [Pagination](https://developer.okta.com/docs/api/#pagination). | [optional] |

### Return type

[**List&lt;OAuth2Scope&gt;**](OAuth2Scope.md)

### Authorization

[apiToken](../README.md#apiToken), [oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json


### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **200** | Success |  -  |
| **403** | Forbidden |  -  |
| **404** | Not Found |  -  |
| **429** | Too Many Requests |  -  |


## replaceOAuth2Scope

> OAuth2Scope replaceOAuth2Scope(authServerId, scopeId, oAuth2Scope)

Replace a Custom Token Scope

Replaces a custom token scope

### Example

```java
// Import classes:
import com.okta.sdk.resource.client.ApiClient;
import com.okta.sdk.resource.client.ApiException;
import com.okta.sdk.resource.client.Configuration;
import com.okta.sdk.resource.client.auth.*;
import com.okta.sdk.resource.client.models.*;
import com.okta.sdk.resource.api.AuthorizationServerScopesApi;

public class Example {
    public static void main(String[] args) {
        ApiClient defaultClient = Configuration.getDefaultApiClient();
        defaultClient.setBasePath("https://subdomain.okta.com");
        
        // Configure API key authorization: apiToken
        ApiKeyAuth apiToken = (ApiKeyAuth) defaultClient.getAuthentication("apiToken");
        apiToken.setApiKey("YOUR API KEY");
        // Uncomment the following line to set a prefix for the API key, e.g. "Token" (defaults to null)
        //apiToken.setApiKeyPrefix("Token");

        // Configure OAuth2 access token for authorization: oauth2
        OAuth oauth2 = (OAuth) defaultClient.getAuthentication("oauth2");
        oauth2.setAccessToken("YOUR ACCESS TOKEN");

        AuthorizationServerScopesApi apiInstance = new AuthorizationServerScopesApi(defaultClient);
        String authServerId = "GeGRTEr7f3yu2n7grw22"; // String | `id` of the Authorization Server
        String scopeId = "0TMRpCWXRKFjP7HiPFNM"; // String | `id` of Scope
        OAuth2Scope oAuth2Scope = new OAuth2Scope(); // OAuth2Scope | 
        try {
            OAuth2Scope result = apiInstance.replaceOAuth2Scope(authServerId, scopeId, oAuth2Scope);
            System.out.println(result);
        } catch (ApiException e) {
            System.err.println("Exception when calling AuthorizationServerScopesApi#replaceOAuth2Scope");
            System.err.println("Status code: " + e.getCode());
            System.err.println("Reason: " + e.getResponseBody());
            System.err.println("Response headers: " + e.getResponseHeaders());
            e.printStackTrace();
        }
    }
}
```

### Parameters


| Name | Type | Description  | Notes |
|------------- | ------------- | ------------- | -------------|
| **authServerId** | **String**| &#x60;id&#x60; of the Authorization Server | |
| **scopeId** | **String**| &#x60;id&#x60; of Scope | |
| **oAuth2Scope** | [**OAuth2Scope**](OAuth2Scope.md)|  | |

### Return type

[**OAuth2Scope**](OAuth2Scope.md)

### Authorization

[apiToken](../README.md#apiToken), [oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: application/json
- **Accept**: application/json


### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **200** | Success |  -  |
| **400** | Bad Request |  -  |
| **403** | Forbidden |  -  |
| **404** | Not Found |  -  |
| **429** | Too Many Requests |  -  |

