# DirectoriesIntegrationApi

All URIs are relative to *https://subdomain.okta.com*

| Method | HTTP request | Description |
|------------- | ------------- | -------------|
| [**updateADGroupMembership**](DirectoriesIntegrationApi.md#updateADGroupMembership) | **POST** /api/v1/directories/{appInstanceId}/groups/modify | Update an AD Group membership |



## updateADGroupMembership

> updateADGroupMembership(appInstanceId, agentAction)

Update an AD Group membership

Updates an AD Group membership directly in AD

### Example

```java
// Import classes:
import com.okta.sdk.resource.client.ApiClient;
import com.okta.sdk.resource.client.ApiException;
import com.okta.sdk.resource.client.Configuration;
import com.okta.sdk.resource.client.auth.*;
import com.okta.sdk.resource.client.models.*;
import com.okta.sdk.resource.api.DirectoriesIntegrationApi;

public class Example {
    public static void main(String[] args) {
        ApiClient defaultClient = Configuration.getDefaultApiClient();
        defaultClient.setBasePath("https://subdomain.okta.com");
        
        // Configure OAuth2 access token for authorization: oauth2
        OAuth oauth2 = (OAuth) defaultClient.getAuthentication("oauth2");
        oauth2.setAccessToken("YOUR ACCESS TOKEN");

        DirectoriesIntegrationApi apiInstance = new DirectoriesIntegrationApi(defaultClient);
        String appInstanceId = "appInstanceId_example"; // String | ID of the AD AppInstance in Okta
        AgentAction agentAction = new AgentAction(); // AgentAction | 
        try {
            apiInstance.updateADGroupMembership(appInstanceId, agentAction);
        } catch (ApiException e) {
            System.err.println("Exception when calling DirectoriesIntegrationApi#updateADGroupMembership");
            System.err.println("Status code: " + e.getCode());
            System.err.println("Reason: " + e.getResponseBody());
            System.err.println("Response headers: " + e.getResponseHeaders());
            e.printStackTrace();
        }
    }
}
```

### Parameters


| Name | Type | Description  | Notes |
|------------- | ------------- | ------------- | -------------|
| **appInstanceId** | **String**| ID of the AD AppInstance in Okta | |
| **agentAction** | [**AgentAction**](AgentAction.md)|  | |

### Return type

null (empty response body)

### Authorization

[oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: application/json
- **Accept**: application/json


### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **200** | OK |  -  |
| **400** | Bad Request |  -  |
| **403** | Forbidden |  -  |
| **404** | Not Found |  -  |
| **502** | There are no connected agents. |  -  |
| **504** | Timed out waiting for agent. |  -  |

