

# GroupProfile

Specifies required and optional properties for a Group. The `objectClass` of a Group determines which additional properties are available.  You can extend Group Profiles with custom properties, but you must first add the properties to the Group Profile schema before you can reference them. Use the Profile Editor in the Admin Console or the [Schemas API](https://developer.okta.com/docs/api/openapi/okta-management/management/tag/Schema/)to manage schema extensions.  Custom properties can contain HTML tags. It is the client's responsibility to escape or encode this data before displaying it. Use [best-practices](https://cheatsheetseries.owasp.org/cheatsheets/Cross_Site_Scripting_Prevention_Cheat_Sheet.html) to prevent cross-site scripting.

## Properties

| Name | Type | Description | Notes |
|------------ | ------------- | ------------- | -------------|
|**description** | **String** | Description of the Windows Group |  [optional] |
|**name** | **String** | Name of the Windows Group |  [optional] |
|**dn** | **String** | The distinguished name of the Windows Group |  [optional] |
|**externalId** | **String** | Base-64 encoded GUID (&#x60;objectGUID&#x60;) of the Windows Group |  [optional] |
|**samAccountName** | **String** | Pre-Windows 2000 name of the Windows Group |  [optional] |
|**windowsDomainQualifiedName** | **String** | Fully qualified name of the Windows Group |  [optional] |


## Implemented Interfaces

* Serializable


