# IdentityProviderSigningKeysApi

All URIs are relative to *https://subdomain.okta.com*

| Method | HTTP request | Description |
|------------- | ------------- | -------------|
| [**cloneIdentityProviderKey**](IdentityProviderSigningKeysApi.md#cloneIdentityProviderKey) | **POST** /api/v1/idps/{idpId}/credentials/keys/{kid}/clone | Clone a signing Key Credential for IdP |
| [**generateCsrForIdentityProvider**](IdentityProviderSigningKeysApi.md#generateCsrForIdentityProvider) | **POST** /api/v1/idps/{idpId}/credentials/csrs | Generate a Certificate Signing Request |
| [**generateIdentityProviderSigningKey**](IdentityProviderSigningKeysApi.md#generateIdentityProviderSigningKey) | **POST** /api/v1/idps/{idpId}/credentials/keys/generate | Generate a new signing Key Credential for IdP |
| [**getCsrForIdentityProvider**](IdentityProviderSigningKeysApi.md#getCsrForIdentityProvider) | **GET** /api/v1/idps/{idpId}/credentials/csrs/{idpCsrId} | Retrieve a Certificate Signing Request |
| [**getIdentityProviderSigningKey**](IdentityProviderSigningKeysApi.md#getIdentityProviderSigningKey) | **GET** /api/v1/idps/{idpId}/credentials/keys/{kid} | Retrieve a signing Key Credential for IdP |
| [**listCsrsForIdentityProvider**](IdentityProviderSigningKeysApi.md#listCsrsForIdentityProvider) | **GET** /api/v1/idps/{idpId}/credentials/csrs | List all Certificate Signing Requests |
| [**listIdentityProviderSigningKeys**](IdentityProviderSigningKeysApi.md#listIdentityProviderSigningKeys) | **GET** /api/v1/idps/{idpId}/credentials/keys | List all signing Key Credentials for IdP |
| [**publishCsrForIdentityProvider**](IdentityProviderSigningKeysApi.md#publishCsrForIdentityProvider) | **POST** /api/v1/idps/{idpId}/credentials/csrs/{idpCsrId}/lifecycle/publish | Publish a Certificate Signing Request |
| [**revokeCsrForIdentityProvider**](IdentityProviderSigningKeysApi.md#revokeCsrForIdentityProvider) | **DELETE** /api/v1/idps/{idpId}/credentials/csrs/{idpCsrId} | Revoke a Certificate Signing Request |



## cloneIdentityProviderKey

> IdPKeyCredential cloneIdentityProviderKey(idpId, kid, targetIdpId)

Clone a signing Key Credential for IdP

Clones an X.509 certificate for an IdP signing Key Credential from a source IdP to target IdP &gt; **Caution:** Sharing certificates isn&#39;t a recommended security practice.  &gt; **Note:** If the key is already present in the list of Key Credentials for the target IdP, you receive a 400 error response.

### Example

```java
// Import classes:
import com.okta.sdk.resource.client.ApiClient;
import com.okta.sdk.resource.client.ApiException;
import com.okta.sdk.resource.client.Configuration;
import com.okta.sdk.resource.client.auth.*;
import com.okta.sdk.resource.client.models.*;
import com.okta.sdk.resource.api.IdentityProviderSigningKeysApi;

public class Example {
    public static void main(String[] args) {
        ApiClient defaultClient = Configuration.getDefaultApiClient();
        defaultClient.setBasePath("https://subdomain.okta.com");
        
        // Configure API key authorization: apiToken
        ApiKeyAuth apiToken = (ApiKeyAuth) defaultClient.getAuthentication("apiToken");
        apiToken.setApiKey("YOUR API KEY");
        // Uncomment the following line to set a prefix for the API key, e.g. "Token" (defaults to null)
        //apiToken.setApiKeyPrefix("Token");

        // Configure OAuth2 access token for authorization: oauth2
        OAuth oauth2 = (OAuth) defaultClient.getAuthentication("oauth2");
        oauth2.setAccessToken("YOUR ACCESS TOKEN");

        IdentityProviderSigningKeysApi apiInstance = new IdentityProviderSigningKeysApi(defaultClient);
        String idpId = "0oa62bfdjnK55Z5x80h7"; // String | `id` of IdP
        String kid = "KmMo85SSsU7TZzOShcGb"; // String | Unique `id` of the IdP Key Credential
        String targetIdpId = "targetIdpId_example"; // String | `id` of the target IdP
        try {
            IdPKeyCredential result = apiInstance.cloneIdentityProviderKey(idpId, kid, targetIdpId);
            System.out.println(result);
        } catch (ApiException e) {
            System.err.println("Exception when calling IdentityProviderSigningKeysApi#cloneIdentityProviderKey");
            System.err.println("Status code: " + e.getCode());
            System.err.println("Reason: " + e.getResponseBody());
            System.err.println("Response headers: " + e.getResponseHeaders());
            e.printStackTrace();
        }
    }
}
```

### Parameters


| Name | Type | Description  | Notes |
|------------- | ------------- | ------------- | -------------|
| **idpId** | **String**| &#x60;id&#x60; of IdP | |
| **kid** | **String**| Unique &#x60;id&#x60; of the IdP Key Credential | |
| **targetIdpId** | **String**| &#x60;id&#x60; of the target IdP | |

### Return type

[**IdPKeyCredential**](IdPKeyCredential.md)

### Authorization

[apiToken](../README.md#apiToken), [oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json


### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **201** | Created |  -  |
| **403** | Forbidden |  -  |
| **404** | Not Found |  -  |
| **429** | Too Many Requests |  -  |


## generateCsrForIdentityProvider

> IdPCsr generateCsrForIdentityProvider(idpId, metadata)

Generate a Certificate Signing Request

Generates a new key pair and returns a Certificate Signing Request (CSR) for it &gt; **Note:** The private key isn&#39;t listed in the [Signing Key Credentials for IdP](https://developer.okta.com/docs/api/openapi/okta-management/management/tag/IdentityProviderSigningKeys/#tag/IdentityProviderSigningKeys/operation/listIdentityProviderSigningKeys) until it&#39;s published.

### Example

```java
// Import classes:
import com.okta.sdk.resource.client.ApiClient;
import com.okta.sdk.resource.client.ApiException;
import com.okta.sdk.resource.client.Configuration;
import com.okta.sdk.resource.client.auth.*;
import com.okta.sdk.resource.client.models.*;
import com.okta.sdk.resource.api.IdentityProviderSigningKeysApi;

public class Example {
    public static void main(String[] args) {
        ApiClient defaultClient = Configuration.getDefaultApiClient();
        defaultClient.setBasePath("https://subdomain.okta.com");
        
        // Configure API key authorization: apiToken
        ApiKeyAuth apiToken = (ApiKeyAuth) defaultClient.getAuthentication("apiToken");
        apiToken.setApiKey("YOUR API KEY");
        // Uncomment the following line to set a prefix for the API key, e.g. "Token" (defaults to null)
        //apiToken.setApiKeyPrefix("Token");

        // Configure OAuth2 access token for authorization: oauth2
        OAuth oauth2 = (OAuth) defaultClient.getAuthentication("oauth2");
        oauth2.setAccessToken("YOUR ACCESS TOKEN");

        IdentityProviderSigningKeysApi apiInstance = new IdentityProviderSigningKeysApi(defaultClient);
        String idpId = "0oa62bfdjnK55Z5x80h7"; // String | `id` of IdP
        CsrMetadata metadata = new CsrMetadata(); // CsrMetadata | 
        try {
            IdPCsr result = apiInstance.generateCsrForIdentityProvider(idpId, metadata);
            System.out.println(result);
        } catch (ApiException e) {
            System.err.println("Exception when calling IdentityProviderSigningKeysApi#generateCsrForIdentityProvider");
            System.err.println("Status code: " + e.getCode());
            System.err.println("Reason: " + e.getResponseBody());
            System.err.println("Response headers: " + e.getResponseHeaders());
            e.printStackTrace();
        }
    }
}
```

### Parameters


| Name | Type | Description  | Notes |
|------------- | ------------- | ------------- | -------------|
| **idpId** | **String**| &#x60;id&#x60; of IdP | |
| **metadata** | [**CsrMetadata**](CsrMetadata.md)|  | |

### Return type

[**IdPCsr**](IdPCsr.md)

### Authorization

[apiToken](../README.md#apiToken), [oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: application/json
- **Accept**: application/json, application/pkcs10


### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **201** | Created |  -  |
| **400** | Bad Request |  -  |
| **403** | Forbidden |  -  |
| **404** | Not Found |  -  |
| **429** | Too Many Requests |  -  |


## generateIdentityProviderSigningKey

> IdPKeyCredential generateIdentityProviderSigningKey(idpId, validityYears)

Generate a new signing Key Credential for IdP

Generates a new X.509 certificate for an IdP signing Key Credential to be used for signing assertions sent to the IdP. IdP signing keys are read-only. &gt; **Note:** To update an IdP with the newly generated Key Credential, [update your IdP](https://developer.okta.com/docs/api/openapi/okta-management/management/tag/IdentityProvider/#tag/IdentityProvider/operation/replaceIdentityProvider) using the returned key&#39;s &#x60;kid&#x60; in the [signing credential](https://developer.okta.com/docs/api/openapi/okta-management/management/tag/IdentityProvider/#tag/IdentityProvider/operation/replaceIdentityProvider!path&#x3D;protocol/0/credentials/signing/kid&amp;t&#x3D;request).

### Example

```java
// Import classes:
import com.okta.sdk.resource.client.ApiClient;
import com.okta.sdk.resource.client.ApiException;
import com.okta.sdk.resource.client.Configuration;
import com.okta.sdk.resource.client.auth.*;
import com.okta.sdk.resource.client.models.*;
import com.okta.sdk.resource.api.IdentityProviderSigningKeysApi;

public class Example {
    public static void main(String[] args) {
        ApiClient defaultClient = Configuration.getDefaultApiClient();
        defaultClient.setBasePath("https://subdomain.okta.com");
        
        // Configure API key authorization: apiToken
        ApiKeyAuth apiToken = (ApiKeyAuth) defaultClient.getAuthentication("apiToken");
        apiToken.setApiKey("YOUR API KEY");
        // Uncomment the following line to set a prefix for the API key, e.g. "Token" (defaults to null)
        //apiToken.setApiKeyPrefix("Token");

        // Configure OAuth2 access token for authorization: oauth2
        OAuth oauth2 = (OAuth) defaultClient.getAuthentication("oauth2");
        oauth2.setAccessToken("YOUR ACCESS TOKEN");

        IdentityProviderSigningKeysApi apiInstance = new IdentityProviderSigningKeysApi(defaultClient);
        String idpId = "0oa62bfdjnK55Z5x80h7"; // String | `id` of IdP
        Integer validityYears = 56; // Integer | expiry of the IdP Key Credential
        try {
            IdPKeyCredential result = apiInstance.generateIdentityProviderSigningKey(idpId, validityYears);
            System.out.println(result);
        } catch (ApiException e) {
            System.err.println("Exception when calling IdentityProviderSigningKeysApi#generateIdentityProviderSigningKey");
            System.err.println("Status code: " + e.getCode());
            System.err.println("Reason: " + e.getResponseBody());
            System.err.println("Response headers: " + e.getResponseHeaders());
            e.printStackTrace();
        }
    }
}
```

### Parameters


| Name | Type | Description  | Notes |
|------------- | ------------- | ------------- | -------------|
| **idpId** | **String**| &#x60;id&#x60; of IdP | |
| **validityYears** | **Integer**| expiry of the IdP Key Credential | |

### Return type

[**IdPKeyCredential**](IdPKeyCredential.md)

### Authorization

[apiToken](../README.md#apiToken), [oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json


### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **200** | Success |  -  |
| **403** | Forbidden |  -  |
| **404** | Not Found |  -  |
| **429** | Too Many Requests |  -  |


## getCsrForIdentityProvider

> IdPCsr getCsrForIdentityProvider(idpId, idpCsrId)

Retrieve a Certificate Signing Request

Retrieves a specific Certificate Signing Request by &#x60;id&#x60;

### Example

```java
// Import classes:
import com.okta.sdk.resource.client.ApiClient;
import com.okta.sdk.resource.client.ApiException;
import com.okta.sdk.resource.client.Configuration;
import com.okta.sdk.resource.client.auth.*;
import com.okta.sdk.resource.client.models.*;
import com.okta.sdk.resource.api.IdentityProviderSigningKeysApi;

public class Example {
    public static void main(String[] args) {
        ApiClient defaultClient = Configuration.getDefaultApiClient();
        defaultClient.setBasePath("https://subdomain.okta.com");
        
        // Configure API key authorization: apiToken
        ApiKeyAuth apiToken = (ApiKeyAuth) defaultClient.getAuthentication("apiToken");
        apiToken.setApiKey("YOUR API KEY");
        // Uncomment the following line to set a prefix for the API key, e.g. "Token" (defaults to null)
        //apiToken.setApiKeyPrefix("Token");

        // Configure OAuth2 access token for authorization: oauth2
        OAuth oauth2 = (OAuth) defaultClient.getAuthentication("oauth2");
        oauth2.setAccessToken("YOUR ACCESS TOKEN");

        IdentityProviderSigningKeysApi apiInstance = new IdentityProviderSigningKeysApi(defaultClient);
        String idpId = "0oa62bfdjnK55Z5x80h7"; // String | `id` of IdP
        String idpCsrId = "1uEhyE65oV3H6KM9gYcN"; // String | `id` of the IdP CSR
        try {
            IdPCsr result = apiInstance.getCsrForIdentityProvider(idpId, idpCsrId);
            System.out.println(result);
        } catch (ApiException e) {
            System.err.println("Exception when calling IdentityProviderSigningKeysApi#getCsrForIdentityProvider");
            System.err.println("Status code: " + e.getCode());
            System.err.println("Reason: " + e.getResponseBody());
            System.err.println("Response headers: " + e.getResponseHeaders());
            e.printStackTrace();
        }
    }
}
```

### Parameters


| Name | Type | Description  | Notes |
|------------- | ------------- | ------------- | -------------|
| **idpId** | **String**| &#x60;id&#x60; of IdP | |
| **idpCsrId** | **String**| &#x60;id&#x60; of the IdP CSR | |

### Return type

[**IdPCsr**](IdPCsr.md)

### Authorization

[apiToken](../README.md#apiToken), [oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json, application/pkcs10


### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **200** | Success |  -  |
| **403** | Forbidden |  -  |
| **404** | Not Found |  -  |
| **429** | Too Many Requests |  -  |


## getIdentityProviderSigningKey

> IdPKeyCredential getIdentityProviderSigningKey(idpId, kid)

Retrieve a signing Key Credential for IdP

Retrieves a specific IdP Key Credential by &#x60;kid&#x60;

### Example

```java
// Import classes:
import com.okta.sdk.resource.client.ApiClient;
import com.okta.sdk.resource.client.ApiException;
import com.okta.sdk.resource.client.Configuration;
import com.okta.sdk.resource.client.auth.*;
import com.okta.sdk.resource.client.models.*;
import com.okta.sdk.resource.api.IdentityProviderSigningKeysApi;

public class Example {
    public static void main(String[] args) {
        ApiClient defaultClient = Configuration.getDefaultApiClient();
        defaultClient.setBasePath("https://subdomain.okta.com");
        
        // Configure API key authorization: apiToken
        ApiKeyAuth apiToken = (ApiKeyAuth) defaultClient.getAuthentication("apiToken");
        apiToken.setApiKey("YOUR API KEY");
        // Uncomment the following line to set a prefix for the API key, e.g. "Token" (defaults to null)
        //apiToken.setApiKeyPrefix("Token");

        // Configure OAuth2 access token for authorization: oauth2
        OAuth oauth2 = (OAuth) defaultClient.getAuthentication("oauth2");
        oauth2.setAccessToken("YOUR ACCESS TOKEN");

        IdentityProviderSigningKeysApi apiInstance = new IdentityProviderSigningKeysApi(defaultClient);
        String idpId = "0oa62bfdjnK55Z5x80h7"; // String | `id` of IdP
        String kid = "KmMo85SSsU7TZzOShcGb"; // String | Unique `id` of the IdP Key Credential
        try {
            IdPKeyCredential result = apiInstance.getIdentityProviderSigningKey(idpId, kid);
            System.out.println(result);
        } catch (ApiException e) {
            System.err.println("Exception when calling IdentityProviderSigningKeysApi#getIdentityProviderSigningKey");
            System.err.println("Status code: " + e.getCode());
            System.err.println("Reason: " + e.getResponseBody());
            System.err.println("Response headers: " + e.getResponseHeaders());
            e.printStackTrace();
        }
    }
}
```

### Parameters


| Name | Type | Description  | Notes |
|------------- | ------------- | ------------- | -------------|
| **idpId** | **String**| &#x60;id&#x60; of IdP | |
| **kid** | **String**| Unique &#x60;id&#x60; of the IdP Key Credential | |

### Return type

[**IdPKeyCredential**](IdPKeyCredential.md)

### Authorization

[apiToken](../README.md#apiToken), [oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json


### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **200** | Success |  -  |
| **403** | Forbidden |  -  |
| **404** | Not Found |  -  |
| **429** | Too Many Requests |  -  |


## listCsrsForIdentityProvider

> List&lt;IdPCsr&gt; listCsrsForIdentityProvider(idpId)

List all Certificate Signing Requests

Lists all Certificate Signing Requests for an IdP

### Example

```java
// Import classes:
import com.okta.sdk.resource.client.ApiClient;
import com.okta.sdk.resource.client.ApiException;
import com.okta.sdk.resource.client.Configuration;
import com.okta.sdk.resource.client.auth.*;
import com.okta.sdk.resource.client.models.*;
import com.okta.sdk.resource.api.IdentityProviderSigningKeysApi;

public class Example {
    public static void main(String[] args) {
        ApiClient defaultClient = Configuration.getDefaultApiClient();
        defaultClient.setBasePath("https://subdomain.okta.com");
        
        // Configure API key authorization: apiToken
        ApiKeyAuth apiToken = (ApiKeyAuth) defaultClient.getAuthentication("apiToken");
        apiToken.setApiKey("YOUR API KEY");
        // Uncomment the following line to set a prefix for the API key, e.g. "Token" (defaults to null)
        //apiToken.setApiKeyPrefix("Token");

        // Configure OAuth2 access token for authorization: oauth2
        OAuth oauth2 = (OAuth) defaultClient.getAuthentication("oauth2");
        oauth2.setAccessToken("YOUR ACCESS TOKEN");

        IdentityProviderSigningKeysApi apiInstance = new IdentityProviderSigningKeysApi(defaultClient);
        String idpId = "0oa62bfdjnK55Z5x80h7"; // String | `id` of IdP
        try {
            List<IdPCsr> result = apiInstance.listCsrsForIdentityProvider(idpId);
            System.out.println(result);
        } catch (ApiException e) {
            System.err.println("Exception when calling IdentityProviderSigningKeysApi#listCsrsForIdentityProvider");
            System.err.println("Status code: " + e.getCode());
            System.err.println("Reason: " + e.getResponseBody());
            System.err.println("Response headers: " + e.getResponseHeaders());
            e.printStackTrace();
        }
    }
}
```

### Parameters


| Name | Type | Description  | Notes |
|------------- | ------------- | ------------- | -------------|
| **idpId** | **String**| &#x60;id&#x60; of IdP | |

### Return type

[**List&lt;IdPCsr&gt;**](IdPCsr.md)

### Authorization

[apiToken](../README.md#apiToken), [oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json


### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **200** | Success |  -  |
| **403** | Forbidden |  -  |
| **404** | Not Found |  -  |
| **429** | Too Many Requests |  -  |


## listIdentityProviderSigningKeys

> List&lt;IdPKeyCredential&gt; listIdentityProviderSigningKeys(idpId)

List all signing Key Credentials for IdP

Lists all signing Key Credentials for an IdP

### Example

```java
// Import classes:
import com.okta.sdk.resource.client.ApiClient;
import com.okta.sdk.resource.client.ApiException;
import com.okta.sdk.resource.client.Configuration;
import com.okta.sdk.resource.client.auth.*;
import com.okta.sdk.resource.client.models.*;
import com.okta.sdk.resource.api.IdentityProviderSigningKeysApi;

public class Example {
    public static void main(String[] args) {
        ApiClient defaultClient = Configuration.getDefaultApiClient();
        defaultClient.setBasePath("https://subdomain.okta.com");
        
        // Configure API key authorization: apiToken
        ApiKeyAuth apiToken = (ApiKeyAuth) defaultClient.getAuthentication("apiToken");
        apiToken.setApiKey("YOUR API KEY");
        // Uncomment the following line to set a prefix for the API key, e.g. "Token" (defaults to null)
        //apiToken.setApiKeyPrefix("Token");

        // Configure OAuth2 access token for authorization: oauth2
        OAuth oauth2 = (OAuth) defaultClient.getAuthentication("oauth2");
        oauth2.setAccessToken("YOUR ACCESS TOKEN");

        IdentityProviderSigningKeysApi apiInstance = new IdentityProviderSigningKeysApi(defaultClient);
        String idpId = "0oa62bfdjnK55Z5x80h7"; // String | `id` of IdP
        try {
            List<IdPKeyCredential> result = apiInstance.listIdentityProviderSigningKeys(idpId);
            System.out.println(result);
        } catch (ApiException e) {
            System.err.println("Exception when calling IdentityProviderSigningKeysApi#listIdentityProviderSigningKeys");
            System.err.println("Status code: " + e.getCode());
            System.err.println("Reason: " + e.getResponseBody());
            System.err.println("Response headers: " + e.getResponseHeaders());
            e.printStackTrace();
        }
    }
}
```

### Parameters


| Name | Type | Description  | Notes |
|------------- | ------------- | ------------- | -------------|
| **idpId** | **String**| &#x60;id&#x60; of IdP | |

### Return type

[**List&lt;IdPKeyCredential&gt;**](IdPKeyCredential.md)

### Authorization

[apiToken](../README.md#apiToken), [oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json


### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **200** | Success |  -  |
| **403** | Forbidden |  -  |
| **404** | Not Found |  -  |
| **429** | Too Many Requests |  -  |


## publishCsrForIdentityProvider

> IdPKeyCredential publishCsrForIdentityProvider(idpId, idpCsrId, body)

Publish a Certificate Signing Request

Publishes the CSR with a signed X.509 certificate and adds it into the signing Key Credentials for the IdP &gt; **Notes:** &gt; * Publishing a certificate completes the lifecycle of the CSR, and it&#39;s no longer accessible. &gt; * If the validity period of the certificate is less than 90 days, a 400 error response is returned.

### Example

```java
// Import classes:
import com.okta.sdk.resource.client.ApiClient;
import com.okta.sdk.resource.client.ApiException;
import com.okta.sdk.resource.client.Configuration;
import com.okta.sdk.resource.client.auth.*;
import com.okta.sdk.resource.client.models.*;
import com.okta.sdk.resource.api.IdentityProviderSigningKeysApi;

public class Example {
    public static void main(String[] args) {
        ApiClient defaultClient = Configuration.getDefaultApiClient();
        defaultClient.setBasePath("https://subdomain.okta.com");
        
        // Configure API key authorization: apiToken
        ApiKeyAuth apiToken = (ApiKeyAuth) defaultClient.getAuthentication("apiToken");
        apiToken.setApiKey("YOUR API KEY");
        // Uncomment the following line to set a prefix for the API key, e.g. "Token" (defaults to null)
        //apiToken.setApiKeyPrefix("Token");

        // Configure OAuth2 access token for authorization: oauth2
        OAuth oauth2 = (OAuth) defaultClient.getAuthentication("oauth2");
        oauth2.setAccessToken("YOUR ACCESS TOKEN");

        IdentityProviderSigningKeysApi apiInstance = new IdentityProviderSigningKeysApi(defaultClient);
        String idpId = "0oa62bfdjnK55Z5x80h7"; // String | `id` of IdP
        String idpCsrId = "1uEhyE65oV3H6KM9gYcN"; // String | `id` of the IdP CSR
        File body = new File("/path/to/file"); // File | 
        try {
            IdPKeyCredential result = apiInstance.publishCsrForIdentityProvider(idpId, idpCsrId, body);
            System.out.println(result);
        } catch (ApiException e) {
            System.err.println("Exception when calling IdentityProviderSigningKeysApi#publishCsrForIdentityProvider");
            System.err.println("Status code: " + e.getCode());
            System.err.println("Reason: " + e.getResponseBody());
            System.err.println("Response headers: " + e.getResponseHeaders());
            e.printStackTrace();
        }
    }
}
```

### Parameters


| Name | Type | Description  | Notes |
|------------- | ------------- | ------------- | -------------|
| **idpId** | **String**| &#x60;id&#x60; of IdP | |
| **idpCsrId** | **String**| &#x60;id&#x60; of the IdP CSR | |
| **body** | **File**|  | |

### Return type

[**IdPKeyCredential**](IdPKeyCredential.md)

### Authorization

[apiToken](../README.md#apiToken), [oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: application/pkix-cert, application/x-x509-ca-cert, application/x-pem-file
- **Accept**: application/json


### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **201** | Created |  -  |
| **400** | Bad Request |  -  |
| **403** | Forbidden |  -  |
| **404** | Not Found |  -  |
| **429** | Too Many Requests |  -  |


## revokeCsrForIdentityProvider

> revokeCsrForIdentityProvider(idpId, idpCsrId)

Revoke a Certificate Signing Request

Revokes a CSR and deletes the key pair from the IdP

### Example

```java
// Import classes:
import com.okta.sdk.resource.client.ApiClient;
import com.okta.sdk.resource.client.ApiException;
import com.okta.sdk.resource.client.Configuration;
import com.okta.sdk.resource.client.auth.*;
import com.okta.sdk.resource.client.models.*;
import com.okta.sdk.resource.api.IdentityProviderSigningKeysApi;

public class Example {
    public static void main(String[] args) {
        ApiClient defaultClient = Configuration.getDefaultApiClient();
        defaultClient.setBasePath("https://subdomain.okta.com");
        
        // Configure API key authorization: apiToken
        ApiKeyAuth apiToken = (ApiKeyAuth) defaultClient.getAuthentication("apiToken");
        apiToken.setApiKey("YOUR API KEY");
        // Uncomment the following line to set a prefix for the API key, e.g. "Token" (defaults to null)
        //apiToken.setApiKeyPrefix("Token");

        // Configure OAuth2 access token for authorization: oauth2
        OAuth oauth2 = (OAuth) defaultClient.getAuthentication("oauth2");
        oauth2.setAccessToken("YOUR ACCESS TOKEN");

        IdentityProviderSigningKeysApi apiInstance = new IdentityProviderSigningKeysApi(defaultClient);
        String idpId = "0oa62bfdjnK55Z5x80h7"; // String | `id` of IdP
        String idpCsrId = "1uEhyE65oV3H6KM9gYcN"; // String | `id` of the IdP CSR
        try {
            apiInstance.revokeCsrForIdentityProvider(idpId, idpCsrId);
        } catch (ApiException e) {
            System.err.println("Exception when calling IdentityProviderSigningKeysApi#revokeCsrForIdentityProvider");
            System.err.println("Status code: " + e.getCode());
            System.err.println("Reason: " + e.getResponseBody());
            System.err.println("Response headers: " + e.getResponseHeaders());
            e.printStackTrace();
        }
    }
}
```

### Parameters


| Name | Type | Description  | Notes |
|------------- | ------------- | ------------- | -------------|
| **idpId** | **String**| &#x60;id&#x60; of IdP | |
| **idpCsrId** | **String**| &#x60;id&#x60; of the IdP CSR | |

### Return type

null (empty response body)

### Authorization

[apiToken](../README.md#apiToken), [oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json


### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **204** | No Content |  -  |
| **403** | Forbidden |  -  |
| **404** | Not Found |  -  |
| **429** | Too Many Requests |  -  |

