# NetworkZoneApi

All URIs are relative to *https://subdomain.okta.com*

| Method | HTTP request | Description |
|------------- | ------------- | -------------|
| [**activateNetworkZone**](NetworkZoneApi.md#activateNetworkZone) | **POST** /api/v1/zones/{zoneId}/lifecycle/activate | Activate a Network Zone |
| [**createNetworkZone**](NetworkZoneApi.md#createNetworkZone) | **POST** /api/v1/zones | Create a Network Zone |
| [**deactivateNetworkZone**](NetworkZoneApi.md#deactivateNetworkZone) | **POST** /api/v1/zones/{zoneId}/lifecycle/deactivate | Deactivate a Network Zone |
| [**deleteNetworkZone**](NetworkZoneApi.md#deleteNetworkZone) | **DELETE** /api/v1/zones/{zoneId} | Delete a Network Zone |
| [**getNetworkZone**](NetworkZoneApi.md#getNetworkZone) | **GET** /api/v1/zones/{zoneId} | Retrieve a Network Zone |
| [**listNetworkZones**](NetworkZoneApi.md#listNetworkZones) | **GET** /api/v1/zones | List all Network Zones |
| [**replaceNetworkZone**](NetworkZoneApi.md#replaceNetworkZone) | **PUT** /api/v1/zones/{zoneId} | Replace a Network Zone |



## activateNetworkZone

> NetworkZone activateNetworkZone(zoneId)

Activate a Network Zone

Activates a Network Zone by &#x60;zoneId&#x60;

### Example

```java
// Import classes:
import com.okta.sdk.resource.client.ApiClient;
import com.okta.sdk.resource.client.ApiException;
import com.okta.sdk.resource.client.Configuration;
import com.okta.sdk.resource.client.auth.*;
import com.okta.sdk.resource.client.models.*;
import com.okta.sdk.resource.api.NetworkZoneApi;

public class Example {
    public static void main(String[] args) {
        ApiClient defaultClient = Configuration.getDefaultApiClient();
        defaultClient.setBasePath("https://subdomain.okta.com");
        
        // Configure API key authorization: apiToken
        ApiKeyAuth apiToken = (ApiKeyAuth) defaultClient.getAuthentication("apiToken");
        apiToken.setApiKey("YOUR API KEY");
        // Uncomment the following line to set a prefix for the API key, e.g. "Token" (defaults to null)
        //apiToken.setApiKeyPrefix("Token");

        // Configure OAuth2 access token for authorization: oauth2
        OAuth oauth2 = (OAuth) defaultClient.getAuthentication("oauth2");
        oauth2.setAccessToken("YOUR ACCESS TOKEN");

        NetworkZoneApi apiInstance = new NetworkZoneApi(defaultClient);
        String zoneId = "nzowc1U5Jh5xuAK0o0g3"; // String | `id` of the Network Zone
        try {
            NetworkZone result = apiInstance.activateNetworkZone(zoneId);
            System.out.println(result);
        } catch (ApiException e) {
            System.err.println("Exception when calling NetworkZoneApi#activateNetworkZone");
            System.err.println("Status code: " + e.getCode());
            System.err.println("Reason: " + e.getResponseBody());
            System.err.println("Response headers: " + e.getResponseHeaders());
            e.printStackTrace();
        }
    }
}
```

### Parameters


| Name | Type | Description  | Notes |
|------------- | ------------- | ------------- | -------------|
| **zoneId** | **String**| &#x60;id&#x60; of the Network Zone | |

### Return type

[**NetworkZone**](NetworkZone.md)

### Authorization

[apiToken](../README.md#apiToken), [oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json


### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **200** | Success |  -  |
| **403** | Forbidden |  -  |
| **404** | Not Found |  -  |
| **429** | Too Many Requests |  -  |


## createNetworkZone

> NetworkZone createNetworkZone(zone)

Create a Network Zone

Creates a Network Zone * For an IP Network Zone, you must define either &#x60;gateways&#x60; or &#x60;proxies&#x60;. * For a Dynamic Network Zone, you must define at least one of the following: &#x60;asns&#x60;, &#x60;locations&#x60;, or &#x60;proxyType&#x60;. * For an Enhanced Dynamic Network Zone, you must define at least one of the following: &#x60;asns&#x60;, &#x60;locations&#x60;, or &#x60;ipServiceCategories&#x60;.

### Example

```java
// Import classes:
import com.okta.sdk.resource.client.ApiClient;
import com.okta.sdk.resource.client.ApiException;
import com.okta.sdk.resource.client.Configuration;
import com.okta.sdk.resource.client.auth.*;
import com.okta.sdk.resource.client.models.*;
import com.okta.sdk.resource.api.NetworkZoneApi;

public class Example {
    public static void main(String[] args) {
        ApiClient defaultClient = Configuration.getDefaultApiClient();
        defaultClient.setBasePath("https://subdomain.okta.com");
        
        // Configure API key authorization: apiToken
        ApiKeyAuth apiToken = (ApiKeyAuth) defaultClient.getAuthentication("apiToken");
        apiToken.setApiKey("YOUR API KEY");
        // Uncomment the following line to set a prefix for the API key, e.g. "Token" (defaults to null)
        //apiToken.setApiKeyPrefix("Token");

        // Configure OAuth2 access token for authorization: oauth2
        OAuth oauth2 = (OAuth) defaultClient.getAuthentication("oauth2");
        oauth2.setAccessToken("YOUR ACCESS TOKEN");

        NetworkZoneApi apiInstance = new NetworkZoneApi(defaultClient);
        NetworkZone zone = new NetworkZone(); // NetworkZone | 
        try {
            NetworkZone result = apiInstance.createNetworkZone(zone);
            System.out.println(result);
        } catch (ApiException e) {
            System.err.println("Exception when calling NetworkZoneApi#createNetworkZone");
            System.err.println("Status code: " + e.getCode());
            System.err.println("Reason: " + e.getResponseBody());
            System.err.println("Response headers: " + e.getResponseHeaders());
            e.printStackTrace();
        }
    }
}
```

### Parameters


| Name | Type | Description  | Notes |
|------------- | ------------- | ------------- | -------------|
| **zone** | [**NetworkZone**](NetworkZone.md)|  | |

### Return type

[**NetworkZone**](NetworkZone.md)

### Authorization

[apiToken](../README.md#apiToken), [oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: application/json
- **Accept**: application/json


### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **200** | Success |  -  |
| **400** | Bad Request |  -  |
| **403** | Forbidden |  -  |
| **429** | Too Many Requests |  -  |


## deactivateNetworkZone

> NetworkZone deactivateNetworkZone(zoneId)

Deactivate a Network Zone

Deactivates a Network Zone by &#x60;zoneId&#x60;

### Example

```java
// Import classes:
import com.okta.sdk.resource.client.ApiClient;
import com.okta.sdk.resource.client.ApiException;
import com.okta.sdk.resource.client.Configuration;
import com.okta.sdk.resource.client.auth.*;
import com.okta.sdk.resource.client.models.*;
import com.okta.sdk.resource.api.NetworkZoneApi;

public class Example {
    public static void main(String[] args) {
        ApiClient defaultClient = Configuration.getDefaultApiClient();
        defaultClient.setBasePath("https://subdomain.okta.com");
        
        // Configure API key authorization: apiToken
        ApiKeyAuth apiToken = (ApiKeyAuth) defaultClient.getAuthentication("apiToken");
        apiToken.setApiKey("YOUR API KEY");
        // Uncomment the following line to set a prefix for the API key, e.g. "Token" (defaults to null)
        //apiToken.setApiKeyPrefix("Token");

        // Configure OAuth2 access token for authorization: oauth2
        OAuth oauth2 = (OAuth) defaultClient.getAuthentication("oauth2");
        oauth2.setAccessToken("YOUR ACCESS TOKEN");

        NetworkZoneApi apiInstance = new NetworkZoneApi(defaultClient);
        String zoneId = "nzowc1U5Jh5xuAK0o0g3"; // String | `id` of the Network Zone
        try {
            NetworkZone result = apiInstance.deactivateNetworkZone(zoneId);
            System.out.println(result);
        } catch (ApiException e) {
            System.err.println("Exception when calling NetworkZoneApi#deactivateNetworkZone");
            System.err.println("Status code: " + e.getCode());
            System.err.println("Reason: " + e.getResponseBody());
            System.err.println("Response headers: " + e.getResponseHeaders());
            e.printStackTrace();
        }
    }
}
```

### Parameters


| Name | Type | Description  | Notes |
|------------- | ------------- | ------------- | -------------|
| **zoneId** | **String**| &#x60;id&#x60; of the Network Zone | |

### Return type

[**NetworkZone**](NetworkZone.md)

### Authorization

[apiToken](../README.md#apiToken), [oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json


### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **200** | Success |  -  |
| **403** | Forbidden |  -  |
| **404** | Not Found |  -  |
| **429** | Too Many Requests |  -  |


## deleteNetworkZone

> deleteNetworkZone(zoneId)

Delete a Network Zone

Deletes a Network Zone by &#x60;zoneId&#x60; &gt; **Notes:** &gt; * You can&#39;t delete a Network Zone that&#39;s used by a [Policy](https://developer.okta.com/docs/api/openapi/okta-management/management/tag/Policy/) or [Rule](https://developer.okta.com/docs/api/openapi/okta-management/management/tag/Policy/#tag/Policy/operation/listPolicyRules). &gt; * For Okta Identity Engine orgs, you can&#39;t delete a Network Zone with an ACTIVE &#x60;status&#x60;. &lt;x-lifecycle class&#x3D;\&quot;oie\&quot;&gt;&lt;/x-lifecycle&gt;

### Example

```java
// Import classes:
import com.okta.sdk.resource.client.ApiClient;
import com.okta.sdk.resource.client.ApiException;
import com.okta.sdk.resource.client.Configuration;
import com.okta.sdk.resource.client.auth.*;
import com.okta.sdk.resource.client.models.*;
import com.okta.sdk.resource.api.NetworkZoneApi;

public class Example {
    public static void main(String[] args) {
        ApiClient defaultClient = Configuration.getDefaultApiClient();
        defaultClient.setBasePath("https://subdomain.okta.com");
        
        // Configure API key authorization: apiToken
        ApiKeyAuth apiToken = (ApiKeyAuth) defaultClient.getAuthentication("apiToken");
        apiToken.setApiKey("YOUR API KEY");
        // Uncomment the following line to set a prefix for the API key, e.g. "Token" (defaults to null)
        //apiToken.setApiKeyPrefix("Token");

        // Configure OAuth2 access token for authorization: oauth2
        OAuth oauth2 = (OAuth) defaultClient.getAuthentication("oauth2");
        oauth2.setAccessToken("YOUR ACCESS TOKEN");

        NetworkZoneApi apiInstance = new NetworkZoneApi(defaultClient);
        String zoneId = "nzowc1U5Jh5xuAK0o0g3"; // String | `id` of the Network Zone
        try {
            apiInstance.deleteNetworkZone(zoneId);
        } catch (ApiException e) {
            System.err.println("Exception when calling NetworkZoneApi#deleteNetworkZone");
            System.err.println("Status code: " + e.getCode());
            System.err.println("Reason: " + e.getResponseBody());
            System.err.println("Response headers: " + e.getResponseHeaders());
            e.printStackTrace();
        }
    }
}
```

### Parameters


| Name | Type | Description  | Notes |
|------------- | ------------- | ------------- | -------------|
| **zoneId** | **String**| &#x60;id&#x60; of the Network Zone | |

### Return type

null (empty response body)

### Authorization

[apiToken](../README.md#apiToken), [oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json


### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **204** | No Content |  -  |
| **403** | Forbidden |  -  |
| **404** | Not Found |  -  |
| **429** | Too Many Requests |  -  |


## getNetworkZone

> NetworkZone getNetworkZone(zoneId)

Retrieve a Network Zone

Retrieves a Network Zone by &#x60;zoneId&#x60;

### Example

```java
// Import classes:
import com.okta.sdk.resource.client.ApiClient;
import com.okta.sdk.resource.client.ApiException;
import com.okta.sdk.resource.client.Configuration;
import com.okta.sdk.resource.client.auth.*;
import com.okta.sdk.resource.client.models.*;
import com.okta.sdk.resource.api.NetworkZoneApi;

public class Example {
    public static void main(String[] args) {
        ApiClient defaultClient = Configuration.getDefaultApiClient();
        defaultClient.setBasePath("https://subdomain.okta.com");
        
        // Configure API key authorization: apiToken
        ApiKeyAuth apiToken = (ApiKeyAuth) defaultClient.getAuthentication("apiToken");
        apiToken.setApiKey("YOUR API KEY");
        // Uncomment the following line to set a prefix for the API key, e.g. "Token" (defaults to null)
        //apiToken.setApiKeyPrefix("Token");

        // Configure OAuth2 access token for authorization: oauth2
        OAuth oauth2 = (OAuth) defaultClient.getAuthentication("oauth2");
        oauth2.setAccessToken("YOUR ACCESS TOKEN");

        NetworkZoneApi apiInstance = new NetworkZoneApi(defaultClient);
        String zoneId = "nzowc1U5Jh5xuAK0o0g3"; // String | `id` of the Network Zone
        try {
            NetworkZone result = apiInstance.getNetworkZone(zoneId);
            System.out.println(result);
        } catch (ApiException e) {
            System.err.println("Exception when calling NetworkZoneApi#getNetworkZone");
            System.err.println("Status code: " + e.getCode());
            System.err.println("Reason: " + e.getResponseBody());
            System.err.println("Response headers: " + e.getResponseHeaders());
            e.printStackTrace();
        }
    }
}
```

### Parameters


| Name | Type | Description  | Notes |
|------------- | ------------- | ------------- | -------------|
| **zoneId** | **String**| &#x60;id&#x60; of the Network Zone | |

### Return type

[**NetworkZone**](NetworkZone.md)

### Authorization

[apiToken](../README.md#apiToken), [oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json


### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **200** | Success |  -  |
| **403** | Forbidden |  -  |
| **404** | Not Found |  -  |
| **429** | Too Many Requests |  -  |


## listNetworkZones

> List&lt;NetworkZone&gt; listNetworkZones(after, limit, filter)

List all Network Zones

Lists all Network Zones with pagination. A subset of zones can be returned that match a supported filter expression or query.  This operation requires URL encoding. For example, &#x60;filter&#x3D;(id eq \&quot;nzoul0wf9jyb8xwZm0g3\&quot; or id eq \&quot;nzoul1MxmGN18NDQT0g3\&quot;)&#x60; is encoded as &#x60;filter&#x3D;%28id+eq+%22nzoul0wf9jyb8xwZm0g3%22+or+id+eq+%22nzoul1MxmGN18NDQT0g3%22%29&#x60;.  Okta supports filtering on the &#x60;id&#x60; and &#x60;usage&#x60; properties. See [Filtering](https://developer.okta.com/docs/reference/core-okta-api/#filter) for more information on the expressions that are used in filtering.

### Example

```java
// Import classes:
import com.okta.sdk.resource.client.ApiClient;
import com.okta.sdk.resource.client.ApiException;
import com.okta.sdk.resource.client.Configuration;
import com.okta.sdk.resource.client.auth.*;
import com.okta.sdk.resource.client.models.*;
import com.okta.sdk.resource.api.NetworkZoneApi;

public class Example {
    public static void main(String[] args) {
        ApiClient defaultClient = Configuration.getDefaultApiClient();
        defaultClient.setBasePath("https://subdomain.okta.com");
        
        // Configure API key authorization: apiToken
        ApiKeyAuth apiToken = (ApiKeyAuth) defaultClient.getAuthentication("apiToken");
        apiToken.setApiKey("YOUR API KEY");
        // Uncomment the following line to set a prefix for the API key, e.g. "Token" (defaults to null)
        //apiToken.setApiKeyPrefix("Token");

        // Configure OAuth2 access token for authorization: oauth2
        OAuth oauth2 = (OAuth) defaultClient.getAuthentication("oauth2");
        oauth2.setAccessToken("YOUR ACCESS TOKEN");

        NetworkZoneApi apiInstance = new NetworkZoneApi(defaultClient);
        String after = "BlockedIpZones"; // String | 
        Integer limit = -1; // Integer | 
        String filter = "id eq \"nzowc1U5Jh5xuAK0o0g3\""; // String | 
        try {
            List<NetworkZone> result = apiInstance.listNetworkZones(after, limit, filter);
            System.out.println(result);
        } catch (ApiException e) {
            System.err.println("Exception when calling NetworkZoneApi#listNetworkZones");
            System.err.println("Status code: " + e.getCode());
            System.err.println("Reason: " + e.getResponseBody());
            System.err.println("Response headers: " + e.getResponseHeaders());
            e.printStackTrace();
        }
    }
}
```

### Parameters


| Name | Type | Description  | Notes |
|------------- | ------------- | ------------- | -------------|
| **after** | **String**|  | [optional] |
| **limit** | **Integer**|  | [optional] [default to -1] |
| **filter** | **String**|  | [optional] |

### Return type

[**List&lt;NetworkZone&gt;**](NetworkZone.md)

### Authorization

[apiToken](../README.md#apiToken), [oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json


### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **200** | Success |  -  |
| **403** | Forbidden |  -  |
| **429** | Too Many Requests |  -  |


## replaceNetworkZone

> NetworkZone replaceNetworkZone(zoneId, zone)

Replace a Network Zone

Replaces a Network Zone by &#x60;zoneId&#x60;. The replaced Network Zone type must be the same as the existing type. You can replace the usage (&#x60;POLICY&#x60;, &#x60;BLOCKLIST&#x60;) of a Network Zone by updating the &#x60;usage&#x60; attribute.

### Example

```java
// Import classes:
import com.okta.sdk.resource.client.ApiClient;
import com.okta.sdk.resource.client.ApiException;
import com.okta.sdk.resource.client.Configuration;
import com.okta.sdk.resource.client.auth.*;
import com.okta.sdk.resource.client.models.*;
import com.okta.sdk.resource.api.NetworkZoneApi;

public class Example {
    public static void main(String[] args) {
        ApiClient defaultClient = Configuration.getDefaultApiClient();
        defaultClient.setBasePath("https://subdomain.okta.com");
        
        // Configure API key authorization: apiToken
        ApiKeyAuth apiToken = (ApiKeyAuth) defaultClient.getAuthentication("apiToken");
        apiToken.setApiKey("YOUR API KEY");
        // Uncomment the following line to set a prefix for the API key, e.g. "Token" (defaults to null)
        //apiToken.setApiKeyPrefix("Token");

        // Configure OAuth2 access token for authorization: oauth2
        OAuth oauth2 = (OAuth) defaultClient.getAuthentication("oauth2");
        oauth2.setAccessToken("YOUR ACCESS TOKEN");

        NetworkZoneApi apiInstance = new NetworkZoneApi(defaultClient);
        String zoneId = "nzowc1U5Jh5xuAK0o0g3"; // String | `id` of the Network Zone
        NetworkZone zone = new NetworkZone(); // NetworkZone | 
        try {
            NetworkZone result = apiInstance.replaceNetworkZone(zoneId, zone);
            System.out.println(result);
        } catch (ApiException e) {
            System.err.println("Exception when calling NetworkZoneApi#replaceNetworkZone");
            System.err.println("Status code: " + e.getCode());
            System.err.println("Reason: " + e.getResponseBody());
            System.err.println("Response headers: " + e.getResponseHeaders());
            e.printStackTrace();
        }
    }
}
```

### Parameters


| Name | Type | Description  | Notes |
|------------- | ------------- | ------------- | -------------|
| **zoneId** | **String**| &#x60;id&#x60; of the Network Zone | |
| **zone** | [**NetworkZone**](NetworkZone.md)|  | |

### Return type

[**NetworkZone**](NetworkZone.md)

### Authorization

[apiToken](../README.md#apiToken), [oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: application/json
- **Accept**: application/json


### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **200** | Success |  -  |
| **400** | Bad Request |  -  |
| **403** | Forbidden |  -  |
| **404** | Not Found |  -  |
| **429** | Too Many Requests |  -  |

