

# OAuth2ScopeConsentGrant

Grant object that represents an app consent scope grant

## Properties

| Name | Type | Description | Notes |
|------------ | ------------- | ------------- | -------------|
|**clientId** | **String** | Client ID of the app integration |  [optional] [readonly] |
|**created** | **OffsetDateTime** | Timestamp when the object was created |  [optional] [readonly] |
|**createdBy** | [**OAuth2Actor**](OAuth2Actor.md) |  |  [optional] |
|**id** | **String** | ID of the Grant object |  [optional] [readonly] |
|**issuer** | **String** | The issuer of your org authorization server. This is typically your Okta domain. |  |
|**lastUpdated** | **OffsetDateTime** | Timestamp when the object was last updated |  [optional] [readonly] |
|**scopeId** | **String** | The name of the [Okta scope](https://developer.okta.com/docs/api/oauth2/#oauth-20-scopes) for which consent is granted |  |
|**source** | **OAuth2ScopeConsentGrantSource** |  |  [optional] |
|**status** | **GrantOrTokenStatus** |  |  [optional] |
|**userId** | **String** | User ID that granted consent (if &#x60;source&#x60; is &#x60;END_USER&#x60;) |  [optional] [readonly] |
|**embedded** | [**OAuth2ScopeConsentGrantEmbedded**](OAuth2ScopeConsentGrantEmbedded.md) |  |  [optional] |
|**links** | [**OAuth2ScopeConsentGrantLinks**](OAuth2ScopeConsentGrantLinks.md) |  |  [optional] |


## Implemented Interfaces

* Serializable


