# PrincipalRateLimitApi

All URIs are relative to *https://subdomain.okta.com*

| Method | HTTP request | Description |
|------------- | ------------- | -------------|
| [**createPrincipalRateLimitEntity**](PrincipalRateLimitApi.md#createPrincipalRateLimitEntity) | **POST** /api/v1/principal-rate-limits | Create a Principal Rate Limit |
| [**getPrincipalRateLimitEntity**](PrincipalRateLimitApi.md#getPrincipalRateLimitEntity) | **GET** /api/v1/principal-rate-limits/{principalRateLimitId} | Retrieve a Principal Rate Limit |
| [**listPrincipalRateLimitEntities**](PrincipalRateLimitApi.md#listPrincipalRateLimitEntities) | **GET** /api/v1/principal-rate-limits | List all Principal Rate Limits |
| [**replacePrincipalRateLimitEntity**](PrincipalRateLimitApi.md#replacePrincipalRateLimitEntity) | **PUT** /api/v1/principal-rate-limits/{principalRateLimitId} | Replace a Principal Rate Limit |



## createPrincipalRateLimitEntity

> PrincipalRateLimitEntity createPrincipalRateLimitEntity(entity)

Create a Principal Rate Limit

Creates a new Principal Rate Limit entity. In the current release, we only allow one Principal Rate Limit entity per org and principal.

### Example

```java
// Import classes:
import com.okta.sdk.resource.client.ApiClient;
import com.okta.sdk.resource.client.ApiException;
import com.okta.sdk.resource.client.Configuration;
import com.okta.sdk.resource.client.auth.*;
import com.okta.sdk.resource.client.models.*;
import com.okta.sdk.resource.api.PrincipalRateLimitApi;

public class Example {
    public static void main(String[] args) {
        ApiClient defaultClient = Configuration.getDefaultApiClient();
        defaultClient.setBasePath("https://subdomain.okta.com");
        
        // Configure API key authorization: apiToken
        ApiKeyAuth apiToken = (ApiKeyAuth) defaultClient.getAuthentication("apiToken");
        apiToken.setApiKey("YOUR API KEY");
        // Uncomment the following line to set a prefix for the API key, e.g. "Token" (defaults to null)
        //apiToken.setApiKeyPrefix("Token");

        // Configure OAuth2 access token for authorization: oauth2
        OAuth oauth2 = (OAuth) defaultClient.getAuthentication("oauth2");
        oauth2.setAccessToken("YOUR ACCESS TOKEN");

        PrincipalRateLimitApi apiInstance = new PrincipalRateLimitApi(defaultClient);
        PrincipalRateLimitEntity entity = new PrincipalRateLimitEntity(); // PrincipalRateLimitEntity | 
        try {
            PrincipalRateLimitEntity result = apiInstance.createPrincipalRateLimitEntity(entity);
            System.out.println(result);
        } catch (ApiException e) {
            System.err.println("Exception when calling PrincipalRateLimitApi#createPrincipalRateLimitEntity");
            System.err.println("Status code: " + e.getCode());
            System.err.println("Reason: " + e.getResponseBody());
            System.err.println("Response headers: " + e.getResponseHeaders());
            e.printStackTrace();
        }
    }
}
```

### Parameters


| Name | Type | Description  | Notes |
|------------- | ------------- | ------------- | -------------|
| **entity** | [**PrincipalRateLimitEntity**](PrincipalRateLimitEntity.md)|  | |

### Return type

[**PrincipalRateLimitEntity**](PrincipalRateLimitEntity.md)

### Authorization

[apiToken](../README.md#apiToken), [oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: application/json
- **Accept**: application/json


### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **201** | Created |  -  |
| **400** | Bad Request |  -  |
| **403** | Forbidden |  -  |
| **404** | Not Found |  -  |
| **429** | Too Many Requests |  -  |


## getPrincipalRateLimitEntity

> PrincipalRateLimitEntity getPrincipalRateLimitEntity(principalRateLimitId)

Retrieve a Principal Rate Limit

Retrieves a Principal Rate Limit entity by &#x60;principalRateLimitId&#x60;

### Example

```java
// Import classes:
import com.okta.sdk.resource.client.ApiClient;
import com.okta.sdk.resource.client.ApiException;
import com.okta.sdk.resource.client.Configuration;
import com.okta.sdk.resource.client.auth.*;
import com.okta.sdk.resource.client.models.*;
import com.okta.sdk.resource.api.PrincipalRateLimitApi;

public class Example {
    public static void main(String[] args) {
        ApiClient defaultClient = Configuration.getDefaultApiClient();
        defaultClient.setBasePath("https://subdomain.okta.com");
        
        // Configure API key authorization: apiToken
        ApiKeyAuth apiToken = (ApiKeyAuth) defaultClient.getAuthentication("apiToken");
        apiToken.setApiKey("YOUR API KEY");
        // Uncomment the following line to set a prefix for the API key, e.g. "Token" (defaults to null)
        //apiToken.setApiKeyPrefix("Token");

        // Configure OAuth2 access token for authorization: oauth2
        OAuth oauth2 = (OAuth) defaultClient.getAuthentication("oauth2");
        oauth2.setAccessToken("YOUR ACCESS TOKEN");

        PrincipalRateLimitApi apiInstance = new PrincipalRateLimitApi(defaultClient);
        String principalRateLimitId = "abcd1234"; // String | id of the Principal Rate Limit
        try {
            PrincipalRateLimitEntity result = apiInstance.getPrincipalRateLimitEntity(principalRateLimitId);
            System.out.println(result);
        } catch (ApiException e) {
            System.err.println("Exception when calling PrincipalRateLimitApi#getPrincipalRateLimitEntity");
            System.err.println("Status code: " + e.getCode());
            System.err.println("Reason: " + e.getResponseBody());
            System.err.println("Response headers: " + e.getResponseHeaders());
            e.printStackTrace();
        }
    }
}
```

### Parameters


| Name | Type | Description  | Notes |
|------------- | ------------- | ------------- | -------------|
| **principalRateLimitId** | **String**| id of the Principal Rate Limit | |

### Return type

[**PrincipalRateLimitEntity**](PrincipalRateLimitEntity.md)

### Authorization

[apiToken](../README.md#apiToken), [oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json


### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **200** | OK |  -  |
| **403** | Forbidden |  -  |
| **404** | Not Found |  -  |
| **429** | Too Many Requests |  -  |


## listPrincipalRateLimitEntities

> List&lt;PrincipalRateLimitEntity&gt; listPrincipalRateLimitEntities(filter, after, limit)

List all Principal Rate Limits

Lists all Principal Rate Limit entities considering the provided parameters

### Example

```java
// Import classes:
import com.okta.sdk.resource.client.ApiClient;
import com.okta.sdk.resource.client.ApiException;
import com.okta.sdk.resource.client.Configuration;
import com.okta.sdk.resource.client.auth.*;
import com.okta.sdk.resource.client.models.*;
import com.okta.sdk.resource.api.PrincipalRateLimitApi;

public class Example {
    public static void main(String[] args) {
        ApiClient defaultClient = Configuration.getDefaultApiClient();
        defaultClient.setBasePath("https://subdomain.okta.com");
        
        // Configure API key authorization: apiToken
        ApiKeyAuth apiToken = (ApiKeyAuth) defaultClient.getAuthentication("apiToken");
        apiToken.setApiKey("YOUR API KEY");
        // Uncomment the following line to set a prefix for the API key, e.g. "Token" (defaults to null)
        //apiToken.setApiKeyPrefix("Token");

        // Configure OAuth2 access token for authorization: oauth2
        OAuth oauth2 = (OAuth) defaultClient.getAuthentication("oauth2");
        oauth2.setAccessToken("YOUR ACCESS TOKEN");

        PrincipalRateLimitApi apiInstance = new PrincipalRateLimitApi(defaultClient);
        String filter = "filter_example"; // String | 
        String after = "after_example"; // String | 
        Integer limit = 20; // Integer | 
        try {
            List<PrincipalRateLimitEntity> result = apiInstance.listPrincipalRateLimitEntities(filter, after, limit);
            System.out.println(result);
        } catch (ApiException e) {
            System.err.println("Exception when calling PrincipalRateLimitApi#listPrincipalRateLimitEntities");
            System.err.println("Status code: " + e.getCode());
            System.err.println("Reason: " + e.getResponseBody());
            System.err.println("Response headers: " + e.getResponseHeaders());
            e.printStackTrace();
        }
    }
}
```

### Parameters


| Name | Type | Description  | Notes |
|------------- | ------------- | ------------- | -------------|
| **filter** | **String**|  | [optional] |
| **after** | **String**|  | [optional] |
| **limit** | **Integer**|  | [optional] [default to 20] |

### Return type

[**List&lt;PrincipalRateLimitEntity&gt;**](PrincipalRateLimitEntity.md)

### Authorization

[apiToken](../README.md#apiToken), [oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json


### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **200** | OK |  -  |
| **400** | Bad Request |  -  |
| **403** | Forbidden |  -  |
| **429** | Too Many Requests |  -  |


## replacePrincipalRateLimitEntity

> PrincipalRateLimitEntity replacePrincipalRateLimitEntity(principalRateLimitId, entity)

Replace a Principal Rate Limit

Replaces a principal rate limit entity by &#x60;principalRateLimitId&#x60;

### Example

```java
// Import classes:
import com.okta.sdk.resource.client.ApiClient;
import com.okta.sdk.resource.client.ApiException;
import com.okta.sdk.resource.client.Configuration;
import com.okta.sdk.resource.client.auth.*;
import com.okta.sdk.resource.client.models.*;
import com.okta.sdk.resource.api.PrincipalRateLimitApi;

public class Example {
    public static void main(String[] args) {
        ApiClient defaultClient = Configuration.getDefaultApiClient();
        defaultClient.setBasePath("https://subdomain.okta.com");
        
        // Configure API key authorization: apiToken
        ApiKeyAuth apiToken = (ApiKeyAuth) defaultClient.getAuthentication("apiToken");
        apiToken.setApiKey("YOUR API KEY");
        // Uncomment the following line to set a prefix for the API key, e.g. "Token" (defaults to null)
        //apiToken.setApiKeyPrefix("Token");

        // Configure OAuth2 access token for authorization: oauth2
        OAuth oauth2 = (OAuth) defaultClient.getAuthentication("oauth2");
        oauth2.setAccessToken("YOUR ACCESS TOKEN");

        PrincipalRateLimitApi apiInstance = new PrincipalRateLimitApi(defaultClient);
        String principalRateLimitId = "abcd1234"; // String | id of the Principal Rate Limit
        PrincipalRateLimitEntity entity = new PrincipalRateLimitEntity(); // PrincipalRateLimitEntity | 
        try {
            PrincipalRateLimitEntity result = apiInstance.replacePrincipalRateLimitEntity(principalRateLimitId, entity);
            System.out.println(result);
        } catch (ApiException e) {
            System.err.println("Exception when calling PrincipalRateLimitApi#replacePrincipalRateLimitEntity");
            System.err.println("Status code: " + e.getCode());
            System.err.println("Reason: " + e.getResponseBody());
            System.err.println("Response headers: " + e.getResponseHeaders());
            e.printStackTrace();
        }
    }
}
```

### Parameters


| Name | Type | Description  | Notes |
|------------- | ------------- | ------------- | -------------|
| **principalRateLimitId** | **String**| id of the Principal Rate Limit | |
| **entity** | [**PrincipalRateLimitEntity**](PrincipalRateLimitEntity.md)|  | |

### Return type

[**PrincipalRateLimitEntity**](PrincipalRateLimitEntity.md)

### Authorization

[apiToken](../README.md#apiToken), [oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: application/json
- **Accept**: application/json


### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **200** | OK |  -  |
| **400** | Bad Request |  -  |
| **403** | Forbidden |  -  |
| **404** | Not Found |  -  |
| **429** | Too Many Requests |  -  |

