# ProfileMappingApi

All URIs are relative to *https://subdomain.okta.com*

| Method | HTTP request | Description |
|------------- | ------------- | -------------|
| [**getProfileMapping**](ProfileMappingApi.md#getProfileMapping) | **GET** /api/v1/mappings/{mappingId} | Retrieve a Profile Mapping |
| [**listProfileMappings**](ProfileMappingApi.md#listProfileMappings) | **GET** /api/v1/mappings | List all Profile Mappings |
| [**updateProfileMapping**](ProfileMappingApi.md#updateProfileMapping) | **POST** /api/v1/mappings/{mappingId} | Update a Profile Mapping |



## getProfileMapping

> ProfileMapping getProfileMapping(mappingId)

Retrieve a Profile Mapping

Retrieves a single Profile Mapping referenced by its ID

### Example

```java
// Import classes:
import com.okta.sdk.resource.client.ApiClient;
import com.okta.sdk.resource.client.ApiException;
import com.okta.sdk.resource.client.Configuration;
import com.okta.sdk.resource.client.auth.*;
import com.okta.sdk.resource.client.models.*;
import com.okta.sdk.resource.api.ProfileMappingApi;

public class Example {
    public static void main(String[] args) {
        ApiClient defaultClient = Configuration.getDefaultApiClient();
        defaultClient.setBasePath("https://subdomain.okta.com");
        
        // Configure API key authorization: apiToken
        ApiKeyAuth apiToken = (ApiKeyAuth) defaultClient.getAuthentication("apiToken");
        apiToken.setApiKey("YOUR API KEY");
        // Uncomment the following line to set a prefix for the API key, e.g. "Token" (defaults to null)
        //apiToken.setApiKeyPrefix("Token");

        // Configure OAuth2 access token for authorization: oauth2
        OAuth oauth2 = (OAuth) defaultClient.getAuthentication("oauth2");
        oauth2.setAccessToken("YOUR ACCESS TOKEN");

        ProfileMappingApi apiInstance = new ProfileMappingApi(defaultClient);
        String mappingId = "cB6u7X8mptebWkffatKA"; // String | `id` of the Mapping
        try {
            ProfileMapping result = apiInstance.getProfileMapping(mappingId);
            System.out.println(result);
        } catch (ApiException e) {
            System.err.println("Exception when calling ProfileMappingApi#getProfileMapping");
            System.err.println("Status code: " + e.getCode());
            System.err.println("Reason: " + e.getResponseBody());
            System.err.println("Response headers: " + e.getResponseHeaders());
            e.printStackTrace();
        }
    }
}
```

### Parameters


| Name | Type | Description  | Notes |
|------------- | ------------- | ------------- | -------------|
| **mappingId** | **String**| &#x60;id&#x60; of the Mapping | |

### Return type

[**ProfileMapping**](ProfileMapping.md)

### Authorization

[apiToken](../README.md#apiToken), [oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json


### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **200** | Success |  -  |
| **403** | Forbidden |  -  |
| **404** | Not Found |  -  |
| **429** | Too Many Requests |  -  |


## listProfileMappings

> List&lt;ListProfileMappings&gt; listProfileMappings(after, limit, sourceId, targetId)

List all Profile Mappings

Lists all profile mappings in your organization with [pagination](https://developer.okta.com/docs/api/#pagination). You can return a subset of profile mappings that match a supported &#x60;sourceId&#x60; and/or &#x60;targetId&#x60;. The results are [paginated](/#pagination) according to the limit parameter. If there are multiple pages of results, the Link header contains a &#x60;next&#x60; link that should be treated as an opaque value (follow it, don&#39;t parse it).  The response is a collection of profile mappings that include a subset of the profile mapping object&#39;s parameters. The profile mapping object describes the properties mapping between an Okta User and an App User Profile using [JSON Schema Draft 4](https://datatracker.ietf.org/doc/html/draft-zyp-json-schema-04).

### Example

```java
// Import classes:
import com.okta.sdk.resource.client.ApiClient;
import com.okta.sdk.resource.client.ApiException;
import com.okta.sdk.resource.client.Configuration;
import com.okta.sdk.resource.client.auth.*;
import com.okta.sdk.resource.client.models.*;
import com.okta.sdk.resource.api.ProfileMappingApi;

public class Example {
    public static void main(String[] args) {
        ApiClient defaultClient = Configuration.getDefaultApiClient();
        defaultClient.setBasePath("https://subdomain.okta.com");
        
        // Configure API key authorization: apiToken
        ApiKeyAuth apiToken = (ApiKeyAuth) defaultClient.getAuthentication("apiToken");
        apiToken.setApiKey("YOUR API KEY");
        // Uncomment the following line to set a prefix for the API key, e.g. "Token" (defaults to null)
        //apiToken.setApiKeyPrefix("Token");

        // Configure OAuth2 access token for authorization: oauth2
        OAuth oauth2 = (OAuth) defaultClient.getAuthentication("oauth2");
        oauth2.setAccessToken("YOUR ACCESS TOKEN");

        ProfileMappingApi apiInstance = new ProfileMappingApi(defaultClient);
        String after = "after_example"; // String | Mapping `id` that specifies the pagination cursor for the next page of mappings
        Integer limit = 20; // Integer | Specifies the number of results per page (maximum 200)
        String sourceId = "sourceId_example"; // String | The UserType or App Instance `id` that acts as the source of expressions in a mapping. If this parameter is included, all returned mappings have this as their `source.id`.
        String targetId = "targetId_example"; // String | The UserType or App Instance `id` that acts as the target of expressions in a mapping. If this parameter is included, all returned mappings have this as their `target.id`.
        try {
            List<ListProfileMappings> result = apiInstance.listProfileMappings(after, limit, sourceId, targetId);
            System.out.println(result);
        } catch (ApiException e) {
            System.err.println("Exception when calling ProfileMappingApi#listProfileMappings");
            System.err.println("Status code: " + e.getCode());
            System.err.println("Reason: " + e.getResponseBody());
            System.err.println("Response headers: " + e.getResponseHeaders());
            e.printStackTrace();
        }
    }
}
```

### Parameters


| Name | Type | Description  | Notes |
|------------- | ------------- | ------------- | -------------|
| **after** | **String**| Mapping &#x60;id&#x60; that specifies the pagination cursor for the next page of mappings | [optional] |
| **limit** | **Integer**| Specifies the number of results per page (maximum 200) | [optional] [default to 20] |
| **sourceId** | **String**| The UserType or App Instance &#x60;id&#x60; that acts as the source of expressions in a mapping. If this parameter is included, all returned mappings have this as their &#x60;source.id&#x60;. | [optional] |
| **targetId** | **String**| The UserType or App Instance &#x60;id&#x60; that acts as the target of expressions in a mapping. If this parameter is included, all returned mappings have this as their &#x60;target.id&#x60;. | [optional] |

### Return type

[**List&lt;ListProfileMappings&gt;**](ListProfileMappings.md)

### Authorization

[apiToken](../README.md#apiToken), [oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json


### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **200** | Success |  -  |
| **403** | Forbidden |  -  |
| **429** | Too Many Requests |  -  |


## updateProfileMapping

> ProfileMapping updateProfileMapping(mappingId, profileMapping)

Update a Profile Mapping

Updates an existing profile mapping by adding, updating, or removing one or many property mappings

### Example

```java
// Import classes:
import com.okta.sdk.resource.client.ApiClient;
import com.okta.sdk.resource.client.ApiException;
import com.okta.sdk.resource.client.Configuration;
import com.okta.sdk.resource.client.auth.*;
import com.okta.sdk.resource.client.models.*;
import com.okta.sdk.resource.api.ProfileMappingApi;

public class Example {
    public static void main(String[] args) {
        ApiClient defaultClient = Configuration.getDefaultApiClient();
        defaultClient.setBasePath("https://subdomain.okta.com");
        
        // Configure API key authorization: apiToken
        ApiKeyAuth apiToken = (ApiKeyAuth) defaultClient.getAuthentication("apiToken");
        apiToken.setApiKey("YOUR API KEY");
        // Uncomment the following line to set a prefix for the API key, e.g. "Token" (defaults to null)
        //apiToken.setApiKeyPrefix("Token");

        // Configure OAuth2 access token for authorization: oauth2
        OAuth oauth2 = (OAuth) defaultClient.getAuthentication("oauth2");
        oauth2.setAccessToken("YOUR ACCESS TOKEN");

        ProfileMappingApi apiInstance = new ProfileMappingApi(defaultClient);
        String mappingId = "cB6u7X8mptebWkffatKA"; // String | `id` of the Mapping
        ProfileMappingRequest profileMapping = new ProfileMappingRequest(); // ProfileMappingRequest | 
        try {
            ProfileMapping result = apiInstance.updateProfileMapping(mappingId, profileMapping);
            System.out.println(result);
        } catch (ApiException e) {
            System.err.println("Exception when calling ProfileMappingApi#updateProfileMapping");
            System.err.println("Status code: " + e.getCode());
            System.err.println("Reason: " + e.getResponseBody());
            System.err.println("Response headers: " + e.getResponseHeaders());
            e.printStackTrace();
        }
    }
}
```

### Parameters


| Name | Type | Description  | Notes |
|------------- | ------------- | ------------- | -------------|
| **mappingId** | **String**| &#x60;id&#x60; of the Mapping | |
| **profileMapping** | [**ProfileMappingRequest**](ProfileMappingRequest.md)|  | |

### Return type

[**ProfileMapping**](ProfileMapping.md)

### Authorization

[apiToken](../README.md#apiToken), [oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: application/json
- **Accept**: application/json


### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **200** | Success |  -  |
| **400** | Bad Request |  -  |
| **403** | Forbidden |  -  |
| **404** | Not Found |  -  |
| **429** | Too Many Requests |  -  |

