# RoleECustomPermissionApi

All URIs are relative to *https://subdomain.okta.com*

| Method | HTTP request | Description |
|------------- | ------------- | -------------|
| [**createRolePermission**](RoleECustomPermissionApi.md#createRolePermission) | **POST** /api/v1/iam/roles/{roleIdOrLabel}/permissions/{permissionType} | Create a Custom Role Permission |
| [**deleteRolePermission**](RoleECustomPermissionApi.md#deleteRolePermission) | **DELETE** /api/v1/iam/roles/{roleIdOrLabel}/permissions/{permissionType} | Delete a Custom Role Permission |
| [**getRolePermission**](RoleECustomPermissionApi.md#getRolePermission) | **GET** /api/v1/iam/roles/{roleIdOrLabel}/permissions/{permissionType} | Retrieve a Custom Role Permission |
| [**listRolePermissions**](RoleECustomPermissionApi.md#listRolePermissions) | **GET** /api/v1/iam/roles/{roleIdOrLabel}/permissions | List all Custom Role Permissions |
| [**replaceRolePermission**](RoleECustomPermissionApi.md#replaceRolePermission) | **PUT** /api/v1/iam/roles/{roleIdOrLabel}/permissions/{permissionType} | Replace a Custom Role Permission |



## createRolePermission

> createRolePermission(roleIdOrLabel, permissionType, instance)

Create a Custom Role Permission

Creates a permission (specified by &#x60;permissionType&#x60;) for a Custom Role

### Example

```java
// Import classes:
import com.okta.sdk.resource.client.ApiClient;
import com.okta.sdk.resource.client.ApiException;
import com.okta.sdk.resource.client.Configuration;
import com.okta.sdk.resource.client.auth.*;
import com.okta.sdk.resource.client.models.*;
import com.okta.sdk.resource.api.RoleECustomPermissionApi;

public class Example {
    public static void main(String[] args) {
        ApiClient defaultClient = Configuration.getDefaultApiClient();
        defaultClient.setBasePath("https://subdomain.okta.com");
        
        // Configure API key authorization: apiToken
        ApiKeyAuth apiToken = (ApiKeyAuth) defaultClient.getAuthentication("apiToken");
        apiToken.setApiKey("YOUR API KEY");
        // Uncomment the following line to set a prefix for the API key, e.g. "Token" (defaults to null)
        //apiToken.setApiKeyPrefix("Token");

        // Configure OAuth2 access token for authorization: oauth2
        OAuth oauth2 = (OAuth) defaultClient.getAuthentication("oauth2");
        oauth2.setAccessToken("YOUR ACCESS TOKEN");

        RoleECustomPermissionApi apiInstance = new RoleECustomPermissionApi(defaultClient);
        String roleIdOrLabel = "cr0Yq6IJxGIr0ouum0g3"; // String | `id` or `label` of the Role
        String permissionType = "okta.users.manage"; // String | An okta permission type
        CreateUpdateIamRolePermissionRequest instance = new CreateUpdateIamRolePermissionRequest(); // CreateUpdateIamRolePermissionRequest | 
        try {
            apiInstance.createRolePermission(roleIdOrLabel, permissionType, instance);
        } catch (ApiException e) {
            System.err.println("Exception when calling RoleECustomPermissionApi#createRolePermission");
            System.err.println("Status code: " + e.getCode());
            System.err.println("Reason: " + e.getResponseBody());
            System.err.println("Response headers: " + e.getResponseHeaders());
            e.printStackTrace();
        }
    }
}
```

### Parameters


| Name | Type | Description  | Notes |
|------------- | ------------- | ------------- | -------------|
| **roleIdOrLabel** | **String**| &#x60;id&#x60; or &#x60;label&#x60; of the Role | |
| **permissionType** | **String**| An okta permission type | |
| **instance** | [**CreateUpdateIamRolePermissionRequest**](CreateUpdateIamRolePermissionRequest.md)|  | [optional] |

### Return type

null (empty response body)

### Authorization

[apiToken](../README.md#apiToken), [oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: application/json
- **Accept**: application/json


### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **204** | No Content |  -  |
| **400** | Bad Request |  -  |
| **403** | Forbidden |  -  |
| **404** | Not Found |  -  |
| **429** | Too Many Requests |  -  |


## deleteRolePermission

> deleteRolePermission(roleIdOrLabel, permissionType)

Delete a Custom Role Permission

Deletes a permission (identified by &#x60;permissionType&#x60;) from a Custom Role

### Example

```java
// Import classes:
import com.okta.sdk.resource.client.ApiClient;
import com.okta.sdk.resource.client.ApiException;
import com.okta.sdk.resource.client.Configuration;
import com.okta.sdk.resource.client.auth.*;
import com.okta.sdk.resource.client.models.*;
import com.okta.sdk.resource.api.RoleECustomPermissionApi;

public class Example {
    public static void main(String[] args) {
        ApiClient defaultClient = Configuration.getDefaultApiClient();
        defaultClient.setBasePath("https://subdomain.okta.com");
        
        // Configure API key authorization: apiToken
        ApiKeyAuth apiToken = (ApiKeyAuth) defaultClient.getAuthentication("apiToken");
        apiToken.setApiKey("YOUR API KEY");
        // Uncomment the following line to set a prefix for the API key, e.g. "Token" (defaults to null)
        //apiToken.setApiKeyPrefix("Token");

        // Configure OAuth2 access token for authorization: oauth2
        OAuth oauth2 = (OAuth) defaultClient.getAuthentication("oauth2");
        oauth2.setAccessToken("YOUR ACCESS TOKEN");

        RoleECustomPermissionApi apiInstance = new RoleECustomPermissionApi(defaultClient);
        String roleIdOrLabel = "cr0Yq6IJxGIr0ouum0g3"; // String | `id` or `label` of the Role
        String permissionType = "okta.users.manage"; // String | An okta permission type
        try {
            apiInstance.deleteRolePermission(roleIdOrLabel, permissionType);
        } catch (ApiException e) {
            System.err.println("Exception when calling RoleECustomPermissionApi#deleteRolePermission");
            System.err.println("Status code: " + e.getCode());
            System.err.println("Reason: " + e.getResponseBody());
            System.err.println("Response headers: " + e.getResponseHeaders());
            e.printStackTrace();
        }
    }
}
```

### Parameters


| Name | Type | Description  | Notes |
|------------- | ------------- | ------------- | -------------|
| **roleIdOrLabel** | **String**| &#x60;id&#x60; or &#x60;label&#x60; of the Role | |
| **permissionType** | **String**| An okta permission type | |

### Return type

null (empty response body)

### Authorization

[apiToken](../README.md#apiToken), [oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json


### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **204** | No Content |  -  |
| **403** | Forbidden |  -  |
| **404** | Not Found |  -  |
| **429** | Too Many Requests |  -  |


## getRolePermission

> Permission getRolePermission(roleIdOrLabel, permissionType)

Retrieve a Custom Role Permission

Retrieves a permission (identified by &#x60;permissionType&#x60;) for a Custom Role

### Example

```java
// Import classes:
import com.okta.sdk.resource.client.ApiClient;
import com.okta.sdk.resource.client.ApiException;
import com.okta.sdk.resource.client.Configuration;
import com.okta.sdk.resource.client.auth.*;
import com.okta.sdk.resource.client.models.*;
import com.okta.sdk.resource.api.RoleECustomPermissionApi;

public class Example {
    public static void main(String[] args) {
        ApiClient defaultClient = Configuration.getDefaultApiClient();
        defaultClient.setBasePath("https://subdomain.okta.com");
        
        // Configure API key authorization: apiToken
        ApiKeyAuth apiToken = (ApiKeyAuth) defaultClient.getAuthentication("apiToken");
        apiToken.setApiKey("YOUR API KEY");
        // Uncomment the following line to set a prefix for the API key, e.g. "Token" (defaults to null)
        //apiToken.setApiKeyPrefix("Token");

        // Configure OAuth2 access token for authorization: oauth2
        OAuth oauth2 = (OAuth) defaultClient.getAuthentication("oauth2");
        oauth2.setAccessToken("YOUR ACCESS TOKEN");

        RoleECustomPermissionApi apiInstance = new RoleECustomPermissionApi(defaultClient);
        String roleIdOrLabel = "cr0Yq6IJxGIr0ouum0g3"; // String | `id` or `label` of the Role
        String permissionType = "okta.users.manage"; // String | An okta permission type
        try {
            Permission result = apiInstance.getRolePermission(roleIdOrLabel, permissionType);
            System.out.println(result);
        } catch (ApiException e) {
            System.err.println("Exception when calling RoleECustomPermissionApi#getRolePermission");
            System.err.println("Status code: " + e.getCode());
            System.err.println("Reason: " + e.getResponseBody());
            System.err.println("Response headers: " + e.getResponseHeaders());
            e.printStackTrace();
        }
    }
}
```

### Parameters


| Name | Type | Description  | Notes |
|------------- | ------------- | ------------- | -------------|
| **roleIdOrLabel** | **String**| &#x60;id&#x60; or &#x60;label&#x60; of the Role | |
| **permissionType** | **String**| An okta permission type | |

### Return type

[**Permission**](Permission.md)

### Authorization

[apiToken](../README.md#apiToken), [oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json


### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **200** | OK |  -  |
| **403** | Forbidden |  -  |
| **404** | Not Found |  -  |
| **429** | Too Many Requests |  -  |


## listRolePermissions

> Permissions listRolePermissions(roleIdOrLabel)

List all Custom Role Permissions

Lists all permissions for a Custom Role by &#x60;roleIdOrLabel&#x60;

### Example

```java
// Import classes:
import com.okta.sdk.resource.client.ApiClient;
import com.okta.sdk.resource.client.ApiException;
import com.okta.sdk.resource.client.Configuration;
import com.okta.sdk.resource.client.auth.*;
import com.okta.sdk.resource.client.models.*;
import com.okta.sdk.resource.api.RoleECustomPermissionApi;

public class Example {
    public static void main(String[] args) {
        ApiClient defaultClient = Configuration.getDefaultApiClient();
        defaultClient.setBasePath("https://subdomain.okta.com");
        
        // Configure API key authorization: apiToken
        ApiKeyAuth apiToken = (ApiKeyAuth) defaultClient.getAuthentication("apiToken");
        apiToken.setApiKey("YOUR API KEY");
        // Uncomment the following line to set a prefix for the API key, e.g. "Token" (defaults to null)
        //apiToken.setApiKeyPrefix("Token");

        // Configure OAuth2 access token for authorization: oauth2
        OAuth oauth2 = (OAuth) defaultClient.getAuthentication("oauth2");
        oauth2.setAccessToken("YOUR ACCESS TOKEN");

        RoleECustomPermissionApi apiInstance = new RoleECustomPermissionApi(defaultClient);
        String roleIdOrLabel = "cr0Yq6IJxGIr0ouum0g3"; // String | `id` or `label` of the Role
        try {
            Permissions result = apiInstance.listRolePermissions(roleIdOrLabel);
            System.out.println(result);
        } catch (ApiException e) {
            System.err.println("Exception when calling RoleECustomPermissionApi#listRolePermissions");
            System.err.println("Status code: " + e.getCode());
            System.err.println("Reason: " + e.getResponseBody());
            System.err.println("Response headers: " + e.getResponseHeaders());
            e.printStackTrace();
        }
    }
}
```

### Parameters


| Name | Type | Description  | Notes |
|------------- | ------------- | ------------- | -------------|
| **roleIdOrLabel** | **String**| &#x60;id&#x60; or &#x60;label&#x60; of the Role | |

### Return type

[**Permissions**](Permissions.md)

### Authorization

[apiToken](../README.md#apiToken), [oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json


### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **200** | OK |  -  |
| **403** | Forbidden |  -  |
| **404** | Not Found |  -  |
| **429** | Too Many Requests |  -  |


## replaceRolePermission

> Permission replaceRolePermission(roleIdOrLabel, permissionType, instance)

Replace a Custom Role Permission

Replaces a permission (specified by &#x60;permissionType&#x60;) for a Custom Role

### Example

```java
// Import classes:
import com.okta.sdk.resource.client.ApiClient;
import com.okta.sdk.resource.client.ApiException;
import com.okta.sdk.resource.client.Configuration;
import com.okta.sdk.resource.client.auth.*;
import com.okta.sdk.resource.client.models.*;
import com.okta.sdk.resource.api.RoleECustomPermissionApi;

public class Example {
    public static void main(String[] args) {
        ApiClient defaultClient = Configuration.getDefaultApiClient();
        defaultClient.setBasePath("https://subdomain.okta.com");
        
        // Configure API key authorization: apiToken
        ApiKeyAuth apiToken = (ApiKeyAuth) defaultClient.getAuthentication("apiToken");
        apiToken.setApiKey("YOUR API KEY");
        // Uncomment the following line to set a prefix for the API key, e.g. "Token" (defaults to null)
        //apiToken.setApiKeyPrefix("Token");

        // Configure OAuth2 access token for authorization: oauth2
        OAuth oauth2 = (OAuth) defaultClient.getAuthentication("oauth2");
        oauth2.setAccessToken("YOUR ACCESS TOKEN");

        RoleECustomPermissionApi apiInstance = new RoleECustomPermissionApi(defaultClient);
        String roleIdOrLabel = "cr0Yq6IJxGIr0ouum0g3"; // String | `id` or `label` of the Role
        String permissionType = "okta.users.manage"; // String | An okta permission type
        CreateUpdateIamRolePermissionRequest instance = new CreateUpdateIamRolePermissionRequest(); // CreateUpdateIamRolePermissionRequest | 
        try {
            Permission result = apiInstance.replaceRolePermission(roleIdOrLabel, permissionType, instance);
            System.out.println(result);
        } catch (ApiException e) {
            System.err.println("Exception when calling RoleECustomPermissionApi#replaceRolePermission");
            System.err.println("Status code: " + e.getCode());
            System.err.println("Reason: " + e.getResponseBody());
            System.err.println("Response headers: " + e.getResponseHeaders());
            e.printStackTrace();
        }
    }
}
```

### Parameters


| Name | Type | Description  | Notes |
|------------- | ------------- | ------------- | -------------|
| **roleIdOrLabel** | **String**| &#x60;id&#x60; or &#x60;label&#x60; of the Role | |
| **permissionType** | **String**| An okta permission type | |
| **instance** | [**CreateUpdateIamRolePermissionRequest**](CreateUpdateIamRolePermissionRequest.md)|  | [optional] |

### Return type

[**Permission**](Permission.md)

### Authorization

[apiToken](../README.md#apiToken), [oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: application/json
- **Accept**: application/json


### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **200** | OK |  -  |
| **400** | Bad Request |  -  |
| **403** | Forbidden |  -  |
| **404** | Not Found |  -  |
| **429** | Too Many Requests |  -  |

