# TrustedOriginApi

All URIs are relative to *https://subdomain.okta.com*

| Method | HTTP request | Description |
|------------- | ------------- | -------------|
| [**activateTrustedOrigin**](TrustedOriginApi.md#activateTrustedOrigin) | **POST** /api/v1/trustedOrigins/{trustedOriginId}/lifecycle/activate | Activate a Trusted Origin |
| [**createTrustedOrigin**](TrustedOriginApi.md#createTrustedOrigin) | **POST** /api/v1/trustedOrigins | Create a Trusted Origin |
| [**deactivateTrustedOrigin**](TrustedOriginApi.md#deactivateTrustedOrigin) | **POST** /api/v1/trustedOrigins/{trustedOriginId}/lifecycle/deactivate | Deactivate a Trusted Origin |
| [**deleteTrustedOrigin**](TrustedOriginApi.md#deleteTrustedOrigin) | **DELETE** /api/v1/trustedOrigins/{trustedOriginId} | Delete a Trusted Origin |
| [**getTrustedOrigin**](TrustedOriginApi.md#getTrustedOrigin) | **GET** /api/v1/trustedOrigins/{trustedOriginId} | Retrieve a Trusted Origin |
| [**listTrustedOrigins**](TrustedOriginApi.md#listTrustedOrigins) | **GET** /api/v1/trustedOrigins | List all Trusted Origins |
| [**replaceTrustedOrigin**](TrustedOriginApi.md#replaceTrustedOrigin) | **PUT** /api/v1/trustedOrigins/{trustedOriginId} | Replace a Trusted Origin |



## activateTrustedOrigin

> TrustedOrigin activateTrustedOrigin(trustedOriginId)

Activate a Trusted Origin

Activates a Trusted Origin. Sets the &#x60;status&#x60; to &#x60;ACTIVE&#x60;.

### Example

```java
// Import classes:
import com.okta.sdk.resource.client.ApiClient;
import com.okta.sdk.resource.client.ApiException;
import com.okta.sdk.resource.client.Configuration;
import com.okta.sdk.resource.client.auth.*;
import com.okta.sdk.resource.client.models.*;
import com.okta.sdk.resource.api.TrustedOriginApi;

public class Example {
    public static void main(String[] args) {
        ApiClient defaultClient = Configuration.getDefaultApiClient();
        defaultClient.setBasePath("https://subdomain.okta.com");
        
        // Configure API key authorization: apiToken
        ApiKeyAuth apiToken = (ApiKeyAuth) defaultClient.getAuthentication("apiToken");
        apiToken.setApiKey("YOUR API KEY");
        // Uncomment the following line to set a prefix for the API key, e.g. "Token" (defaults to null)
        //apiToken.setApiKeyPrefix("Token");

        // Configure OAuth2 access token for authorization: oauth2
        OAuth oauth2 = (OAuth) defaultClient.getAuthentication("oauth2");
        oauth2.setAccessToken("YOUR ACCESS TOKEN");

        TrustedOriginApi apiInstance = new TrustedOriginApi(defaultClient);
        String trustedOriginId = "7j2PkU1nyNIDe26ZNufR"; // String | `id` of the Trusted Origin
        try {
            TrustedOrigin result = apiInstance.activateTrustedOrigin(trustedOriginId);
            System.out.println(result);
        } catch (ApiException e) {
            System.err.println("Exception when calling TrustedOriginApi#activateTrustedOrigin");
            System.err.println("Status code: " + e.getCode());
            System.err.println("Reason: " + e.getResponseBody());
            System.err.println("Response headers: " + e.getResponseHeaders());
            e.printStackTrace();
        }
    }
}
```

### Parameters


| Name | Type | Description  | Notes |
|------------- | ------------- | ------------- | -------------|
| **trustedOriginId** | **String**| &#x60;id&#x60; of the Trusted Origin | |

### Return type

[**TrustedOrigin**](TrustedOrigin.md)

### Authorization

[apiToken](../README.md#apiToken), [oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json


### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **200** | Success |  -  |
| **403** | Forbidden |  -  |
| **404** | Not Found |  -  |
| **429** | Too Many Requests |  -  |


## createTrustedOrigin

> TrustedOrigin createTrustedOrigin(trustedOrigin)

Create a Trusted Origin

Creates a trusted origin

### Example

```java
// Import classes:
import com.okta.sdk.resource.client.ApiClient;
import com.okta.sdk.resource.client.ApiException;
import com.okta.sdk.resource.client.Configuration;
import com.okta.sdk.resource.client.auth.*;
import com.okta.sdk.resource.client.models.*;
import com.okta.sdk.resource.api.TrustedOriginApi;

public class Example {
    public static void main(String[] args) {
        ApiClient defaultClient = Configuration.getDefaultApiClient();
        defaultClient.setBasePath("https://subdomain.okta.com");
        
        // Configure API key authorization: apiToken
        ApiKeyAuth apiToken = (ApiKeyAuth) defaultClient.getAuthentication("apiToken");
        apiToken.setApiKey("YOUR API KEY");
        // Uncomment the following line to set a prefix for the API key, e.g. "Token" (defaults to null)
        //apiToken.setApiKeyPrefix("Token");

        // Configure OAuth2 access token for authorization: oauth2
        OAuth oauth2 = (OAuth) defaultClient.getAuthentication("oauth2");
        oauth2.setAccessToken("YOUR ACCESS TOKEN");

        TrustedOriginApi apiInstance = new TrustedOriginApi(defaultClient);
        TrustedOriginWrite trustedOrigin = new TrustedOriginWrite(); // TrustedOriginWrite | 
        try {
            TrustedOrigin result = apiInstance.createTrustedOrigin(trustedOrigin);
            System.out.println(result);
        } catch (ApiException e) {
            System.err.println("Exception when calling TrustedOriginApi#createTrustedOrigin");
            System.err.println("Status code: " + e.getCode());
            System.err.println("Reason: " + e.getResponseBody());
            System.err.println("Response headers: " + e.getResponseHeaders());
            e.printStackTrace();
        }
    }
}
```

### Parameters


| Name | Type | Description  | Notes |
|------------- | ------------- | ------------- | -------------|
| **trustedOrigin** | [**TrustedOriginWrite**](TrustedOriginWrite.md)|  | |

### Return type

[**TrustedOrigin**](TrustedOrigin.md)

### Authorization

[apiToken](../README.md#apiToken), [oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: application/json
- **Accept**: application/json


### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **200** | Success |  -  |
| **400** | Bad Request |  -  |
| **403** | Forbidden |  -  |
| **429** | Too Many Requests |  -  |


## deactivateTrustedOrigin

> TrustedOrigin deactivateTrustedOrigin(trustedOriginId)

Deactivate a Trusted Origin

Deactivates a Trusted Origin. Sets the &#x60;status&#x60; to &#x60;INACTIVE&#x60;.

### Example

```java
// Import classes:
import com.okta.sdk.resource.client.ApiClient;
import com.okta.sdk.resource.client.ApiException;
import com.okta.sdk.resource.client.Configuration;
import com.okta.sdk.resource.client.auth.*;
import com.okta.sdk.resource.client.models.*;
import com.okta.sdk.resource.api.TrustedOriginApi;

public class Example {
    public static void main(String[] args) {
        ApiClient defaultClient = Configuration.getDefaultApiClient();
        defaultClient.setBasePath("https://subdomain.okta.com");
        
        // Configure API key authorization: apiToken
        ApiKeyAuth apiToken = (ApiKeyAuth) defaultClient.getAuthentication("apiToken");
        apiToken.setApiKey("YOUR API KEY");
        // Uncomment the following line to set a prefix for the API key, e.g. "Token" (defaults to null)
        //apiToken.setApiKeyPrefix("Token");

        // Configure OAuth2 access token for authorization: oauth2
        OAuth oauth2 = (OAuth) defaultClient.getAuthentication("oauth2");
        oauth2.setAccessToken("YOUR ACCESS TOKEN");

        TrustedOriginApi apiInstance = new TrustedOriginApi(defaultClient);
        String trustedOriginId = "7j2PkU1nyNIDe26ZNufR"; // String | `id` of the Trusted Origin
        try {
            TrustedOrigin result = apiInstance.deactivateTrustedOrigin(trustedOriginId);
            System.out.println(result);
        } catch (ApiException e) {
            System.err.println("Exception when calling TrustedOriginApi#deactivateTrustedOrigin");
            System.err.println("Status code: " + e.getCode());
            System.err.println("Reason: " + e.getResponseBody());
            System.err.println("Response headers: " + e.getResponseHeaders());
            e.printStackTrace();
        }
    }
}
```

### Parameters


| Name | Type | Description  | Notes |
|------------- | ------------- | ------------- | -------------|
| **trustedOriginId** | **String**| &#x60;id&#x60; of the Trusted Origin | |

### Return type

[**TrustedOrigin**](TrustedOrigin.md)

### Authorization

[apiToken](../README.md#apiToken), [oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json


### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **200** | Success |  -  |
| **403** | Forbidden |  -  |
| **404** | Not Found |  -  |
| **429** | Too Many Requests |  -  |


## deleteTrustedOrigin

> deleteTrustedOrigin(trustedOriginId)

Delete a Trusted Origin

Deletes a trusted origin

### Example

```java
// Import classes:
import com.okta.sdk.resource.client.ApiClient;
import com.okta.sdk.resource.client.ApiException;
import com.okta.sdk.resource.client.Configuration;
import com.okta.sdk.resource.client.auth.*;
import com.okta.sdk.resource.client.models.*;
import com.okta.sdk.resource.api.TrustedOriginApi;

public class Example {
    public static void main(String[] args) {
        ApiClient defaultClient = Configuration.getDefaultApiClient();
        defaultClient.setBasePath("https://subdomain.okta.com");
        
        // Configure API key authorization: apiToken
        ApiKeyAuth apiToken = (ApiKeyAuth) defaultClient.getAuthentication("apiToken");
        apiToken.setApiKey("YOUR API KEY");
        // Uncomment the following line to set a prefix for the API key, e.g. "Token" (defaults to null)
        //apiToken.setApiKeyPrefix("Token");

        // Configure OAuth2 access token for authorization: oauth2
        OAuth oauth2 = (OAuth) defaultClient.getAuthentication("oauth2");
        oauth2.setAccessToken("YOUR ACCESS TOKEN");

        TrustedOriginApi apiInstance = new TrustedOriginApi(defaultClient);
        String trustedOriginId = "7j2PkU1nyNIDe26ZNufR"; // String | `id` of the Trusted Origin
        try {
            apiInstance.deleteTrustedOrigin(trustedOriginId);
        } catch (ApiException e) {
            System.err.println("Exception when calling TrustedOriginApi#deleteTrustedOrigin");
            System.err.println("Status code: " + e.getCode());
            System.err.println("Reason: " + e.getResponseBody());
            System.err.println("Response headers: " + e.getResponseHeaders());
            e.printStackTrace();
        }
    }
}
```

### Parameters


| Name | Type | Description  | Notes |
|------------- | ------------- | ------------- | -------------|
| **trustedOriginId** | **String**| &#x60;id&#x60; of the Trusted Origin | |

### Return type

null (empty response body)

### Authorization

[apiToken](../README.md#apiToken), [oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json


### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **204** | Success |  -  |
| **403** | Forbidden |  -  |
| **404** | Not Found |  -  |
| **429** | Too Many Requests |  -  |


## getTrustedOrigin

> TrustedOrigin getTrustedOrigin(trustedOriginId)

Retrieve a Trusted Origin

Retrieves a trusted origin

### Example

```java
// Import classes:
import com.okta.sdk.resource.client.ApiClient;
import com.okta.sdk.resource.client.ApiException;
import com.okta.sdk.resource.client.Configuration;
import com.okta.sdk.resource.client.auth.*;
import com.okta.sdk.resource.client.models.*;
import com.okta.sdk.resource.api.TrustedOriginApi;

public class Example {
    public static void main(String[] args) {
        ApiClient defaultClient = Configuration.getDefaultApiClient();
        defaultClient.setBasePath("https://subdomain.okta.com");
        
        // Configure API key authorization: apiToken
        ApiKeyAuth apiToken = (ApiKeyAuth) defaultClient.getAuthentication("apiToken");
        apiToken.setApiKey("YOUR API KEY");
        // Uncomment the following line to set a prefix for the API key, e.g. "Token" (defaults to null)
        //apiToken.setApiKeyPrefix("Token");

        // Configure OAuth2 access token for authorization: oauth2
        OAuth oauth2 = (OAuth) defaultClient.getAuthentication("oauth2");
        oauth2.setAccessToken("YOUR ACCESS TOKEN");

        TrustedOriginApi apiInstance = new TrustedOriginApi(defaultClient);
        String trustedOriginId = "7j2PkU1nyNIDe26ZNufR"; // String | `id` of the Trusted Origin
        try {
            TrustedOrigin result = apiInstance.getTrustedOrigin(trustedOriginId);
            System.out.println(result);
        } catch (ApiException e) {
            System.err.println("Exception when calling TrustedOriginApi#getTrustedOrigin");
            System.err.println("Status code: " + e.getCode());
            System.err.println("Reason: " + e.getResponseBody());
            System.err.println("Response headers: " + e.getResponseHeaders());
            e.printStackTrace();
        }
    }
}
```

### Parameters


| Name | Type | Description  | Notes |
|------------- | ------------- | ------------- | -------------|
| **trustedOriginId** | **String**| &#x60;id&#x60; of the Trusted Origin | |

### Return type

[**TrustedOrigin**](TrustedOrigin.md)

### Authorization

[apiToken](../README.md#apiToken), [oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json


### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **200** | Success |  -  |
| **403** | Forbidden |  -  |
| **404** | Not Found |  -  |
| **429** | Too Many Requests |  -  |


## listTrustedOrigins

> List&lt;TrustedOrigin&gt; listTrustedOrigins(q, filter, after, limit)

List all Trusted Origins

Lists all trusted origins

### Example

```java
// Import classes:
import com.okta.sdk.resource.client.ApiClient;
import com.okta.sdk.resource.client.ApiException;
import com.okta.sdk.resource.client.Configuration;
import com.okta.sdk.resource.client.auth.*;
import com.okta.sdk.resource.client.models.*;
import com.okta.sdk.resource.api.TrustedOriginApi;

public class Example {
    public static void main(String[] args) {
        ApiClient defaultClient = Configuration.getDefaultApiClient();
        defaultClient.setBasePath("https://subdomain.okta.com");
        
        // Configure API key authorization: apiToken
        ApiKeyAuth apiToken = (ApiKeyAuth) defaultClient.getAuthentication("apiToken");
        apiToken.setApiKey("YOUR API KEY");
        // Uncomment the following line to set a prefix for the API key, e.g. "Token" (defaults to null)
        //apiToken.setApiKeyPrefix("Token");

        // Configure OAuth2 access token for authorization: oauth2
        OAuth oauth2 = (OAuth) defaultClient.getAuthentication("oauth2");
        oauth2.setAccessToken("YOUR ACCESS TOKEN");

        TrustedOriginApi apiInstance = new TrustedOriginApi(defaultClient);
        String q = "q_example"; // String | A search string that will prefix match against the `name` and `origin`
        String filter = "name eq \"Example Trusted Origin\""; // String | [Filter](/#filter) Trusted Origins with a supported expression for a subset of properties. You can filter on the following properties: `name`, `origin`, `status`, and `type` (type of scopes). 
        String after = "after_example"; // String | The after cursor provided by a prior request.
        Integer limit = 20; // Integer | Specifies the number of results.
        try {
            List<TrustedOrigin> result = apiInstance.listTrustedOrigins(q, filter, after, limit);
            System.out.println(result);
        } catch (ApiException e) {
            System.err.println("Exception when calling TrustedOriginApi#listTrustedOrigins");
            System.err.println("Status code: " + e.getCode());
            System.err.println("Reason: " + e.getResponseBody());
            System.err.println("Response headers: " + e.getResponseHeaders());
            e.printStackTrace();
        }
    }
}
```

### Parameters


| Name | Type | Description  | Notes |
|------------- | ------------- | ------------- | -------------|
| **q** | **String**| A search string that will prefix match against the &#x60;name&#x60; and &#x60;origin&#x60; | [optional] |
| **filter** | **String**| [Filter](/#filter) Trusted Origins with a supported expression for a subset of properties. You can filter on the following properties: &#x60;name&#x60;, &#x60;origin&#x60;, &#x60;status&#x60;, and &#x60;type&#x60; (type of scopes).  | [optional] |
| **after** | **String**| The after cursor provided by a prior request. | [optional] |
| **limit** | **Integer**| Specifies the number of results. | [optional] [default to 20] |

### Return type

[**List&lt;TrustedOrigin&gt;**](TrustedOrigin.md)

### Authorization

[apiToken](../README.md#apiToken), [oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json


### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **200** | Success |  -  |
| **403** | Forbidden |  -  |
| **429** | Too Many Requests |  -  |


## replaceTrustedOrigin

> TrustedOrigin replaceTrustedOrigin(trustedOriginId, trustedOrigin)

Replace a Trusted Origin

Replaces a trusted origin

### Example

```java
// Import classes:
import com.okta.sdk.resource.client.ApiClient;
import com.okta.sdk.resource.client.ApiException;
import com.okta.sdk.resource.client.Configuration;
import com.okta.sdk.resource.client.auth.*;
import com.okta.sdk.resource.client.models.*;
import com.okta.sdk.resource.api.TrustedOriginApi;

public class Example {
    public static void main(String[] args) {
        ApiClient defaultClient = Configuration.getDefaultApiClient();
        defaultClient.setBasePath("https://subdomain.okta.com");
        
        // Configure API key authorization: apiToken
        ApiKeyAuth apiToken = (ApiKeyAuth) defaultClient.getAuthentication("apiToken");
        apiToken.setApiKey("YOUR API KEY");
        // Uncomment the following line to set a prefix for the API key, e.g. "Token" (defaults to null)
        //apiToken.setApiKeyPrefix("Token");

        // Configure OAuth2 access token for authorization: oauth2
        OAuth oauth2 = (OAuth) defaultClient.getAuthentication("oauth2");
        oauth2.setAccessToken("YOUR ACCESS TOKEN");

        TrustedOriginApi apiInstance = new TrustedOriginApi(defaultClient);
        String trustedOriginId = "7j2PkU1nyNIDe26ZNufR"; // String | `id` of the Trusted Origin
        TrustedOrigin trustedOrigin = new TrustedOrigin(); // TrustedOrigin | 
        try {
            TrustedOrigin result = apiInstance.replaceTrustedOrigin(trustedOriginId, trustedOrigin);
            System.out.println(result);
        } catch (ApiException e) {
            System.err.println("Exception when calling TrustedOriginApi#replaceTrustedOrigin");
            System.err.println("Status code: " + e.getCode());
            System.err.println("Reason: " + e.getResponseBody());
            System.err.println("Response headers: " + e.getResponseHeaders());
            e.printStackTrace();
        }
    }
}
```

### Parameters


| Name | Type | Description  | Notes |
|------------- | ------------- | ------------- | -------------|
| **trustedOriginId** | **String**| &#x60;id&#x60; of the Trusted Origin | |
| **trustedOrigin** | [**TrustedOrigin**](TrustedOrigin.md)|  | |

### Return type

[**TrustedOrigin**](TrustedOrigin.md)

### Authorization

[apiToken](../README.md#apiToken), [oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: application/json
- **Accept**: application/json


### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **200** | Success |  -  |
| **400** | Bad Request |  -  |
| **403** | Forbidden |  -  |
| **404** | Not Found |  -  |
| **429** | Too Many Requests |  -  |

