# UserCredApi

All URIs are relative to *https://subdomain.okta.com*

| Method | HTTP request | Description |
|------------- | ------------- | -------------|
| [**changePassword**](UserCredApi.md#changePassword) | **POST** /api/v1/users/{userId}/credentials/change_password | Update Password |
| [**changeRecoveryQuestion**](UserCredApi.md#changeRecoveryQuestion) | **POST** /api/v1/users/{userId}/credentials/change_recovery_question | Update Recovery Question |
| [**expirePassword**](UserCredApi.md#expirePassword) | **POST** /api/v1/users/{userId}/lifecycle/expire_password | Expire Password |
| [**expirePasswordWithTempPassword**](UserCredApi.md#expirePasswordWithTempPassword) | **POST** /api/v1/users/{userId}/lifecycle/expire_password_with_temp_password | Expire Password with temporary password |
| [**forgotPassword**](UserCredApi.md#forgotPassword) | **POST** /api/v1/users/{userId}/credentials/forgot_password | Start forgot password flow |
| [**forgotPasswordSetNewPassword**](UserCredApi.md#forgotPasswordSetNewPassword) | **POST** /api/v1/users/{userId}/credentials/forgot_password_recovery_question | Reset Password with Recovery Question |
| [**resetPassword**](UserCredApi.md#resetPassword) | **POST** /api/v1/users/{userId}/lifecycle/reset_password | Reset password |



## changePassword

> UserCredentials changePassword(userId, changePasswordRequest, strict)

Update Password

Updates a User&#39;s password by validating the User&#39;s current Password.  This operation provides an option to delete all the sessions of the specified User. However, if the request is made in the context of a session owned by the specified User, that session isn&#39;t cleared.  You can only perform this operation on Users in &#x60;STAGED&#x60;, &#x60;ACTIVE&#x60;, &#x60;PASSWORD_EXPIRED&#x60;, or &#x60;RECOVERY&#x60; status that have a valid [Password credential](https://developer.okta.com/docs/api/openapi/okta-management/management/tag/User/#tag/User/operation/createUser!path&#x3D;credentials/password&amp;t&#x3D;request).  The User transitions to &#x60;ACTIVE&#x60; status when successfully invoked in &#x60;RECOVERY&#x60; status.

### Example

```java
// Import classes:
import com.okta.sdk.resource.client.ApiClient;
import com.okta.sdk.resource.client.ApiException;
import com.okta.sdk.resource.client.Configuration;
import com.okta.sdk.resource.client.auth.*;
import com.okta.sdk.resource.client.models.*;
import com.okta.sdk.resource.api.UserCredApi;

public class Example {
    public static void main(String[] args) {
        ApiClient defaultClient = Configuration.getDefaultApiClient();
        defaultClient.setBasePath("https://subdomain.okta.com");
        
        // Configure API key authorization: apiToken
        ApiKeyAuth apiToken = (ApiKeyAuth) defaultClient.getAuthentication("apiToken");
        apiToken.setApiKey("YOUR API KEY");
        // Uncomment the following line to set a prefix for the API key, e.g. "Token" (defaults to null)
        //apiToken.setApiKeyPrefix("Token");

        // Configure OAuth2 access token for authorization: oauth2
        OAuth oauth2 = (OAuth) defaultClient.getAuthentication("oauth2");
        oauth2.setAccessToken("YOUR ACCESS TOKEN");

        UserCredApi apiInstance = new UserCredApi(defaultClient);
        String userId = "00ub0oNGTSWTBKOLGLNR"; // String | ID of an existing Okta user
        ChangePasswordRequest changePasswordRequest = new ChangePasswordRequest(); // ChangePasswordRequest | 
        Boolean strict = false; // Boolean | If true, validates against password minimum age policy
        try {
            UserCredentials result = apiInstance.changePassword(userId, changePasswordRequest, strict);
            System.out.println(result);
        } catch (ApiException e) {
            System.err.println("Exception when calling UserCredApi#changePassword");
            System.err.println("Status code: " + e.getCode());
            System.err.println("Reason: " + e.getResponseBody());
            System.err.println("Response headers: " + e.getResponseHeaders());
            e.printStackTrace();
        }
    }
}
```

### Parameters


| Name | Type | Description  | Notes |
|------------- | ------------- | ------------- | -------------|
| **userId** | **String**| ID of an existing Okta user | |
| **changePasswordRequest** | [**ChangePasswordRequest**](ChangePasswordRequest.md)|  | |
| **strict** | **Boolean**| If true, validates against password minimum age policy | [optional] [default to false] |

### Return type

[**UserCredentials**](UserCredentials.md)

### Authorization

[apiToken](../README.md#apiToken), [oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: application/json
- **Accept**: application/json


### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **200** | Success |  -  |
| **400** | Bad Request |  -  |
| **403** | Forbidden |  -  |
| **404** | Not Found |  -  |
| **429** | Too Many Requests |  -  |


## changeRecoveryQuestion

> UserCredentials changeRecoveryQuestion(userId, userCredentials)

Update Recovery Question

Updates a User&#39;s Recovery Question and answer credential by validating the User&#39;s current Password. You can only perform this operation on Users in &#x60;STAGED&#x60;, &#x60;ACTIVE&#x60;, or &#x60;RECOVERY&#x60; status that have a valid [Password credential](https://developer.okta.com/docs/api/openapi/okta-management/management/tag/User/#tag/User/operation/createUser!path&#x3D;credentials/password&amp;t&#x3D;request).

### Example

```java
// Import classes:
import com.okta.sdk.resource.client.ApiClient;
import com.okta.sdk.resource.client.ApiException;
import com.okta.sdk.resource.client.Configuration;
import com.okta.sdk.resource.client.auth.*;
import com.okta.sdk.resource.client.models.*;
import com.okta.sdk.resource.api.UserCredApi;

public class Example {
    public static void main(String[] args) {
        ApiClient defaultClient = Configuration.getDefaultApiClient();
        defaultClient.setBasePath("https://subdomain.okta.com");
        
        // Configure API key authorization: apiToken
        ApiKeyAuth apiToken = (ApiKeyAuth) defaultClient.getAuthentication("apiToken");
        apiToken.setApiKey("YOUR API KEY");
        // Uncomment the following line to set a prefix for the API key, e.g. "Token" (defaults to null)
        //apiToken.setApiKeyPrefix("Token");

        // Configure OAuth2 access token for authorization: oauth2
        OAuth oauth2 = (OAuth) defaultClient.getAuthentication("oauth2");
        oauth2.setAccessToken("YOUR ACCESS TOKEN");

        UserCredApi apiInstance = new UserCredApi(defaultClient);
        String userId = "00ub0oNGTSWTBKOLGLNR"; // String | ID of an existing Okta user
        UserCredentials userCredentials = new UserCredentials(); // UserCredentials | 
        try {
            UserCredentials result = apiInstance.changeRecoveryQuestion(userId, userCredentials);
            System.out.println(result);
        } catch (ApiException e) {
            System.err.println("Exception when calling UserCredApi#changeRecoveryQuestion");
            System.err.println("Status code: " + e.getCode());
            System.err.println("Reason: " + e.getResponseBody());
            System.err.println("Response headers: " + e.getResponseHeaders());
            e.printStackTrace();
        }
    }
}
```

### Parameters


| Name | Type | Description  | Notes |
|------------- | ------------- | ------------- | -------------|
| **userId** | **String**| ID of an existing Okta user | |
| **userCredentials** | [**UserCredentials**](UserCredentials.md)|  | |

### Return type

[**UserCredentials**](UserCredentials.md)

### Authorization

[apiToken](../README.md#apiToken), [oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: application/json
- **Accept**: application/json


### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **200** | Success |  -  |
| **400** | Bad Request |  -  |
| **403** | Forbidden |  -  |
| **404** | Not Found |  -  |
| **429** | Too Many Requests |  -  |


## expirePassword

> User expirePassword(userId)

Expire Password

Expires the password. This operation transitions the User status to &#x60;PASSWORD_EXPIRED&#x60; so that the User must change their password the next time that they sign in. &lt;br&gt; If you have integrated Okta with your on-premises Active Directory (AD), then setting a User&#39;s Password as expired in Okta also expires the Password in AD. When the User tries to sign in to Okta, delegated authentication finds the password-expired status in AD, and the User is presented with the password-expired page where they can change their Password.

### Example

```java
// Import classes:
import com.okta.sdk.resource.client.ApiClient;
import com.okta.sdk.resource.client.ApiException;
import com.okta.sdk.resource.client.Configuration;
import com.okta.sdk.resource.client.auth.*;
import com.okta.sdk.resource.client.models.*;
import com.okta.sdk.resource.api.UserCredApi;

public class Example {
    public static void main(String[] args) {
        ApiClient defaultClient = Configuration.getDefaultApiClient();
        defaultClient.setBasePath("https://subdomain.okta.com");
        
        // Configure API key authorization: apiToken
        ApiKeyAuth apiToken = (ApiKeyAuth) defaultClient.getAuthentication("apiToken");
        apiToken.setApiKey("YOUR API KEY");
        // Uncomment the following line to set a prefix for the API key, e.g. "Token" (defaults to null)
        //apiToken.setApiKeyPrefix("Token");

        // Configure OAuth2 access token for authorization: oauth2
        OAuth oauth2 = (OAuth) defaultClient.getAuthentication("oauth2");
        oauth2.setAccessToken("YOUR ACCESS TOKEN");

        UserCredApi apiInstance = new UserCredApi(defaultClient);
        String userId = "00ub0oNGTSWTBKOLGLNR"; // String | ID of an existing Okta user
        try {
            User result = apiInstance.expirePassword(userId);
            System.out.println(result);
        } catch (ApiException e) {
            System.err.println("Exception when calling UserCredApi#expirePassword");
            System.err.println("Status code: " + e.getCode());
            System.err.println("Reason: " + e.getResponseBody());
            System.err.println("Response headers: " + e.getResponseHeaders());
            e.printStackTrace();
        }
    }
}
```

### Parameters


| Name | Type | Description  | Notes |
|------------- | ------------- | ------------- | -------------|
| **userId** | **String**| ID of an existing Okta user | |

### Return type

[**User**](User.md)

### Authorization

[apiToken](../README.md#apiToken), [oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json


### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **200** | Success |  -  |
| **403** | Forbidden |  -  |
| **404** | Not Found |  -  |
| **429** | Too Many Requests |  -  |


## expirePasswordWithTempPassword

> User expirePasswordWithTempPassword(userId, revokeSessions)

Expire Password with temporary password

Expires the password and resets the User&#39;s Password to a temporary password. This operation transitions the User status to &#x60;PASSWORD_EXPIRED&#x60; so that the User must change their password the next time that they sign in. User&#39;s Password is reset to a temporary password that is returned, and then the User&#39;s Password is expired. If &#x60;revokeSessions&#x60; is included in the request with a value of &#x60;true&#x60;, the User&#39;s current outstanding sessions are revoked and require re-authentication. &lt;br&gt; If you have integrated Okta with your on-premises Active Directory (AD), then setting a User&#39;s Password as expired in Okta also expires the Password in AD. When the User tries to sign in to Okta, delegated authentication finds the password-expired status in AD, and the User is presented with the password-expired page where they can change their Password.

### Example

```java
// Import classes:
import com.okta.sdk.resource.client.ApiClient;
import com.okta.sdk.resource.client.ApiException;
import com.okta.sdk.resource.client.Configuration;
import com.okta.sdk.resource.client.auth.*;
import com.okta.sdk.resource.client.models.*;
import com.okta.sdk.resource.api.UserCredApi;

public class Example {
    public static void main(String[] args) {
        ApiClient defaultClient = Configuration.getDefaultApiClient();
        defaultClient.setBasePath("https://subdomain.okta.com");
        
        // Configure API key authorization: apiToken
        ApiKeyAuth apiToken = (ApiKeyAuth) defaultClient.getAuthentication("apiToken");
        apiToken.setApiKey("YOUR API KEY");
        // Uncomment the following line to set a prefix for the API key, e.g. "Token" (defaults to null)
        //apiToken.setApiKeyPrefix("Token");

        // Configure OAuth2 access token for authorization: oauth2
        OAuth oauth2 = (OAuth) defaultClient.getAuthentication("oauth2");
        oauth2.setAccessToken("YOUR ACCESS TOKEN");

        UserCredApi apiInstance = new UserCredApi(defaultClient);
        String userId = "00ub0oNGTSWTBKOLGLNR"; // String | ID of an existing Okta user
        Boolean revokeSessions = false; // Boolean | Revokes the User's existing sessions if `true`
        try {
            User result = apiInstance.expirePasswordWithTempPassword(userId, revokeSessions);
            System.out.println(result);
        } catch (ApiException e) {
            System.err.println("Exception when calling UserCredApi#expirePasswordWithTempPassword");
            System.err.println("Status code: " + e.getCode());
            System.err.println("Reason: " + e.getResponseBody());
            System.err.println("Response headers: " + e.getResponseHeaders());
            e.printStackTrace();
        }
    }
}
```

### Parameters


| Name | Type | Description  | Notes |
|------------- | ------------- | ------------- | -------------|
| **userId** | **String**| ID of an existing Okta user | |
| **revokeSessions** | **Boolean**| Revokes the User&#39;s existing sessions if &#x60;true&#x60; | [optional] [default to false] |

### Return type

[**User**](User.md)

### Authorization

[apiToken](../README.md#apiToken), [oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json


### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **200** | Success |  -  |
| **403** | Forbidden |  -  |
| **404** | Not Found |  -  |
| **429** | Too Many Requests |  -  |


## forgotPassword

> ForgotPasswordResponse forgotPassword(userId, sendEmail)

Start forgot password flow

Starts the forgot password flow.  Generates a one-time token (OTT) that you can use to reset a User&#39;s Password.  The User must validate their security question&#39;s answer when visiting the reset link. This operation can only be performed on Users with an ACTIVE status and a valid [Recovery Question credential](https://developer.okta.com/docs/api/openapi/okta-management/management/tag/User/#tag/User/operation/createUser!path&#x3D;credentials/recovery_question&amp;t&#x3D;request).  &gt; **Note:** If you have migrated to Identity Engine, you can allow Users to recover passwords with any enrolled MFA authenticator. See [Self-service account recovery](https://help.okta.com/oie/en-us/content/topics/identity-engine/authenticators/configure-sspr.htm?cshid&#x3D;ext-config-sspr)  If an email address is associated with multiple Users, keep in mind the following to ensure a successful password recovery lookup:   * Okta no longer includes deactivated Users in the lookup.   * The lookup searches sign-in IDs first, then primary email addresses, and then secondary email addresses.  If &#x60;sendEmail&#x60; is &#x60;false&#x60;, returns a link for the User to reset their Password. This operation doesn&#39;t affect the status of the User.

### Example

```java
// Import classes:
import com.okta.sdk.resource.client.ApiClient;
import com.okta.sdk.resource.client.ApiException;
import com.okta.sdk.resource.client.Configuration;
import com.okta.sdk.resource.client.auth.*;
import com.okta.sdk.resource.client.models.*;
import com.okta.sdk.resource.api.UserCredApi;

public class Example {
    public static void main(String[] args) {
        ApiClient defaultClient = Configuration.getDefaultApiClient();
        defaultClient.setBasePath("https://subdomain.okta.com");
        
        // Configure API key authorization: apiToken
        ApiKeyAuth apiToken = (ApiKeyAuth) defaultClient.getAuthentication("apiToken");
        apiToken.setApiKey("YOUR API KEY");
        // Uncomment the following line to set a prefix for the API key, e.g. "Token" (defaults to null)
        //apiToken.setApiKeyPrefix("Token");

        // Configure OAuth2 access token for authorization: oauth2
        OAuth oauth2 = (OAuth) defaultClient.getAuthentication("oauth2");
        oauth2.setAccessToken("YOUR ACCESS TOKEN");

        UserCredApi apiInstance = new UserCredApi(defaultClient);
        String userId = "00ub0oNGTSWTBKOLGLNR"; // String | ID of an existing Okta user
        Boolean sendEmail = true; // Boolean | Sends a forgot password email to the User if `true`
        try {
            ForgotPasswordResponse result = apiInstance.forgotPassword(userId, sendEmail);
            System.out.println(result);
        } catch (ApiException e) {
            System.err.println("Exception when calling UserCredApi#forgotPassword");
            System.err.println("Status code: " + e.getCode());
            System.err.println("Reason: " + e.getResponseBody());
            System.err.println("Response headers: " + e.getResponseHeaders());
            e.printStackTrace();
        }
    }
}
```

### Parameters


| Name | Type | Description  | Notes |
|------------- | ------------- | ------------- | -------------|
| **userId** | **String**| ID of an existing Okta user | |
| **sendEmail** | **Boolean**| Sends a forgot password email to the User if &#x60;true&#x60; | [optional] [default to true] |

### Return type

[**ForgotPasswordResponse**](ForgotPasswordResponse.md)

### Authorization

[apiToken](../README.md#apiToken), [oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json


### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **200** | Reset URL |  -  |
| **403** | Forbidden |  -  |
| **404** | Not Found |  -  |
| **429** | Too Many Requests |  -  |


## forgotPasswordSetNewPassword

> UserCredentials forgotPasswordSetNewPassword(userId, userCredentials, sendEmail)

Reset Password with Recovery Question

Resets the User&#39;s password to the specified password if the provided answer to the recovery question is correct. You must include the Recovery Question answer with the submission.

### Example

```java
// Import classes:
import com.okta.sdk.resource.client.ApiClient;
import com.okta.sdk.resource.client.ApiException;
import com.okta.sdk.resource.client.Configuration;
import com.okta.sdk.resource.client.auth.*;
import com.okta.sdk.resource.client.models.*;
import com.okta.sdk.resource.api.UserCredApi;

public class Example {
    public static void main(String[] args) {
        ApiClient defaultClient = Configuration.getDefaultApiClient();
        defaultClient.setBasePath("https://subdomain.okta.com");
        
        // Configure API key authorization: apiToken
        ApiKeyAuth apiToken = (ApiKeyAuth) defaultClient.getAuthentication("apiToken");
        apiToken.setApiKey("YOUR API KEY");
        // Uncomment the following line to set a prefix for the API key, e.g. "Token" (defaults to null)
        //apiToken.setApiKeyPrefix("Token");

        // Configure OAuth2 access token for authorization: oauth2
        OAuth oauth2 = (OAuth) defaultClient.getAuthentication("oauth2");
        oauth2.setAccessToken("YOUR ACCESS TOKEN");

        UserCredApi apiInstance = new UserCredApi(defaultClient);
        String userId = "00ub0oNGTSWTBKOLGLNR"; // String | ID of an existing Okta user
        UserCredentials userCredentials = new UserCredentials(); // UserCredentials | 
        Boolean sendEmail = true; // Boolean | 
        try {
            UserCredentials result = apiInstance.forgotPasswordSetNewPassword(userId, userCredentials, sendEmail);
            System.out.println(result);
        } catch (ApiException e) {
            System.err.println("Exception when calling UserCredApi#forgotPasswordSetNewPassword");
            System.err.println("Status code: " + e.getCode());
            System.err.println("Reason: " + e.getResponseBody());
            System.err.println("Response headers: " + e.getResponseHeaders());
            e.printStackTrace();
        }
    }
}
```

### Parameters


| Name | Type | Description  | Notes |
|------------- | ------------- | ------------- | -------------|
| **userId** | **String**| ID of an existing Okta user | |
| **userCredentials** | [**UserCredentials**](UserCredentials.md)|  | |
| **sendEmail** | **Boolean**|  | [optional] [default to true] |

### Return type

[**UserCredentials**](UserCredentials.md)

### Authorization

[apiToken](../README.md#apiToken), [oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: application/json
- **Accept**: application/json


### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **200** | Credentials |  -  |
| **400** | Bad Request |  -  |
| **403** | Forbidden |  -  |
| **404** | Not Found |  -  |
| **429** | Too Many Requests |  -  |


## resetPassword

> ResetPasswordToken resetPassword(userId, sendEmail, revokeSessions)

Reset password

Resets password. Generates a one-time token (OTT) that you can use to reset a User&#39;s password. You can automatically email the OTT link to the User or return the OTT to the API caller and distribute using a custom flow.  This operation transitions the User to the &#x60;RECOVERY&#x60; status. The User is then not able to sign in or initiate a forgot password flow until they complete the reset flow.  This operation provides an option to delete all the User&#39;s sessions. However, if the request is made in the context of a session owned by the specified User, that session isn&#39;t cleared. &gt; **Note:** You can also use this API to convert a User with the Okta Credential Provider to use a Federated Provider. After this conversion, the User can&#39;t directly sign in with a password. &gt; To convert a federated User back to an Okta User, use the default API call.  If an email address is associated with multiple Users, keep in mind the following to ensure a successful password recovery lookup:   * Okta no longer includes deactivated Users in the lookup.   * The lookup searches sign-in IDs first, then primary email addresses, and then secondary email addresses.   If &#x60;sendEmail&#x60; is &#x60;false&#x60;, returns a link for the User to reset their password.

### Example

```java
// Import classes:
import com.okta.sdk.resource.client.ApiClient;
import com.okta.sdk.resource.client.ApiException;
import com.okta.sdk.resource.client.Configuration;
import com.okta.sdk.resource.client.auth.*;
import com.okta.sdk.resource.client.models.*;
import com.okta.sdk.resource.api.UserCredApi;

public class Example {
    public static void main(String[] args) {
        ApiClient defaultClient = Configuration.getDefaultApiClient();
        defaultClient.setBasePath("https://subdomain.okta.com");
        
        // Configure API key authorization: apiToken
        ApiKeyAuth apiToken = (ApiKeyAuth) defaultClient.getAuthentication("apiToken");
        apiToken.setApiKey("YOUR API KEY");
        // Uncomment the following line to set a prefix for the API key, e.g. "Token" (defaults to null)
        //apiToken.setApiKeyPrefix("Token");

        // Configure OAuth2 access token for authorization: oauth2
        OAuth oauth2 = (OAuth) defaultClient.getAuthentication("oauth2");
        oauth2.setAccessToken("YOUR ACCESS TOKEN");

        UserCredApi apiInstance = new UserCredApi(defaultClient);
        String userId = "00ub0oNGTSWTBKOLGLNR"; // String | ID of an existing Okta user
        Boolean sendEmail = true; // Boolean | 
        Boolean revokeSessions = false; // Boolean | Revokes all User sessions, except for the current session, if set to `true`
        try {
            ResetPasswordToken result = apiInstance.resetPassword(userId, sendEmail, revokeSessions);
            System.out.println(result);
        } catch (ApiException e) {
            System.err.println("Exception when calling UserCredApi#resetPassword");
            System.err.println("Status code: " + e.getCode());
            System.err.println("Reason: " + e.getResponseBody());
            System.err.println("Response headers: " + e.getResponseHeaders());
            e.printStackTrace();
        }
    }
}
```

### Parameters


| Name | Type | Description  | Notes |
|------------- | ------------- | ------------- | -------------|
| **userId** | **String**| ID of an existing Okta user | |
| **sendEmail** | **Boolean**|  | |
| **revokeSessions** | **Boolean**| Revokes all User sessions, except for the current session, if set to &#x60;true&#x60; | [optional] [default to false] |

### Return type

[**ResetPasswordToken**](ResetPasswordToken.md)

### Authorization

[apiToken](../README.md#apiToken), [oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json


### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **200** | Success |  -  |
| **403** | Forbidden |  -  |
| **404** | Not Found |  -  |
| **429** | Too Many Requests |  -  |

