# UserFactorApi

All URIs are relative to *https://subdomain.okta.com*

| Method | HTTP request | Description |
|------------- | ------------- | -------------|
| [**activateFactor**](UserFactorApi.md#activateFactor) | **POST** /api/v1/users/{userId}/factors/{factorId}/lifecycle/activate | Activate a Factor |
| [**enrollFactor**](UserFactorApi.md#enrollFactor) | **POST** /api/v1/users/{userId}/factors | Enroll a Factor |
| [**getFactor**](UserFactorApi.md#getFactor) | **GET** /api/v1/users/{userId}/factors/{factorId} | Retrieve a Factor |
| [**getFactorTransactionStatus**](UserFactorApi.md#getFactorTransactionStatus) | **GET** /api/v1/users/{userId}/factors/{factorId}/transactions/{transactionId} | Retrieve a Factor transaction status |
| [**getYubikeyOtpTokenById**](UserFactorApi.md#getYubikeyOtpTokenById) | **GET** /api/v1/org/factors/yubikey_token/tokens/{tokenId} | Retrieve a YubiKey OTP Token |
| [**listFactors**](UserFactorApi.md#listFactors) | **GET** /api/v1/users/{userId}/factors | List all enrolled Factors |
| [**listSupportedFactors**](UserFactorApi.md#listSupportedFactors) | **GET** /api/v1/users/{userId}/factors/catalog | List all supported Factors |
| [**listSupportedSecurityQuestions**](UserFactorApi.md#listSupportedSecurityQuestions) | **GET** /api/v1/users/{userId}/factors/questions | List all supported Security Questions |
| [**listYubikeyOtpTokens**](UserFactorApi.md#listYubikeyOtpTokens) | **GET** /api/v1/org/factors/yubikey_token/tokens | List all YubiKey OTP Tokens |
| [**resendEnrollFactor**](UserFactorApi.md#resendEnrollFactor) | **POST** /api/v1/users/{userId}/factors/{factorId}/resend | Resend a Factor enrollment |
| [**unenrollFactor**](UserFactorApi.md#unenrollFactor) | **DELETE** /api/v1/users/{userId}/factors/{factorId} | Unenroll a Factor |
| [**uploadYubikeyOtpTokenSeed**](UserFactorApi.md#uploadYubikeyOtpTokenSeed) | **POST** /api/v1/org/factors/yubikey_token/tokens | Upload a YubiKey OTP Seed |
| [**verifyFactor**](UserFactorApi.md#verifyFactor) | **POST** /api/v1/users/{userId}/factors/{factorId}/verify | Verify a Factor |



## activateFactor

> UserFactorActivateResponse activateFactor(userId, factorId, body)

Activate a Factor

Activates a Factor. Some Factors (&#x60;call&#x60;, &#x60;email&#x60;, &#x60;push&#x60;, &#x60;sms&#x60;, &#x60;token:software:totp&#x60;, &#x60;u2f&#x60;, and &#x60;webauthn&#x60;) require activation to complete the enrollment process.  Okta enforces a rate limit of five activation attempts within five minutes. After a user exceeds the rate limit, Okta returns an error message.  &gt; **Note**: If the user exceeds their SMS, call, or email factor activate rate limit, then an OTP resend request (&#x60;/api/v1/users/${userId}}/factors/${factorId}/resend&#x60;) isn&#39;t allowed for the same Factor.

### Example

```java
// Import classes:
import com.okta.sdk.resource.client.ApiClient;
import com.okta.sdk.resource.client.ApiException;
import com.okta.sdk.resource.client.Configuration;
import com.okta.sdk.resource.client.auth.*;
import com.okta.sdk.resource.client.models.*;
import com.okta.sdk.resource.api.UserFactorApi;

public class Example {
    public static void main(String[] args) {
        ApiClient defaultClient = Configuration.getDefaultApiClient();
        defaultClient.setBasePath("https://subdomain.okta.com");
        
        // Configure API key authorization: apiToken
        ApiKeyAuth apiToken = (ApiKeyAuth) defaultClient.getAuthentication("apiToken");
        apiToken.setApiKey("YOUR API KEY");
        // Uncomment the following line to set a prefix for the API key, e.g. "Token" (defaults to null)
        //apiToken.setApiKeyPrefix("Token");

        // Configure OAuth2 access token for authorization: oauth2
        OAuth oauth2 = (OAuth) defaultClient.getAuthentication("oauth2");
        oauth2.setAccessToken("YOUR ACCESS TOKEN");

        UserFactorApi apiInstance = new UserFactorApi(defaultClient);
        String userId = "00ub0oNGTSWTBKOLGLNR"; // String | ID of an existing Okta user
        String factorId = "zAgrsaBe0wVGRugDYtdv"; // String | ID of an existing user Factor
        UserFactorActivateRequest body = new UserFactorActivateRequest(); // UserFactorActivateRequest | 
        try {
            UserFactorActivateResponse result = apiInstance.activateFactor(userId, factorId, body);
            System.out.println(result);
        } catch (ApiException e) {
            System.err.println("Exception when calling UserFactorApi#activateFactor");
            System.err.println("Status code: " + e.getCode());
            System.err.println("Reason: " + e.getResponseBody());
            System.err.println("Response headers: " + e.getResponseHeaders());
            e.printStackTrace();
        }
    }
}
```

### Parameters


| Name | Type | Description  | Notes |
|------------- | ------------- | ------------- | -------------|
| **userId** | **String**| ID of an existing Okta user | |
| **factorId** | **String**| ID of an existing user Factor | |
| **body** | [**UserFactorActivateRequest**](UserFactorActivateRequest.md)|  | [optional] |

### Return type

[**UserFactorActivateResponse**](UserFactorActivateResponse.md)

### Authorization

[apiToken](../README.md#apiToken), [oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: application/json
- **Accept**: application/json


### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **200** | Success |  -  |
| **400** | Bad Request |  -  |
| **403** | Forbidden |  -  |
| **404** | Not Found |  -  |
| **429** | Too Many Requests |  -  |


## enrollFactor

> UserFactor enrollFactor(userId, body, updatePhone, templateId, tokenLifetimeSeconds, activate, acceptLanguage)

Enroll a Factor

Enrolls a supported Factor for the specified user  &gt; **Note:** All responses return the enrolled Factor with a status of either &#x60;PENDING_ACTIVATION&#x60;&#x60; or &#x60;ACTIVE&#x60;.  #### Additional SMS/Call Factor information * **Rate limits**: Okta may return a &#x60;429 Too Many Requests&#x60; status code if you attempt to resend an SMS or a voice call challenge (OTP) within the same time window. The current [rate limit](https://developer.okta.com/docs/reference/rate-limits/) is one SMS/CALL challenge per phone number every 30 seconds. * **Existing phone numbers**: Okta may return a &#x60;400 Bad Request&#x60; status code if a user attempts to enroll with a different phone number when the user has an existing mobile phone or has an existing phone with voice call capability. A user can enroll only one mobile phone for &#x60;sms&#x60; and enroll only one voice call capable phone for &#x60;call&#x60; factor.  #### Additional WebAuthn Factor information **Enroll WebAuthn response parameters** * For detailed information on the Webauthn standard, including an up-to-date list of supported browsers, see [webauthn.me](https://a0.to/webauthnme-okta-docs).  * In the enroll API response, the &#x60;response._embedded.activation&#x60; object contains properties used to help the client to create a new WebAuthn credential for use with Okta. See the [WebAuthn spec for PublicKeyCredentialCreationOptions](https://www.w3.org/TR/webauthn/#dictionary-makecredentialoptions).  #### Additional Custom TOTP Factor information  **Enroll Custom TOTP Factor** * The enrollment process involves passing both the &#x60;factorProfileId&#x60; and &#x60;sharedSecret&#x60; properties for a token.  * A Factor Profile represents a particular configuration of the Custom TOTP factor. It includes certain properties that match the hardware token that end users possess, such as the HMAC algorithm, passcode length, and time interval. There can be multiple Custom TOTP factor profiles per org, but users can only enroll in one Custom TOTP factor. Admins can [create Custom TOTP factor profiles](https://help.okta.com/okta_help.htm?id&#x3D;ext-mfa-totp) in the Admin Console. Then, copy the &#x60;factorProfileId&#x60; from the Admin Console into the API request.  * &lt;x-lifecycle class&#x3D;\&quot;oie\&quot;&gt;&lt;/x-lifecycle&gt; For Custom TOTP enrollment, Okta automaticaly enrolls a user with a &#x60;token:software:totp&#x60; factor and the &#x60;push&#x60; factor if the user isn&#39;t currently enrolled with these factors.

### Example

```java
// Import classes:
import com.okta.sdk.resource.client.ApiClient;
import com.okta.sdk.resource.client.ApiException;
import com.okta.sdk.resource.client.Configuration;
import com.okta.sdk.resource.client.auth.*;
import com.okta.sdk.resource.client.models.*;
import com.okta.sdk.resource.api.UserFactorApi;

public class Example {
    public static void main(String[] args) {
        ApiClient defaultClient = Configuration.getDefaultApiClient();
        defaultClient.setBasePath("https://subdomain.okta.com");
        
        // Configure API key authorization: apiToken
        ApiKeyAuth apiToken = (ApiKeyAuth) defaultClient.getAuthentication("apiToken");
        apiToken.setApiKey("YOUR API KEY");
        // Uncomment the following line to set a prefix for the API key, e.g. "Token" (defaults to null)
        //apiToken.setApiKeyPrefix("Token");

        // Configure OAuth2 access token for authorization: oauth2
        OAuth oauth2 = (OAuth) defaultClient.getAuthentication("oauth2");
        oauth2.setAccessToken("YOUR ACCESS TOKEN");

        UserFactorApi apiInstance = new UserFactorApi(defaultClient);
        String userId = "00ub0oNGTSWTBKOLGLNR"; // String | ID of an existing Okta user
        UserFactor body = new UserFactor(); // UserFactor | Factor
        Boolean updatePhone = false; // Boolean | If `true`, indicates that you are replacing the currently registered phone number for the specified user. This parameter is ignored if the existing phone number is used by an activated Factor.
        String templateId = "cstk2flOtuCMDJK4b0g3"; // String | ID of an existing custom SMS template. See the [SMS Templates API](../Template). This parameter is only used by `sms` Factors. If the provided ID doesn't exist, the default template is used instead.
        Integer tokenLifetimeSeconds = 300; // Integer | Defines how long the token remains valid
        Boolean activate = false; // Boolean | If `true`, the factor is immediately activated as part of the enrollment. An activation process isn't required. Currently auto-activation is supported by `sms`, `call`, `email` and `token:hotp` (Custom TOTP) Factor.
        String acceptLanguage = "fr"; // String | An ISO 639-1 two-letter language code that defines a localized message to send. This parameter is only used by `sms` Factors. If a localized message doesn't exist or the `templateId` is incorrect, the default template is used instead.
        try {
            UserFactor result = apiInstance.enrollFactor(userId, body, updatePhone, templateId, tokenLifetimeSeconds, activate, acceptLanguage);
            System.out.println(result);
        } catch (ApiException e) {
            System.err.println("Exception when calling UserFactorApi#enrollFactor");
            System.err.println("Status code: " + e.getCode());
            System.err.println("Reason: " + e.getResponseBody());
            System.err.println("Response headers: " + e.getResponseHeaders());
            e.printStackTrace();
        }
    }
}
```

### Parameters


| Name | Type | Description  | Notes |
|------------- | ------------- | ------------- | -------------|
| **userId** | **String**| ID of an existing Okta user | |
| **body** | [**UserFactor**](UserFactor.md)| Factor | |
| **updatePhone** | **Boolean**| If &#x60;true&#x60;, indicates that you are replacing the currently registered phone number for the specified user. This parameter is ignored if the existing phone number is used by an activated Factor. | [optional] [default to false] |
| **templateId** | **String**| ID of an existing custom SMS template. See the [SMS Templates API](../Template). This parameter is only used by &#x60;sms&#x60; Factors. If the provided ID doesn&#39;t exist, the default template is used instead. | [optional] |
| **tokenLifetimeSeconds** | **Integer**| Defines how long the token remains valid | [optional] [default to 300] |
| **activate** | **Boolean**| If &#x60;true&#x60;, the factor is immediately activated as part of the enrollment. An activation process isn&#39;t required. Currently auto-activation is supported by &#x60;sms&#x60;, &#x60;call&#x60;, &#x60;email&#x60; and &#x60;token:hotp&#x60; (Custom TOTP) Factor. | [optional] [default to false] |
| **acceptLanguage** | **String**| An ISO 639-1 two-letter language code that defines a localized message to send. This parameter is only used by &#x60;sms&#x60; Factors. If a localized message doesn&#39;t exist or the &#x60;templateId&#x60; is incorrect, the default template is used instead. | [optional] |

### Return type

[**UserFactor**](UserFactor.md)

### Authorization

[apiToken](../README.md#apiToken), [oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: application/json
- **Accept**: application/json


### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **200** | Success |  -  |
| **400** | Bad Request |  -  |
| **403** | Forbidden |  -  |
| **404** | Not Found |  -  |
| **429** | Too Many Requests |  -  |


## getFactor

> UserFactor getFactor(userId, factorId)

Retrieve a Factor

Retrieves an existing Factor for the specified user

### Example

```java
// Import classes:
import com.okta.sdk.resource.client.ApiClient;
import com.okta.sdk.resource.client.ApiException;
import com.okta.sdk.resource.client.Configuration;
import com.okta.sdk.resource.client.auth.*;
import com.okta.sdk.resource.client.models.*;
import com.okta.sdk.resource.api.UserFactorApi;

public class Example {
    public static void main(String[] args) {
        ApiClient defaultClient = Configuration.getDefaultApiClient();
        defaultClient.setBasePath("https://subdomain.okta.com");
        
        // Configure API key authorization: apiToken
        ApiKeyAuth apiToken = (ApiKeyAuth) defaultClient.getAuthentication("apiToken");
        apiToken.setApiKey("YOUR API KEY");
        // Uncomment the following line to set a prefix for the API key, e.g. "Token" (defaults to null)
        //apiToken.setApiKeyPrefix("Token");

        // Configure OAuth2 access token for authorization: oauth2
        OAuth oauth2 = (OAuth) defaultClient.getAuthentication("oauth2");
        oauth2.setAccessToken("YOUR ACCESS TOKEN");

        UserFactorApi apiInstance = new UserFactorApi(defaultClient);
        String userId = "00ub0oNGTSWTBKOLGLNR"; // String | ID of an existing Okta user
        String factorId = "zAgrsaBe0wVGRugDYtdv"; // String | ID of an existing user Factor
        try {
            UserFactor result = apiInstance.getFactor(userId, factorId);
            System.out.println(result);
        } catch (ApiException e) {
            System.err.println("Exception when calling UserFactorApi#getFactor");
            System.err.println("Status code: " + e.getCode());
            System.err.println("Reason: " + e.getResponseBody());
            System.err.println("Response headers: " + e.getResponseHeaders());
            e.printStackTrace();
        }
    }
}
```

### Parameters


| Name | Type | Description  | Notes |
|------------- | ------------- | ------------- | -------------|
| **userId** | **String**| ID of an existing Okta user | |
| **factorId** | **String**| ID of an existing user Factor | |

### Return type

[**UserFactor**](UserFactor.md)

### Authorization

[apiToken](../README.md#apiToken), [oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json


### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **200** | Success |  -  |
| **403** | Forbidden |  -  |
| **404** | Not Found |  -  |
| **429** | Too Many Requests |  -  |


## getFactorTransactionStatus

> UserFactorPushTransaction getFactorTransactionStatus(userId, factorId, transactionId)

Retrieve a Factor transaction status

Retrieves the status of a &#x60;push&#x60; Factor verification transaction

### Example

```java
// Import classes:
import com.okta.sdk.resource.client.ApiClient;
import com.okta.sdk.resource.client.ApiException;
import com.okta.sdk.resource.client.Configuration;
import com.okta.sdk.resource.client.auth.*;
import com.okta.sdk.resource.client.models.*;
import com.okta.sdk.resource.api.UserFactorApi;

public class Example {
    public static void main(String[] args) {
        ApiClient defaultClient = Configuration.getDefaultApiClient();
        defaultClient.setBasePath("https://subdomain.okta.com");
        
        // Configure API key authorization: apiToken
        ApiKeyAuth apiToken = (ApiKeyAuth) defaultClient.getAuthentication("apiToken");
        apiToken.setApiKey("YOUR API KEY");
        // Uncomment the following line to set a prefix for the API key, e.g. "Token" (defaults to null)
        //apiToken.setApiKeyPrefix("Token");

        // Configure OAuth2 access token for authorization: oauth2
        OAuth oauth2 = (OAuth) defaultClient.getAuthentication("oauth2");
        oauth2.setAccessToken("YOUR ACCESS TOKEN");

        UserFactorApi apiInstance = new UserFactorApi(defaultClient);
        String userId = "00ub0oNGTSWTBKOLGLNR"; // String | ID of an existing Okta user
        String factorId = "zAgrsaBe0wVGRugDYtdv"; // String | ID of an existing user Factor
        String transactionId = "gPAQcN3NDjSGOCAeG2Jv"; // String | ID of an existing Factor verification transaction
        try {
            UserFactorPushTransaction result = apiInstance.getFactorTransactionStatus(userId, factorId, transactionId);
            System.out.println(result);
        } catch (ApiException e) {
            System.err.println("Exception when calling UserFactorApi#getFactorTransactionStatus");
            System.err.println("Status code: " + e.getCode());
            System.err.println("Reason: " + e.getResponseBody());
            System.err.println("Response headers: " + e.getResponseHeaders());
            e.printStackTrace();
        }
    }
}
```

### Parameters


| Name | Type | Description  | Notes |
|------------- | ------------- | ------------- | -------------|
| **userId** | **String**| ID of an existing Okta user | |
| **factorId** | **String**| ID of an existing user Factor | |
| **transactionId** | **String**| ID of an existing Factor verification transaction | |

### Return type

[**UserFactorPushTransaction**](UserFactorPushTransaction.md)

### Authorization

[apiToken](../README.md#apiToken), [oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json


### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **200** | Success |  -  |
| **403** | Forbidden |  -  |
| **404** | Not Found |  -  |
| **429** | Too Many Requests |  -  |


## getYubikeyOtpTokenById

> UserFactorYubikeyOtpToken getYubikeyOtpTokenById(tokenId)

Retrieve a YubiKey OTP Token

Retrieves the specified YubiKey OTP Token by &#x60;id&#x60;

### Example

```java
// Import classes:
import com.okta.sdk.resource.client.ApiClient;
import com.okta.sdk.resource.client.ApiException;
import com.okta.sdk.resource.client.Configuration;
import com.okta.sdk.resource.client.auth.*;
import com.okta.sdk.resource.client.models.*;
import com.okta.sdk.resource.api.UserFactorApi;

public class Example {
    public static void main(String[] args) {
        ApiClient defaultClient = Configuration.getDefaultApiClient();
        defaultClient.setBasePath("https://subdomain.okta.com");
        
        // Configure API key authorization: apiToken
        ApiKeyAuth apiToken = (ApiKeyAuth) defaultClient.getAuthentication("apiToken");
        apiToken.setApiKey("YOUR API KEY");
        // Uncomment the following line to set a prefix for the API key, e.g. "Token" (defaults to null)
        //apiToken.setApiKeyPrefix("Token");

        // Configure OAuth2 access token for authorization: oauth2
        OAuth oauth2 = (OAuth) defaultClient.getAuthentication("oauth2");
        oauth2.setAccessToken("YOUR ACCESS TOKEN");

        UserFactorApi apiInstance = new UserFactorApi(defaultClient);
        String tokenId = "ykkxdtCA1fKVxyu6R0g3"; // String | ID of a Yubikey token
        try {
            UserFactorYubikeyOtpToken result = apiInstance.getYubikeyOtpTokenById(tokenId);
            System.out.println(result);
        } catch (ApiException e) {
            System.err.println("Exception when calling UserFactorApi#getYubikeyOtpTokenById");
            System.err.println("Status code: " + e.getCode());
            System.err.println("Reason: " + e.getResponseBody());
            System.err.println("Response headers: " + e.getResponseHeaders());
            e.printStackTrace();
        }
    }
}
```

### Parameters


| Name | Type | Description  | Notes |
|------------- | ------------- | ------------- | -------------|
| **tokenId** | **String**| ID of a Yubikey token | |

### Return type

[**UserFactorYubikeyOtpToken**](UserFactorYubikeyOtpToken.md)

### Authorization

[apiToken](../README.md#apiToken), [oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json


### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **200** | Success |  -  |
| **403** | Forbidden |  -  |
| **404** | Not Found |  -  |
| **429** | Too Many Requests |  -  |


## listFactors

> List&lt;UserFactor&gt; listFactors(userId)

List all enrolled Factors

Lists all enrolled Factors for the specified user

### Example

```java
// Import classes:
import com.okta.sdk.resource.client.ApiClient;
import com.okta.sdk.resource.client.ApiException;
import com.okta.sdk.resource.client.Configuration;
import com.okta.sdk.resource.client.auth.*;
import com.okta.sdk.resource.client.models.*;
import com.okta.sdk.resource.api.UserFactorApi;

public class Example {
    public static void main(String[] args) {
        ApiClient defaultClient = Configuration.getDefaultApiClient();
        defaultClient.setBasePath("https://subdomain.okta.com");
        
        // Configure API key authorization: apiToken
        ApiKeyAuth apiToken = (ApiKeyAuth) defaultClient.getAuthentication("apiToken");
        apiToken.setApiKey("YOUR API KEY");
        // Uncomment the following line to set a prefix for the API key, e.g. "Token" (defaults to null)
        //apiToken.setApiKeyPrefix("Token");

        // Configure OAuth2 access token for authorization: oauth2
        OAuth oauth2 = (OAuth) defaultClient.getAuthentication("oauth2");
        oauth2.setAccessToken("YOUR ACCESS TOKEN");

        UserFactorApi apiInstance = new UserFactorApi(defaultClient);
        String userId = "00ub0oNGTSWTBKOLGLNR"; // String | ID of an existing Okta user
        try {
            List<UserFactor> result = apiInstance.listFactors(userId);
            System.out.println(result);
        } catch (ApiException e) {
            System.err.println("Exception when calling UserFactorApi#listFactors");
            System.err.println("Status code: " + e.getCode());
            System.err.println("Reason: " + e.getResponseBody());
            System.err.println("Response headers: " + e.getResponseHeaders());
            e.printStackTrace();
        }
    }
}
```

### Parameters


| Name | Type | Description  | Notes |
|------------- | ------------- | ------------- | -------------|
| **userId** | **String**| ID of an existing Okta user | |

### Return type

[**List&lt;UserFactor&gt;**](UserFactor.md)

### Authorization

[apiToken](../README.md#apiToken), [oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json


### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **200** | Success |  -  |
| **403** | Forbidden |  -  |
| **404** | Not Found |  -  |
| **429** | Too Many Requests |  -  |


## listSupportedFactors

> List&lt;UserFactorSupported&gt; listSupportedFactors(userId)

List all supported Factors

Lists all the supported Factors that can be enrolled for the specified user

### Example

```java
// Import classes:
import com.okta.sdk.resource.client.ApiClient;
import com.okta.sdk.resource.client.ApiException;
import com.okta.sdk.resource.client.Configuration;
import com.okta.sdk.resource.client.auth.*;
import com.okta.sdk.resource.client.models.*;
import com.okta.sdk.resource.api.UserFactorApi;

public class Example {
    public static void main(String[] args) {
        ApiClient defaultClient = Configuration.getDefaultApiClient();
        defaultClient.setBasePath("https://subdomain.okta.com");
        
        // Configure API key authorization: apiToken
        ApiKeyAuth apiToken = (ApiKeyAuth) defaultClient.getAuthentication("apiToken");
        apiToken.setApiKey("YOUR API KEY");
        // Uncomment the following line to set a prefix for the API key, e.g. "Token" (defaults to null)
        //apiToken.setApiKeyPrefix("Token");

        // Configure OAuth2 access token for authorization: oauth2
        OAuth oauth2 = (OAuth) defaultClient.getAuthentication("oauth2");
        oauth2.setAccessToken("YOUR ACCESS TOKEN");

        UserFactorApi apiInstance = new UserFactorApi(defaultClient);
        String userId = "00ub0oNGTSWTBKOLGLNR"; // String | ID of an existing Okta user
        try {
            List<UserFactorSupported> result = apiInstance.listSupportedFactors(userId);
            System.out.println(result);
        } catch (ApiException e) {
            System.err.println("Exception when calling UserFactorApi#listSupportedFactors");
            System.err.println("Status code: " + e.getCode());
            System.err.println("Reason: " + e.getResponseBody());
            System.err.println("Response headers: " + e.getResponseHeaders());
            e.printStackTrace();
        }
    }
}
```

### Parameters


| Name | Type | Description  | Notes |
|------------- | ------------- | ------------- | -------------|
| **userId** | **String**| ID of an existing Okta user | |

### Return type

[**List&lt;UserFactorSupported&gt;**](UserFactorSupported.md)

### Authorization

[apiToken](../README.md#apiToken), [oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json


### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **200** | Success |  -  |
| **403** | Forbidden |  -  |
| **404** | Not Found |  -  |
| **429** | Too Many Requests |  -  |


## listSupportedSecurityQuestions

> List&lt;UserFactorSecurityQuestionProfile&gt; listSupportedSecurityQuestions(userId)

List all supported Security Questions

Lists all available Security Questions for the specified user

### Example

```java
// Import classes:
import com.okta.sdk.resource.client.ApiClient;
import com.okta.sdk.resource.client.ApiException;
import com.okta.sdk.resource.client.Configuration;
import com.okta.sdk.resource.client.auth.*;
import com.okta.sdk.resource.client.models.*;
import com.okta.sdk.resource.api.UserFactorApi;

public class Example {
    public static void main(String[] args) {
        ApiClient defaultClient = Configuration.getDefaultApiClient();
        defaultClient.setBasePath("https://subdomain.okta.com");
        
        // Configure API key authorization: apiToken
        ApiKeyAuth apiToken = (ApiKeyAuth) defaultClient.getAuthentication("apiToken");
        apiToken.setApiKey("YOUR API KEY");
        // Uncomment the following line to set a prefix for the API key, e.g. "Token" (defaults to null)
        //apiToken.setApiKeyPrefix("Token");

        UserFactorApi apiInstance = new UserFactorApi(defaultClient);
        String userId = "00ub0oNGTSWTBKOLGLNR"; // String | ID of an existing Okta user
        try {
            List<UserFactorSecurityQuestionProfile> result = apiInstance.listSupportedSecurityQuestions(userId);
            System.out.println(result);
        } catch (ApiException e) {
            System.err.println("Exception when calling UserFactorApi#listSupportedSecurityQuestions");
            System.err.println("Status code: " + e.getCode());
            System.err.println("Reason: " + e.getResponseBody());
            System.err.println("Response headers: " + e.getResponseHeaders());
            e.printStackTrace();
        }
    }
}
```

### Parameters


| Name | Type | Description  | Notes |
|------------- | ------------- | ------------- | -------------|
| **userId** | **String**| ID of an existing Okta user | |

### Return type

[**List&lt;UserFactorSecurityQuestionProfile&gt;**](UserFactorSecurityQuestionProfile.md)

### Authorization

[apiToken](../README.md#apiToken)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json


### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **200** | Success |  -  |
| **403** | Forbidden |  -  |
| **404** | Not Found |  -  |
| **429** | Too Many Requests |  -  |


## listYubikeyOtpTokens

> List&lt;UserFactorYubikeyOtpToken&gt; listYubikeyOtpTokens(after, expand, filter, forDownload, limit, sortBy, sortOrder)

List all YubiKey OTP Tokens

Lists all YubiKey OTP Tokens

### Example

```java
// Import classes:
import com.okta.sdk.resource.client.ApiClient;
import com.okta.sdk.resource.client.ApiException;
import com.okta.sdk.resource.client.Configuration;
import com.okta.sdk.resource.client.auth.*;
import com.okta.sdk.resource.client.models.*;
import com.okta.sdk.resource.api.UserFactorApi;

public class Example {
    public static void main(String[] args) {
        ApiClient defaultClient = Configuration.getDefaultApiClient();
        defaultClient.setBasePath("https://subdomain.okta.com");
        
        // Configure API key authorization: apiToken
        ApiKeyAuth apiToken = (ApiKeyAuth) defaultClient.getAuthentication("apiToken");
        apiToken.setApiKey("YOUR API KEY");
        // Uncomment the following line to set a prefix for the API key, e.g. "Token" (defaults to null)
        //apiToken.setApiKeyPrefix("Token");

        // Configure OAuth2 access token for authorization: oauth2
        OAuth oauth2 = (OAuth) defaultClient.getAuthentication("oauth2");
        oauth2.setAccessToken("YOUR ACCESS TOKEN");

        UserFactorApi apiInstance = new UserFactorApi(defaultClient);
        String after = "after_example"; // String | Specifies the pagination cursor for the next page of tokens
        String expand = "expand_example"; // String | Embeds the [User](/openapi/okta-management/management/tag/User/) resource if the YubiKey Token is assigned to a user and `expand` is set to `user`
        String filter = "profile.email"; // String | The expression used to filter tokens
        Boolean forDownload = false; // Boolean | Returns tokens in a CSV to download instead of in the response. When you use this query parameter, the `limit` default changes to 1000.
        Integer limit = 20; // Integer | Specifies the number of results per page
        String sortBy = "profile.email"; // String | The value of how the tokens are sorted
        String sortOrder = "ASC"; // String | Specifies the sort order, either `ASC` or `DESC`
        try {
            List<UserFactorYubikeyOtpToken> result = apiInstance.listYubikeyOtpTokens(after, expand, filter, forDownload, limit, sortBy, sortOrder);
            System.out.println(result);
        } catch (ApiException e) {
            System.err.println("Exception when calling UserFactorApi#listYubikeyOtpTokens");
            System.err.println("Status code: " + e.getCode());
            System.err.println("Reason: " + e.getResponseBody());
            System.err.println("Response headers: " + e.getResponseHeaders());
            e.printStackTrace();
        }
    }
}
```

### Parameters


| Name | Type | Description  | Notes |
|------------- | ------------- | ------------- | -------------|
| **after** | **String**| Specifies the pagination cursor for the next page of tokens | [optional] |
| **expand** | **String**| Embeds the [User](/openapi/okta-management/management/tag/User/) resource if the YubiKey Token is assigned to a user and &#x60;expand&#x60; is set to &#x60;user&#x60; | [optional] |
| **filter** | **String**| The expression used to filter tokens | [optional] [enum: profile.email, profile.serial, activated, user.id, created, status, lastVerified] |
| **forDownload** | **Boolean**| Returns tokens in a CSV to download instead of in the response. When you use this query parameter, the &#x60;limit&#x60; default changes to 1000. | [optional] [default to false] |
| **limit** | **Integer**| Specifies the number of results per page | [optional] [default to 20] |
| **sortBy** | **String**| The value of how the tokens are sorted | [optional] [enum: profile.email, profile.serial, activated, user.id, created, status, lastVerified] |
| **sortOrder** | **String**| Specifies the sort order, either &#x60;ASC&#x60; or &#x60;DESC&#x60; | [optional] [enum: ASC, DESC] |

### Return type

[**List&lt;UserFactorYubikeyOtpToken&gt;**](UserFactorYubikeyOtpToken.md)

### Authorization

[apiToken](../README.md#apiToken), [oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json


### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **200** | Success |  -  |
| **403** | Forbidden |  -  |
| **404** | Not Found |  -  |
| **429** | Too Many Requests |  -  |


## resendEnrollFactor

> ResendUserFactor resendEnrollFactor(userId, factorId, resendUserFactor, templateId)

Resend a Factor enrollment

Resends an &#x60;sms&#x60;, &#x60;call&#x60;, or &#x60;email&#x60; factor challenge as part of an enrollment flow  For &#x60;call&#x60; and &#x60;sms&#x60; factors, Okta enforces a rate limit of one OTP challenge per device every 30 seconds. You can configure your &#x60;sms&#x60; and &#x60;call&#x60; factors to use a third-party telephony provider. See the [Telephony inline hook reference](https://developer.okta.com/docs/reference/telephony-hook/). Okta round-robins between SMS providers with every resend request to help ensure delivery of an SMS and Call OTPs across different carriers.  &gt; **Note**: Resend operations aren&#39;t allowed after a factor exceeds the activation rate limit. See [Activate a Factor](./#tag/UserFactor/operation/activateFactor).

### Example

```java
// Import classes:
import com.okta.sdk.resource.client.ApiClient;
import com.okta.sdk.resource.client.ApiException;
import com.okta.sdk.resource.client.Configuration;
import com.okta.sdk.resource.client.auth.*;
import com.okta.sdk.resource.client.models.*;
import com.okta.sdk.resource.api.UserFactorApi;

public class Example {
    public static void main(String[] args) {
        ApiClient defaultClient = Configuration.getDefaultApiClient();
        defaultClient.setBasePath("https://subdomain.okta.com");
        
        // Configure API key authorization: apiToken
        ApiKeyAuth apiToken = (ApiKeyAuth) defaultClient.getAuthentication("apiToken");
        apiToken.setApiKey("YOUR API KEY");
        // Uncomment the following line to set a prefix for the API key, e.g. "Token" (defaults to null)
        //apiToken.setApiKeyPrefix("Token");

        // Configure OAuth2 access token for authorization: oauth2
        OAuth oauth2 = (OAuth) defaultClient.getAuthentication("oauth2");
        oauth2.setAccessToken("YOUR ACCESS TOKEN");

        UserFactorApi apiInstance = new UserFactorApi(defaultClient);
        String userId = "00ub0oNGTSWTBKOLGLNR"; // String | ID of an existing Okta user
        String factorId = "zAgrsaBe0wVGRugDYtdv"; // String | ID of an existing user Factor
        ResendUserFactor resendUserFactor = new ResendUserFactor(); // ResendUserFactor | 
        String templateId = "cstk2flOtuCMDJK4b0g3"; // String | ID of an existing custom SMS template. See the [SMS Templates API](../Template). This parameter is only used by `sms` Factors.
        try {
            ResendUserFactor result = apiInstance.resendEnrollFactor(userId, factorId, resendUserFactor, templateId);
            System.out.println(result);
        } catch (ApiException e) {
            System.err.println("Exception when calling UserFactorApi#resendEnrollFactor");
            System.err.println("Status code: " + e.getCode());
            System.err.println("Reason: " + e.getResponseBody());
            System.err.println("Response headers: " + e.getResponseHeaders());
            e.printStackTrace();
        }
    }
}
```

### Parameters


| Name | Type | Description  | Notes |
|------------- | ------------- | ------------- | -------------|
| **userId** | **String**| ID of an existing Okta user | |
| **factorId** | **String**| ID of an existing user Factor | |
| **resendUserFactor** | [**ResendUserFactor**](ResendUserFactor.md)|  | |
| **templateId** | **String**| ID of an existing custom SMS template. See the [SMS Templates API](../Template). This parameter is only used by &#x60;sms&#x60; Factors. | [optional] |

### Return type

[**ResendUserFactor**](ResendUserFactor.md)

### Authorization

[apiToken](../README.md#apiToken), [oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: application/json
- **Accept**: application/json


### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **200** | Success |  -  |
| **400** | Bad Request |  -  |
| **403** | Forbidden |  -  |
| **404** | Not Found |  -  |
| **429** | Too Many Requests |  -  |


## unenrollFactor

> unenrollFactor(userId, factorId, removeRecoveryEnrollment)

Unenroll a Factor

Unenrolls an existing Factor for the specified user. This allows the user to enroll a new Factor.  &gt; **Note**: If you unenroll the &#x60;push&#x60; or the &#x60;signed_nonce&#x60; Factors, Okta also unenrolls any other &#x60;totp&#x60;, &#x60;signed_nonce&#x60;, or Okta Verify &#x60;push&#x60; Factors associated with the user.

### Example

```java
// Import classes:
import com.okta.sdk.resource.client.ApiClient;
import com.okta.sdk.resource.client.ApiException;
import com.okta.sdk.resource.client.Configuration;
import com.okta.sdk.resource.client.auth.*;
import com.okta.sdk.resource.client.models.*;
import com.okta.sdk.resource.api.UserFactorApi;

public class Example {
    public static void main(String[] args) {
        ApiClient defaultClient = Configuration.getDefaultApiClient();
        defaultClient.setBasePath("https://subdomain.okta.com");
        
        // Configure API key authorization: apiToken
        ApiKeyAuth apiToken = (ApiKeyAuth) defaultClient.getAuthentication("apiToken");
        apiToken.setApiKey("YOUR API KEY");
        // Uncomment the following line to set a prefix for the API key, e.g. "Token" (defaults to null)
        //apiToken.setApiKeyPrefix("Token");

        // Configure OAuth2 access token for authorization: oauth2
        OAuth oauth2 = (OAuth) defaultClient.getAuthentication("oauth2");
        oauth2.setAccessToken("YOUR ACCESS TOKEN");

        UserFactorApi apiInstance = new UserFactorApi(defaultClient);
        String userId = "00ub0oNGTSWTBKOLGLNR"; // String | ID of an existing Okta user
        String factorId = "zAgrsaBe0wVGRugDYtdv"; // String | ID of an existing user Factor
        Boolean removeRecoveryEnrollment = false; // Boolean | If `true`, removes the phone number as both a recovery method and a Factor. This parameter is only used for the `sms` and `call` Factors.
        try {
            apiInstance.unenrollFactor(userId, factorId, removeRecoveryEnrollment);
        } catch (ApiException e) {
            System.err.println("Exception when calling UserFactorApi#unenrollFactor");
            System.err.println("Status code: " + e.getCode());
            System.err.println("Reason: " + e.getResponseBody());
            System.err.println("Response headers: " + e.getResponseHeaders());
            e.printStackTrace();
        }
    }
}
```

### Parameters


| Name | Type | Description  | Notes |
|------------- | ------------- | ------------- | -------------|
| **userId** | **String**| ID of an existing Okta user | |
| **factorId** | **String**| ID of an existing user Factor | |
| **removeRecoveryEnrollment** | **Boolean**| If &#x60;true&#x60;, removes the phone number as both a recovery method and a Factor. This parameter is only used for the &#x60;sms&#x60; and &#x60;call&#x60; Factors. | [optional] [default to false] |

### Return type

null (empty response body)

### Authorization

[apiToken](../README.md#apiToken), [oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json


### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **204** | No Content |  -  |
| **403** | Forbidden |  -  |
| **404** | Not Found |  -  |
| **429** | Too Many Requests |  -  |


## uploadYubikeyOtpTokenSeed

> UserFactorYubikeyOtpToken uploadYubikeyOtpTokenSeed(uploadYubikeyOtpTokenSeedRequest, after, expand, filter, forDownload, limit, sortBy, sortOrder)

Upload a YubiKey OTP Seed

Uploads a seed for a user to enroll a YubiKey OTP

### Example

```java
// Import classes:
import com.okta.sdk.resource.client.ApiClient;
import com.okta.sdk.resource.client.ApiException;
import com.okta.sdk.resource.client.Configuration;
import com.okta.sdk.resource.client.auth.*;
import com.okta.sdk.resource.client.models.*;
import com.okta.sdk.resource.api.UserFactorApi;

public class Example {
    public static void main(String[] args) {
        ApiClient defaultClient = Configuration.getDefaultApiClient();
        defaultClient.setBasePath("https://subdomain.okta.com");
        
        // Configure API key authorization: apiToken
        ApiKeyAuth apiToken = (ApiKeyAuth) defaultClient.getAuthentication("apiToken");
        apiToken.setApiKey("YOUR API KEY");
        // Uncomment the following line to set a prefix for the API key, e.g. "Token" (defaults to null)
        //apiToken.setApiKeyPrefix("Token");

        // Configure OAuth2 access token for authorization: oauth2
        OAuth oauth2 = (OAuth) defaultClient.getAuthentication("oauth2");
        oauth2.setAccessToken("YOUR ACCESS TOKEN");

        UserFactorApi apiInstance = new UserFactorApi(defaultClient);
        UploadYubikeyOtpTokenSeedRequest uploadYubikeyOtpTokenSeedRequest = new UploadYubikeyOtpTokenSeedRequest(); // UploadYubikeyOtpTokenSeedRequest | 
        String after = "after_example"; // String | Specifies the pagination cursor for the next page of tokens
        String expand = "expand_example"; // String | Embeds the [User](/openapi/okta-management/management/tag/User/) resource if the YubiKey Token is assigned to a user and `expand` is set to `user`
        String filter = "profile.email"; // String | The expression used to filter tokens
        Boolean forDownload = false; // Boolean | Returns tokens in a CSV to download instead of in the response. When you use this query parameter, the `limit` default changes to 1000.
        Integer limit = 20; // Integer | Specifies the number of results per page
        String sortBy = "profile.email"; // String | The value of how the tokens are sorted
        String sortOrder = "ASC"; // String | Specifies the sort order, either `ASC` or `DESC`
        try {
            UserFactorYubikeyOtpToken result = apiInstance.uploadYubikeyOtpTokenSeed(uploadYubikeyOtpTokenSeedRequest, after, expand, filter, forDownload, limit, sortBy, sortOrder);
            System.out.println(result);
        } catch (ApiException e) {
            System.err.println("Exception when calling UserFactorApi#uploadYubikeyOtpTokenSeed");
            System.err.println("Status code: " + e.getCode());
            System.err.println("Reason: " + e.getResponseBody());
            System.err.println("Response headers: " + e.getResponseHeaders());
            e.printStackTrace();
        }
    }
}
```

### Parameters


| Name | Type | Description  | Notes |
|------------- | ------------- | ------------- | -------------|
| **uploadYubikeyOtpTokenSeedRequest** | [**UploadYubikeyOtpTokenSeedRequest**](UploadYubikeyOtpTokenSeedRequest.md)|  | |
| **after** | **String**| Specifies the pagination cursor for the next page of tokens | [optional] |
| **expand** | **String**| Embeds the [User](/openapi/okta-management/management/tag/User/) resource if the YubiKey Token is assigned to a user and &#x60;expand&#x60; is set to &#x60;user&#x60; | [optional] |
| **filter** | **String**| The expression used to filter tokens | [optional] [enum: profile.email, profile.serial, activated, user.id, created, status, lastVerified] |
| **forDownload** | **Boolean**| Returns tokens in a CSV to download instead of in the response. When you use this query parameter, the &#x60;limit&#x60; default changes to 1000. | [optional] [default to false] |
| **limit** | **Integer**| Specifies the number of results per page | [optional] [default to 20] |
| **sortBy** | **String**| The value of how the tokens are sorted | [optional] [enum: profile.email, profile.serial, activated, user.id, created, status, lastVerified] |
| **sortOrder** | **String**| Specifies the sort order, either &#x60;ASC&#x60; or &#x60;DESC&#x60; | [optional] [enum: ASC, DESC] |

### Return type

[**UserFactorYubikeyOtpToken**](UserFactorYubikeyOtpToken.md)

### Authorization

[apiToken](../README.md#apiToken), [oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: application/json
- **Accept**: application/json


### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **200** | Success |  -  |
| **400** | Bad Request |  -  |
| **403** | Forbidden |  -  |
| **404** | Not Found |  -  |
| **429** | Too Many Requests |  -  |


## verifyFactor

> UserFactorVerifyResponse verifyFactor(userId, factorId, templateId, tokenLifetimeSeconds, xForwardedFor, userAgent, acceptLanguage, body)

Verify a Factor

Verifies an OTP for a Factor. Some Factors (&#x60;call&#x60;, &#x60;email&#x60;, &#x60;push&#x60;, &#x60;sms&#x60;, &#x60;u2f&#x60;, and &#x60;webauthn&#x60;) must first issue a challenge before you can verify the Factor. Do this by making a request without a body. After a challenge is issued, make another request to verify the Factor.  **Note**: To verify a &#x60;push&#x60; factor, use the **poll** link returned when you issue the challenge. See [Retrieve a Factor Transaction Status](/openapi/okta-management/management/tag/UserFactor/#tag/UserFactor/operation/getFactorTransactionStatus).

### Example

```java
// Import classes:
import com.okta.sdk.resource.client.ApiClient;
import com.okta.sdk.resource.client.ApiException;
import com.okta.sdk.resource.client.Configuration;
import com.okta.sdk.resource.client.auth.*;
import com.okta.sdk.resource.client.models.*;
import com.okta.sdk.resource.api.UserFactorApi;

public class Example {
    public static void main(String[] args) {
        ApiClient defaultClient = Configuration.getDefaultApiClient();
        defaultClient.setBasePath("https://subdomain.okta.com");
        
        // Configure API key authorization: apiToken
        ApiKeyAuth apiToken = (ApiKeyAuth) defaultClient.getAuthentication("apiToken");
        apiToken.setApiKey("YOUR API KEY");
        // Uncomment the following line to set a prefix for the API key, e.g. "Token" (defaults to null)
        //apiToken.setApiKeyPrefix("Token");

        // Configure OAuth2 access token for authorization: oauth2
        OAuth oauth2 = (OAuth) defaultClient.getAuthentication("oauth2");
        oauth2.setAccessToken("YOUR ACCESS TOKEN");

        UserFactorApi apiInstance = new UserFactorApi(defaultClient);
        String userId = "00ub0oNGTSWTBKOLGLNR"; // String | ID of an existing Okta user
        String factorId = "zAgrsaBe0wVGRugDYtdv"; // String | ID of an existing user Factor
        String templateId = "cstk2flOtuCMDJK4b0g3"; // String | ID of an existing custom SMS template. See the [SMS Templates API](../Template). This parameter is only used by `sms` Factors.
        Integer tokenLifetimeSeconds = 300; // Integer | Defines how long the token remains valid
        String xForwardedFor = "xForwardedFor_example"; // String | Public IP address for the user agent
        String userAgent = "userAgent_example"; // String | Type of user agent detected when the request is made. Required to verify `push` Factors.
        String acceptLanguage = "fr"; // String | An ISO 639-1 two-letter language code that defines a localized message to send. This parameter is only used by `sms` Factors. If a localized message doesn't exist or the `templateId` is incorrect, the default template is used instead.
        UserFactorVerifyRequest body = new UserFactorVerifyRequest(); // UserFactorVerifyRequest | Some Factors (`call`, `email`, `push`, `sms`, `u2f`, and `webauthn`) must first issue a challenge before you can verify the Factor. Do this by making a request without a body. After a challenge is issued, make another request to verify the Factor.
        try {
            UserFactorVerifyResponse result = apiInstance.verifyFactor(userId, factorId, templateId, tokenLifetimeSeconds, xForwardedFor, userAgent, acceptLanguage, body);
            System.out.println(result);
        } catch (ApiException e) {
            System.err.println("Exception when calling UserFactorApi#verifyFactor");
            System.err.println("Status code: " + e.getCode());
            System.err.println("Reason: " + e.getResponseBody());
            System.err.println("Response headers: " + e.getResponseHeaders());
            e.printStackTrace();
        }
    }
}
```

### Parameters


| Name | Type | Description  | Notes |
|------------- | ------------- | ------------- | -------------|
| **userId** | **String**| ID of an existing Okta user | |
| **factorId** | **String**| ID of an existing user Factor | |
| **templateId** | **String**| ID of an existing custom SMS template. See the [SMS Templates API](../Template). This parameter is only used by &#x60;sms&#x60; Factors. | [optional] |
| **tokenLifetimeSeconds** | **Integer**| Defines how long the token remains valid | [optional] [default to 300] |
| **xForwardedFor** | **String**| Public IP address for the user agent | [optional] |
| **userAgent** | **String**| Type of user agent detected when the request is made. Required to verify &#x60;push&#x60; Factors. | [optional] |
| **acceptLanguage** | **String**| An ISO 639-1 two-letter language code that defines a localized message to send. This parameter is only used by &#x60;sms&#x60; Factors. If a localized message doesn&#39;t exist or the &#x60;templateId&#x60; is incorrect, the default template is used instead. | [optional] |
| **body** | [**UserFactorVerifyRequest**](UserFactorVerifyRequest.md)| Some Factors (&#x60;call&#x60;, &#x60;email&#x60;, &#x60;push&#x60;, &#x60;sms&#x60;, &#x60;u2f&#x60;, and &#x60;webauthn&#x60;) must first issue a challenge before you can verify the Factor. Do this by making a request without a body. After a challenge is issued, make another request to verify the Factor. | [optional] |

### Return type

[**UserFactorVerifyResponse**](UserFactorVerifyResponse.md)

### Authorization

[apiToken](../README.md#apiToken), [oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: application/json
- **Accept**: application/json


### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **200** | Success |  -  |
| **400** | Bad Request |  -  |
| **403** | Forbidden |  -  |
| **404** | Not Found |  -  |
| **429** | Too Many Requests |  -  |

