# WebAuthnPreregistrationApi

All URIs are relative to *https://subdomain.okta.com*

| Method | HTTP request | Description |
|------------- | ------------- | -------------|
| [**activatePreregistrationEnrollment**](WebAuthnPreregistrationApi.md#activatePreregistrationEnrollment) | **POST** /webauthn-registration/api/v1/activate | Activate a Preregistered WebAuthn Factor |
| [**deleteWebAuthnPreregistrationFactor**](WebAuthnPreregistrationApi.md#deleteWebAuthnPreregistrationFactor) | **DELETE** /webauthn-registration/api/v1/users/{userId}/enrollments/{authenticatorEnrollmentId} | Delete a WebAuthn Preregistration Factor |
| [**enrollPreregistrationEnrollment**](WebAuthnPreregistrationApi.md#enrollPreregistrationEnrollment) | **POST** /webauthn-registration/api/v1/enroll | Enroll a Preregistered WebAuthn Factor |
| [**generateFulfillmentRequest**](WebAuthnPreregistrationApi.md#generateFulfillmentRequest) | **POST** /webauthn-registration/api/v1/initiate-fulfillment-request | Generate a Fulfillment Request |
| [**listWebAuthnPreregistrationFactors**](WebAuthnPreregistrationApi.md#listWebAuthnPreregistrationFactors) | **GET** /webauthn-registration/api/v1/users/{userId}/enrollments | List all WebAuthn Preregistration Factors |
| [**sendPin**](WebAuthnPreregistrationApi.md#sendPin) | **POST** /webauthn-registration/api/v1/send-pin | Send a PIN to user |



## activatePreregistrationEnrollment

> EnrollmentActivationResponse activatePreregistrationEnrollment(body)

Activate a Preregistered WebAuthn Factor

Activates a preregistered WebAuthn Factor. As part of this operation, Okta first decrypts and verifies the Factor PIN and enrollment data sent by the fulfillment provider.

### Example

```java
// Import classes:
import com.okta.sdk.resource.client.ApiClient;
import com.okta.sdk.resource.client.ApiException;
import com.okta.sdk.resource.client.Configuration;
import com.okta.sdk.resource.client.auth.*;
import com.okta.sdk.resource.client.models.*;
import com.okta.sdk.resource.api.WebAuthnPreregistrationApi;

public class Example {
    public static void main(String[] args) {
        ApiClient defaultClient = Configuration.getDefaultApiClient();
        defaultClient.setBasePath("https://subdomain.okta.com");
        
        // Configure API key authorization: apiToken
        ApiKeyAuth apiToken = (ApiKeyAuth) defaultClient.getAuthentication("apiToken");
        apiToken.setApiKey("YOUR API KEY");
        // Uncomment the following line to set a prefix for the API key, e.g. "Token" (defaults to null)
        //apiToken.setApiKeyPrefix("Token");

        // Configure OAuth2 access token for authorization: oauth2
        OAuth oauth2 = (OAuth) defaultClient.getAuthentication("oauth2");
        oauth2.setAccessToken("YOUR ACCESS TOKEN");

        WebAuthnPreregistrationApi apiInstance = new WebAuthnPreregistrationApi(defaultClient);
        EnrollmentActivationRequest body = new EnrollmentActivationRequest(); // EnrollmentActivationRequest | Enrollment Activation Request
        try {
            EnrollmentActivationResponse result = apiInstance.activatePreregistrationEnrollment(body);
            System.out.println(result);
        } catch (ApiException e) {
            System.err.println("Exception when calling WebAuthnPreregistrationApi#activatePreregistrationEnrollment");
            System.err.println("Status code: " + e.getCode());
            System.err.println("Reason: " + e.getResponseBody());
            System.err.println("Response headers: " + e.getResponseHeaders());
            e.printStackTrace();
        }
    }
}
```

### Parameters


| Name | Type | Description  | Notes |
|------------- | ------------- | ------------- | -------------|
| **body** | [**EnrollmentActivationRequest**](EnrollmentActivationRequest.md)| Enrollment Activation Request | [optional] |

### Return type

[**EnrollmentActivationResponse**](EnrollmentActivationResponse.md)

### Authorization

[apiToken](../README.md#apiToken), [oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: application/json
- **Accept**: application/json


### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **200** | Success |  -  |
| **400** | PIN or Cred Requests Generation Failed |  -  |
| **403** | Forbidden |  -  |
| **404** | Not Found |  -  |
| **429** | Too Many Requests |  -  |


## deleteWebAuthnPreregistrationFactor

> deleteWebAuthnPreregistrationFactor(userId, authenticatorEnrollmentId)

Delete a WebAuthn Preregistration Factor

Deletes a specific WebAuthn Preregistration Factor for a user

### Example

```java
// Import classes:
import com.okta.sdk.resource.client.ApiClient;
import com.okta.sdk.resource.client.ApiException;
import com.okta.sdk.resource.client.Configuration;
import com.okta.sdk.resource.client.auth.*;
import com.okta.sdk.resource.client.models.*;
import com.okta.sdk.resource.api.WebAuthnPreregistrationApi;

public class Example {
    public static void main(String[] args) {
        ApiClient defaultClient = Configuration.getDefaultApiClient();
        defaultClient.setBasePath("https://subdomain.okta.com");
        
        // Configure API key authorization: apiToken
        ApiKeyAuth apiToken = (ApiKeyAuth) defaultClient.getAuthentication("apiToken");
        apiToken.setApiKey("YOUR API KEY");
        // Uncomment the following line to set a prefix for the API key, e.g. "Token" (defaults to null)
        //apiToken.setApiKeyPrefix("Token");

        // Configure OAuth2 access token for authorization: oauth2
        OAuth oauth2 = (OAuth) defaultClient.getAuthentication("oauth2");
        oauth2.setAccessToken("YOUR ACCESS TOKEN");

        WebAuthnPreregistrationApi apiInstance = new WebAuthnPreregistrationApi(defaultClient);
        String userId = "00ub0oNGTSWTBKOLGLNR"; // String | ID of an existing Okta user
        String authenticatorEnrollmentId = "authenticatorEnrollmentId_example"; // String | ID for a WebAuthn Preregistration Factor in Okta
        try {
            apiInstance.deleteWebAuthnPreregistrationFactor(userId, authenticatorEnrollmentId);
        } catch (ApiException e) {
            System.err.println("Exception when calling WebAuthnPreregistrationApi#deleteWebAuthnPreregistrationFactor");
            System.err.println("Status code: " + e.getCode());
            System.err.println("Reason: " + e.getResponseBody());
            System.err.println("Response headers: " + e.getResponseHeaders());
            e.printStackTrace();
        }
    }
}
```

### Parameters


| Name | Type | Description  | Notes |
|------------- | ------------- | ------------- | -------------|
| **userId** | **String**| ID of an existing Okta user | |
| **authenticatorEnrollmentId** | **String**| ID for a WebAuthn Preregistration Factor in Okta | |

### Return type

null (empty response body)

### Authorization

[apiToken](../README.md#apiToken), [oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json


### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **204** | No Content |  -  |
| **403** | Forbidden |  -  |
| **404** | Not Found |  -  |
| **429** | Too Many Requests |  -  |


## enrollPreregistrationEnrollment

> EnrollmentInitializationResponse enrollPreregistrationEnrollment(body)

Enroll a Preregistered WebAuthn Factor

Enrolls a preregistered WebAuthn Factor. This WebAuthn Factor has a longer challenge timeout period to accommodate the fulfillment request process. As part of this operation, Okta generates EC key-pairs used to encrypt the Factor PIN and enrollment data sent by the fulfillment provider.

### Example

```java
// Import classes:
import com.okta.sdk.resource.client.ApiClient;
import com.okta.sdk.resource.client.ApiException;
import com.okta.sdk.resource.client.Configuration;
import com.okta.sdk.resource.client.auth.*;
import com.okta.sdk.resource.client.models.*;
import com.okta.sdk.resource.api.WebAuthnPreregistrationApi;

public class Example {
    public static void main(String[] args) {
        ApiClient defaultClient = Configuration.getDefaultApiClient();
        defaultClient.setBasePath("https://subdomain.okta.com");
        
        // Configure API key authorization: apiToken
        ApiKeyAuth apiToken = (ApiKeyAuth) defaultClient.getAuthentication("apiToken");
        apiToken.setApiKey("YOUR API KEY");
        // Uncomment the following line to set a prefix for the API key, e.g. "Token" (defaults to null)
        //apiToken.setApiKeyPrefix("Token");

        // Configure OAuth2 access token for authorization: oauth2
        OAuth oauth2 = (OAuth) defaultClient.getAuthentication("oauth2");
        oauth2.setAccessToken("YOUR ACCESS TOKEN");

        WebAuthnPreregistrationApi apiInstance = new WebAuthnPreregistrationApi(defaultClient);
        EnrollmentInitializationRequest body = new EnrollmentInitializationRequest(); // EnrollmentInitializationRequest | Enrollment Initialization Request
        try {
            EnrollmentInitializationResponse result = apiInstance.enrollPreregistrationEnrollment(body);
            System.out.println(result);
        } catch (ApiException e) {
            System.err.println("Exception when calling WebAuthnPreregistrationApi#enrollPreregistrationEnrollment");
            System.err.println("Status code: " + e.getCode());
            System.err.println("Reason: " + e.getResponseBody());
            System.err.println("Response headers: " + e.getResponseHeaders());
            e.printStackTrace();
        }
    }
}
```

### Parameters


| Name | Type | Description  | Notes |
|------------- | ------------- | ------------- | -------------|
| **body** | [**EnrollmentInitializationRequest**](EnrollmentInitializationRequest.md)| Enrollment Initialization Request | [optional] |

### Return type

[**EnrollmentInitializationResponse**](EnrollmentInitializationResponse.md)

### Authorization

[apiToken](../README.md#apiToken), [oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: application/json
- **Accept**: application/json


### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **200** | Success |  -  |
| **400** | PIN or Cred Requests Generation Failed |  -  |
| **403** | Forbidden |  -  |
| **404** | Not Found |  -  |
| **429** | Too Many Requests |  -  |


## generateFulfillmentRequest

> generateFulfillmentRequest(body)

Generate a Fulfillment Request

Generates a fulfillment request by sending a WebAuthn Preregistration event to start the flow. The Okta Workflows WebAuthn preregistration integration uses this to populate the fulfillment request.

### Example

```java
// Import classes:
import com.okta.sdk.resource.client.ApiClient;
import com.okta.sdk.resource.client.ApiException;
import com.okta.sdk.resource.client.Configuration;
import com.okta.sdk.resource.client.auth.*;
import com.okta.sdk.resource.client.models.*;
import com.okta.sdk.resource.api.WebAuthnPreregistrationApi;

public class Example {
    public static void main(String[] args) {
        ApiClient defaultClient = Configuration.getDefaultApiClient();
        defaultClient.setBasePath("https://subdomain.okta.com");
        
        // Configure API key authorization: apiToken
        ApiKeyAuth apiToken = (ApiKeyAuth) defaultClient.getAuthentication("apiToken");
        apiToken.setApiKey("YOUR API KEY");
        // Uncomment the following line to set a prefix for the API key, e.g. "Token" (defaults to null)
        //apiToken.setApiKeyPrefix("Token");

        // Configure OAuth2 access token for authorization: oauth2
        OAuth oauth2 = (OAuth) defaultClient.getAuthentication("oauth2");
        oauth2.setAccessToken("YOUR ACCESS TOKEN");

        WebAuthnPreregistrationApi apiInstance = new WebAuthnPreregistrationApi(defaultClient);
        FulfillmentRequest body = new FulfillmentRequest(); // FulfillmentRequest | Fulfillment Request
        try {
            apiInstance.generateFulfillmentRequest(body);
        } catch (ApiException e) {
            System.err.println("Exception when calling WebAuthnPreregistrationApi#generateFulfillmentRequest");
            System.err.println("Status code: " + e.getCode());
            System.err.println("Reason: " + e.getResponseBody());
            System.err.println("Response headers: " + e.getResponseHeaders());
            e.printStackTrace();
        }
    }
}
```

### Parameters


| Name | Type | Description  | Notes |
|------------- | ------------- | ------------- | -------------|
| **body** | [**FulfillmentRequest**](FulfillmentRequest.md)| Fulfillment Request | [optional] |

### Return type

null (empty response body)

### Authorization

[apiToken](../README.md#apiToken), [oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: application/json
- **Accept**: application/json


### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **204** | No Content |  -  |
| **403** | Forbidden |  -  |
| **404** | Not Found |  -  |
| **429** | Too Many Requests |  -  |


## listWebAuthnPreregistrationFactors

> List&lt;WebAuthnPreregistrationFactor&gt; listWebAuthnPreregistrationFactors(userId)

List all WebAuthn Preregistration Factors

Lists all WebAuthn Preregistration Factors for the specified user

### Example

```java
// Import classes:
import com.okta.sdk.resource.client.ApiClient;
import com.okta.sdk.resource.client.ApiException;
import com.okta.sdk.resource.client.Configuration;
import com.okta.sdk.resource.client.auth.*;
import com.okta.sdk.resource.client.models.*;
import com.okta.sdk.resource.api.WebAuthnPreregistrationApi;

public class Example {
    public static void main(String[] args) {
        ApiClient defaultClient = Configuration.getDefaultApiClient();
        defaultClient.setBasePath("https://subdomain.okta.com");
        
        // Configure API key authorization: apiToken
        ApiKeyAuth apiToken = (ApiKeyAuth) defaultClient.getAuthentication("apiToken");
        apiToken.setApiKey("YOUR API KEY");
        // Uncomment the following line to set a prefix for the API key, e.g. "Token" (defaults to null)
        //apiToken.setApiKeyPrefix("Token");

        // Configure OAuth2 access token for authorization: oauth2
        OAuth oauth2 = (OAuth) defaultClient.getAuthentication("oauth2");
        oauth2.setAccessToken("YOUR ACCESS TOKEN");

        WebAuthnPreregistrationApi apiInstance = new WebAuthnPreregistrationApi(defaultClient);
        String userId = "00ub0oNGTSWTBKOLGLNR"; // String | ID of an existing Okta user
        try {
            List<WebAuthnPreregistrationFactor> result = apiInstance.listWebAuthnPreregistrationFactors(userId);
            System.out.println(result);
        } catch (ApiException e) {
            System.err.println("Exception when calling WebAuthnPreregistrationApi#listWebAuthnPreregistrationFactors");
            System.err.println("Status code: " + e.getCode());
            System.err.println("Reason: " + e.getResponseBody());
            System.err.println("Response headers: " + e.getResponseHeaders());
            e.printStackTrace();
        }
    }
}
```

### Parameters


| Name | Type | Description  | Notes |
|------------- | ------------- | ------------- | -------------|
| **userId** | **String**| ID of an existing Okta user | |

### Return type

[**List&lt;WebAuthnPreregistrationFactor&gt;**](WebAuthnPreregistrationFactor.md)

### Authorization

[apiToken](../README.md#apiToken), [oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json


### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **200** | Success |  -  |
| **403** | Forbidden |  -  |
| **404** | Not Found |  -  |
| **429** | Too Many Requests |  -  |


## sendPin

> sendPin(body)

Send a PIN to user

Sends the decoded PIN for the specified WebAuthn Preregistration Enrollment. PINs are sent to the user&#39;s email. To resend the PIN, call this operation again.

### Example

```java
// Import classes:
import com.okta.sdk.resource.client.ApiClient;
import com.okta.sdk.resource.client.ApiException;
import com.okta.sdk.resource.client.Configuration;
import com.okta.sdk.resource.client.auth.*;
import com.okta.sdk.resource.client.models.*;
import com.okta.sdk.resource.api.WebAuthnPreregistrationApi;

public class Example {
    public static void main(String[] args) {
        ApiClient defaultClient = Configuration.getDefaultApiClient();
        defaultClient.setBasePath("https://subdomain.okta.com");
        
        // Configure API key authorization: apiToken
        ApiKeyAuth apiToken = (ApiKeyAuth) defaultClient.getAuthentication("apiToken");
        apiToken.setApiKey("YOUR API KEY");
        // Uncomment the following line to set a prefix for the API key, e.g. "Token" (defaults to null)
        //apiToken.setApiKeyPrefix("Token");

        // Configure OAuth2 access token for authorization: oauth2
        OAuth oauth2 = (OAuth) defaultClient.getAuthentication("oauth2");
        oauth2.setAccessToken("YOUR ACCESS TOKEN");

        WebAuthnPreregistrationApi apiInstance = new WebAuthnPreregistrationApi(defaultClient);
        PinRequest body = new PinRequest(); // PinRequest | Send PIN Request
        try {
            apiInstance.sendPin(body);
        } catch (ApiException e) {
            System.err.println("Exception when calling WebAuthnPreregistrationApi#sendPin");
            System.err.println("Status code: " + e.getCode());
            System.err.println("Reason: " + e.getResponseBody());
            System.err.println("Response headers: " + e.getResponseHeaders());
            e.printStackTrace();
        }
    }
}
```

### Parameters


| Name | Type | Description  | Notes |
|------------- | ------------- | ------------- | -------------|
| **body** | [**PinRequest**](PinRequest.md)| Send PIN Request | [optional] |

### Return type

null (empty response body)

### Authorization

[apiToken](../README.md#apiToken), [oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: application/json
- **Accept**: application/json


### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **204** | No Content |  -  |
| **403** | Forbidden |  -  |
| **404** | Not Found |  -  |
| **429** | Too Many Requests |  -  |

