/*
 * Okta Admin Management
 * Allows customers to easily access the Okta Management APIs
 *
 * The version of the OpenAPI document: 2024.08.3
 * Contact: devex-public@okta.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.okta.sdk.resource.api;

import com.fasterxml.jackson.core.type.TypeReference;

import com.okta.sdk.resource.client.ApiException;
import com.okta.sdk.resource.client.ApiClient;
import com.okta.sdk.resource.client.Configuration;
import com.okta.sdk.resource.model.*;
import com.okta.sdk.resource.client.Pair;

import com.okta.sdk.resource.model.Error;
import com.okta.sdk.resource.model.OAuth2Claim;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;

import org.openapitools.jackson.nullable.JsonNullableModule;

@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-01-23T09:50:29.349096-06:00[America/Chicago]", comments = "Generator version: 7.8.0")
public class AuthorizationServerClaimsApi {

    private ApiClient apiClient;

    public AuthorizationServerClaimsApi() {
        this(Configuration.getDefaultApiClient());
    }

    public AuthorizationServerClaimsApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    /**
     * Create a custom token Claim Creates a custom token Claim for a custom authorization server
     *
     * @param authServerId
     *            &#x60;id&#x60; of the Authorization Server (required)
     * @param oAuth2Claim
     *            (required)
     *
     * @return OAuth2Claim
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public OAuth2Claim createOAuth2Claim(String authServerId, OAuth2Claim oAuth2Claim) throws ApiException {
        return this.createOAuth2Claim(authServerId, oAuth2Claim, Collections.emptyMap());
    }

    /**
     * Create a custom token Claim Creates a custom token Claim for a custom authorization server
     *
     * @param authServerId
     *            &#x60;id&#x60; of the Authorization Server (required)
     * @param oAuth2Claim
     *            (required)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @return OAuth2Claim
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public OAuth2Claim createOAuth2Claim(String authServerId, OAuth2Claim oAuth2Claim,
            Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = oAuth2Claim;

        // verify the required parameter 'authServerId' is set
        if (authServerId == null) {
            throw new ApiException(400, "Missing the required parameter 'authServerId' when calling createOAuth2Claim");
        }

        // verify the required parameter 'oAuth2Claim' is set
        if (oAuth2Claim == null) {
            throw new ApiException(400, "Missing the required parameter 'oAuth2Claim' when calling createOAuth2Claim");
        }

        // create path and map variables
        String localVarPath = "/api/v1/authorizationServers/{authServerId}/claims"
                .replaceAll("\\{" + "authServerId" + "\\}", apiClient.escapeString(authServerId.toString()));

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

        final String[] localVarContentTypes = { "application/json" };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        TypeReference<OAuth2Claim> localVarReturnType = new TypeReference<OAuth2Claim>() {
        };
        return apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Delete a custom token Claim Deletes a custom token Claim specified by the &#x60;claimId&#x60;
     *
     * @param authServerId
     *            &#x60;id&#x60; of the Authorization Server (required)
     * @param claimId
     *            &#x60;id&#x60; of Claim (required)
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public void deleteOAuth2Claim(String authServerId, String claimId) throws ApiException {
        this.deleteOAuth2Claim(authServerId, claimId, Collections.emptyMap());
    }

    /**
     * Delete a custom token Claim Deletes a custom token Claim specified by the &#x60;claimId&#x60;
     *
     * @param authServerId
     *            &#x60;id&#x60; of the Authorization Server (required)
     * @param claimId
     *            &#x60;id&#x60; of Claim (required)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public void deleteOAuth2Claim(String authServerId, String claimId, Map<String, String> additionalHeaders)
            throws ApiException {
        Object localVarPostBody = null;

        // verify the required parameter 'authServerId' is set
        if (authServerId == null) {
            throw new ApiException(400, "Missing the required parameter 'authServerId' when calling deleteOAuth2Claim");
        }

        // verify the required parameter 'claimId' is set
        if (claimId == null) {
            throw new ApiException(400, "Missing the required parameter 'claimId' when calling deleteOAuth2Claim");
        }

        // create path and map variables
        String localVarPath = "/api/v1/authorizationServers/{authServerId}/claims/{claimId}"
                .replaceAll("\\{" + "authServerId" + "\\}", apiClient.escapeString(authServerId.toString()))
                .replaceAll("\\{" + "claimId" + "\\}", apiClient.escapeString(claimId.toString()));

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    /**
     * Retrieve a custom token Claim Retrieves a custom token Claim by the specified &#x60;claimId&#x60;
     *
     * @param authServerId
     *            &#x60;id&#x60; of the Authorization Server (required)
     * @param claimId
     *            &#x60;id&#x60; of Claim (required)
     *
     * @return OAuth2Claim
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public OAuth2Claim getOAuth2Claim(String authServerId, String claimId) throws ApiException {
        return this.getOAuth2Claim(authServerId, claimId, Collections.emptyMap());
    }

    /**
     * Retrieve a custom token Claim Retrieves a custom token Claim by the specified &#x60;claimId&#x60;
     *
     * @param authServerId
     *            &#x60;id&#x60; of the Authorization Server (required)
     * @param claimId
     *            &#x60;id&#x60; of Claim (required)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @return OAuth2Claim
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public OAuth2Claim getOAuth2Claim(String authServerId, String claimId, Map<String, String> additionalHeaders)
            throws ApiException {
        Object localVarPostBody = null;

        // verify the required parameter 'authServerId' is set
        if (authServerId == null) {
            throw new ApiException(400, "Missing the required parameter 'authServerId' when calling getOAuth2Claim");
        }

        // verify the required parameter 'claimId' is set
        if (claimId == null) {
            throw new ApiException(400, "Missing the required parameter 'claimId' when calling getOAuth2Claim");
        }

        // create path and map variables
        String localVarPath = "/api/v1/authorizationServers/{authServerId}/claims/{claimId}"
                .replaceAll("\\{" + "authServerId" + "\\}", apiClient.escapeString(authServerId.toString()))
                .replaceAll("\\{" + "claimId" + "\\}", apiClient.escapeString(claimId.toString()));

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        TypeReference<OAuth2Claim> localVarReturnType = new TypeReference<OAuth2Claim>() {
        };
        return apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * List all custom token Claims Lists all custom token Claims defined for a specified custom authorization server
     *
     * @param authServerId
     *            &#x60;id&#x60; of the Authorization Server (required)
     *
     * @return List&lt;OAuth2Claim&gt;
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public List<OAuth2Claim> listOAuth2Claims(String authServerId) throws ApiException {
        return this.listOAuth2Claims(authServerId, Collections.emptyMap());
    }

    /**
     * List all custom token Claims Lists all custom token Claims defined for a specified custom authorization server
     *
     * @param authServerId
     *            &#x60;id&#x60; of the Authorization Server (required)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @return List&lt;OAuth2Claim&gt;
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public List<OAuth2Claim> listOAuth2Claims(String authServerId, Map<String, String> additionalHeaders)
            throws ApiException {
        Object localVarPostBody = null;

        // verify the required parameter 'authServerId' is set
        if (authServerId == null) {
            throw new ApiException(400, "Missing the required parameter 'authServerId' when calling listOAuth2Claims");
        }

        // create path and map variables
        String localVarPath = "/api/v1/authorizationServers/{authServerId}/claims"
                .replaceAll("\\{" + "authServerId" + "\\}", apiClient.escapeString(authServerId.toString()));

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        TypeReference<List<OAuth2Claim>> localVarReturnType = new TypeReference<List<OAuth2Claim>>() {
        };
        return apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Replace a custom token Claim Replaces a custom token Claim specified by the &#x60;claimId&#x60;
     *
     * @param authServerId
     *            &#x60;id&#x60; of the Authorization Server (required)
     * @param claimId
     *            &#x60;id&#x60; of Claim (required)
     * @param oAuth2Claim
     *            (required)
     *
     * @return OAuth2Claim
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public OAuth2Claim replaceOAuth2Claim(String authServerId, String claimId, OAuth2Claim oAuth2Claim)
            throws ApiException {
        return this.replaceOAuth2Claim(authServerId, claimId, oAuth2Claim, Collections.emptyMap());
    }

    /**
     * Replace a custom token Claim Replaces a custom token Claim specified by the &#x60;claimId&#x60;
     *
     * @param authServerId
     *            &#x60;id&#x60; of the Authorization Server (required)
     * @param claimId
     *            &#x60;id&#x60; of Claim (required)
     * @param oAuth2Claim
     *            (required)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @return OAuth2Claim
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public OAuth2Claim replaceOAuth2Claim(String authServerId, String claimId, OAuth2Claim oAuth2Claim,
            Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = oAuth2Claim;

        // verify the required parameter 'authServerId' is set
        if (authServerId == null) {
            throw new ApiException(400,
                    "Missing the required parameter 'authServerId' when calling replaceOAuth2Claim");
        }

        // verify the required parameter 'claimId' is set
        if (claimId == null) {
            throw new ApiException(400, "Missing the required parameter 'claimId' when calling replaceOAuth2Claim");
        }

        // verify the required parameter 'oAuth2Claim' is set
        if (oAuth2Claim == null) {
            throw new ApiException(400, "Missing the required parameter 'oAuth2Claim' when calling replaceOAuth2Claim");
        }

        // create path and map variables
        String localVarPath = "/api/v1/authorizationServers/{authServerId}/claims/{claimId}"
                .replaceAll("\\{" + "authServerId" + "\\}", apiClient.escapeString(authServerId.toString()))
                .replaceAll("\\{" + "claimId" + "\\}", apiClient.escapeString(claimId.toString()));

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

        final String[] localVarContentTypes = { "application/json" };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        TypeReference<OAuth2Claim> localVarReturnType = new TypeReference<OAuth2Claim>() {
        };
        return apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    protected static ObjectMapper getObjectMapper() {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.registerModule(new JavaTimeModule());
        objectMapper.registerModule(new JsonNullableModule());
        objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        objectMapper.configure(DeserializationFeature.READ_UNKNOWN_ENUM_VALUES_AS_NULL, true);
        return objectMapper;
    }

}
