/*
 * Okta Admin Management
 * Allows customers to easily access the Okta Management APIs
 *
 * The version of the OpenAPI document: 2024.08.3
 * Contact: devex-public@okta.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.okta.sdk.resource.api;

import com.fasterxml.jackson.core.type.TypeReference;

import com.okta.sdk.resource.client.ApiException;
import com.okta.sdk.resource.client.ApiClient;
import com.okta.sdk.resource.client.Configuration;
import com.okta.sdk.resource.model.*;
import com.okta.sdk.resource.client.Pair;

import com.okta.sdk.resource.model.AuthorizationServerPolicy;
import com.okta.sdk.resource.model.Error;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;

import org.openapitools.jackson.nullable.JsonNullableModule;

@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-01-23T09:50:29.349096-06:00[America/Chicago]", comments = "Generator version: 7.8.0")
public class AuthorizationServerPoliciesApi {

    private ApiClient apiClient;

    public AuthorizationServerPoliciesApi() {
        this(Configuration.getDefaultApiClient());
    }

    public AuthorizationServerPoliciesApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    /**
     * Activate a Policy Activates an authorization server policy
     *
     * @param authServerId
     *            &#x60;id&#x60; of the Authorization Server (required)
     * @param policyId
     *            &#x60;id&#x60; of the Policy (required)
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public void activateAuthorizationServerPolicy(String authServerId, String policyId) throws ApiException {
        this.activateAuthorizationServerPolicy(authServerId, policyId, Collections.emptyMap());
    }

    /**
     * Activate a Policy Activates an authorization server policy
     *
     * @param authServerId
     *            &#x60;id&#x60; of the Authorization Server (required)
     * @param policyId
     *            &#x60;id&#x60; of the Policy (required)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public void activateAuthorizationServerPolicy(String authServerId, String policyId,
            Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;

        // verify the required parameter 'authServerId' is set
        if (authServerId == null) {
            throw new ApiException(400,
                    "Missing the required parameter 'authServerId' when calling activateAuthorizationServerPolicy");
        }

        // verify the required parameter 'policyId' is set
        if (policyId == null) {
            throw new ApiException(400,
                    "Missing the required parameter 'policyId' when calling activateAuthorizationServerPolicy");
        }

        // create path and map variables
        String localVarPath = "/api/v1/authorizationServers/{authServerId}/policies/{policyId}/lifecycle/activate"
                .replaceAll("\\{" + "authServerId" + "\\}", apiClient.escapeString(authServerId.toString()))
                .replaceAll("\\{" + "policyId" + "\\}", apiClient.escapeString(policyId.toString()));

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    /**
     * Create a Policy Creates a policy
     *
     * @param authServerId
     *            &#x60;id&#x60; of the Authorization Server (required)
     * @param policy
     *            (required)
     *
     * @return AuthorizationServerPolicy
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public AuthorizationServerPolicy createAuthorizationServerPolicy(String authServerId,
            AuthorizationServerPolicy policy) throws ApiException {
        return this.createAuthorizationServerPolicy(authServerId, policy, Collections.emptyMap());
    }

    /**
     * Create a Policy Creates a policy
     *
     * @param authServerId
     *            &#x60;id&#x60; of the Authorization Server (required)
     * @param policy
     *            (required)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @return AuthorizationServerPolicy
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public AuthorizationServerPolicy createAuthorizationServerPolicy(String authServerId,
            AuthorizationServerPolicy policy, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = policy;

        // verify the required parameter 'authServerId' is set
        if (authServerId == null) {
            throw new ApiException(400,
                    "Missing the required parameter 'authServerId' when calling createAuthorizationServerPolicy");
        }

        // verify the required parameter 'policy' is set
        if (policy == null) {
            throw new ApiException(400,
                    "Missing the required parameter 'policy' when calling createAuthorizationServerPolicy");
        }

        // create path and map variables
        String localVarPath = "/api/v1/authorizationServers/{authServerId}/policies"
                .replaceAll("\\{" + "authServerId" + "\\}", apiClient.escapeString(authServerId.toString()));

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

        final String[] localVarContentTypes = { "application/json" };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        TypeReference<AuthorizationServerPolicy> localVarReturnType = new TypeReference<AuthorizationServerPolicy>() {
        };
        return apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Deactivate a Policy Deactivates an authorization server policy
     *
     * @param authServerId
     *            &#x60;id&#x60; of the Authorization Server (required)
     * @param policyId
     *            &#x60;id&#x60; of the Policy (required)
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public void deactivateAuthorizationServerPolicy(String authServerId, String policyId) throws ApiException {
        this.deactivateAuthorizationServerPolicy(authServerId, policyId, Collections.emptyMap());
    }

    /**
     * Deactivate a Policy Deactivates an authorization server policy
     *
     * @param authServerId
     *            &#x60;id&#x60; of the Authorization Server (required)
     * @param policyId
     *            &#x60;id&#x60; of the Policy (required)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public void deactivateAuthorizationServerPolicy(String authServerId, String policyId,
            Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;

        // verify the required parameter 'authServerId' is set
        if (authServerId == null) {
            throw new ApiException(400,
                    "Missing the required parameter 'authServerId' when calling deactivateAuthorizationServerPolicy");
        }

        // verify the required parameter 'policyId' is set
        if (policyId == null) {
            throw new ApiException(400,
                    "Missing the required parameter 'policyId' when calling deactivateAuthorizationServerPolicy");
        }

        // create path and map variables
        String localVarPath = "/api/v1/authorizationServers/{authServerId}/policies/{policyId}/lifecycle/deactivate"
                .replaceAll("\\{" + "authServerId" + "\\}", apiClient.escapeString(authServerId.toString()))
                .replaceAll("\\{" + "policyId" + "\\}", apiClient.escapeString(policyId.toString()));

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    /**
     * Delete a Policy Deletes a policy
     *
     * @param authServerId
     *            &#x60;id&#x60; of the Authorization Server (required)
     * @param policyId
     *            &#x60;id&#x60; of the Policy (required)
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public void deleteAuthorizationServerPolicy(String authServerId, String policyId) throws ApiException {
        this.deleteAuthorizationServerPolicy(authServerId, policyId, Collections.emptyMap());
    }

    /**
     * Delete a Policy Deletes a policy
     *
     * @param authServerId
     *            &#x60;id&#x60; of the Authorization Server (required)
     * @param policyId
     *            &#x60;id&#x60; of the Policy (required)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public void deleteAuthorizationServerPolicy(String authServerId, String policyId,
            Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;

        // verify the required parameter 'authServerId' is set
        if (authServerId == null) {
            throw new ApiException(400,
                    "Missing the required parameter 'authServerId' when calling deleteAuthorizationServerPolicy");
        }

        // verify the required parameter 'policyId' is set
        if (policyId == null) {
            throw new ApiException(400,
                    "Missing the required parameter 'policyId' when calling deleteAuthorizationServerPolicy");
        }

        // create path and map variables
        String localVarPath = "/api/v1/authorizationServers/{authServerId}/policies/{policyId}"
                .replaceAll("\\{" + "authServerId" + "\\}", apiClient.escapeString(authServerId.toString()))
                .replaceAll("\\{" + "policyId" + "\\}", apiClient.escapeString(policyId.toString()));

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    /**
     * Retrieve a Policy Retrieves a policy
     *
     * @param authServerId
     *            &#x60;id&#x60; of the Authorization Server (required)
     * @param policyId
     *            &#x60;id&#x60; of the Policy (required)
     *
     * @return AuthorizationServerPolicy
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public AuthorizationServerPolicy getAuthorizationServerPolicy(String authServerId, String policyId)
            throws ApiException {
        return this.getAuthorizationServerPolicy(authServerId, policyId, Collections.emptyMap());
    }

    /**
     * Retrieve a Policy Retrieves a policy
     *
     * @param authServerId
     *            &#x60;id&#x60; of the Authorization Server (required)
     * @param policyId
     *            &#x60;id&#x60; of the Policy (required)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @return AuthorizationServerPolicy
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public AuthorizationServerPolicy getAuthorizationServerPolicy(String authServerId, String policyId,
            Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;

        // verify the required parameter 'authServerId' is set
        if (authServerId == null) {
            throw new ApiException(400,
                    "Missing the required parameter 'authServerId' when calling getAuthorizationServerPolicy");
        }

        // verify the required parameter 'policyId' is set
        if (policyId == null) {
            throw new ApiException(400,
                    "Missing the required parameter 'policyId' when calling getAuthorizationServerPolicy");
        }

        // create path and map variables
        String localVarPath = "/api/v1/authorizationServers/{authServerId}/policies/{policyId}"
                .replaceAll("\\{" + "authServerId" + "\\}", apiClient.escapeString(authServerId.toString()))
                .replaceAll("\\{" + "policyId" + "\\}", apiClient.escapeString(policyId.toString()));

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        TypeReference<AuthorizationServerPolicy> localVarReturnType = new TypeReference<AuthorizationServerPolicy>() {
        };
        return apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * List all Policies Lists all policies
     *
     * @param authServerId
     *            &#x60;id&#x60; of the Authorization Server (required)
     *
     * @return List&lt;AuthorizationServerPolicy&gt;
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public List<AuthorizationServerPolicy> listAuthorizationServerPolicies(String authServerId) throws ApiException {
        return this.listAuthorizationServerPolicies(authServerId, Collections.emptyMap());
    }

    /**
     * List all Policies Lists all policies
     *
     * @param authServerId
     *            &#x60;id&#x60; of the Authorization Server (required)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @return List&lt;AuthorizationServerPolicy&gt;
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public List<AuthorizationServerPolicy> listAuthorizationServerPolicies(String authServerId,
            Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;

        // verify the required parameter 'authServerId' is set
        if (authServerId == null) {
            throw new ApiException(400,
                    "Missing the required parameter 'authServerId' when calling listAuthorizationServerPolicies");
        }

        // create path and map variables
        String localVarPath = "/api/v1/authorizationServers/{authServerId}/policies"
                .replaceAll("\\{" + "authServerId" + "\\}", apiClient.escapeString(authServerId.toString()));

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        TypeReference<List<AuthorizationServerPolicy>> localVarReturnType = new TypeReference<List<AuthorizationServerPolicy>>() {
        };
        return apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Replace a Policy Replaces a policy
     *
     * @param authServerId
     *            &#x60;id&#x60; of the Authorization Server (required)
     * @param policyId
     *            &#x60;id&#x60; of the Policy (required)
     * @param policy
     *            (required)
     *
     * @return AuthorizationServerPolicy
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public AuthorizationServerPolicy replaceAuthorizationServerPolicy(String authServerId, String policyId,
            AuthorizationServerPolicy policy) throws ApiException {
        return this.replaceAuthorizationServerPolicy(authServerId, policyId, policy, Collections.emptyMap());
    }

    /**
     * Replace a Policy Replaces a policy
     *
     * @param authServerId
     *            &#x60;id&#x60; of the Authorization Server (required)
     * @param policyId
     *            &#x60;id&#x60; of the Policy (required)
     * @param policy
     *            (required)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @return AuthorizationServerPolicy
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public AuthorizationServerPolicy replaceAuthorizationServerPolicy(String authServerId, String policyId,
            AuthorizationServerPolicy policy, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = policy;

        // verify the required parameter 'authServerId' is set
        if (authServerId == null) {
            throw new ApiException(400,
                    "Missing the required parameter 'authServerId' when calling replaceAuthorizationServerPolicy");
        }

        // verify the required parameter 'policyId' is set
        if (policyId == null) {
            throw new ApiException(400,
                    "Missing the required parameter 'policyId' when calling replaceAuthorizationServerPolicy");
        }

        // verify the required parameter 'policy' is set
        if (policy == null) {
            throw new ApiException(400,
                    "Missing the required parameter 'policy' when calling replaceAuthorizationServerPolicy");
        }

        // create path and map variables
        String localVarPath = "/api/v1/authorizationServers/{authServerId}/policies/{policyId}"
                .replaceAll("\\{" + "authServerId" + "\\}", apiClient.escapeString(authServerId.toString()))
                .replaceAll("\\{" + "policyId" + "\\}", apiClient.escapeString(policyId.toString()));

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

        final String[] localVarContentTypes = { "application/json" };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        TypeReference<AuthorizationServerPolicy> localVarReturnType = new TypeReference<AuthorizationServerPolicy>() {
        };
        return apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    protected static ObjectMapper getObjectMapper() {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.registerModule(new JavaTimeModule());
        objectMapper.registerModule(new JsonNullableModule());
        objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        objectMapper.configure(DeserializationFeature.READ_UNKNOWN_ENUM_VALUES_AS_NULL, true);
        return objectMapper;
    }

}
