/*
 * Okta Admin Management
 * Allows customers to easily access the Okta Management APIs
 *
 * The version of the OpenAPI document: 2024.08.3
 * Contact: devex-public@okta.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.okta.sdk.resource.api;

import com.fasterxml.jackson.core.type.TypeReference;

import com.okta.sdk.resource.client.ApiException;
import com.okta.sdk.resource.client.ApiClient;
import com.okta.sdk.resource.client.Configuration;
import com.okta.sdk.resource.model.*;
import com.okta.sdk.resource.client.Pair;

import com.okta.sdk.resource.model.Brand;
import com.okta.sdk.resource.model.BrandRequest;
import com.okta.sdk.resource.model.BrandWithEmbedded;
import com.okta.sdk.resource.model.CreateBrandRequest;
import com.okta.sdk.resource.model.DomainResponse;
import com.okta.sdk.resource.model.Error;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;

import org.openapitools.jackson.nullable.JsonNullableModule;

@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-01-23T09:50:29.349096-06:00[America/Chicago]", comments = "Generator version: 7.8.0")
public class BrandsApi {

    private ApiClient apiClient;

    public BrandsApi() {
        this(Configuration.getDefaultApiClient());
    }

    public BrandsApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    /**
     * Create a Brand Creates a new brand in your org
     *
     * @param createBrandRequest
     *            (optional)
     *
     * @return Brand
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public Brand createBrand(CreateBrandRequest createBrandRequest) throws ApiException {
        return this.createBrand(createBrandRequest, Collections.emptyMap());
    }

    /**
     * Create a Brand Creates a new brand in your org
     *
     * @param createBrandRequest
     *            (optional)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @return Brand
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public Brand createBrand(CreateBrandRequest createBrandRequest, Map<String, String> additionalHeaders)
            throws ApiException {
        Object localVarPostBody = createBrandRequest;

        // create path and map variables
        String localVarPath = "/api/v1/brands";

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

        final String[] localVarContentTypes = { "application/json" };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        TypeReference<Brand> localVarReturnType = new TypeReference<Brand>() {
        };
        return apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Delete a brand Deletes a brand by &#x60;brandId&#x60;
     *
     * @param brandId
     *            The ID of the brand (required)
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public void deleteBrand(String brandId) throws ApiException {
        this.deleteBrand(brandId, Collections.emptyMap());
    }

    /**
     * Delete a brand Deletes a brand by &#x60;brandId&#x60;
     *
     * @param brandId
     *            The ID of the brand (required)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public void deleteBrand(String brandId, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;

        // verify the required parameter 'brandId' is set
        if (brandId == null) {
            throw new ApiException(400, "Missing the required parameter 'brandId' when calling deleteBrand");
        }

        // create path and map variables
        String localVarPath = "/api/v1/brands/{brandId}".replaceAll("\\{" + "brandId" + "\\}",
                apiClient.escapeString(brandId.toString()));

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    /**
     * Retrieve a Brand Retrieves a brand by &#x60;brandId&#x60;
     *
     * @param brandId
     *            The ID of the brand (required)
     * @param expand
     *            Specifies additional metadata to be included in the response (optional
     *
     * @return BrandWithEmbedded
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public BrandWithEmbedded getBrand(String brandId, List<String> expand) throws ApiException {
        return this.getBrand(brandId, expand, Collections.emptyMap());
    }

    /**
     * Retrieve a Brand Retrieves a brand by &#x60;brandId&#x60;
     *
     * @param brandId
     *            The ID of the brand (required)
     * @param expand
     *            Specifies additional metadata to be included in the response (optional
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @return BrandWithEmbedded
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public BrandWithEmbedded getBrand(String brandId, List<String> expand, Map<String, String> additionalHeaders)
            throws ApiException {
        Object localVarPostBody = null;

        // verify the required parameter 'brandId' is set
        if (brandId == null) {
            throw new ApiException(400, "Missing the required parameter 'brandId' when calling getBrand");
        }

        // create path and map variables
        String localVarPath = "/api/v1/brands/{brandId}".replaceAll("\\{" + "brandId" + "\\}",
                apiClient.escapeString(brandId.toString()));

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarCollectionQueryParams.addAll(apiClient.parameterToPairs("csv", "expand", expand));

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        TypeReference<BrandWithEmbedded> localVarReturnType = new TypeReference<BrandWithEmbedded>() {
        };
        return apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * List all Domains associated with a Brand Lists all domains associated with a brand by &#x60;brandId&#x60;
     *
     * @param brandId
     *            The ID of the brand (required)
     *
     * @return List&lt;DomainResponse&gt;
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public List<DomainResponse> listBrandDomains(String brandId) throws ApiException {
        return this.listBrandDomains(brandId, Collections.emptyMap());
    }

    /**
     * List all Domains associated with a Brand Lists all domains associated with a brand by &#x60;brandId&#x60;
     *
     * @param brandId
     *            The ID of the brand (required)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @return List&lt;DomainResponse&gt;
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public List<DomainResponse> listBrandDomains(String brandId, Map<String, String> additionalHeaders)
            throws ApiException {
        Object localVarPostBody = null;

        // verify the required parameter 'brandId' is set
        if (brandId == null) {
            throw new ApiException(400, "Missing the required parameter 'brandId' when calling listBrandDomains");
        }

        // create path and map variables
        String localVarPath = "/api/v1/brands/{brandId}/domains".replaceAll("\\{" + "brandId" + "\\}",
                apiClient.escapeString(brandId.toString()));

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        TypeReference<List<DomainResponse>> localVarReturnType = new TypeReference<List<DomainResponse>>() {
        };
        return apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * List all Brands Lists all the brands in your org
     *
     * @param expand
     *            Specifies additional metadata to be included in the response (optional
     * @param after
     *            The cursor to use for pagination. It is an opaque string that specifies your current location in the
     *            list and is obtained from the &#x60;Link&#x60; response header. See
     *            [Pagination](https://developer.okta.com/docs/api/#pagination). (optional)
     * @param limit
     *            A limit on the number of objects to return (optional, default to 20)
     * @param q
     *            Searches the records for matching value (optional)
     *
     * @return List&lt;BrandWithEmbedded&gt;
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public List<BrandWithEmbedded> listBrands(List<String> expand, String after, Integer limit, String q)
            throws ApiException {
        return this.listBrands(expand, after, limit, q, Collections.emptyMap());
    }

    /**
     * List all Brands Lists all the brands in your org
     *
     * @param expand
     *            Specifies additional metadata to be included in the response (optional
     * @param after
     *            The cursor to use for pagination. It is an opaque string that specifies your current location in the
     *            list and is obtained from the &#x60;Link&#x60; response header. See
     *            [Pagination](https://developer.okta.com/docs/api/#pagination). (optional)
     * @param limit
     *            A limit on the number of objects to return (optional, default to 20)
     * @param q
     *            Searches the records for matching value (optional)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @return List&lt;BrandWithEmbedded&gt;
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public List<BrandWithEmbedded> listBrands(List<String> expand, String after, Integer limit, String q,
            Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/api/v1/brands";

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarCollectionQueryParams.addAll(apiClient.parameterToPairs("csv", "expand", expand));
        localVarQueryParams.addAll(apiClient.parameterToPair("after", after));
        localVarQueryParams.addAll(apiClient.parameterToPair("limit", limit));
        localVarQueryParams.addAll(apiClient.parameterToPair("q", q));

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        TypeReference<List<BrandWithEmbedded>> localVarReturnType = new TypeReference<List<BrandWithEmbedded>>() {
        };
        return apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Replace a Brand Replaces a brand by &#x60;brandId&#x60; Passing an invalid &#x60;brandId&#x60; returns a
     * &#x60;404 Not Found&#x60; status code with the error code &#x60;E0000007&#x60;. Not providing
     * &#x60;agreeToCustomPrivacyPolicy&#x60; with &#x60;customPrivacyPolicyUrl&#x60; returns a &#x60;400 Bad
     * Request&#x60; status code with the error code &#x60;E0000001&#x60;.
     *
     * @param brandId
     *            The ID of the brand (required)
     * @param brand
     *            (required)
     *
     * @return Brand
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public Brand replaceBrand(String brandId, BrandRequest brand) throws ApiException {
        return this.replaceBrand(brandId, brand, Collections.emptyMap());
    }

    /**
     * Replace a Brand Replaces a brand by &#x60;brandId&#x60; Passing an invalid &#x60;brandId&#x60; returns a
     * &#x60;404 Not Found&#x60; status code with the error code &#x60;E0000007&#x60;. Not providing
     * &#x60;agreeToCustomPrivacyPolicy&#x60; with &#x60;customPrivacyPolicyUrl&#x60; returns a &#x60;400 Bad
     * Request&#x60; status code with the error code &#x60;E0000001&#x60;.
     *
     * @param brandId
     *            The ID of the brand (required)
     * @param brand
     *            (required)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @return Brand
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public Brand replaceBrand(String brandId, BrandRequest brand, Map<String, String> additionalHeaders)
            throws ApiException {
        Object localVarPostBody = brand;

        // verify the required parameter 'brandId' is set
        if (brandId == null) {
            throw new ApiException(400, "Missing the required parameter 'brandId' when calling replaceBrand");
        }

        // verify the required parameter 'brand' is set
        if (brand == null) {
            throw new ApiException(400, "Missing the required parameter 'brand' when calling replaceBrand");
        }

        // create path and map variables
        String localVarPath = "/api/v1/brands/{brandId}".replaceAll("\\{" + "brandId" + "\\}",
                apiClient.escapeString(brandId.toString()));

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

        final String[] localVarContentTypes = { "application/json" };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        TypeReference<Brand> localVarReturnType = new TypeReference<Brand>() {
        };
        return apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    protected static ObjectMapper getObjectMapper() {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.registerModule(new JavaTimeModule());
        objectMapper.registerModule(new JsonNullableModule());
        objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        objectMapper.configure(DeserializationFeature.READ_UNKNOWN_ENUM_VALUES_AS_NULL, true);
        return objectMapper;
    }

}
