/*
 * Okta Admin Management
 * Allows customers to easily access the Okta Management APIs
 *
 * The version of the OpenAPI document: 2024.08.3
 * Contact: devex-public@okta.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.okta.sdk.resource.api;

import com.fasterxml.jackson.core.type.TypeReference;

import com.okta.sdk.resource.client.ApiException;
import com.okta.sdk.resource.client.ApiClient;
import com.okta.sdk.resource.client.Configuration;
import com.okta.sdk.resource.model.*;
import com.okta.sdk.resource.client.Pair;

import com.okta.sdk.resource.model.EmailDomain;
import com.okta.sdk.resource.model.EmailDomainResponse;
import com.okta.sdk.resource.model.EmailDomainResponseWithEmbedded;
import com.okta.sdk.resource.model.Error;
import com.okta.sdk.resource.model.UpdateEmailDomain;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;

import org.openapitools.jackson.nullable.JsonNullableModule;

@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-01-23T09:50:29.349096-06:00[America/Chicago]", comments = "Generator version: 7.8.0")
public class EmailDomainApi {

    private ApiClient apiClient;

    public EmailDomainApi() {
        this(Configuration.getDefaultApiClient());
    }

    public EmailDomainApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    /**
     * Create an Email Domain Creates an Email Domain in your org
     *
     * @param emailDomain
     *            (required)
     * @param expand
     *            Specifies additional metadata to be included in the response (optional
     *
     * @return EmailDomainResponse
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public EmailDomainResponse createEmailDomain(EmailDomain emailDomain, List<String> expand) throws ApiException {
        return this.createEmailDomain(emailDomain, expand, Collections.emptyMap());
    }

    /**
     * Create an Email Domain Creates an Email Domain in your org
     *
     * @param emailDomain
     *            (required)
     * @param expand
     *            Specifies additional metadata to be included in the response (optional
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @return EmailDomainResponse
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public EmailDomainResponse createEmailDomain(EmailDomain emailDomain, List<String> expand,
            Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = emailDomain;

        // verify the required parameter 'emailDomain' is set
        if (emailDomain == null) {
            throw new ApiException(400, "Missing the required parameter 'emailDomain' when calling createEmailDomain");
        }

        // create path and map variables
        String localVarPath = "/api/v1/email-domains";

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarCollectionQueryParams.addAll(apiClient.parameterToPairs("csv", "expand", expand));

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

        final String[] localVarContentTypes = { "application/json" };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        TypeReference<EmailDomainResponse> localVarReturnType = new TypeReference<EmailDomainResponse>() {
        };
        return apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Delete an Email Domain Deletes an Email Domain by &#x60;emailDomainId&#x60;
     *
     * @param emailDomainId
     *            (required)
     * @param expand
     *            Specifies additional metadata to be included in the response (optional
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public void deleteEmailDomain(String emailDomainId, List<String> expand) throws ApiException {
        this.deleteEmailDomain(emailDomainId, expand, Collections.emptyMap());
    }

    /**
     * Delete an Email Domain Deletes an Email Domain by &#x60;emailDomainId&#x60;
     *
     * @param emailDomainId
     *            (required)
     * @param expand
     *            Specifies additional metadata to be included in the response (optional
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public void deleteEmailDomain(String emailDomainId, List<String> expand, Map<String, String> additionalHeaders)
            throws ApiException {
        Object localVarPostBody = null;

        // verify the required parameter 'emailDomainId' is set
        if (emailDomainId == null) {
            throw new ApiException(400,
                    "Missing the required parameter 'emailDomainId' when calling deleteEmailDomain");
        }

        // create path and map variables
        String localVarPath = "/api/v1/email-domains/{emailDomainId}".replaceAll("\\{" + "emailDomainId" + "\\}",
                apiClient.escapeString(emailDomainId.toString()));

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarCollectionQueryParams.addAll(apiClient.parameterToPairs("csv", "expand", expand));

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    /**
     * Retrieve an Email Domain Retrieves an Email Domain by &#x60;emailDomainId&#x60;
     *
     * @param emailDomainId
     *            (required)
     * @param expand
     *            Specifies additional metadata to be included in the response (optional
     *
     * @return EmailDomainResponseWithEmbedded
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public EmailDomainResponseWithEmbedded getEmailDomain(String emailDomainId, List<String> expand)
            throws ApiException {
        return this.getEmailDomain(emailDomainId, expand, Collections.emptyMap());
    }

    /**
     * Retrieve an Email Domain Retrieves an Email Domain by &#x60;emailDomainId&#x60;
     *
     * @param emailDomainId
     *            (required)
     * @param expand
     *            Specifies additional metadata to be included in the response (optional
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @return EmailDomainResponseWithEmbedded
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public EmailDomainResponseWithEmbedded getEmailDomain(String emailDomainId, List<String> expand,
            Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;

        // verify the required parameter 'emailDomainId' is set
        if (emailDomainId == null) {
            throw new ApiException(400, "Missing the required parameter 'emailDomainId' when calling getEmailDomain");
        }

        // create path and map variables
        String localVarPath = "/api/v1/email-domains/{emailDomainId}".replaceAll("\\{" + "emailDomainId" + "\\}",
                apiClient.escapeString(emailDomainId.toString()));

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarCollectionQueryParams.addAll(apiClient.parameterToPairs("csv", "expand", expand));

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        TypeReference<EmailDomainResponseWithEmbedded> localVarReturnType = new TypeReference<EmailDomainResponseWithEmbedded>() {
        };
        return apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * List all Email Domains Lists all the Email Domains in your org
     *
     * @param expand
     *            Specifies additional metadata to be included in the response (optional
     *
     * @return List&lt;EmailDomainResponseWithEmbedded&gt;
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public List<EmailDomainResponseWithEmbedded> listEmailDomains(List<String> expand) throws ApiException {
        return this.listEmailDomains(expand, Collections.emptyMap());
    }

    /**
     * List all Email Domains Lists all the Email Domains in your org
     *
     * @param expand
     *            Specifies additional metadata to be included in the response (optional
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @return List&lt;EmailDomainResponseWithEmbedded&gt;
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public List<EmailDomainResponseWithEmbedded> listEmailDomains(List<String> expand,
            Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/api/v1/email-domains";

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarCollectionQueryParams.addAll(apiClient.parameterToPairs("csv", "expand", expand));

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        TypeReference<List<EmailDomainResponseWithEmbedded>> localVarReturnType = new TypeReference<List<EmailDomainResponseWithEmbedded>>() {
        };
        return apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Replace an Email Domain Replaces associated username and sender display name by &#x60;emailDomainId&#x60;
     *
     * @param emailDomainId
     *            (required)
     * @param updateEmailDomain
     *            (required)
     * @param expand
     *            Specifies additional metadata to be included in the response (optional
     *
     * @return EmailDomainResponse
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public EmailDomainResponse replaceEmailDomain(String emailDomainId, UpdateEmailDomain updateEmailDomain,
            List<String> expand) throws ApiException {
        return this.replaceEmailDomain(emailDomainId, updateEmailDomain, expand, Collections.emptyMap());
    }

    /**
     * Replace an Email Domain Replaces associated username and sender display name by &#x60;emailDomainId&#x60;
     *
     * @param emailDomainId
     *            (required)
     * @param updateEmailDomain
     *            (required)
     * @param expand
     *            Specifies additional metadata to be included in the response (optional
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @return EmailDomainResponse
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public EmailDomainResponse replaceEmailDomain(String emailDomainId, UpdateEmailDomain updateEmailDomain,
            List<String> expand, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = updateEmailDomain;

        // verify the required parameter 'emailDomainId' is set
        if (emailDomainId == null) {
            throw new ApiException(400,
                    "Missing the required parameter 'emailDomainId' when calling replaceEmailDomain");
        }

        // verify the required parameter 'updateEmailDomain' is set
        if (updateEmailDomain == null) {
            throw new ApiException(400,
                    "Missing the required parameter 'updateEmailDomain' when calling replaceEmailDomain");
        }

        // create path and map variables
        String localVarPath = "/api/v1/email-domains/{emailDomainId}".replaceAll("\\{" + "emailDomainId" + "\\}",
                apiClient.escapeString(emailDomainId.toString()));

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarCollectionQueryParams.addAll(apiClient.parameterToPairs("csv", "expand", expand));

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

        final String[] localVarContentTypes = { "application/json" };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        TypeReference<EmailDomainResponse> localVarReturnType = new TypeReference<EmailDomainResponse>() {
        };
        return apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Verify an Email Domain Verifies an Email Domain by &#x60;emailDomainId&#x60;
     *
     * @param emailDomainId
     *            (required)
     *
     * @return EmailDomainResponse
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public EmailDomainResponse verifyEmailDomain(String emailDomainId) throws ApiException {
        return this.verifyEmailDomain(emailDomainId, Collections.emptyMap());
    }

    /**
     * Verify an Email Domain Verifies an Email Domain by &#x60;emailDomainId&#x60;
     *
     * @param emailDomainId
     *            (required)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @return EmailDomainResponse
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public EmailDomainResponse verifyEmailDomain(String emailDomainId, Map<String, String> additionalHeaders)
            throws ApiException {
        Object localVarPostBody = null;

        // verify the required parameter 'emailDomainId' is set
        if (emailDomainId == null) {
            throw new ApiException(400,
                    "Missing the required parameter 'emailDomainId' when calling verifyEmailDomain");
        }

        // create path and map variables
        String localVarPath = "/api/v1/email-domains/{emailDomainId}/verify".replaceAll("\\{" + "emailDomainId" + "\\}",
                apiClient.escapeString(emailDomainId.toString()));

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        TypeReference<EmailDomainResponse> localVarReturnType = new TypeReference<EmailDomainResponse>() {
        };
        return apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    protected static ObjectMapper getObjectMapper() {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.registerModule(new JavaTimeModule());
        objectMapper.registerModule(new JsonNullableModule());
        objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        objectMapper.configure(DeserializationFeature.READ_UNKNOWN_ENUM_VALUES_AS_NULL, true);
        return objectMapper;
    }

}
