/*
 * Okta Admin Management
 * Allows customers to easily access the Okta Management APIs
 *
 * The version of the OpenAPI document: 2024.08.3
 * Contact: devex-public@okta.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.okta.sdk.resource.api;

import com.fasterxml.jackson.core.type.TypeReference;

import com.okta.sdk.resource.client.ApiException;
import com.okta.sdk.resource.client.ApiClient;
import com.okta.sdk.resource.client.Configuration;
import com.okta.sdk.resource.model.*;
import com.okta.sdk.resource.client.Pair;

import com.okta.sdk.resource.model.Error;
import com.okta.sdk.resource.model.EventHook;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;

import org.openapitools.jackson.nullable.JsonNullableModule;

@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-01-23T09:50:29.349096-06:00[America/Chicago]", comments = "Generator version: 7.8.0")
public class EventHookApi {

    private ApiClient apiClient;

    public EventHookApi() {
        this(Configuration.getDefaultApiClient());
    }

    public EventHookApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    /**
     * Activate an Event Hook Activates the event hook that matches the provided &#x60;id&#x60;
     *
     * @param eventHookId
     *            &#x60;id&#x60; of the Event Hook (required)
     *
     * @return EventHook
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public EventHook activateEventHook(String eventHookId) throws ApiException {
        return this.activateEventHook(eventHookId, Collections.emptyMap());
    }

    /**
     * Activate an Event Hook Activates the event hook that matches the provided &#x60;id&#x60;
     *
     * @param eventHookId
     *            &#x60;id&#x60; of the Event Hook (required)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @return EventHook
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public EventHook activateEventHook(String eventHookId, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;

        // verify the required parameter 'eventHookId' is set
        if (eventHookId == null) {
            throw new ApiException(400, "Missing the required parameter 'eventHookId' when calling activateEventHook");
        }

        // create path and map variables
        String localVarPath = "/api/v1/eventHooks/{eventHookId}/lifecycle/activate"
                .replaceAll("\\{" + "eventHookId" + "\\}", apiClient.escapeString(eventHookId.toString()));

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        TypeReference<EventHook> localVarReturnType = new TypeReference<EventHook>() {
        };
        return apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Create an Event Hook Creates a new event hook for your organization in &#x60;ACTIVE&#x60; status. You pass an
     * event hook object in the JSON payload of your request. That object represents the set of required information
     * about the event hook you&#39;re registering, including: * The URI of your external service * The
     * [events](https://developer.okta.com/docs/reference/api/event-types/) in Okta you want to subscribe to * An
     * optional event hook filter that can reduce the number of event hook calls. This is a self-service Early Access
     * (EA) feature. See [Create an event hook
     * filter](https://developer.okta.com/docs/concepts/event-hooks/#create-an-event-hook-filter). Additionally, you can
     * specify a secret API key for Okta to pass to your external service endpoint for security verification. Note that
     * the API key you set here is unrelated to the Okta API token you must supply when making calls to Okta APIs.
     * Optionally, you can specify extra headers that Okta passes to your external service with each call. Your external
     * service must use a valid HTTPS endpoint.
     *
     * @param eventHook
     *            (required)
     *
     * @return EventHook
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public EventHook createEventHook(EventHook eventHook) throws ApiException {
        return this.createEventHook(eventHook, Collections.emptyMap());
    }

    /**
     * Create an Event Hook Creates a new event hook for your organization in &#x60;ACTIVE&#x60; status. You pass an
     * event hook object in the JSON payload of your request. That object represents the set of required information
     * about the event hook you&#39;re registering, including: * The URI of your external service * The
     * [events](https://developer.okta.com/docs/reference/api/event-types/) in Okta you want to subscribe to * An
     * optional event hook filter that can reduce the number of event hook calls. This is a self-service Early Access
     * (EA) feature. See [Create an event hook
     * filter](https://developer.okta.com/docs/concepts/event-hooks/#create-an-event-hook-filter). Additionally, you can
     * specify a secret API key for Okta to pass to your external service endpoint for security verification. Note that
     * the API key you set here is unrelated to the Okta API token you must supply when making calls to Okta APIs.
     * Optionally, you can specify extra headers that Okta passes to your external service with each call. Your external
     * service must use a valid HTTPS endpoint.
     *
     * @param eventHook
     *            (required)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @return EventHook
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public EventHook createEventHook(EventHook eventHook, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = eventHook;

        // verify the required parameter 'eventHook' is set
        if (eventHook == null) {
            throw new ApiException(400, "Missing the required parameter 'eventHook' when calling createEventHook");
        }

        // create path and map variables
        String localVarPath = "/api/v1/eventHooks";

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

        final String[] localVarContentTypes = { "application/json" };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        TypeReference<EventHook> localVarReturnType = new TypeReference<EventHook>() {
        };
        return apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Deactivate an Event Hook Deactivates the event hook that matches the provided &#x60;id&#x60;
     *
     * @param eventHookId
     *            &#x60;id&#x60; of the Event Hook (required)
     *
     * @return EventHook
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public EventHook deactivateEventHook(String eventHookId) throws ApiException {
        return this.deactivateEventHook(eventHookId, Collections.emptyMap());
    }

    /**
     * Deactivate an Event Hook Deactivates the event hook that matches the provided &#x60;id&#x60;
     *
     * @param eventHookId
     *            &#x60;id&#x60; of the Event Hook (required)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @return EventHook
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public EventHook deactivateEventHook(String eventHookId, Map<String, String> additionalHeaders)
            throws ApiException {
        Object localVarPostBody = null;

        // verify the required parameter 'eventHookId' is set
        if (eventHookId == null) {
            throw new ApiException(400,
                    "Missing the required parameter 'eventHookId' when calling deactivateEventHook");
        }

        // create path and map variables
        String localVarPath = "/api/v1/eventHooks/{eventHookId}/lifecycle/deactivate"
                .replaceAll("\\{" + "eventHookId" + "\\}", apiClient.escapeString(eventHookId.toString()));

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        TypeReference<EventHook> localVarReturnType = new TypeReference<EventHook>() {
        };
        return apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Delete an Event Hook Deletes the event hook that matches the provided &#x60;id&#x60;. After deletion, the event
     * hook is unrecoverable. As a safety precaution, you can only delete event hooks with a status of
     * &#x60;INACTIVE&#x60;.
     *
     * @param eventHookId
     *            &#x60;id&#x60; of the Event Hook (required)
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public void deleteEventHook(String eventHookId) throws ApiException {
        this.deleteEventHook(eventHookId, Collections.emptyMap());
    }

    /**
     * Delete an Event Hook Deletes the event hook that matches the provided &#x60;id&#x60;. After deletion, the event
     * hook is unrecoverable. As a safety precaution, you can only delete event hooks with a status of
     * &#x60;INACTIVE&#x60;.
     *
     * @param eventHookId
     *            &#x60;id&#x60; of the Event Hook (required)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public void deleteEventHook(String eventHookId, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;

        // verify the required parameter 'eventHookId' is set
        if (eventHookId == null) {
            throw new ApiException(400, "Missing the required parameter 'eventHookId' when calling deleteEventHook");
        }

        // create path and map variables
        String localVarPath = "/api/v1/eventHooks/{eventHookId}".replaceAll("\\{" + "eventHookId" + "\\}",
                apiClient.escapeString(eventHookId.toString()));

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    /**
     * Retrieve an Event Hook Retrieves an event hook
     *
     * @param eventHookId
     *            &#x60;id&#x60; of the Event Hook (required)
     *
     * @return EventHook
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public EventHook getEventHook(String eventHookId) throws ApiException {
        return this.getEventHook(eventHookId, Collections.emptyMap());
    }

    /**
     * Retrieve an Event Hook Retrieves an event hook
     *
     * @param eventHookId
     *            &#x60;id&#x60; of the Event Hook (required)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @return EventHook
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public EventHook getEventHook(String eventHookId, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;

        // verify the required parameter 'eventHookId' is set
        if (eventHookId == null) {
            throw new ApiException(400, "Missing the required parameter 'eventHookId' when calling getEventHook");
        }

        // create path and map variables
        String localVarPath = "/api/v1/eventHooks/{eventHookId}".replaceAll("\\{" + "eventHookId" + "\\}",
                apiClient.escapeString(eventHookId.toString()));

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        TypeReference<EventHook> localVarReturnType = new TypeReference<EventHook>() {
        };
        return apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * List all Event Hooks Lists all event hooks
     *
     * @return List&lt;EventHook&gt;
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public List<EventHook> listEventHooks() throws ApiException {
        return this.listEventHooks(Collections.emptyMap());
    }

    /**
     * List all Event Hooks Lists all event hooks
     *
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @return List&lt;EventHook&gt;
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public List<EventHook> listEventHooks(Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/api/v1/eventHooks";

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        TypeReference<List<EventHook>> localVarReturnType = new TypeReference<List<EventHook>>() {
        };
        return apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Replace an Event Hook Replaces an event hook. Okta validates the new properties before replacing the existing
     * values. Some event hook properties are immutable and can&#39;t be updated. Refer to the parameter description in
     * the request body schema. &gt;**Note:** Updating the &#x60;channel&#x60; property requires you to verify the hook
     * again.
     *
     * @param eventHookId
     *            &#x60;id&#x60; of the Event Hook (required)
     * @param eventHook
     *            (required)
     *
     * @return EventHook
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public EventHook replaceEventHook(String eventHookId, EventHook eventHook) throws ApiException {
        return this.replaceEventHook(eventHookId, eventHook, Collections.emptyMap());
    }

    /**
     * Replace an Event Hook Replaces an event hook. Okta validates the new properties before replacing the existing
     * values. Some event hook properties are immutable and can&#39;t be updated. Refer to the parameter description in
     * the request body schema. &gt;**Note:** Updating the &#x60;channel&#x60; property requires you to verify the hook
     * again.
     *
     * @param eventHookId
     *            &#x60;id&#x60; of the Event Hook (required)
     * @param eventHook
     *            (required)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @return EventHook
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public EventHook replaceEventHook(String eventHookId, EventHook eventHook, Map<String, String> additionalHeaders)
            throws ApiException {
        Object localVarPostBody = eventHook;

        // verify the required parameter 'eventHookId' is set
        if (eventHookId == null) {
            throw new ApiException(400, "Missing the required parameter 'eventHookId' when calling replaceEventHook");
        }

        // verify the required parameter 'eventHook' is set
        if (eventHook == null) {
            throw new ApiException(400, "Missing the required parameter 'eventHook' when calling replaceEventHook");
        }

        // create path and map variables
        String localVarPath = "/api/v1/eventHooks/{eventHookId}".replaceAll("\\{" + "eventHookId" + "\\}",
                apiClient.escapeString(eventHookId.toString()));

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

        final String[] localVarContentTypes = { "application/json" };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        TypeReference<EventHook> localVarReturnType = new TypeReference<EventHook>() {
        };
        return apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Verify an Event Hook Verifies that the event hook matches the provided &#x60;eventHookId&#x60;. To verify
     * ownership, your endpoint must send information back to Okta in JSON format. See [Event
     * hooks](https://developer.okta.com/docs/concepts/event-hooks/#one-time-verification-request). Only
     * &#x60;ACTIVE&#x60; and &#x60;VERIFIED&#x60; event hooks can receive events from Okta. If a response is not
     * received within 3 seconds, the outbound request times out. One retry is attempted after a timeout or error
     * response. If a successful response still isn&#39;t received, this operation returns a 400 error with more
     * information about the failure.
     *
     * @param eventHookId
     *            &#x60;id&#x60; of the Event Hook (required)
     *
     * @return EventHook
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public EventHook verifyEventHook(String eventHookId) throws ApiException {
        return this.verifyEventHook(eventHookId, Collections.emptyMap());
    }

    /**
     * Verify an Event Hook Verifies that the event hook matches the provided &#x60;eventHookId&#x60;. To verify
     * ownership, your endpoint must send information back to Okta in JSON format. See [Event
     * hooks](https://developer.okta.com/docs/concepts/event-hooks/#one-time-verification-request). Only
     * &#x60;ACTIVE&#x60; and &#x60;VERIFIED&#x60; event hooks can receive events from Okta. If a response is not
     * received within 3 seconds, the outbound request times out. One retry is attempted after a timeout or error
     * response. If a successful response still isn&#39;t received, this operation returns a 400 error with more
     * information about the failure.
     *
     * @param eventHookId
     *            &#x60;id&#x60; of the Event Hook (required)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @return EventHook
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public EventHook verifyEventHook(String eventHookId, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;

        // verify the required parameter 'eventHookId' is set
        if (eventHookId == null) {
            throw new ApiException(400, "Missing the required parameter 'eventHookId' when calling verifyEventHook");
        }

        // create path and map variables
        String localVarPath = "/api/v1/eventHooks/{eventHookId}/lifecycle/verify"
                .replaceAll("\\{" + "eventHookId" + "\\}", apiClient.escapeString(eventHookId.toString()));

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        TypeReference<EventHook> localVarReturnType = new TypeReference<EventHook>() {
        };
        return apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    protected static ObjectMapper getObjectMapper() {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.registerModule(new JavaTimeModule());
        objectMapper.registerModule(new JsonNullableModule());
        objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        objectMapper.configure(DeserializationFeature.READ_UNKNOWN_ENUM_VALUES_AS_NULL, true);
        return objectMapper;
    }

}
