/*
 * Okta Admin Management
 * Allows customers to easily access the Okta Management APIs
 *
 * The version of the OpenAPI document: 2024.08.3
 * Contact: devex-public@okta.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.okta.sdk.resource.api;

import com.fasterxml.jackson.core.type.TypeReference;

import com.okta.sdk.resource.client.ApiException;
import com.okta.sdk.resource.client.ApiClient;
import com.okta.sdk.resource.client.Configuration;
import com.okta.sdk.resource.model.*;
import com.okta.sdk.resource.client.Pair;

import com.okta.sdk.resource.model.AddGroupRequest;
import com.okta.sdk.resource.model.Application;
import com.okta.sdk.resource.model.Error;
import com.okta.sdk.resource.model.Group;
import com.okta.sdk.resource.model.User;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;

import org.openapitools.jackson.nullable.JsonNullableModule;

@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-01-23T09:50:29.349096-06:00[America/Chicago]", comments = "Generator version: 7.8.0")
public class GroupApi {

    private ApiClient apiClient;

    public GroupApi() {
        this(Configuration.getDefaultApiClient());
    }

    public GroupApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    /**
     * Add a Group Adds a new Group with the &#x60;OKTA_GROUP&#x60; type to your org &gt; **Note:** App import
     * operations are responsible for syncing Groups with &#x60;APP_GROUP&#x60; type such as Active Directory Groups.
     * See [About groups](https://help.okta.com/okta_help.htm?id&#x3D;Directory_Groups).
     *
     * @param group
     *            (required)
     *
     * @return Group
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public Group addGroup(AddGroupRequest group) throws ApiException {
        return this.addGroup(group, Collections.emptyMap());
    }

    /**
     * Add a Group Adds a new Group with the &#x60;OKTA_GROUP&#x60; type to your org &gt; **Note:** App import
     * operations are responsible for syncing Groups with &#x60;APP_GROUP&#x60; type such as Active Directory Groups.
     * See [About groups](https://help.okta.com/okta_help.htm?id&#x3D;Directory_Groups).
     *
     * @param group
     *            (required)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @return Group
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public Group addGroup(AddGroupRequest group, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = group;

        // verify the required parameter 'group' is set
        if (group == null) {
            throw new ApiException(400, "Missing the required parameter 'group' when calling addGroup");
        }

        // create path and map variables
        String localVarPath = "/api/v1/groups";

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

        final String[] localVarContentTypes = { "application/json" };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        TypeReference<Group> localVarReturnType = new TypeReference<Group>() {
        };
        return apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Assign a User to a Group Assigns a User to a Group with the &#x60;OKTA_GROUP&#x60; type &gt; **Note:** You only
     * can modify memberships for Groups of the &#x60;OKTA_GROUP&#x60; type. App imports are responsible for managing
     * group memberships for Groups of the &#x60;APP_GROUP&#x60; type, such as Active Directory groups.
     *
     * @param groupId
     *            The &#x60;id&#x60; of the group (required)
     * @param userId
     *            ID of an existing Okta user (required)
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public void assignUserToGroup(String groupId, String userId) throws ApiException {
        this.assignUserToGroup(groupId, userId, Collections.emptyMap());
    }

    /**
     * Assign a User to a Group Assigns a User to a Group with the &#x60;OKTA_GROUP&#x60; type &gt; **Note:** You only
     * can modify memberships for Groups of the &#x60;OKTA_GROUP&#x60; type. App imports are responsible for managing
     * group memberships for Groups of the &#x60;APP_GROUP&#x60; type, such as Active Directory groups.
     *
     * @param groupId
     *            The &#x60;id&#x60; of the group (required)
     * @param userId
     *            ID of an existing Okta user (required)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public void assignUserToGroup(String groupId, String userId, Map<String, String> additionalHeaders)
            throws ApiException {
        Object localVarPostBody = null;

        // verify the required parameter 'groupId' is set
        if (groupId == null) {
            throw new ApiException(400, "Missing the required parameter 'groupId' when calling assignUserToGroup");
        }

        // verify the required parameter 'userId' is set
        if (userId == null) {
            throw new ApiException(400, "Missing the required parameter 'userId' when calling assignUserToGroup");
        }

        // create path and map variables
        String localVarPath = "/api/v1/groups/{groupId}/users/{userId}"
                .replaceAll("\\{" + "groupId" + "\\}", apiClient.escapeString(groupId.toString()))
                .replaceAll("\\{" + "userId" + "\\}", apiClient.escapeString(userId.toString()));

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    /**
     * Delete a Group Deletes a Group of the &#x60;OKTA_GROUP&#x60; or &#x60;APP_GROUP&#x60; type from your org &gt;
     * **Note:** You can&#39;t remove Groups of type &#x60;APP_GROUP&#x60; if they are used in a group push mapping.
     *
     * @param groupId
     *            The &#x60;id&#x60; of the group (required)
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public void deleteGroup(String groupId) throws ApiException {
        this.deleteGroup(groupId, Collections.emptyMap());
    }

    /**
     * Delete a Group Deletes a Group of the &#x60;OKTA_GROUP&#x60; or &#x60;APP_GROUP&#x60; type from your org &gt;
     * **Note:** You can&#39;t remove Groups of type &#x60;APP_GROUP&#x60; if they are used in a group push mapping.
     *
     * @param groupId
     *            The &#x60;id&#x60; of the group (required)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public void deleteGroup(String groupId, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;

        // verify the required parameter 'groupId' is set
        if (groupId == null) {
            throw new ApiException(400, "Missing the required parameter 'groupId' when calling deleteGroup");
        }

        // create path and map variables
        String localVarPath = "/api/v1/groups/{groupId}".replaceAll("\\{" + "groupId" + "\\}",
                apiClient.escapeString(groupId.toString()));

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    /**
     * Retrieve a Group Retrieves a specific Group by &#x60;id&#x60; from your org
     *
     * @param groupId
     *            The &#x60;id&#x60; of the group (required)
     *
     * @return Group
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public Group getGroup(String groupId) throws ApiException {
        return this.getGroup(groupId, Collections.emptyMap());
    }

    /**
     * Retrieve a Group Retrieves a specific Group by &#x60;id&#x60; from your org
     *
     * @param groupId
     *            The &#x60;id&#x60; of the group (required)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @return Group
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public Group getGroup(String groupId, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;

        // verify the required parameter 'groupId' is set
        if (groupId == null) {
            throw new ApiException(400, "Missing the required parameter 'groupId' when calling getGroup");
        }

        // create path and map variables
        String localVarPath = "/api/v1/groups/{groupId}".replaceAll("\\{" + "groupId" + "\\}",
                apiClient.escapeString(groupId.toString()));

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        TypeReference<Group> localVarReturnType = new TypeReference<Group>() {
        };
        return apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * List all Assigned Applications Lists all apps that are assigned to a Group. See [Application Groups
     * API](/openapi/okta-management/management/tag/ApplicationGroups/).
     *
     * @param groupId
     *            The &#x60;id&#x60; of the group (required)
     * @param after
     *            Specifies the pagination cursor for the next page of apps (optional)
     * @param limit
     *            Specifies the number of app results for a page (optional, default to 20)
     *
     * @return List&lt;Application&gt;
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public List<Application> listAssignedApplicationsForGroup(String groupId, String after, Integer limit)
            throws ApiException {
        return this.listAssignedApplicationsForGroup(groupId, after, limit, Collections.emptyMap());
    }

    /**
     * List all Assigned Applications Lists all apps that are assigned to a Group. See [Application Groups
     * API](/openapi/okta-management/management/tag/ApplicationGroups/).
     *
     * @param groupId
     *            The &#x60;id&#x60; of the group (required)
     * @param after
     *            Specifies the pagination cursor for the next page of apps (optional)
     * @param limit
     *            Specifies the number of app results for a page (optional, default to 20)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @return List&lt;Application&gt;
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public List<Application> listAssignedApplicationsForGroup(String groupId, String after, Integer limit,
            Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;

        // verify the required parameter 'groupId' is set
        if (groupId == null) {
            throw new ApiException(400,
                    "Missing the required parameter 'groupId' when calling listAssignedApplicationsForGroup");
        }

        // create path and map variables
        String localVarPath = "/api/v1/groups/{groupId}/apps".replaceAll("\\{" + "groupId" + "\\}",
                apiClient.escapeString(groupId.toString()));

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarQueryParams.addAll(apiClient.parameterToPair("after", after));
        localVarQueryParams.addAll(apiClient.parameterToPair("limit", limit));

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        TypeReference<List<Application>> localVarReturnType = new TypeReference<List<Application>>() {
        };
        return apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * List all Member Users Lists all users that are a member of a Group. The default user limit is set to a very high
     * number due to historical reasons that are no longer valid for most orgs. This will change in a future version of
     * this API. The recommended page limit is now &#x60;limit&#x3D;200&#x60;.
     *
     * @param groupId
     *            The &#x60;id&#x60; of the group (required)
     * @param after
     *            The cursor to use for pagination. It is an opaque string that specifies your current location in the
     *            list and is obtained from the &#x60;Link&#x60; response header. See
     *            [Pagination](https://developer.okta.com/docs/api/#pagination). (optional)
     * @param limit
     *            Specifies the number of user results in a page (optional, default to 1000)
     *
     * @return List&lt;User&gt;
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public List<User> listGroupUsers(String groupId, String after, Integer limit) throws ApiException {
        return this.listGroupUsers(groupId, after, limit, Collections.emptyMap());
    }

    /**
     * List all Member Users Lists all users that are a member of a Group. The default user limit is set to a very high
     * number due to historical reasons that are no longer valid for most orgs. This will change in a future version of
     * this API. The recommended page limit is now &#x60;limit&#x3D;200&#x60;.
     *
     * @param groupId
     *            The &#x60;id&#x60; of the group (required)
     * @param after
     *            The cursor to use for pagination. It is an opaque string that specifies your current location in the
     *            list and is obtained from the &#x60;Link&#x60; response header. See
     *            [Pagination](https://developer.okta.com/docs/api/#pagination). (optional)
     * @param limit
     *            Specifies the number of user results in a page (optional, default to 1000)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @return List&lt;User&gt;
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public List<User> listGroupUsers(String groupId, String after, Integer limit, Map<String, String> additionalHeaders)
            throws ApiException {
        Object localVarPostBody = null;

        // verify the required parameter 'groupId' is set
        if (groupId == null) {
            throw new ApiException(400, "Missing the required parameter 'groupId' when calling listGroupUsers");
        }

        // create path and map variables
        String localVarPath = "/api/v1/groups/{groupId}/users".replaceAll("\\{" + "groupId" + "\\}",
                apiClient.escapeString(groupId.toString()));

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarQueryParams.addAll(apiClient.parameterToPair("after", after));
        localVarQueryParams.addAll(apiClient.parameterToPair("limit", limit));

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        TypeReference<List<User>> localVarReturnType = new TypeReference<List<User>>() {
        };
        return apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * List all Groups Lists all Groups with pagination support. The number of Groups returned depends on the specified
     * [&#x60;limit&#x60;](/openapi/okta-management/management/tag/Group/#tag/Group/operation/listGroups!in&#x3D;query&amp;path&#x3D;limit&amp;t&#x3D;request),
     * if you have a search, filter, and/or query parameter set, and if that parameter is not null. We recommend using a
     * limit less than or equal to 200. A subset of Groups can be returned that match a supported filter expression,
     * query, or search criteria. &gt; **Note:** Results from the filter or query parameter are driven from an
     * eventually consistent datasource. The synchronization lag is typically less than one second. See
     * [Filtering](https://developer.okta.com/docs/api/#filter) for more information on expressions.
     *
     * @param q
     *            Finds a Group that matches the &#x60;name&#x60; property &gt; **Note:** Paging and searching are
     *            currently mutually exclusive. You can&#39;t page a query. The default limit for a query is 300
     *            results. Query is intended for an auto-complete picker use case where users refine their search string
     *            to constrain the results. (optional)
     * @param filter
     *            [Filter expression](https://developer.okta.com/docs/reference/core-okta-api/#filter) for Groups &gt;
     *            **Note:** All filters must be [URL
     *            encoded](https://developer.mozilla.org/en-US/docs/Glossary/Percent-encoding). For example,
     *            &#x60;filter&#x3D;lastUpdated gt \&quot;2013-06-01T00:00:00.000Z\&quot;&#x60; is encoded as
     *            &#x60;filter&#x3D;lastUpdated%20gt%20%222013-06-01T00:00:00.000Z%22&#x60;. (optional)
     * @param after
     *            Specifies the pagination cursor for the next page of Groups. The &#x60;after&#x60; cursor should be
     *            treated as an opaque value and obtained through the next link relation. See
     *            [Pagination](https://developer.okta.com/docs/api/#pagination). (optional)
     * @param limit
     *            Specifies the number of Group results in a page. Don&#39;t write code that depends on the default or
     *            maximum value, as it might change. If you receive an &#x60;HTTP 500&#x60; status code, you likely
     *            exceeded the request timeout. Retry your request with a smaller &#x60;limit&#x60; and [page the
     *            results](https://developer.okta.com/docs/api/#pagination). The Okta default Everyone group isn&#39;t
     *            returned for users with a Group Admin role. &gt;**Note:** We strongly encourage using a limit
     *            that&#39;s less than or equal to 200. Any number greater than 200 affects performance and accuracy.
     *            (optional)
     * @param expand
     *            If specified, additional metadata is included in the response. Possible values are &#x60;stats&#x60;
     *            and &#x60;app&#x60;. (optional)
     * @param search
     *            Searches for groups with a supported
     *            [filtering](https://developer.okta.com/docs/reference/core-okta-api/#filter) expression for all
     *            attributes except for &#x60;_embedded&#x60;, &#x60;_links&#x60;, and &#x60;objectClass&#x60;. Search
     *            currently performs a &#x60;startsWith&#x60; match but it should be considered an implementation detail
     *            and might change without notice in the future. This operation supports
     *            [pagination](https://developer.okta.com/docs/api/#pagination). Using search requires [URL
     *            encoding](https://developer.mozilla.org/en-US/docs/Glossary/Percent-encoding), for example,
     *            &#x60;search&#x3D;type eq \&quot;OKTA_GROUP\&quot;&#x60; is encoded as
     *            &#x60;search&#x3D;type+eq+%22OKTA_GROUP%22&#x60;. This operation searches many properties: * Any group
     *            profile property, including imported app group profile properties. * The top-level properties
     *            &#x60;id&#x60;, &#x60;created&#x60;, &#x60;lastMembershipUpdated&#x60;, &#x60;lastUpdated&#x60;, and
     *            &#x60;type&#x60;. * The
     *            [source](/openapi/okta-management/management/tag/Group/#tag/Group/operation/listGroups!c&#x3D;200&amp;path&#x3D;_links/source&amp;t&#x3D;response)
     *            of groups with type of &#x60;APP_GROUP&#x60;, accessed as &#x60;source.id&#x60;. You can also use
     *            &#x60;sortBy&#x60; and &#x60;sortOrder&#x60; parameters. (optional)
     * @param sortBy
     *            Specifies field to sort by **(for search queries only)**. &#x60;sortBy&#x60; can be any single
     *            property, for example &#x60;sortBy&#x3D;profile.name&#x60;. (optional)
     * @param sortOrder
     *            Specifies sort order: &#x60;asc&#x60; or &#x60;desc&#x60; (for search queries only). This parameter is
     *            ignored if if &#x60;sortBy&#x60; is not present. Groups with the same value for the &#x60;sortBy&#x60;
     *            property will be ordered by &#x60;id&#x60; (optional, default to asc)
     *
     * @return List&lt;Group&gt;
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public List<Group> listGroups(String q, String filter, String after, Integer limit, String expand, String search,
            String sortBy, String sortOrder) throws ApiException {
        return this.listGroups(q, filter, after, limit, expand, search, sortBy, sortOrder, Collections.emptyMap());
    }

    /**
     * List all Groups Lists all Groups with pagination support. The number of Groups returned depends on the specified
     * [&#x60;limit&#x60;](/openapi/okta-management/management/tag/Group/#tag/Group/operation/listGroups!in&#x3D;query&amp;path&#x3D;limit&amp;t&#x3D;request),
     * if you have a search, filter, and/or query parameter set, and if that parameter is not null. We recommend using a
     * limit less than or equal to 200. A subset of Groups can be returned that match a supported filter expression,
     * query, or search criteria. &gt; **Note:** Results from the filter or query parameter are driven from an
     * eventually consistent datasource. The synchronization lag is typically less than one second. See
     * [Filtering](https://developer.okta.com/docs/api/#filter) for more information on expressions.
     *
     * @param q
     *            Finds a Group that matches the &#x60;name&#x60; property &gt; **Note:** Paging and searching are
     *            currently mutually exclusive. You can&#39;t page a query. The default limit for a query is 300
     *            results. Query is intended for an auto-complete picker use case where users refine their search string
     *            to constrain the results. (optional)
     * @param filter
     *            [Filter expression](https://developer.okta.com/docs/reference/core-okta-api/#filter) for Groups &gt;
     *            **Note:** All filters must be [URL
     *            encoded](https://developer.mozilla.org/en-US/docs/Glossary/Percent-encoding). For example,
     *            &#x60;filter&#x3D;lastUpdated gt \&quot;2013-06-01T00:00:00.000Z\&quot;&#x60; is encoded as
     *            &#x60;filter&#x3D;lastUpdated%20gt%20%222013-06-01T00:00:00.000Z%22&#x60;. (optional)
     * @param after
     *            Specifies the pagination cursor for the next page of Groups. The &#x60;after&#x60; cursor should be
     *            treated as an opaque value and obtained through the next link relation. See
     *            [Pagination](https://developer.okta.com/docs/api/#pagination). (optional)
     * @param limit
     *            Specifies the number of Group results in a page. Don&#39;t write code that depends on the default or
     *            maximum value, as it might change. If you receive an &#x60;HTTP 500&#x60; status code, you likely
     *            exceeded the request timeout. Retry your request with a smaller &#x60;limit&#x60; and [page the
     *            results](https://developer.okta.com/docs/api/#pagination). The Okta default Everyone group isn&#39;t
     *            returned for users with a Group Admin role. &gt;**Note:** We strongly encourage using a limit
     *            that&#39;s less than or equal to 200. Any number greater than 200 affects performance and accuracy.
     *            (optional)
     * @param expand
     *            If specified, additional metadata is included in the response. Possible values are &#x60;stats&#x60;
     *            and &#x60;app&#x60;. (optional)
     * @param search
     *            Searches for groups with a supported
     *            [filtering](https://developer.okta.com/docs/reference/core-okta-api/#filter) expression for all
     *            attributes except for &#x60;_embedded&#x60;, &#x60;_links&#x60;, and &#x60;objectClass&#x60;. Search
     *            currently performs a &#x60;startsWith&#x60; match but it should be considered an implementation detail
     *            and might change without notice in the future. This operation supports
     *            [pagination](https://developer.okta.com/docs/api/#pagination). Using search requires [URL
     *            encoding](https://developer.mozilla.org/en-US/docs/Glossary/Percent-encoding), for example,
     *            &#x60;search&#x3D;type eq \&quot;OKTA_GROUP\&quot;&#x60; is encoded as
     *            &#x60;search&#x3D;type+eq+%22OKTA_GROUP%22&#x60;. This operation searches many properties: * Any group
     *            profile property, including imported app group profile properties. * The top-level properties
     *            &#x60;id&#x60;, &#x60;created&#x60;, &#x60;lastMembershipUpdated&#x60;, &#x60;lastUpdated&#x60;, and
     *            &#x60;type&#x60;. * The
     *            [source](/openapi/okta-management/management/tag/Group/#tag/Group/operation/listGroups!c&#x3D;200&amp;path&#x3D;_links/source&amp;t&#x3D;response)
     *            of groups with type of &#x60;APP_GROUP&#x60;, accessed as &#x60;source.id&#x60;. You can also use
     *            &#x60;sortBy&#x60; and &#x60;sortOrder&#x60; parameters. (optional)
     * @param sortBy
     *            Specifies field to sort by **(for search queries only)**. &#x60;sortBy&#x60; can be any single
     *            property, for example &#x60;sortBy&#x3D;profile.name&#x60;. (optional)
     * @param sortOrder
     *            Specifies sort order: &#x60;asc&#x60; or &#x60;desc&#x60; (for search queries only). This parameter is
     *            ignored if if &#x60;sortBy&#x60; is not present. Groups with the same value for the &#x60;sortBy&#x60;
     *            property will be ordered by &#x60;id&#x60; (optional, default to asc)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @return List&lt;Group&gt;
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public List<Group> listGroups(String q, String filter, String after, Integer limit, String expand, String search,
            String sortBy, String sortOrder, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/api/v1/groups";

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarQueryParams.addAll(apiClient.parameterToPair("q", q));
        localVarQueryParams.addAll(apiClient.parameterToPair("filter", filter));
        localVarQueryParams.addAll(apiClient.parameterToPair("after", after));
        localVarQueryParams.addAll(apiClient.parameterToPair("limit", limit));
        localVarQueryParams.addAll(apiClient.parameterToPair("expand", expand));
        localVarQueryParams.addAll(apiClient.parameterToPair("search", search));
        localVarQueryParams.addAll(apiClient.parameterToPair("sortBy", sortBy));
        localVarQueryParams.addAll(apiClient.parameterToPair("sortOrder", sortOrder));

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        TypeReference<List<Group>> localVarReturnType = new TypeReference<List<Group>>() {
        };
        return apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Replace a Group Replaces the profile for a Group of &#x60;OKTA_GROUP&#x60; type from your org &gt; **Note :** You
     * only can modify profiles for groups of the &#x60;OKTA_GROUP&#x60; type. &gt; &gt; App imports are responsible for
     * updating profiles for groups of the &#x60;APP_GROUP&#x60; type, such as Active Directory groups.
     *
     * @param groupId
     *            The &#x60;id&#x60; of the group (required)
     * @param group
     *            (required)
     *
     * @return Group
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public Group replaceGroup(String groupId, AddGroupRequest group) throws ApiException {
        return this.replaceGroup(groupId, group, Collections.emptyMap());
    }

    /**
     * Replace a Group Replaces the profile for a Group of &#x60;OKTA_GROUP&#x60; type from your org &gt; **Note :** You
     * only can modify profiles for groups of the &#x60;OKTA_GROUP&#x60; type. &gt; &gt; App imports are responsible for
     * updating profiles for groups of the &#x60;APP_GROUP&#x60; type, such as Active Directory groups.
     *
     * @param groupId
     *            The &#x60;id&#x60; of the group (required)
     * @param group
     *            (required)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @return Group
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public Group replaceGroup(String groupId, AddGroupRequest group, Map<String, String> additionalHeaders)
            throws ApiException {
        Object localVarPostBody = group;

        // verify the required parameter 'groupId' is set
        if (groupId == null) {
            throw new ApiException(400, "Missing the required parameter 'groupId' when calling replaceGroup");
        }

        // verify the required parameter 'group' is set
        if (group == null) {
            throw new ApiException(400, "Missing the required parameter 'group' when calling replaceGroup");
        }

        // create path and map variables
        String localVarPath = "/api/v1/groups/{groupId}".replaceAll("\\{" + "groupId" + "\\}",
                apiClient.escapeString(groupId.toString()));

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

        final String[] localVarContentTypes = { "application/json" };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        TypeReference<Group> localVarReturnType = new TypeReference<Group>() {
        };
        return apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Unassign a User from a Group Unassigns a User from a Group with the &#x60;OKTA_GROUP&#x60; type &gt; **Note:**
     * You only can modify memberships for groups of the &#x60;OKTA_GROUP&#x60; type. &gt; &gt; App imports are
     * responsible for managing group memberships for groups of the &#x60;APP_GROUP&#x60; type, such as Active Directory
     * groups.
     *
     * @param groupId
     *            The &#x60;id&#x60; of the group (required)
     * @param userId
     *            ID of an existing Okta user (required)
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public void unassignUserFromGroup(String groupId, String userId) throws ApiException {
        this.unassignUserFromGroup(groupId, userId, Collections.emptyMap());
    }

    /**
     * Unassign a User from a Group Unassigns a User from a Group with the &#x60;OKTA_GROUP&#x60; type &gt; **Note:**
     * You only can modify memberships for groups of the &#x60;OKTA_GROUP&#x60; type. &gt; &gt; App imports are
     * responsible for managing group memberships for groups of the &#x60;APP_GROUP&#x60; type, such as Active Directory
     * groups.
     *
     * @param groupId
     *            The &#x60;id&#x60; of the group (required)
     * @param userId
     *            ID of an existing Okta user (required)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public void unassignUserFromGroup(String groupId, String userId, Map<String, String> additionalHeaders)
            throws ApiException {
        Object localVarPostBody = null;

        // verify the required parameter 'groupId' is set
        if (groupId == null) {
            throw new ApiException(400, "Missing the required parameter 'groupId' when calling unassignUserFromGroup");
        }

        // verify the required parameter 'userId' is set
        if (userId == null) {
            throw new ApiException(400, "Missing the required parameter 'userId' when calling unassignUserFromGroup");
        }

        // create path and map variables
        String localVarPath = "/api/v1/groups/{groupId}/users/{userId}"
                .replaceAll("\\{" + "groupId" + "\\}", apiClient.escapeString(groupId.toString()))
                .replaceAll("\\{" + "userId" + "\\}", apiClient.escapeString(userId.toString()));

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    protected static ObjectMapper getObjectMapper() {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.registerModule(new JavaTimeModule());
        objectMapper.registerModule(new JsonNullableModule());
        objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        objectMapper.configure(DeserializationFeature.READ_UNKNOWN_ENUM_VALUES_AS_NULL, true);
        return objectMapper;
    }

}
