/*
 * Okta Admin Management
 * Allows customers to easily access the Okta Management APIs
 *
 * The version of the OpenAPI document: 2024.08.3
 * Contact: devex-public@okta.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.okta.sdk.resource.api;

import com.fasterxml.jackson.core.type.TypeReference;

import com.okta.sdk.resource.client.ApiException;
import com.okta.sdk.resource.client.ApiClient;
import com.okta.sdk.resource.client.Configuration;
import com.okta.sdk.resource.model.*;
import com.okta.sdk.resource.client.Pair;

import com.okta.sdk.resource.model.Error;
import com.okta.sdk.resource.model.OrgOktaCommunicationSetting;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;

import org.openapitools.jackson.nullable.JsonNullableModule;

@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-01-23T09:50:29.349096-06:00[America/Chicago]", comments = "Generator version: 7.8.0")
public class OrgSettingCommunicationApi {

    private ApiClient apiClient;

    public OrgSettingCommunicationApi() {
        this(Configuration.getDefaultApiClient());
    }

    public OrgSettingCommunicationApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    /**
     * Retrieve the Okta Communication Settings Retrieves Okta Communication Settings of your org
     *
     * @return OrgOktaCommunicationSetting
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public OrgOktaCommunicationSetting getOktaCommunicationSettings() throws ApiException {
        return this.getOktaCommunicationSettings(Collections.emptyMap());
    }

    /**
     * Retrieve the Okta Communication Settings Retrieves Okta Communication Settings of your org
     *
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @return OrgOktaCommunicationSetting
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public OrgOktaCommunicationSetting getOktaCommunicationSettings(Map<String, String> additionalHeaders)
            throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/api/v1/org/privacy/oktaCommunication";

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        TypeReference<OrgOktaCommunicationSetting> localVarReturnType = new TypeReference<OrgOktaCommunicationSetting>() {
        };
        return apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Opt in to Okta User Communication Emails Opts in all users of this org to Okta communication emails
     *
     * @return OrgOktaCommunicationSetting
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public OrgOktaCommunicationSetting optInUsersToOktaCommunicationEmails() throws ApiException {
        return this.optInUsersToOktaCommunicationEmails(Collections.emptyMap());
    }

    /**
     * Opt in to Okta User Communication Emails Opts in all users of this org to Okta communication emails
     *
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @return OrgOktaCommunicationSetting
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public OrgOktaCommunicationSetting optInUsersToOktaCommunicationEmails(Map<String, String> additionalHeaders)
            throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/api/v1/org/privacy/oktaCommunication/optIn";

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        TypeReference<OrgOktaCommunicationSetting> localVarReturnType = new TypeReference<OrgOktaCommunicationSetting>() {
        };
        return apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Opt out of Okta User Communication Emails Opts out all users of this org from Okta communication emails
     *
     * @return OrgOktaCommunicationSetting
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public OrgOktaCommunicationSetting optOutUsersFromOktaCommunicationEmails() throws ApiException {
        return this.optOutUsersFromOktaCommunicationEmails(Collections.emptyMap());
    }

    /**
     * Opt out of Okta User Communication Emails Opts out all users of this org from Okta communication emails
     *
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @return OrgOktaCommunicationSetting
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public OrgOktaCommunicationSetting optOutUsersFromOktaCommunicationEmails(Map<String, String> additionalHeaders)
            throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/api/v1/org/privacy/oktaCommunication/optOut";

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        TypeReference<OrgOktaCommunicationSetting> localVarReturnType = new TypeReference<OrgOktaCommunicationSetting>() {
        };
        return apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    protected static ObjectMapper getObjectMapper() {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.registerModule(new JavaTimeModule());
        objectMapper.registerModule(new JsonNullableModule());
        objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        objectMapper.configure(DeserializationFeature.READ_UNKNOWN_ENUM_VALUES_AS_NULL, true);
        return objectMapper;
    }

}
