/*
 * Okta Admin Management
 * Allows customers to easily access the Okta Management APIs
 *
 * The version of the OpenAPI document: 2024.08.3
 * Contact: devex-public@okta.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.okta.sdk.resource.api;

import com.fasterxml.jackson.core.type.TypeReference;

import com.okta.sdk.resource.client.ApiException;
import com.okta.sdk.resource.client.ApiClient;
import com.okta.sdk.resource.client.Configuration;
import com.okta.sdk.resource.model.*;
import com.okta.sdk.resource.client.Pair;

import com.okta.sdk.resource.model.Error;
import com.okta.sdk.resource.model.OrgSetting;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;

import org.openapitools.jackson.nullable.JsonNullableModule;

@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-01-23T09:50:29.349096-06:00[America/Chicago]", comments = "Generator version: 7.8.0")
public class OrgSettingGeneralApi {

    private ApiClient apiClient;

    public OrgSettingGeneralApi() {
        this(Configuration.getDefaultApiClient());
    }

    public OrgSettingGeneralApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    /**
     * Retrieve the Org General Settings Retrieves the Org General Settings
     *
     * @return OrgSetting
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public OrgSetting getOrgSettings() throws ApiException {
        return this.getOrgSettings(Collections.emptyMap());
    }

    /**
     * Retrieve the Org General Settings Retrieves the Org General Settings
     *
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @return OrgSetting
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public OrgSetting getOrgSettings(Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/api/v1/org";

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        TypeReference<OrgSetting> localVarReturnType = new TypeReference<OrgSetting>() {
        };
        return apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Replace the Org General Settings Replaces the Org General Settings for your Okta org
     *
     * @param orgSetting
     *            (required)
     *
     * @return OrgSetting
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public OrgSetting replaceOrgSettings(OrgSetting orgSetting) throws ApiException {
        return this.replaceOrgSettings(orgSetting, Collections.emptyMap());
    }

    /**
     * Replace the Org General Settings Replaces the Org General Settings for your Okta org
     *
     * @param orgSetting
     *            (required)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @return OrgSetting
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public OrgSetting replaceOrgSettings(OrgSetting orgSetting, Map<String, String> additionalHeaders)
            throws ApiException {
        Object localVarPostBody = orgSetting;

        // verify the required parameter 'orgSetting' is set
        if (orgSetting == null) {
            throw new ApiException(400, "Missing the required parameter 'orgSetting' when calling replaceOrgSettings");
        }

        // create path and map variables
        String localVarPath = "/api/v1/org";

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

        final String[] localVarContentTypes = { "application/json" };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        TypeReference<OrgSetting> localVarReturnType = new TypeReference<OrgSetting>() {
        };
        return apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Update the Org General Settings Updates partial Org General Settings
     *
     * @param orgSetting
     *            (optional)
     *
     * @return OrgSetting
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public OrgSetting updateOrgSettings(OrgSetting orgSetting) throws ApiException {
        return this.updateOrgSettings(orgSetting, Collections.emptyMap());
    }

    /**
     * Update the Org General Settings Updates partial Org General Settings
     *
     * @param orgSetting
     *            (optional)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @return OrgSetting
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public OrgSetting updateOrgSettings(OrgSetting orgSetting, Map<String, String> additionalHeaders)
            throws ApiException {
        Object localVarPostBody = orgSetting;

        // create path and map variables
        String localVarPath = "/api/v1/org";

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

        final String[] localVarContentTypes = { "application/json" };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        TypeReference<OrgSetting> localVarReturnType = new TypeReference<OrgSetting>() {
        };
        return apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    protected static ObjectMapper getObjectMapper() {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.registerModule(new JavaTimeModule());
        objectMapper.registerModule(new JsonNullableModule());
        objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        objectMapper.configure(DeserializationFeature.READ_UNKNOWN_ENUM_VALUES_AS_NULL, true);
        return objectMapper;
    }

}
