/*
 * Okta Admin Management
 * Allows customers to easily access the Okta Management APIs
 *
 * The version of the OpenAPI document: 2024.08.3
 * Contact: devex-public@okta.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.okta.sdk.resource.api;

import com.fasterxml.jackson.core.type.TypeReference;

import com.okta.sdk.resource.client.ApiException;
import com.okta.sdk.resource.client.ApiClient;
import com.okta.sdk.resource.client.Configuration;
import com.okta.sdk.resource.model.*;
import com.okta.sdk.resource.client.Pair;

import com.okta.sdk.resource.model.Error;
import com.okta.sdk.resource.model.ListProfileMappings;
import com.okta.sdk.resource.model.ProfileMapping;
import com.okta.sdk.resource.model.ProfileMappingRequest;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;

import org.openapitools.jackson.nullable.JsonNullableModule;

@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-01-23T09:50:29.349096-06:00[America/Chicago]", comments = "Generator version: 7.8.0")
public class ProfileMappingApi {

    private ApiClient apiClient;

    public ProfileMappingApi() {
        this(Configuration.getDefaultApiClient());
    }

    public ProfileMappingApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    /**
     * Retrieve a Profile Mapping Retrieves a single Profile Mapping referenced by its ID
     *
     * @param mappingId
     *            &#x60;id&#x60; of the Mapping (required)
     *
     * @return ProfileMapping
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public ProfileMapping getProfileMapping(String mappingId) throws ApiException {
        return this.getProfileMapping(mappingId, Collections.emptyMap());
    }

    /**
     * Retrieve a Profile Mapping Retrieves a single Profile Mapping referenced by its ID
     *
     * @param mappingId
     *            &#x60;id&#x60; of the Mapping (required)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @return ProfileMapping
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public ProfileMapping getProfileMapping(String mappingId, Map<String, String> additionalHeaders)
            throws ApiException {
        Object localVarPostBody = null;

        // verify the required parameter 'mappingId' is set
        if (mappingId == null) {
            throw new ApiException(400, "Missing the required parameter 'mappingId' when calling getProfileMapping");
        }

        // create path and map variables
        String localVarPath = "/api/v1/mappings/{mappingId}".replaceAll("\\{" + "mappingId" + "\\}",
                apiClient.escapeString(mappingId.toString()));

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        TypeReference<ProfileMapping> localVarReturnType = new TypeReference<ProfileMapping>() {
        };
        return apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * List all Profile Mappings Lists all profile mappings in your organization with
     * [pagination](https://developer.okta.com/docs/api/#pagination). You can return a subset of profile mappings that
     * match a supported &#x60;sourceId&#x60; and/or &#x60;targetId&#x60;. The results are [paginated](/#pagination)
     * according to the limit parameter. If there are multiple pages of results, the Link header contains a
     * &#x60;next&#x60; link that should be treated as an opaque value (follow it, don&#39;t parse it). The response is
     * a collection of profile mappings that include a subset of the profile mapping object&#39;s parameters. The
     * profile mapping object describes the properties mapping between an Okta User and an App User Profile using [JSON
     * Schema Draft 4](https://datatracker.ietf.org/doc/html/draft-zyp-json-schema-04).
     *
     * @param after
     *            Mapping &#x60;id&#x60; that specifies the pagination cursor for the next page of mappings (optional)
     * @param limit
     *            Specifies the number of results per page (maximum 200) (optional, default to 20)
     * @param sourceId
     *            The UserType or App Instance &#x60;id&#x60; that acts as the source of expressions in a mapping. If
     *            this parameter is included, all returned mappings have this as their &#x60;source.id&#x60;. (optional)
     * @param targetId
     *            The UserType or App Instance &#x60;id&#x60; that acts as the target of expressions in a mapping. If
     *            this parameter is included, all returned mappings have this as their &#x60;target.id&#x60;. (optional)
     *
     * @return List&lt;ListProfileMappings&gt;
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public List<ListProfileMappings> listProfileMappings(String after, Integer limit, String sourceId, String targetId)
            throws ApiException {
        return this.listProfileMappings(after, limit, sourceId, targetId, Collections.emptyMap());
    }

    /**
     * List all Profile Mappings Lists all profile mappings in your organization with
     * [pagination](https://developer.okta.com/docs/api/#pagination). You can return a subset of profile mappings that
     * match a supported &#x60;sourceId&#x60; and/or &#x60;targetId&#x60;. The results are [paginated](/#pagination)
     * according to the limit parameter. If there are multiple pages of results, the Link header contains a
     * &#x60;next&#x60; link that should be treated as an opaque value (follow it, don&#39;t parse it). The response is
     * a collection of profile mappings that include a subset of the profile mapping object&#39;s parameters. The
     * profile mapping object describes the properties mapping between an Okta User and an App User Profile using [JSON
     * Schema Draft 4](https://datatracker.ietf.org/doc/html/draft-zyp-json-schema-04).
     *
     * @param after
     *            Mapping &#x60;id&#x60; that specifies the pagination cursor for the next page of mappings (optional)
     * @param limit
     *            Specifies the number of results per page (maximum 200) (optional, default to 20)
     * @param sourceId
     *            The UserType or App Instance &#x60;id&#x60; that acts as the source of expressions in a mapping. If
     *            this parameter is included, all returned mappings have this as their &#x60;source.id&#x60;. (optional)
     * @param targetId
     *            The UserType or App Instance &#x60;id&#x60; that acts as the target of expressions in a mapping. If
     *            this parameter is included, all returned mappings have this as their &#x60;target.id&#x60;. (optional)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @return List&lt;ListProfileMappings&gt;
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public List<ListProfileMappings> listProfileMappings(String after, Integer limit, String sourceId, String targetId,
            Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/api/v1/mappings";

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarQueryParams.addAll(apiClient.parameterToPair("after", after));
        localVarQueryParams.addAll(apiClient.parameterToPair("limit", limit));
        localVarQueryParams.addAll(apiClient.parameterToPair("sourceId", sourceId));
        localVarQueryParams.addAll(apiClient.parameterToPair("targetId", targetId));

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        TypeReference<List<ListProfileMappings>> localVarReturnType = new TypeReference<List<ListProfileMappings>>() {
        };
        return apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Update a Profile Mapping Updates an existing profile mapping by adding, updating, or removing one or many
     * property mappings
     *
     * @param mappingId
     *            &#x60;id&#x60; of the Mapping (required)
     * @param profileMapping
     *            (required)
     *
     * @return ProfileMapping
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public ProfileMapping updateProfileMapping(String mappingId, ProfileMappingRequest profileMapping)
            throws ApiException {
        return this.updateProfileMapping(mappingId, profileMapping, Collections.emptyMap());
    }

    /**
     * Update a Profile Mapping Updates an existing profile mapping by adding, updating, or removing one or many
     * property mappings
     *
     * @param mappingId
     *            &#x60;id&#x60; of the Mapping (required)
     * @param profileMapping
     *            (required)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @return ProfileMapping
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public ProfileMapping updateProfileMapping(String mappingId, ProfileMappingRequest profileMapping,
            Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = profileMapping;

        // verify the required parameter 'mappingId' is set
        if (mappingId == null) {
            throw new ApiException(400, "Missing the required parameter 'mappingId' when calling updateProfileMapping");
        }

        // verify the required parameter 'profileMapping' is set
        if (profileMapping == null) {
            throw new ApiException(400,
                    "Missing the required parameter 'profileMapping' when calling updateProfileMapping");
        }

        // create path and map variables
        String localVarPath = "/api/v1/mappings/{mappingId}".replaceAll("\\{" + "mappingId" + "\\}",
                apiClient.escapeString(mappingId.toString()));

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

        final String[] localVarContentTypes = { "application/json" };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        TypeReference<ProfileMapping> localVarReturnType = new TypeReference<ProfileMapping>() {
        };
        return apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    protected static ObjectMapper getObjectMapper() {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.registerModule(new JavaTimeModule());
        objectMapper.registerModule(new JsonNullableModule());
        objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        objectMapper.configure(DeserializationFeature.READ_UNKNOWN_ENUM_VALUES_AS_NULL, true);
        return objectMapper;
    }

}
