/*
 * Okta Admin Management
 * Allows customers to easily access the Okta Management APIs
 *
 * The version of the OpenAPI document: 2024.08.3
 * Contact: devex-public@okta.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.okta.sdk.resource.api;

import com.fasterxml.jackson.core.type.TypeReference;

import com.okta.sdk.resource.client.ApiException;
import com.okta.sdk.resource.client.ApiClient;
import com.okta.sdk.resource.client.Configuration;
import com.okta.sdk.resource.model.*;
import com.okta.sdk.resource.client.Pair;

import com.okta.sdk.resource.model.Error;
import com.okta.sdk.resource.model.RiskProvider;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;

import org.openapitools.jackson.nullable.JsonNullableModule;

@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-01-23T09:50:29.349096-06:00[America/Chicago]", comments = "Generator version: 7.8.0")
public class RiskProviderApi {

    private ApiClient apiClient;

    public RiskProviderApi() {
        this(Configuration.getDefaultApiClient());
    }

    public RiskProviderApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    /**
     * Create a Risk Provider Creates a Risk Provider object. A maximum of three Risk Provider objects can be created.
     *
     * @param instance
     *            (required)
     *
     * @return RiskProvider
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public RiskProvider createRiskProvider(RiskProvider instance) throws ApiException {
        return this.createRiskProvider(instance, Collections.emptyMap());
    }

    /**
     * Create a Risk Provider Creates a Risk Provider object. A maximum of three Risk Provider objects can be created.
     *
     * @param instance
     *            (required)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @return RiskProvider
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public RiskProvider createRiskProvider(RiskProvider instance, Map<String, String> additionalHeaders)
            throws ApiException {
        Object localVarPostBody = instance;

        // verify the required parameter 'instance' is set
        if (instance == null) {
            throw new ApiException(400, "Missing the required parameter 'instance' when calling createRiskProvider");
        }

        // create path and map variables
        String localVarPath = "/api/v1/risk/providers";

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

        final String[] localVarContentTypes = { "application/json" };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        TypeReference<RiskProvider> localVarReturnType = new TypeReference<RiskProvider>() {
        };
        return apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Delete a Risk Provider Deletes a Risk Provider object by its ID
     *
     * @param riskProviderId
     *            &#x60;id&#x60; of the Risk Provider object (required)
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public void deleteRiskProvider(String riskProviderId) throws ApiException {
        this.deleteRiskProvider(riskProviderId, Collections.emptyMap());
    }

    /**
     * Delete a Risk Provider Deletes a Risk Provider object by its ID
     *
     * @param riskProviderId
     *            &#x60;id&#x60; of the Risk Provider object (required)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public void deleteRiskProvider(String riskProviderId, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;

        // verify the required parameter 'riskProviderId' is set
        if (riskProviderId == null) {
            throw new ApiException(400,
                    "Missing the required parameter 'riskProviderId' when calling deleteRiskProvider");
        }

        // create path and map variables
        String localVarPath = "/api/v1/risk/providers/{riskProviderId}".replaceAll("\\{" + "riskProviderId" + "\\}",
                apiClient.escapeString(riskProviderId.toString()));

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    /**
     * Retrieve a Risk Provider Retrieves a Risk Provider object by ID
     *
     * @param riskProviderId
     *            &#x60;id&#x60; of the Risk Provider object (required)
     *
     * @return RiskProvider
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public RiskProvider getRiskProvider(String riskProviderId) throws ApiException {
        return this.getRiskProvider(riskProviderId, Collections.emptyMap());
    }

    /**
     * Retrieve a Risk Provider Retrieves a Risk Provider object by ID
     *
     * @param riskProviderId
     *            &#x60;id&#x60; of the Risk Provider object (required)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @return RiskProvider
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public RiskProvider getRiskProvider(String riskProviderId, Map<String, String> additionalHeaders)
            throws ApiException {
        Object localVarPostBody = null;

        // verify the required parameter 'riskProviderId' is set
        if (riskProviderId == null) {
            throw new ApiException(400, "Missing the required parameter 'riskProviderId' when calling getRiskProvider");
        }

        // create path and map variables
        String localVarPath = "/api/v1/risk/providers/{riskProviderId}".replaceAll("\\{" + "riskProviderId" + "\\}",
                apiClient.escapeString(riskProviderId.toString()));

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        TypeReference<RiskProvider> localVarReturnType = new TypeReference<RiskProvider>() {
        };
        return apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * List all Risk Providers Lists all Risk Provider objects
     *
     * @return List&lt;RiskProvider&gt;
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public List<RiskProvider> listRiskProviders() throws ApiException {
        return this.listRiskProviders(Collections.emptyMap());
    }

    /**
     * List all Risk Providers Lists all Risk Provider objects
     *
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @return List&lt;RiskProvider&gt;
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public List<RiskProvider> listRiskProviders(Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/api/v1/risk/providers";

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        TypeReference<List<RiskProvider>> localVarReturnType = new TypeReference<List<RiskProvider>>() {
        };
        return apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Replace a Risk Provider Replaces the properties for a given Risk Provider object ID
     *
     * @param riskProviderId
     *            &#x60;id&#x60; of the Risk Provider object (required)
     * @param instance
     *            (required)
     *
     * @return RiskProvider
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public RiskProvider replaceRiskProvider(String riskProviderId, RiskProvider instance) throws ApiException {
        return this.replaceRiskProvider(riskProviderId, instance, Collections.emptyMap());
    }

    /**
     * Replace a Risk Provider Replaces the properties for a given Risk Provider object ID
     *
     * @param riskProviderId
     *            &#x60;id&#x60; of the Risk Provider object (required)
     * @param instance
     *            (required)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @return RiskProvider
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public RiskProvider replaceRiskProvider(String riskProviderId, RiskProvider instance,
            Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = instance;

        // verify the required parameter 'riskProviderId' is set
        if (riskProviderId == null) {
            throw new ApiException(400,
                    "Missing the required parameter 'riskProviderId' when calling replaceRiskProvider");
        }

        // verify the required parameter 'instance' is set
        if (instance == null) {
            throw new ApiException(400, "Missing the required parameter 'instance' when calling replaceRiskProvider");
        }

        // create path and map variables
        String localVarPath = "/api/v1/risk/providers/{riskProviderId}".replaceAll("\\{" + "riskProviderId" + "\\}",
                apiClient.escapeString(riskProviderId.toString()));

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

        final String[] localVarContentTypes = { "application/json" };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        TypeReference<RiskProvider> localVarReturnType = new TypeReference<RiskProvider>() {
        };
        return apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    protected static ObjectMapper getObjectMapper() {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.registerModule(new JavaTimeModule());
        objectMapper.registerModule(new JsonNullableModule());
        objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        objectMapper.configure(DeserializationFeature.READ_UNKNOWN_ENUM_VALUES_AS_NULL, true);
        return objectMapper;
    }

}
