/*
 * Okta Admin Management
 * Allows customers to easily access the Okta Management APIs
 *
 * The version of the OpenAPI document: 2024.08.3
 * Contact: devex-public@okta.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.okta.sdk.resource.api;

import com.fasterxml.jackson.core.type.TypeReference;

import com.okta.sdk.resource.client.ApiException;
import com.okta.sdk.resource.client.ApiClient;
import com.okta.sdk.resource.client.Configuration;
import com.okta.sdk.resource.model.*;
import com.okta.sdk.resource.client.Pair;

import com.okta.sdk.resource.model.Error;
import com.okta.sdk.resource.model.ResponseLinks;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;

import org.openapitools.jackson.nullable.JsonNullableModule;

@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-01-23T09:50:29.349096-06:00[America/Chicago]", comments = "Generator version: 7.8.0")
public class UserLinkedObjectApi {

    private ApiClient apiClient;

    public UserLinkedObjectApi() {
        this(Configuration.getDefaultApiClient());
    }

    public UserLinkedObjectApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    /**
     * Assign a Linked Object value for primary Assigns the first User as the &#x60;associated&#x60; and the second User
     * as the &#x60;primary&#x60; for the specified relationship. If the first User is already associated with a
     * different &#x60;primary&#x60; for this relationship, the previous link is removed. A Linked Object relationship
     * can specify only one primary User for an associated User.
     *
     * @param userIdOrLogin
     *            If for the &#x60;self&#x60; link, the ID of the User for whom you want to get the primary User ID. If
     *            for the &#x60;associated&#x60; relation, the User ID or login value of the User assigned the
     *            associated relationship. This can be &#x60;me&#x60; to represent the current session User. (required)
     * @param primaryRelationshipName
     *            Name of the &#x60;primary&#x60; relationship being assigned (required)
     * @param primaryUserId
     *            User ID to be assigned to the &#x60;primary&#x60; relationship for the &#x60;associated&#x60; user
     *            (required)
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public void assignLinkedObjectValueForPrimary(String userIdOrLogin, String primaryRelationshipName,
            String primaryUserId) throws ApiException {
        this.assignLinkedObjectValueForPrimary(userIdOrLogin, primaryRelationshipName, primaryUserId,
                Collections.emptyMap());
    }

    /**
     * Assign a Linked Object value for primary Assigns the first User as the &#x60;associated&#x60; and the second User
     * as the &#x60;primary&#x60; for the specified relationship. If the first User is already associated with a
     * different &#x60;primary&#x60; for this relationship, the previous link is removed. A Linked Object relationship
     * can specify only one primary User for an associated User.
     *
     * @param userIdOrLogin
     *            If for the &#x60;self&#x60; link, the ID of the User for whom you want to get the primary User ID. If
     *            for the &#x60;associated&#x60; relation, the User ID or login value of the User assigned the
     *            associated relationship. This can be &#x60;me&#x60; to represent the current session User. (required)
     * @param primaryRelationshipName
     *            Name of the &#x60;primary&#x60; relationship being assigned (required)
     * @param primaryUserId
     *            User ID to be assigned to the &#x60;primary&#x60; relationship for the &#x60;associated&#x60; user
     *            (required)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public void assignLinkedObjectValueForPrimary(String userIdOrLogin, String primaryRelationshipName,
            String primaryUserId, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;

        // verify the required parameter 'userIdOrLogin' is set
        if (userIdOrLogin == null) {
            throw new ApiException(400,
                    "Missing the required parameter 'userIdOrLogin' when calling assignLinkedObjectValueForPrimary");
        }

        // verify the required parameter 'primaryRelationshipName' is set
        if (primaryRelationshipName == null) {
            throw new ApiException(400,
                    "Missing the required parameter 'primaryRelationshipName' when calling assignLinkedObjectValueForPrimary");
        }

        // verify the required parameter 'primaryUserId' is set
        if (primaryUserId == null) {
            throw new ApiException(400,
                    "Missing the required parameter 'primaryUserId' when calling assignLinkedObjectValueForPrimary");
        }

        // create path and map variables
        String localVarPath = "/api/v1/users/{userIdOrLogin}/linkedObjects/{primaryRelationshipName}/{primaryUserId}"
                .replaceAll("\\{" + "userIdOrLogin" + "\\}", apiClient.escapeString(userIdOrLogin.toString()))
                .replaceAll("\\{" + "primaryRelationshipName" + "\\}",
                        apiClient.escapeString(primaryRelationshipName.toString()))
                .replaceAll("\\{" + "primaryUserId" + "\\}", apiClient.escapeString(primaryUserId.toString()));

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2" };

        apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    /**
     * Delete a Linked Object value Deletes any existing relationship between the &#x60;associated&#x60; and
     * &#x60;primary&#x60; user. For the &#x60;associated&#x60; User, this is specified by the ID. The
     * &#x60;primary&#x60; name specifies the relationship. The operation is successful if the relationship is deleted
     * or if the specified User isn&#39;t in the &#x60;associated&#x60; relationship for any instance of the specified
     * &#x60;primary&#x60; and thus, no relationship is found.
     *
     * @param userIdOrLogin
     *            If for the &#x60;self&#x60; link, the ID of the User for whom you want to get the primary User ID. If
     *            for the &#x60;associated&#x60; relation, the User ID or login value of the User assigned the
     *            associated relationship. This can be &#x60;me&#x60; to represent the current session User. (required)
     * @param relationshipName
     *            Name of the &#x60;primary&#x60; or &#x60;associated&#x60; relationship being queried (required)
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public void deleteLinkedObjectForUser(String userIdOrLogin, String relationshipName) throws ApiException {
        this.deleteLinkedObjectForUser(userIdOrLogin, relationshipName, Collections.emptyMap());
    }

    /**
     * Delete a Linked Object value Deletes any existing relationship between the &#x60;associated&#x60; and
     * &#x60;primary&#x60; user. For the &#x60;associated&#x60; User, this is specified by the ID. The
     * &#x60;primary&#x60; name specifies the relationship. The operation is successful if the relationship is deleted
     * or if the specified User isn&#39;t in the &#x60;associated&#x60; relationship for any instance of the specified
     * &#x60;primary&#x60; and thus, no relationship is found.
     *
     * @param userIdOrLogin
     *            If for the &#x60;self&#x60; link, the ID of the User for whom you want to get the primary User ID. If
     *            for the &#x60;associated&#x60; relation, the User ID or login value of the User assigned the
     *            associated relationship. This can be &#x60;me&#x60; to represent the current session User. (required)
     * @param relationshipName
     *            Name of the &#x60;primary&#x60; or &#x60;associated&#x60; relationship being queried (required)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public void deleteLinkedObjectForUser(String userIdOrLogin, String relationshipName,
            Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;

        // verify the required parameter 'userIdOrLogin' is set
        if (userIdOrLogin == null) {
            throw new ApiException(400,
                    "Missing the required parameter 'userIdOrLogin' when calling deleteLinkedObjectForUser");
        }

        // verify the required parameter 'relationshipName' is set
        if (relationshipName == null) {
            throw new ApiException(400,
                    "Missing the required parameter 'relationshipName' when calling deleteLinkedObjectForUser");
        }

        // create path and map variables
        String localVarPath = "/api/v1/users/{userIdOrLogin}/linkedObjects/{relationshipName}"
                .replaceAll("\\{" + "userIdOrLogin" + "\\}", apiClient.escapeString(userIdOrLogin.toString()))
                .replaceAll("\\{" + "relationshipName" + "\\}", apiClient.escapeString(relationshipName.toString()));

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    /**
     * List the primary or all of the associated Linked Object values Lists either the &#x60;self&#x60; link for the
     * primary User or all associated Users in the relationship specified by &#x60;relationshipName&#x60;. If the
     * specified User isn&#39;t associated in any relationship, an empty array is returned. Use &#x60;me&#x60; instead
     * of &#x60;id&#x60; to specify the current session User.
     *
     * @param userIdOrLogin
     *            If for the &#x60;self&#x60; link, the ID of the User for whom you want to get the primary User ID. If
     *            for the &#x60;associated&#x60; relation, the User ID or login value of the User assigned the
     *            associated relationship. This can be &#x60;me&#x60; to represent the current session User. (required)
     * @param relationshipName
     *            Name of the &#x60;primary&#x60; or &#x60;associated&#x60; relationship being queried (required)
     *
     * @return List&lt;ResponseLinks&gt;
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public List<ResponseLinks> listLinkedObjectsForUser(String userIdOrLogin, String relationshipName)
            throws ApiException {
        return this.listLinkedObjectsForUser(userIdOrLogin, relationshipName, Collections.emptyMap());
    }

    /**
     * List the primary or all of the associated Linked Object values Lists either the &#x60;self&#x60; link for the
     * primary User or all associated Users in the relationship specified by &#x60;relationshipName&#x60;. If the
     * specified User isn&#39;t associated in any relationship, an empty array is returned. Use &#x60;me&#x60; instead
     * of &#x60;id&#x60; to specify the current session User.
     *
     * @param userIdOrLogin
     *            If for the &#x60;self&#x60; link, the ID of the User for whom you want to get the primary User ID. If
     *            for the &#x60;associated&#x60; relation, the User ID or login value of the User assigned the
     *            associated relationship. This can be &#x60;me&#x60; to represent the current session User. (required)
     * @param relationshipName
     *            Name of the &#x60;primary&#x60; or &#x60;associated&#x60; relationship being queried (required)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @return List&lt;ResponseLinks&gt;
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public List<ResponseLinks> listLinkedObjectsForUser(String userIdOrLogin, String relationshipName,
            Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;

        // verify the required parameter 'userIdOrLogin' is set
        if (userIdOrLogin == null) {
            throw new ApiException(400,
                    "Missing the required parameter 'userIdOrLogin' when calling listLinkedObjectsForUser");
        }

        // verify the required parameter 'relationshipName' is set
        if (relationshipName == null) {
            throw new ApiException(400,
                    "Missing the required parameter 'relationshipName' when calling listLinkedObjectsForUser");
        }

        // create path and map variables
        String localVarPath = "/api/v1/users/{userIdOrLogin}/linkedObjects/{relationshipName}"
                .replaceAll("\\{" + "userIdOrLogin" + "\\}", apiClient.escapeString(userIdOrLogin.toString()))
                .replaceAll("\\{" + "relationshipName" + "\\}", apiClient.escapeString(relationshipName.toString()));

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        TypeReference<List<ResponseLinks>> localVarReturnType = new TypeReference<List<ResponseLinks>>() {
        };
        return apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    protected static ObjectMapper getObjectMapper() {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.registerModule(new JavaTimeModule());
        objectMapper.registerModule(new JsonNullableModule());
        objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        objectMapper.configure(DeserializationFeature.READ_UNKNOWN_ENUM_VALUES_AS_NULL, true);
        return objectMapper;
    }

}
