package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import com.okta.sdk.resource.model.APIServiceIntegrationLinks;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * APIServiceIntegrationInstance
 */
@JsonPropertyOrder({ APIServiceIntegrationInstance.JSON_PROPERTY_CONFIG_GUIDE_URL,
        APIServiceIntegrationInstance.JSON_PROPERTY_CREATED_AT, APIServiceIntegrationInstance.JSON_PROPERTY_CREATED_BY,
        APIServiceIntegrationInstance.JSON_PROPERTY_GRANTED_SCOPES, APIServiceIntegrationInstance.JSON_PROPERTY_ID,
        APIServiceIntegrationInstance.JSON_PROPERTY_NAME, APIServiceIntegrationInstance.JSON_PROPERTY_TYPE,
        APIServiceIntegrationInstance.JSON_PROPERTY_LINKS })
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-01-23T09:50:29.349096-06:00[America/Chicago]", comments = "Generator version: 7.8.0")
public class APIServiceIntegrationInstance implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_CONFIG_GUIDE_URL = "configGuideUrl";
    private String configGuideUrl;

    public static final String JSON_PROPERTY_CREATED_AT = "createdAt";
    private String createdAt;

    public static final String JSON_PROPERTY_CREATED_BY = "createdBy";
    private String createdBy;

    public static final String JSON_PROPERTY_GRANTED_SCOPES = "grantedScopes";
    private List<String> grantedScopes = null;

    public static final String JSON_PROPERTY_ID = "id";
    private String id;

    public static final String JSON_PROPERTY_NAME = "name";
    private String name;

    public static final String JSON_PROPERTY_TYPE = "type";
    private String type;

    public static final String JSON_PROPERTY_LINKS = "_links";
    private APIServiceIntegrationLinks links;

    public APIServiceIntegrationInstance() {
    }

    /*
     * @JsonCreator public APIServiceIntegrationInstance(
     *
     * @JsonProperty(JSON_PROPERTY_CONFIG_GUIDE_URL) String configGuideUrl,
     *
     * @JsonProperty(JSON_PROPERTY_CREATED_AT) String createdAt,
     *
     * @JsonProperty(JSON_PROPERTY_CREATED_BY) String createdBy,
     *
     * @JsonProperty(JSON_PROPERTY_ID) String id,
     *
     * @JsonProperty(JSON_PROPERTY_NAME) String name ) { this(); this.configGuideUrl = configGuideUrl; this.createdAt =
     * createdAt; this.createdBy = createdBy; this.id = id; this.name = name; }
     */

    /**
     * The URL to the API service integration configuration guide
     *
     * @return configGuideUrl
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(example = "https://{docDomain}/my-app-cie/configuration-guide", value = "The URL to the API service integration configuration guide")
    @JsonProperty(JSON_PROPERTY_CONFIG_GUIDE_URL)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getConfigGuideUrl() {
        return configGuideUrl;
    }

    /**
     * Timestamp when the API Service Integration instance was created
     *
     * @return createdAt
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(example = "2023-02-21T20:08:24.000Z", value = "Timestamp when the API Service Integration instance was created")
    @JsonProperty(JSON_PROPERTY_CREATED_AT)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getCreatedAt() {
        return createdAt;
    }

    /**
     * The user ID of the API Service Integration instance creator
     *
     * @return createdBy
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(example = "00uu3u0ujW1P6AfZC2d5", value = "The user ID of the API Service Integration instance creator")
    @JsonProperty(JSON_PROPERTY_CREATED_BY)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getCreatedBy() {
        return createdBy;
    }

    public APIServiceIntegrationInstance grantedScopes(List<String> grantedScopes) {

        this.grantedScopes = grantedScopes;
        return this;
    }

    public APIServiceIntegrationInstance addgrantedScopesItem(String grantedScopesItem) {
        if (this.grantedScopes == null) {
            this.grantedScopes = new ArrayList<>();
        }
        this.grantedScopes.add(grantedScopesItem);
        return this;
    }

    /**
     * The list of Okta management scopes granted to the API Service Integration instance. See [Okta management OAuth
     * 2.0 scopes](/oauth2/#okta-admin-management).
     *
     * @return grantedScopes
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(example = "[\"okta.logs.read\"]", value = "The list of Okta management scopes granted to the API Service Integration instance. See [Okta management OAuth 2.0 scopes](/oauth2/#okta-admin-management).")
    @JsonProperty(JSON_PROPERTY_GRANTED_SCOPES)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public List<String> getGrantedScopes() {
        return grantedScopes;
    }

    @JsonProperty(JSON_PROPERTY_GRANTED_SCOPES)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setGrantedScopes(List<String> grantedScopes) {
        this.grantedScopes = grantedScopes;
    }

    /**
     * The ID of the API Service Integration instance
     *
     * @return id
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(example = "0oa72lrepvp4WqEET1d9", value = "The ID of the API Service Integration instance")
    @JsonProperty(JSON_PROPERTY_ID)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getId() {
        return id;
    }

    /**
     * The name of the API service integration that corresponds with the &#x60;type&#x60; property. This is the full
     * name of the API service integration listed in the Okta Integration Network (OIN) catalog.
     *
     * @return name
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(example = "My App Cloud Identity Engine", value = "The name of the API service integration that corresponds with the `type` property. This is the full name of the API service integration listed in the Okta Integration Network (OIN) catalog.")
    @JsonProperty(JSON_PROPERTY_NAME)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getName() {
        return name;
    }

    public APIServiceIntegrationInstance type(String type) {

        this.type = type;
        return this;
    }

    /**
     * The type of the API service integration. This string is an underscore-concatenated, lowercased API service
     * integration name. For example, &#x60;my_api_log_integration&#x60;.
     *
     * @return type
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(example = "my_app_cie", value = "The type of the API service integration. This string is an underscore-concatenated, lowercased API service integration name. For example, `my_api_log_integration`.")
    @JsonProperty(JSON_PROPERTY_TYPE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getType() {
        return type;
    }

    @JsonProperty(JSON_PROPERTY_TYPE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setType(String type) {
        this.type = type;
    }

    public APIServiceIntegrationInstance links(APIServiceIntegrationLinks links) {

        this.links = links;
        return this;
    }

    /**
     * Get links
     *
     * @return links
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_LINKS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public APIServiceIntegrationLinks getLinks() {
        return links;
    }

    @JsonProperty(JSON_PROPERTY_LINKS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setLinks(APIServiceIntegrationLinks links) {
        this.links = links;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        APIServiceIntegrationInstance apIServiceIntegrationInstance = (APIServiceIntegrationInstance) o;
        return Objects.equals(this.configGuideUrl, apIServiceIntegrationInstance.configGuideUrl)
                && Objects.equals(this.createdAt, apIServiceIntegrationInstance.createdAt)
                && Objects.equals(this.createdBy, apIServiceIntegrationInstance.createdBy)
                && Objects.equals(this.grantedScopes, apIServiceIntegrationInstance.grantedScopes)
                && Objects.equals(this.id, apIServiceIntegrationInstance.id)
                && Objects.equals(this.name, apIServiceIntegrationInstance.name)
                && Objects.equals(this.type, apIServiceIntegrationInstance.type)
                && Objects.equals(this.links, apIServiceIntegrationInstance.links);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(configGuideUrl, createdAt, createdBy, grantedScopes, id, name, type, links);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class APIServiceIntegrationInstance {\n");
        sb.append("    configGuideUrl: ").append(toIndentedString(configGuideUrl)).append("\n");
        sb.append("    createdAt: ").append(toIndentedString(createdAt)).append("\n");
        sb.append("    createdBy: ").append(toIndentedString(createdBy)).append("\n");
        sb.append("    grantedScopes: ").append(toIndentedString(grantedScopes)).append("\n");
        sb.append("    id: ").append(toIndentedString(id)).append("\n");
        sb.append("    name: ").append(toIndentedString(name)).append("\n");
        sb.append("    type: ").append(toIndentedString(type)).append("\n");
        sb.append("    links: ").append(toIndentedString(links)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
