package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * Licenses for the app
 */
@ApiModel(description = "Licenses for the app")
@JsonPropertyOrder({ ApplicationLicensing.JSON_PROPERTY_SEAT_COUNT })
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-01-23T09:50:29.349096-06:00[America/Chicago]", comments = "Generator version: 7.8.0")
public class ApplicationLicensing implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_SEAT_COUNT = "seatCount";
    private Integer seatCount;

    public ApplicationLicensing() {
    }

    public ApplicationLicensing seatCount(Integer seatCount) {

        this.seatCount = seatCount;
        return this;
    }

    /**
     * Number of licenses purchased for the app
     *
     * @return seatCount
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Number of licenses purchased for the app")
    @JsonProperty(JSON_PROPERTY_SEAT_COUNT)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public Integer getSeatCount() {
        return seatCount;
    }

    @JsonProperty(JSON_PROPERTY_SEAT_COUNT)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setSeatCount(Integer seatCount) {
        this.seatCount = seatCount;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        ApplicationLicensing applicationLicensing = (ApplicationLicensing) o;
        return Objects.equals(this.seatCount, applicationLicensing.seatCount);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(seatCount);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ApplicationLicensing {\n");
        sb.append("    seatCount: ").append(toIndentedString(seatCount)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
