package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import com.okta.sdk.resource.model.ApplicationSettingsNotificationsVpnNetwork;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * Sends customizable messages with conditions to end users when a VPN connection is required
 */
@ApiModel(description = "Sends customizable messages with conditions to end users when a VPN connection is required")
@JsonPropertyOrder({ ApplicationSettingsNotificationsVpn.JSON_PROPERTY_HELP_URL,
        ApplicationSettingsNotificationsVpn.JSON_PROPERTY_MESSAGE,
        ApplicationSettingsNotificationsVpn.JSON_PROPERTY_NETWORK })
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-01-23T09:50:29.349096-06:00[America/Chicago]", comments = "Generator version: 7.8.0")
public class ApplicationSettingsNotificationsVpn implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_HELP_URL = "helpUrl";
    private String helpUrl;

    public static final String JSON_PROPERTY_MESSAGE = "message";
    private String message;

    public static final String JSON_PROPERTY_NETWORK = "network";
    private ApplicationSettingsNotificationsVpnNetwork network;

    public ApplicationSettingsNotificationsVpn() {
    }

    public ApplicationSettingsNotificationsVpn helpUrl(String helpUrl) {

        this.helpUrl = helpUrl;
        return this;
    }

    /**
     * An optional URL to a help page to assist your end users in signing in to your company VPN
     *
     * @return helpUrl
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "An optional URL to a help page to assist your end users in signing in to your company VPN")
    @JsonProperty(JSON_PROPERTY_HELP_URL)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getHelpUrl() {
        return helpUrl;
    }

    @JsonProperty(JSON_PROPERTY_HELP_URL)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setHelpUrl(String helpUrl) {
        this.helpUrl = helpUrl;
    }

    public ApplicationSettingsNotificationsVpn message(String message) {

        this.message = message;
        return this;
    }

    /**
     * A VPN requirement message that&#39;s displayed to users
     *
     * @return message
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "A VPN requirement message that's displayed to users")
    @JsonProperty(JSON_PROPERTY_MESSAGE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getMessage() {
        return message;
    }

    @JsonProperty(JSON_PROPERTY_MESSAGE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setMessage(String message) {
        this.message = message;
    }

    public ApplicationSettingsNotificationsVpn network(ApplicationSettingsNotificationsVpnNetwork network) {

        this.network = network;
        return this;
    }

    /**
     * Get network
     *
     * @return network
     **/
    @javax.annotation.Nonnull
    @ApiModelProperty(required = true, value = "")
    @JsonProperty(JSON_PROPERTY_NETWORK)
    @JsonInclude(value = JsonInclude.Include.ALWAYS)

    public ApplicationSettingsNotificationsVpnNetwork getNetwork() {
        return network;
    }

    @JsonProperty(JSON_PROPERTY_NETWORK)
    @JsonInclude(value = JsonInclude.Include.ALWAYS)
    public void setNetwork(ApplicationSettingsNotificationsVpnNetwork network) {
        this.network = network;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        ApplicationSettingsNotificationsVpn applicationSettingsNotificationsVpn = (ApplicationSettingsNotificationsVpn) o;
        return Objects.equals(this.helpUrl, applicationSettingsNotificationsVpn.helpUrl)
                && Objects.equals(this.message, applicationSettingsNotificationsVpn.message)
                && Objects.equals(this.network, applicationSettingsNotificationsVpn.network);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(helpUrl, message, network);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ApplicationSettingsNotificationsVpn {\n");
        sb.append("    helpUrl: ").append(toIndentedString(helpUrl)).append("\n");
        sb.append("    message: ").append(toIndentedString(message)).append("\n");
        sb.append("    network: ").append(toIndentedString(network)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
