package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import com.okta.sdk.resource.model.AuthenticationMethod;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * AuthenticationMethodChain
 */
@JsonPropertyOrder({ AuthenticationMethodChain.JSON_PROPERTY_AUTHENTICATION_METHODS,
        AuthenticationMethodChain.JSON_PROPERTY_NEXT, AuthenticationMethodChain.JSON_PROPERTY_REAUTHENTICATE_IN })
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-01-23T09:50:29.349096-06:00[America/Chicago]", comments = "Generator version: 7.8.0")
public class AuthenticationMethodChain implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_AUTHENTICATION_METHODS = "authenticationMethods";
    private List<AuthenticationMethod> authenticationMethods = null;

    public static final String JSON_PROPERTY_NEXT = "next";
    private List<Object> next = null;

    public static final String JSON_PROPERTY_REAUTHENTICATE_IN = "reauthenticateIn";
    private String reauthenticateIn;

    public AuthenticationMethodChain() {
    }

    public AuthenticationMethodChain authenticationMethods(List<AuthenticationMethod> authenticationMethods) {

        this.authenticationMethods = authenticationMethods;
        return this;
    }

    public AuthenticationMethodChain addauthenticationMethodsItem(AuthenticationMethod authenticationMethodsItem) {
        if (this.authenticationMethods == null) {
            this.authenticationMethods = new ArrayList<>();
        }
        this.authenticationMethods.add(authenticationMethodsItem);
        return this;
    }

    /**
     * Get authenticationMethods
     *
     * @return authenticationMethods
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_AUTHENTICATION_METHODS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public List<AuthenticationMethod> getAuthenticationMethods() {
        return authenticationMethods;
    }

    @JsonProperty(JSON_PROPERTY_AUTHENTICATION_METHODS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setAuthenticationMethods(List<AuthenticationMethod> authenticationMethods) {
        this.authenticationMethods = authenticationMethods;
    }

    public AuthenticationMethodChain next(List<Object> next) {

        this.next = next;
        return this;
    }

    public AuthenticationMethodChain addnextItem(Object nextItem) {
        if (this.next == null) {
            this.next = new ArrayList<>();
        }
        this.next.add(nextItem);
        return this;
    }

    /**
     * The next steps of the authentication method chain. This is an array of &#x60;AuthenticationMethodChain&#x60;.
     * Only supports one item in the array.
     *
     * @return next
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "The next steps of the authentication method chain. This is an array of `AuthenticationMethodChain`. Only supports one item in the array.")
    @JsonProperty(JSON_PROPERTY_NEXT)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public List<Object> getNext() {
        return next;
    }

    @JsonProperty(JSON_PROPERTY_NEXT)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setNext(List<Object> next) {
        this.next = next;
    }

    public AuthenticationMethodChain reauthenticateIn(String reauthenticateIn) {

        this.reauthenticateIn = reauthenticateIn;
        return this;
    }

    /**
     * Specifies how often the user should be prompted for authentication using duration format for the time period. For
     * example, &#x60;PT2H30M&#x60; for two and a half hours. This parameter can&#39;t be set at the same time as the
     * &#x60;reauthenticateIn&#x60; property on the &#x60;verificationMethod&#x60;.
     *
     * @return reauthenticateIn
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Specifies how often the user should be prompted for authentication using duration format for the time period.  For example, `PT2H30M` for two and a half hours. This parameter can't be set at the same time as the `reauthenticateIn` property on the `verificationMethod`.")
    @JsonProperty(JSON_PROPERTY_REAUTHENTICATE_IN)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getReauthenticateIn() {
        return reauthenticateIn;
    }

    @JsonProperty(JSON_PROPERTY_REAUTHENTICATE_IN)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setReauthenticateIn(String reauthenticateIn) {
        this.reauthenticateIn = reauthenticateIn;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        AuthenticationMethodChain authenticationMethodChain = (AuthenticationMethodChain) o;
        return Objects.equals(this.authenticationMethods, authenticationMethodChain.authenticationMethods)
                && Objects.equals(this.next, authenticationMethodChain.next)
                && Objects.equals(this.reauthenticateIn, authenticationMethodChain.reauthenticateIn);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(authenticationMethods, next, reauthenticateIn);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AuthenticationMethodChain {\n");
        sb.append("    authenticationMethods: ").append(toIndentedString(authenticationMethods)).append("\n");
        sb.append("    next: ").append(toIndentedString(next)).append("\n");
        sb.append("    reauthenticateIn: ").append(toIndentedString(reauthenticateIn)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
