package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import com.okta.sdk.resource.model.AuthenticatorEnrollmentPolicyConditions;
import com.okta.sdk.resource.model.AuthenticatorEnrollmentPolicySettings;
import com.okta.sdk.resource.model.LifecycleStatus;
import com.okta.sdk.resource.model.Policy;
import com.okta.sdk.resource.model.PolicyLinks;
import com.okta.sdk.resource.model.PolicyType;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.Map;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * AuthenticatorEnrollmentPolicy
 */
@JsonPropertyOrder({ AuthenticatorEnrollmentPolicy.JSON_PROPERTY_CONDITIONS,
        AuthenticatorEnrollmentPolicy.JSON_PROPERTY_SETTINGS })
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-01-23T09:50:29.349096-06:00[America/Chicago]", comments = "Generator version: 7.8.0")
@JsonTypeInfo(use = JsonTypeInfo.Id.NAME, include = JsonTypeInfo.As.EXISTING_PROPERTY, property = "type", visible = true, defaultImpl = AuthenticatorEnrollmentPolicy.class)

public class AuthenticatorEnrollmentPolicy extends Policy implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_CONDITIONS = "conditions";
    private AuthenticatorEnrollmentPolicyConditions conditions;

    public static final String JSON_PROPERTY_SETTINGS = "settings";
    private AuthenticatorEnrollmentPolicySettings settings;

    public AuthenticatorEnrollmentPolicy() {
    }

    /*
     * @JsonCreator public AuthenticatorEnrollmentPolicy(
     *
     * @JsonProperty(JSON_PROPERTY_CREATED) OffsetDateTime created,
     *
     * @JsonProperty(JSON_PROPERTY_ID) String id,
     *
     * @JsonProperty(JSON_PROPERTY_LAST_UPDATED) OffsetDateTime lastUpdated,
     *
     * @JsonProperty(JSON_PROPERTY_EMBEDDED) Map<String, Object> embedded ) { this(); this.created = created; this.id =
     * id; this.lastUpdated = lastUpdated; this.embedded = embedded; }
     */

    public AuthenticatorEnrollmentPolicy conditions(AuthenticatorEnrollmentPolicyConditions conditions) {

        this.conditions = conditions;
        return this;
    }

    /**
     * Get conditions
     *
     * @return conditions
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_CONDITIONS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public AuthenticatorEnrollmentPolicyConditions getConditions() {
        return conditions;
    }

    @JsonProperty(JSON_PROPERTY_CONDITIONS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setConditions(AuthenticatorEnrollmentPolicyConditions conditions) {
        this.conditions = conditions;
    }

    public AuthenticatorEnrollmentPolicy settings(AuthenticatorEnrollmentPolicySettings settings) {

        this.settings = settings;
        return this;
    }

    /**
     * Get settings
     *
     * @return settings
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_SETTINGS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public AuthenticatorEnrollmentPolicySettings getSettings() {
        return settings;
    }

    @JsonProperty(JSON_PROPERTY_SETTINGS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setSettings(AuthenticatorEnrollmentPolicySettings settings) {
        this.settings = settings;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        AuthenticatorEnrollmentPolicy authenticatorEnrollmentPolicy = (AuthenticatorEnrollmentPolicy) o;
        return Objects.equals(this.conditions, authenticatorEnrollmentPolicy.conditions)
                && Objects.equals(this.settings, authenticatorEnrollmentPolicy.settings);
        // && super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(conditions, settings, super.hashCode());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AuthenticatorEnrollmentPolicy {\n");
        sb.append("    ").append(toIndentedString(super.toString())).append("\n");
        sb.append("    conditions: ").append(toIndentedString(conditions)).append("\n");
        sb.append("    settings: ").append(toIndentedString(settings)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
