package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import com.okta.sdk.resource.model.AuthenticatorKeyCustomAppAllOfProvider;
import com.okta.sdk.resource.model.AuthenticatorKeyCustomAppAllOfSettings;
import com.okta.sdk.resource.model.AuthenticatorKeyEnum;
import com.okta.sdk.resource.model.AuthenticatorLinks;
import com.okta.sdk.resource.model.AuthenticatorSimple;
import com.okta.sdk.resource.model.AuthenticatorType;
import com.okta.sdk.resource.model.LifecycleStatus;
import java.time.OffsetDateTime;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * AuthenticatorKeyCustomApp
 */
@JsonPropertyOrder({ AuthenticatorKeyCustomApp.JSON_PROPERTY_AGREE_TO_TERMS,
        AuthenticatorKeyCustomApp.JSON_PROPERTY_PROVIDER, AuthenticatorKeyCustomApp.JSON_PROPERTY_SETTINGS })
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-01-23T09:50:29.349096-06:00[America/Chicago]", comments = "Generator version: 7.8.0")
@JsonTypeInfo(use = JsonTypeInfo.Id.NAME, include = JsonTypeInfo.As.EXISTING_PROPERTY, property = "key", visible = true, defaultImpl = AuthenticatorKeyCustomApp.class)

public class AuthenticatorKeyCustomApp extends AuthenticatorSimple implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_AGREE_TO_TERMS = "agreeToTerms";
    private Boolean agreeToTerms;

    public static final String JSON_PROPERTY_PROVIDER = "provider";
    private AuthenticatorKeyCustomAppAllOfProvider provider;

    public static final String JSON_PROPERTY_SETTINGS = "settings";
    private AuthenticatorKeyCustomAppAllOfSettings settings;

    public AuthenticatorKeyCustomApp() {
    }

    /*
     * @JsonCreator public AuthenticatorKeyCustomApp(
     *
     * @JsonProperty(JSON_PROPERTY_CREATED) OffsetDateTime created,
     *
     * @JsonProperty(JSON_PROPERTY_ID) String id,
     *
     * @JsonProperty(JSON_PROPERTY_LAST_UPDATED) OffsetDateTime lastUpdated ) { this(); this.created = created; this.id
     * = id; this.lastUpdated = lastUpdated; }
     */

    public AuthenticatorKeyCustomApp agreeToTerms(Boolean agreeToTerms) {

        this.agreeToTerms = agreeToTerms;
        return this;
    }

    /**
     * A value of &#x60;true&#x60; indicates that the administrator accepts the
     * [terms](https://www.okta.com/privacy-policy/)for creating a new authenticator. Okta requires that you accept the
     * terms when creating a new &#x60;custom_app&#x60; authenticator. Other authenticators don&#39;t require this
     * field.
     *
     * @return agreeToTerms
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "A value of `true` indicates that the administrator accepts the [terms](https://www.okta.com/privacy-policy/)for creating a new authenticator. Okta requires that you accept the terms when creating a new `custom_app` authenticator. Other authenticators don't require this field.")
    @JsonProperty(JSON_PROPERTY_AGREE_TO_TERMS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public Boolean getAgreeToTerms() {
        return agreeToTerms;
    }

    @JsonProperty(JSON_PROPERTY_AGREE_TO_TERMS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setAgreeToTerms(Boolean agreeToTerms) {
        this.agreeToTerms = agreeToTerms;
    }

    public AuthenticatorKeyCustomApp provider(AuthenticatorKeyCustomAppAllOfProvider provider) {

        this.provider = provider;
        return this;
    }

    /**
     * Get provider
     *
     * @return provider
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_PROVIDER)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public AuthenticatorKeyCustomAppAllOfProvider getProvider() {
        return provider;
    }

    @JsonProperty(JSON_PROPERTY_PROVIDER)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setProvider(AuthenticatorKeyCustomAppAllOfProvider provider) {
        this.provider = provider;
    }

    public AuthenticatorKeyCustomApp settings(AuthenticatorKeyCustomAppAllOfSettings settings) {

        this.settings = settings;
        return this;
    }

    /**
     * Get settings
     *
     * @return settings
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_SETTINGS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public AuthenticatorKeyCustomAppAllOfSettings getSettings() {
        return settings;
    }

    @JsonProperty(JSON_PROPERTY_SETTINGS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setSettings(AuthenticatorKeyCustomAppAllOfSettings settings) {
        this.settings = settings;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        AuthenticatorKeyCustomApp authenticatorKeyCustomApp = (AuthenticatorKeyCustomApp) o;
        return Objects.equals(this.agreeToTerms, authenticatorKeyCustomApp.agreeToTerms)
                && Objects.equals(this.provider, authenticatorKeyCustomApp.provider)
                && Objects.equals(this.settings, authenticatorKeyCustomApp.settings);
        // && super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(agreeToTerms, provider, settings, super.hashCode());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AuthenticatorKeyCustomApp {\n");
        sb.append("    ").append(toIndentedString(super.toString())).append("\n");
        sb.append("    agreeToTerms: ").append(toIndentedString(agreeToTerms)).append("\n");
        sb.append("    provider: ").append(toIndentedString(provider)).append("\n");
        sb.append("    settings: ").append(toIndentedString(settings)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
